/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.util;

import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sp.sdk.cache.SpTestCache;
import com.hs.lego.core.sp.sdk.model.SmsConfig;
import com.hs.lego.core.sp.unicom.sdk.model.UnicomSpConfig;
import com.hs.lego.core.system.notify.sdk.model.SmsBean;
import com.hs.lego.sp.unicom.config.SGIPConfig;
import com.hs.lego.sp.unicom.protocol.Bind;
import com.hs.lego.sp.unicom.protocol.BindResp;
import com.hs.lego.sp.unicom.protocol.SGIPCommand;
import com.hs.lego.sp.unicom.protocol.SGIPCommandDefine;
import com.hs.lego.sp.unicom.protocol.Submit;
import com.hs.lego.sp.unicom.protocol.SubmitResp;
import com.hs.lego.sp.unicom.protocol.Unbind;
import com.hs.lego.sp.unicom.protocol.UnbindResp;
import com.hs.lego.sp.unicom.util.MTReq;
import com.hs.lego.sp.unicom.util.MessageCenterUtil;
import com.hs.lego.sp.unicom.util.WriteOptLog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

public final class SPSender {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final int WORKER_NUM = 1;
    private static final long SLEEP_PERIOD = 10000L;
    private static SPSender instance = new SPSender();
    private static Map<String, Submit> mtsendedMap;
    private final LinkedList<MTReq> mtReqQueue = new LinkedList();
    private int errorCode;
    private volatile boolean isSendUnbind = true;
    private volatile boolean isBind = false;
    private volatile boolean isException = false;
    private Socket socket = null;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private long bindstartTime;
    private long currentTime;
    private final Object lock = new Object();

    private SPSender() {
        for (int i = 0; i < 1; ++i) {
            Thread workerThrader = new Thread(new WorkerHandler());
            workerThrader.setName("MT-thread-" + i);
            workerThrader.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            workerThrader.start();
        }
        LOGGER.info((Object)"[ MT send thread start \uff0cthread count : 1 ]");
    }

    public static SPSender getInstance(Map<String, Submit> map) {
        if (map != null) {
            mtsendedMap = map;
        }
        return instance;
    }

    public static boolean isMTsendedMapEmpty() {
        return mtsendedMap == null || mtsendedMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(MTReq mtreq) {
        SPSender sPSender = this;
        synchronized (sPSender) {
            this.mtReqQueue.add(mtreq);
            LOGGER.info((Object)("receive MT send request \uff0cthe queue count :" + this.mtReqQueue.size()));
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MTReq getTask() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.mtReqQueue.isEmpty()) {
                LOGGER.info((Object)(Thread.currentThread().getName() + "wait task"));
                TimeUnit.MILLISECONDS.sleep(10000L);
            }
            return this.mtReqQueue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMTReq(MTReq mtreq) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                SGIPCommand sgip;
                boolean flag3;
                boolean flag1 = SGIPConfig.getUnicomIp() == null || SGIPConfig.getUnicomIp().equals("") || SGIPConfig.getUnicomPort().equals("0") || SGIPConfig.getLoginName() == null;
                boolean flag2 = SGIPConfig.getLoginName().equals("") || SGIPConfig.getLoginPassword() == null || SGIPConfig.getLoginPassword().equals("") || SGIPConfig.getChargeNumber() == null;
                boolean bl = flag3 = SGIPConfig.getChargeNumber().equals("") || SGIPConfig.getCorpId() == null || SGIPConfig.getCorpId().equals("");
                if (flag1 || flag2 || flag3) {
                    LOGGER.info((Object)"read config file again");
                    this.readConfFile();
                }
                if (this.isException || this.isSendUnbind || this.socket.isClosed()) {
                    LOGGER.info((Object)"greate connect-------------------------------------------");
                    int connectnum = 0;
                    while (true) {
                        try {
                            this.socket = SGIPConfig.getUnicomPort() == null || SGIPConfig.getUnicomPort().equals("") ? SocketFactory.getDefault().createSocket(SGIPConfig.getUnicomIp(), 1) : SocketFactory.getDefault().createSocket(SGIPConfig.getUnicomIp(), Integer.parseInt(SGIPConfig.getUnicomPort()));
                            this.socket.setTcpNoDelay(true);
                            this.socket.setTrafficClass(20);
                        }
                        catch (ConnectException e) {
                            this.setException(true);
                            try {
                                TimeUnit.MILLISECONDS.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException e1) {
                                this.setException(true);
                                LOGGER.error((Object)"\u7ebf\u7a0b\u4e2d\u65ad!", (Throwable)e1);
                            }
                            if (++connectnum <= 2) continue;
                            LOGGER.fatal((Object)"can not connect SMG , connect time out");
                            this.setErrorCode(101);
                            WriteOptLog.writeLog(mtreq.getPhoneList(), 0, 1, this.errorCode);
                            return;
                        }
                        break;
                    }
                    if (!this.isBind) {
                        this.bindstartTime = System.currentTimeMillis();
                        this.out = new DataOutputStream(this.socket.getOutputStream());
                        this.in = new DataInputStream(this.socket.getInputStream());
                        LOGGER.info((Object)(Thread.currentThread().getName() + "connect SMG"));
                        Bind bind = new Bind();
                        bind.setLoginType((byte)1);
                        bind.setLoginName(SGIPConfig.getLoginName());
                        bind.setLoginPassword(SGIPConfig.getLoginPassword());
                        try {
                            bind.write(this.out, SGIPConfig.getNodeID());
                        }
                        catch (RuntimeException e) {
                            this.setException(true);
                            this.mtReqQueue.addFirst(mtreq);
                            LOGGER.fatal((Object)"bind write OutputStream exception ", (Throwable)e);
                            this.setErrorCode(102);
                            WriteOptLog.writeLog(mtreq.getPhoneList(), 0, 1, this.errorCode);
                            return;
                        }
                        this.setSendUnbind(false);
                        BindResp res = null;
                        try {
                            sgip = bind.read(this.in);
                            if (sgip instanceof BindResp) {
                                res = (BindResp)sgip;
                            } else {
                                LOGGER.error((Object)"sendMTReq() error, sgip is not BindResp.");
                            }
                        }
                        catch (RuntimeException e) {
                            this.setException(true);
                            this.mtReqQueue.addFirst(mtreq);
                            LOGGER.fatal((Object)"BindResp read InputStream exception ", (Throwable)e);
                            this.setErrorCode(102);
                            WriteOptLog.writeLog(mtreq.getPhoneList(), 0, 1, this.errorCode);
                            return;
                        }
                        if (null != res && res.getResult() != 0) {
                            LOGGER.fatal((Object)("SMG refuse connect. the error code is :" + res.getResult()));
                            this.setErrorCode(102);
                            WriteOptLog.writeLog(mtreq.getPhoneList(), 0, 1, this.errorCode);
                            return;
                        }
                        this.setBind(true);
                        this.setException(false);
                        this.launchTimer(SGIPConfig.getNodeID());
                    }
                }
                for (int i = 0; i < mtreq.getPhoneList().size(); ++i) {
                    Submit submit = new Submit();
                    submit.setSpNumber(mtreq.getSpNumber());
                    submit.setChargeNumber(SGIPConfig.getChargeNumber());
                    submit.setUserNumber(new String[]{mtreq.getPhoneList().get(i)});
                    submit.setCorpId(SGIPConfig.getCorpId());
                    submit.setFeeType((byte)0);
                    submit.setFeeValue("0");
                    submit.setGivenValue("0");
                    submit.setAgentFlag((byte)0);
                    submit.setMorelatetoMTFlag((byte)2);
                    submit.setPriority((byte)0);
                    submit.setExpireTime("");
                    submit.setScheduleTime("");
                    submit.setReportFlag(Byte.valueOf(mtreq.getReportFlag()));
                    submit.setTpPid((byte)0);
                    submit.setTpUdhi((byte)0);
                    submit.setMessageCoding((byte)15);
                    submit.setMessageType((byte)0);
                    submit.setUserCoun((byte)1);
                    submit.setServiceType(mtreq.getServiceType());
                    submit.setLinkID(mtreq.getLinkId());
                    submit.setMessageContent(mtreq.getMessageContent());
                    try {
                        submit.write(this.out, SGIPConfig.getNodeID());
                    }
                    catch (Exception e) {
                        this.setException(true);
                        this.setBind(false);
                        this.mtReqQueue.addFirst(mtreq);
                        LOGGER.fatal((Object)"submit write OutputStream exception ", (Throwable)e);
                        this.setErrorCode(-1);
                        WriteOptLog.writeLog(mtreq.getPhoneList().get(i), 0, 1, this.errorCode);
                        return;
                    }
                    SubmitResp submitres = null;
                    try {
                        sgip = submit.read(this.in);
                        if (sgip instanceof SubmitResp) {
                            submitres = (SubmitResp)sgip;
                        } else {
                            LOGGER.error((Object)"sendMTReq() error, sgip is not SubmitResp.");
                        }
                    }
                    catch (Exception e) {
                        this.setException(true);
                        this.setBind(false);
                        this.mtReqQueue.addFirst(mtreq);
                        LOGGER.fatal((Object)"SubmitResp read inputStream exception ", (Throwable)e);
                        this.setErrorCode(103);
                        WriteOptLog.writeLog(mtreq.getPhoneList().get(i), 0, 1, this.errorCode);
                        return;
                    }
                    if (null != submitres && submitres.getResult() == 0) {
                        LOGGER.info((Object)("[" + Thread.currentThread().getName() + " send MT request to SMG success ]"));
                        WriteOptLog.writeLog(mtreq.getPhoneList().get(i), 1, 1, this.errorCode);
                        continue;
                    }
                    if (null != submitres) {
                        LOGGER.warn((Object)("[" + Thread.currentThread().getName() + " send MT request to SMG failed!, error code is " + submitres.getResult() + "]"));
                    }
                    this.setErrorCode(103);
                    WriteOptLog.writeLog(mtreq.getPhoneList().get(i), 0, 1, this.errorCode);
                }
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"[send MT request to SMG failed!]", (Throwable)e);
                this.setErrorCode(103);
                WriteOptLog.writeLog(mtreq.getPhoneList(), 0, 1, this.errorCode);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"[send MT request to SMG failed!]", (Throwable)e);
                this.setErrorCode(103);
                WriteOptLog.writeLog(mtreq.getPhoneList(), 0, 1, this.errorCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTestMTReq(MTReq mtreq, long smsId) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.bindstartTime = 0L;
                SmsConfig smsConfig = SpTestCache.remove(smsId);
                if (null == smsConfig || !(smsConfig instanceof UnicomSpConfig)) {
                    this.setErrorCode(103);
                    return;
                }
                UnicomSpConfig unicomSpConfig = (UnicomSpConfig)smsConfig;
                TimeUnit.MILLISECONDS.sleep(2000L);
                if (this.isException || this.isSendUnbind || this.socket.isClosed()) {
                    LOGGER.info((Object)"greate connect-------------------------------------------");
                    int connectnum = 0;
                    while (true) {
                        try {
                            this.socket = SocketFactory.getDefault().createSocket(unicomSpConfig.getUnicomIp(), Integer.parseInt(unicomSpConfig.getUnicomPort()));
                            this.socket.setTcpNoDelay(true);
                            this.socket.setTrafficClass(20);
                        }
                        catch (ConnectException e) {
                            this.setException(true);
                            try {
                                TimeUnit.MILLISECONDS.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException e1) {
                                this.setException(true);
                                LOGGER.error((Object)"\u7ebf\u7a0b\u4e2d\u65ad!", (Throwable)e1);
                            }
                            if (++connectnum <= 2) continue;
                            LOGGER.fatal((Object)"can not connect SMG , connect time out");
                            this.setErrorCode(101);
                            return;
                        }
                        break;
                    }
                    if (!this.isBind) {
                        this.bindstartTime = System.currentTimeMillis();
                        this.out = new DataOutputStream(this.socket.getOutputStream());
                        this.in = new DataInputStream(this.socket.getInputStream());
                        LOGGER.info((Object)(Thread.currentThread().getName() + "connect SMG"));
                        Bind bind = new Bind();
                        bind.setLoginType((byte)1);
                        bind.setLoginName(unicomSpConfig.getLoginName());
                        bind.setLoginPassword(unicomSpConfig.getLoginPassword());
                        try {
                            bind.write(this.out, unicomSpConfig.getNodeId());
                        }
                        catch (RuntimeException e) {
                            this.setException(true);
                            LOGGER.fatal((Object)"bind write OutputStream exception ", (Throwable)e);
                            this.setErrorCode(102);
                            return;
                        }
                        this.setSendUnbind(false);
                        BindResp res = null;
                        try {
                            SGIPCommand sgip = bind.read(this.in);
                            if (sgip instanceof BindResp) {
                                res = (BindResp)sgip;
                            } else {
                                LOGGER.error((Object)"sendTestMTReq() error, sgip is not BindResp.");
                            }
                        }
                        catch (RuntimeException e) {
                            this.setException(true);
                            LOGGER.fatal((Object)"BindResp read InputStream exception ", (Throwable)e);
                            this.setErrorCode(102);
                            return;
                        }
                        if (null != res && res.getResult() != 0) {
                            LOGGER.fatal((Object)("SMG refuse connect. the error code is :" + res.getResult()));
                            this.setErrorCode(res.getResult());
                            return;
                        }
                        this.setBind(true);
                        this.setException(false);
                        this.launchTimer(unicomSpConfig.getNodeId());
                    }
                }
                Submit submit = new Submit();
                submit.setSpNumber(unicomSpConfig.getSpNumber());
                submit.setChargeNumber(unicomSpConfig.getChargeNumber());
                submit.setUserNumber(new String[]{unicomSpConfig.getTestPhone()});
                submit.setCorpId(unicomSpConfig.getCorpId());
                submit.setFeeType((byte)0);
                submit.setFeeValue("0");
                submit.setGivenValue("0");
                submit.setAgentFlag((byte)0);
                submit.setMorelatetoMTFlag((byte)2);
                submit.setPriority((byte)0);
                submit.setExpireTime("");
                submit.setScheduleTime("");
                submit.setReportFlag(Byte.valueOf(mtreq.getReportFlag()));
                submit.setTpPid((byte)0);
                submit.setTpUdhi((byte)0);
                submit.setMessageCoding((byte)15);
                submit.setMessageType((byte)0);
                submit.setUserCoun((byte)1);
                submit.setServiceType(unicomSpConfig.getServiceType());
                submit.setLinkID(mtreq.getLinkId());
                submit.setMessageContent(mtreq.getMessageContent());
                try {
                    submit.write(this.out, unicomSpConfig.getNodeId());
                }
                catch (RuntimeException e) {
                    this.setException(true);
                    this.setBind(false);
                    LOGGER.fatal((Object)"submit write OutputStream exception ", (Throwable)e);
                    this.setErrorCode(this.getExceptionErrorCode(e));
                    return;
                }
                SubmitResp submitres = null;
                try {
                    SGIPCommand sgip = submit.read(this.in);
                    if (sgip instanceof SubmitResp) {
                        submitres = (SubmitResp)sgip;
                    } else {
                        LOGGER.error((Object)"sendTestMTReq() error, sgip is not SubmitResp.");
                    }
                }
                catch (RuntimeException e) {
                    this.setException(true);
                    this.setBind(false);
                    LOGGER.fatal((Object)"SubmitResp read inputStream exception ", (Throwable)e);
                    this.setErrorCode(103);
                    return;
                }
                if (null != submitres && submitres.getResult() == 0) {
                    LOGGER.info((Object)("[" + Thread.currentThread().getName() + " send MT request to SMG success ]"));
                    return;
                }
                if (null != submitres) {
                    LOGGER.warn((Object)("[" + Thread.currentThread().getName() + " send MT request to SMG failed!, error code is " + submitres.getResult() + "]"));
                    this.setErrorCode(submitres.getResult());
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)"[send MT request to SMG failed!]", e);
                this.setErrorCode(103);
            }
        }
    }

    private void sendTestSmsResult(long smsId) {
        SmsBean smsBean = new SmsBean();
        smsBean.setRandomId(smsId);
        smsBean.setSendResult(!this.isException);
        smsBean.setErrorCode(this.errorCode);
        LOGGER.info((Object)"Send sp sms report in unicom bundle.");
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(5010L);
        mu.setObj((Object)smsBean);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName("unicom");
        MessageCenterUtil.getInstance().getMessageCenter().sendMessage(mu);
    }

    private int getExceptionErrorCode(Exception e) {
        if (e.getMessage().contains("CorpId longer than 5 bytes")) {
            return 104;
        }
        if (e.getMessage().contains("ServiceType longer than 10 bytes")) {
            return 105;
        }
        if (e.getMessage().contains("ChargeNumber longer than 21 bytes")) {
            return 106;
        }
        if (e.getMessage().contains("SPNumber Longer than 21 bytes")) {
            return 107;
        }
        if (e.getMessage().contains("UserNumber longer than 21 bytes")) {
            return 108;
        }
        return 103;
    }

    public void launchTimer(final String nodeId) {
        final ScheduledExecutorService scheduExec = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                SPSender.this.runSynMethod(nodeId, scheduExec);
            }
        };
        scheduExec.scheduleWithFixedDelay(task, 1L, 1L, TimeUnit.SECONDS);
    }

    private void readConfFile() {
        SGIPConfig.readConfFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSynMethod(String nodeId, ScheduledExecutorService scheduExec) {
        if (this.mtReqQueue.isEmpty()) {
            this.currentTime = System.currentTimeMillis();
            int passedTime = (int)((this.currentTime - this.bindstartTime) / 1000L);
            if (passedTime > 30) {
                Object object = this.lock;
                synchronized (object) {
                    block31: {
                        Unbind unbind = new Unbind();
                        try {
                            if (this.in.available() == 0) {
                                LOGGER.info((Object)"the server socket has closed");
                                this.isBind = false;
                                try {
                                    this.in.close();
                                    if (this.out != null) {
                                        this.out.close();
                                    }
                                    if (this.socket != null) {
                                        this.socket.close();
                                    }
                                }
                                catch (IOException e) {
                                    LOGGER.error((Object)"close message send socket failed", (Throwable)e);
                                }
                                scheduExec.shutdown();
                                return;
                            }
                            unbind.write(this.out, nodeId);
                        }
                        catch (Exception e) {
                            this.isException = true;
                            this.isBind = false;
                            LOGGER.fatal((Object)"unbind write OutputStream exception ", (Throwable)e);
                            scheduExec.shutdown();
                            return;
                        }
                        LOGGER.info((Object)(Thread.currentThread().getName() + " send to SMG unbind command"));
                        try {
                            if (this.in.available() == 0) {
                                LOGGER.info((Object)"the server socket has closed");
                                this.isBind = false;
                                try {
                                    this.in.close();
                                    if (this.out != null) {
                                        this.out.close();
                                    }
                                    if (this.socket != null) {
                                        this.socket.close();
                                    }
                                    break block31;
                                }
                                catch (IOException e) {
                                    LOGGER.error((Object)"close message send socket failed", (Throwable)e);
                                }
                                break block31;
                            }
                            UnbindResp resp = null;
                            try {
                                SGIPCommand sgip = unbind.read(this.in);
                                if (sgip instanceof UnbindResp) {
                                    resp = (UnbindResp)sgip;
                                } else {
                                    LOGGER.error((Object)"launchTimer() error, resp is not UnbindResp.");
                                }
                            }
                            catch (RuntimeException e) {
                                this.isException = true;
                                this.isBind = false;
                                LOGGER.fatal((Object)"UnbindResp read OutputStream exception ", (Throwable)e);
                                scheduExec.shutdown();
                                return;
                            }
                            if (null == resp || !Arrays.equals(resp.getHeader().getCommandId(), SGIPCommandDefine.getSgipUnbindResp())) break block31;
                            this.isSendUnbind = true;
                            this.isBind = false;
                            LOGGER.info((Object)"receive SMG unbind command\uff0cSP close connect");
                            scheduExec.shutdown();
                            try {
                                this.in.close();
                                if (this.out != null) {
                                    this.out.close();
                                }
                                if (this.socket != null) {
                                    this.socket.close();
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error((Object)"close message send socket failed", (Throwable)e);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"unkonw socket exception", (Throwable)e);
                            this.isException = true;
                            this.isBind = false;
                            try {
                                this.in.close();
                                if (this.out != null) {
                                    this.out.close();
                                }
                                if (this.socket != null) {
                                    this.socket.close();
                                }
                            }
                            catch (IOException e1) {
                                LOGGER.error((Object)"close message send socket failed", (Throwable)e1);
                            }
                            scheduExec.shutdown();
                        }
                    }
                }
            }
        }
    }

    public void setException(boolean isExc) {
        this.isException = isExc;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setSendUnbind(boolean isSendUnb) {
        this.isSendUnbind = isSendUnb;
    }

    public void setBind(boolean isBid) {
        this.isBind = isBid;
    }

    class WorkerHandler
    implements Runnable {
        MTReq mtreq = null;

        WorkerHandler() {
        }

        @Override
        public void run() {
            while (true) {
                long smsRandom = 0L;
                try {
                    LOGGER.info((Object)("Thread.currentThread().isInterrupted() begin-----------------" + Thread.currentThread().isInterrupted()));
                    while (!Thread.currentThread().isInterrupted()) {
                        this.mtreq = SPSender.this.getTask();
                        if (this.mtreq == null) continue;
                        LOGGER.info((Object)("[" + Thread.currentThread().getName() + "receive a message send instance]"));
                        Thread.currentThread();
                        Thread.yield();
                        String smsId = this.mtreq.getSmsId();
                        try {
                            smsRandom = Long.parseLong(smsId);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error((Object)"Long.parseLong(smsId)", (Throwable)e);
                        }
                        if (smsRandom == 0L) {
                            SPSender.this.sendMTReq(this.mtreq);
                        } else {
                            SPSender.this.errorCode = 0;
                            SPSender.this.sendTestMTReq(this.mtreq, smsRandom);
                            SPSender.this.sendTestSmsResult(smsRandom);
                        }
                        this.close();
                    }
                    LOGGER.info((Object)("Thread.currentThread().isInterrupted() end-----------------" + Thread.currentThread().isInterrupted()));
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"message send thread stop!", (Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    if (smsRandom == 0L) {
                        SPSender.this.mtReqQueue.add(this.mtreq);
                    }
                    LOGGER.error((Object)"IOStream exception when send message!", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    if (smsRandom == 0L) {
                        SPSender.this.mtReqQueue.add(this.mtreq);
                    }
                    LOGGER.error((Object)"unknow excption when send message!", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void close() {
            if (SPSender.this.isException) {
                SPSender.this.bindstartTime = 0L;
                try {
                    TimeUnit.MILLISECONDS.sleep(2000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"close", (Throwable)e);
                }
            }
        }
    }
}

