/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import java.util.Date;
import java.util.List;

public class WriteOptLog {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    public static void writeLog(String phone, int result, int level, int errorCode) {
        if (result == 1) {
            return;
        }
        try {
            SysOptLog oOptLog = new SysOptLog();
            Date date = new Date();
            oOptLog.setDate(date);
            oOptLog.setLevel(level);
            oOptLog.setModule("lego.dic.module.system");
            oOptLog.setOperation("lego.lab.log.func.send.sms");
            oOptLog.setOperator("system");
            oOptLog.setTerminalIp("127.0.0.1");
            oOptLog.setTarget(phone);
            oOptLog.setResult(result);
            String errorStr = WriteOptLog.getLogDetail(errorCode);
            oOptLog.setDetail(errorStr);
            ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            sysOpLog.writeOptLog(oOptLog);
        }
        catch (Exception e) {
            LOGGER.error((Object)"writeLog exception.", (Throwable)e);
        }
    }

    public static void writeLog(List<String> phones, int result, int level, int errorCode) {
        for (String phone : phones) {
            WriteOptLog.writeLog(phone, result, level, errorCode);
        }
    }

    public static void writeLog(String[] phones, int result, int level, int errorCode) {
        for (String phone : phones) {
            WriteOptLog.writeLog(phone, result, level, errorCode);
        }
    }

    private static String getLogDetail(int errorCode) {
        if (errorCode == 0) {
            return "";
        }
        if (errorCode > 0 && errorCode <= 100) {
            return "lego.ver.fault.unicom.error." + errorCode;
        }
        String detail = "";
        switch (errorCode) {
            case -1: {
                detail = "lego.ver.fault.unicom.senderror";
                break;
            }
            case 101: {
                detail = "lego.ver.fault.unicom.connectfail";
                break;
            }
            case 102: {
                detail = "lego.ver.fault.unicom.bindspfail";
                break;
            }
            case 103: {
                detail = "lego.ver.fault.unicom.sendsmsfail";
                break;
            }
            case 104: {
                detail = "lego.ver.fault.unicom.corpidlong";
                break;
            }
            case 105: {
                detail = "lego.ver.fault.unicom.servicetypelong";
                break;
            }
            case 106: {
                detail = "lego.ver.fault.unicom.chargelong";
                break;
            }
            case 107: {
                detail = "lego.ver.fault.unicom.spnumlong";
                break;
            }
            case 108: {
                detail = "lego.ver.fault.unicom.testnumlong";
                break;
            }
        }
        return detail;
    }
}

