/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.util.CategoryChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.components.spiderchart.FillChartSettings;
import net.sf.jasperreports.components.spiderchart.FillSpiderDataset;
import net.sf.jasperreports.components.spiderchart.FillSpiderPlot;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class FillSpiderChart
extends BaseFillComponent
implements JRFillCloneable {
    private final SpiderChartComponent chartComponent;
    private final FillChartSettings chartSettings;
    private final FillSpiderDataset dataset;
    private final FillSpiderPlot plot;
    private Double maxValue;
    private String titleText;
    private String subtitleText;
    private String anchorName;
    private String hyperlinkReference;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private Integer bookmarkLevel;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    private JRFillExpressionEvaluator expressionEvaluator;
    private ChartHyperlinkProvider chartHyperlinkProvider;
    private JRRenderable renderer;

    public FillSpiderChart(SpiderChartComponent chartComponent, JRFillObjectFactory factory) {
        this.chartComponent = chartComponent;
        this.chartSettings = new FillChartSettings(chartComponent.getChartSettings(), factory);
        this.dataset = new FillSpiderDataset(chartComponent.getDataset(), factory);
        factory.registerElementDataset(this.dataset);
        this.plot = new FillSpiderPlot(chartComponent.getPlot(), factory);
        this.expressionEvaluator = factory.getExpressionEvaluator();
    }

    protected boolean isEvaluateNow() {
        return this.chartComponent.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateRenderer(evaluation);
        }
    }

    protected void evaluateRenderer(byte evaluation) throws JRException {
        JFreeChart chart = this.evaluateChart(evaluation);
        JRComponentElement element = this.fillContext.getComponentElement();
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, element.getWidth(), element.getHeight());
        this.renderer = ChartUtil.getChartRendererFactory(this.getChartSettings().getRenderType()).getRenderer(chart, this.chartHyperlinkProvider, rectangle);
    }

    protected JFreeChart evaluateChart(byte evaluation) throws JRException {
        LegendTitle legend;
        this.maxValue = (Double)this.fillContext.evaluate(this.getPlot().getMaxValueExpression(), evaluation);
        this.titleText = (String)this.fillContext.evaluate(this.getChartSettings().getTitleExpression(), evaluation);
        this.subtitleText = (String)this.fillContext.evaluate(this.getChartSettings().getSubtitleExpression(), evaluation);
        this.anchorName = (String)this.fillContext.evaluate(this.getChartSettings().getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.fillContext.evaluate(this.getChartSettings().getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.fillContext.evaluate(this.getChartSettings().getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.fillContext.evaluate(this.getChartSettings().getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.fillContext.evaluate(this.getChartSettings().getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this.getChartSettings(), this.expressionEvaluator, evaluation);
        this.dataset.evaluateDatasetRun(evaluation);
        this.dataset.finishDataset();
        this.chartHyperlinkProvider = new CategoryChartHyperlinkProvider(this.dataset.getItemHyperlinks());
        this.bookmarkLevel = this.getChartSettings().getBookmarkLevel();
        SpiderWebPlot spiderWebPlot = new SpiderWebPlot((CategoryDataset)((DefaultCategoryDataset)this.dataset.getCustomDataset()));
        if (this.getPlot().getAxisLineColor() != null) {
            spiderWebPlot.setAxisLinePaint((Paint)this.getPlot().getAxisLineColor());
        }
        if (this.getPlot().getAxisLineWidth() != null) {
            spiderWebPlot.setAxisLineStroke((Stroke)new BasicStroke(this.getPlot().getAxisLineWidth().floatValue()));
        }
        if (this.getPlot().getBackcolor() != null) {
            spiderWebPlot.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        if (this.getPlot().getBackgroundAlpha() != null) {
            spiderWebPlot.setBackgroundAlpha(this.getPlot().getBackgroundAlpha().floatValue());
        }
        if (this.getPlot().getForegroundAlpha() != null) {
            spiderWebPlot.setForegroundAlpha(this.getPlot().getForegroundAlpha().floatValue());
        }
        if (this.getPlot().getHeadPercent() != null) {
            spiderWebPlot.setHeadPercent(this.getPlot().getHeadPercent().doubleValue());
        }
        if (this.getPlot().getInteriorGap() != null) {
            spiderWebPlot.setInteriorGap(this.getPlot().getInteriorGap().doubleValue());
        }
        if (this.getPlot().getLabelColor() != null) {
            spiderWebPlot.setLabelPaint((Paint)this.getPlot().getLabelColor());
        }
        if (this.getPlot().getLabelFont() != null) {
            spiderWebPlot.setLabelFont(JRFontUtil.getAwtFont(this.getPlot().getLabelFont(), Locale.getDefault()));
        }
        if (this.getPlot().getLabelGap() != null) {
            spiderWebPlot.setAxisLabelGap(this.getPlot().getLabelGap().doubleValue());
        }
        if (this.maxValue != null) {
            spiderWebPlot.setMaxValue(this.maxValue.doubleValue());
        }
        if (this.getPlot().getRotation() != null) {
            spiderWebPlot.setDirection(this.getPlot().getRotation().getRotation());
        }
        if (this.getPlot().getStartAngle() != null) {
            spiderWebPlot.setStartAngle(this.getPlot().getStartAngle().doubleValue());
        }
        if (this.getPlot().getTableOrder() != null) {
            spiderWebPlot.setDataExtractOrder(this.getPlot().getTableOrder().getOrder());
        }
        if (this.getPlot().getWebFilled() != null) {
            spiderWebPlot.setWebFilled(this.getPlot().getWebFilled().booleanValue());
        }
        spiderWebPlot.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        spiderWebPlot.setLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        Font titleFont = this.getChartSettings().getTitleFont() != null ? JRFontUtil.getAwtFont(this.getChartSettings().getTitleFont(), Locale.getDefault()) : TextTitle.DEFAULT_FONT;
        JFreeChart jfreechart = new JFreeChart(this.titleText, titleFont, (Plot)spiderWebPlot, true);
        if (this.chartSettings.getBackcolor() != null) {
            jfreechart.setBackgroundPaint((Paint)this.chartSettings.getBackcolor());
        }
        RectangleEdge titleEdge = FillSpiderChart.getEdge(this.getChartSettings().getTitlePosition(), RectangleEdge.TOP);
        if (this.titleText != null) {
            TextTitle title = jfreechart.getTitle();
            title.setText(this.titleText);
            if (this.getChartSettings().getTitleColor() != null) {
                title.setPaint((Paint)this.getChartSettings().getTitleColor());
            }
            title.setFont(titleFont);
            title.setPosition(titleEdge);
            jfreechart.setTitle(title);
        }
        if (this.subtitleText != null) {
            TextTitle subtitle = new TextTitle(this.subtitleText);
            subtitle.setText(this.subtitleText);
            if (this.getChartSettings().getSubtitleColor() != null) {
                subtitle.setPaint((Paint)this.getChartSettings().getSubtitleColor());
            }
            if (this.getChartSettings().getSubtitleColor() != null) {
                Font subtitleFont = this.getChartSettings().getSubtitleFont() != null ? JRFontUtil.getAwtFont(this.getChartSettings().getSubtitleFont(), Locale.getDefault()) : TextTitle.DEFAULT_FONT;
                subtitle.setFont(subtitleFont);
            }
            subtitle.setPosition(titleEdge);
            jfreechart.addSubtitle((Title)subtitle);
        }
        if ((legend = jfreechart.getLegend()) != null) {
            legend.setVisible(this.chartSettings.getShowLegend() == null || this.chartSettings.getShowLegend() != false);
            if (legend.isVisible()) {
                if (this.getChartSettings().getLegendColor() != null) {
                    legend.setItemPaint((Paint)this.getChartSettings().getLegendColor());
                }
                if (this.getChartSettings().getLegendBackgroundColor() != null) {
                    legend.setBackgroundPaint((Paint)this.getChartSettings().getLegendBackgroundColor());
                }
                if (this.getChartSettings().getLegendFont() != null) {
                    legend.setItemFont(JRFontUtil.getAwtFont(this.getChartSettings().getLegendFont(), Locale.getDefault()));
                }
                legend.setPosition(FillSpiderChart.getEdge(this.getChartSettings().getLegendPosition(), RectangleEdge.BOTTOM));
            }
        }
        return jfreechart;
    }

    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateImage templateImage = new JRTemplateImage(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
        templateImage.setStyle(this.fillContext.getElementStyle());
        templateImage.setLinkType(this.getLinkType());
        templateImage.setLinkTarget(this.getLinkTarget());
        JRTemplatePrintImage image = new JRTemplatePrintImage(templateImage);
        image.setX(element.getX());
        image.setY(this.fillContext.getElementPrintY());
        image.setWidth(element.getWidth());
        image.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy(image);
        } else {
            this.fillContext.registerDelayedEvaluation(image, this.chartComponent.getEvaluationTime(), this.chartComponent.getEvaluationGroup());
        }
        return image;
    }

    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        throw new UnsupportedOperationException();
    }

    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateRenderer(evaluation);
        this.copy((JRPrintImage)element);
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
    }

    private static RectangleEdge getEdge(EdgeEnum position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case TOP: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case BOTTOM: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case LEFT: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case RIGHT: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }

    protected ChartHyperlinkProvider getHyperlinkProvider() {
        return this.chartHyperlinkProvider;
    }

    public FillChartSettings getChartSettings() {
        return this.chartSettings;
    }

    public FillSpiderDataset getDataset() {
        return this.dataset;
    }

    public FillSpiderPlot getPlot() {
        return this.plot;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public String getSubtitleText() {
        return this.subtitleText;
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public Integer getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public JRFillExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public JRRenderable getRenderer() {
        return this.renderer;
    }

    public String getLinkType() {
        return this.getChartSettings().getLinkType();
    }

    public String getLinkTarget() {
        return this.getChartSettings().getLinkTarget();
    }

    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }
}

