/*
 * Decompiled with CFR 0.152.
 */
package com.ha.atic.ha.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class CollectorIpThread
extends Thread {
    private static int sleepTime = 60000;
    private static final String CONFIGFILE = "/collector.conf";
    private static CollectorIpThread thread = null;
    private List<String> cmds;
    private List<Long> nowProcessing = new ArrayList<Long>();
    private ReentrantLock lock = new ReentrantLock();
    private IAticDeviceService aticDeviceService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private Boolean isActive = true;

    public CollectorIpThread(List<String> cmd) {
        this.cmds = cmd;
    }

    private CollectorIpThread(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public static synchronized CollectorIpThread getInstance(IAticDeviceService aticDeviceService) {
        if (null == thread) {
            thread = new CollectorIpThread(aticDeviceService);
            InputStream inputStream = AticUtil.class.getResourceAsStream(CONFIGFILE);
            String propertyTime = AticUtil.getPropertyValue((InputStream)inputStream, (String)"DualHostSwitchSleepTime");
            if (null != propertyTime) {
                try {
                    sleepTime = Integer.parseInt(propertyTime);
                }
                catch (Exception e) {
                    sleepTime = 60000;
                }
            }
        }
        return thread;
    }

    @Override
    public void run() {
        while (this.isActive.booleanValue()) {
            block5: {
                try {
                    this.reDeployLogServerIp();
                }
                catch (Exception e) {
                    this.logger.error((Object)(this.getClass().getSimpleName() + "'s run method failed:"), (Throwable)e);
                    if (null == this.lock) break block5;
                    this.lock.unlock();
                }
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                this.logger.error((Object)"sleep failed:", (Throwable)e);
                if (null == this.lock) continue;
                this.lock.unlock();
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void reDeployLogServerIp() {
        if (this.nowProcessing.isEmpty()) {
            return;
        }
        Iterator<Long> iterator = this.nowProcessing.iterator();
        while (iterator.hasNext()) {
            Long devId = iterator.next();
            List results = null;
            try {
                results = this.aticDeviceService.execCmd(this.cmds, devId.longValue());
            }
            catch (Exception e) {
                this.logger.error((Object)("execCmd failed! cmds :" + (this.cmds == null ? "" : this.getcleanedMessage(this.cmds.toString())) + " Exception:" + e));
                continue;
            }
            if (!AticUtil.isCmdSucess((List)results)) {
                this.logger.error((Object)"execCmd failed!");
                continue;
            }
            iterator.remove();
        }
        if (this.nowProcessing.isEmpty()) {
            this.setIsActive(false);
        }
    }

    public void addNeedDeployDev(Long devId) {
        this.lock.lock();
        try {
            this.logger.info((Object)("add redeploy device in queue! device id is " + devId));
            if (!this.nowProcessing.contains(devId)) {
                this.nowProcessing.add(devId);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

