/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.ha.action;

import com.ha.atic.ha.util.HaUtil;
import com.hs.ha.rmi.ManageService;
import com.hs.ha.vo.MonitorInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class HaMonitorAction
extends BaseAction {
    private static final long serialVersionUID = 1811798541917136030L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private boolean isServiceNull = false;
    private boolean isHARunning = false;
    private boolean isAbleToSwitch = false;
    private List<MonitorInfo> monitorInfoList = new ArrayList<MonitorInfo>();

    public String getHAInfo() {
        block9: {
            ManageService manageService = null;
            try {
                manageService = HaUtil.getHaService();
                if (null != manageService) {
                    this.isHARunning = manageService.checkHaRunning();
                    if (this.isHARunning) {
                        this.monitorInfoList = manageService.getMonitorInfoList();
                        this.isAbleToSwitch = manageService.isAbleToSwitch();
                    }
                } else {
                    this.isServiceNull = true;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"the HA manager service is not start.");
                    }
                }
            }
            catch (RemoteException e) {
                if (null == manageService) {
                    this.isServiceNull = true;
                }
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"execute get HA Info failed. the exception is : ", (Throwable)e);
                }
            }
            catch (NotBoundException e) {
                this.isServiceNull = true;
                if (!logger.isErrorEnabled()) break block9;
                logger.error((Object)"execute get HA Info failed. the exception is : ", (Throwable)e);
            }
        }
        return "success";
    }

    public void startHA() {
        block9: {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"execute start HA service.");
            }
            this.getOperateLog().normal("lego.sys.ha.start", "lego.sys.haServer.manager", HaUtil.getAticCommonUtilService().getServerIp(), false, "lego.sys.ha.startSuccess", new String[0]);
            String startHAResult = "";
            ManageService manageService = null;
            try {
                manageService = HaUtil.getHaService();
                if (manageService != null) {
                    startHAResult = manageService.startHa();
                    if (this.isStartHASuccess(startHAResult, manageService)) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"execute start HA success.");
                        }
                        this.responseResult("success");
                        return;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("execute start HA failed. the resutl is : " + startHAResult));
                    }
                }
            }
            catch (RemoteException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"execute start HA failed. the exception is : ", (Throwable)e);
                }
            }
            catch (NotBoundException e) {
                if (!logger.isErrorEnabled()) break block9;
                logger.error((Object)"execute start HA failed. the exception is : ", (Throwable)e);
            }
        }
        this.responseResult("error");
    }

    private boolean isStartHASuccess(String startHAResult, ManageService manageService) {
        if (startHAResult != null) {
            if ("remote HA is not primary!".equals(startHAResult)) {
                return false;
            }
            if ("remote HA is running!".equals(startHAResult)) {
                return true;
            }
            if ("remote HA start success!".equals(startHAResult)) {
                return true;
            }
            if ("remote HA start error!".equals(startHAResult)) {
                return false;
            }
            try {
                if (manageService != null) {
                    return manageService.checkHaRunning();
                }
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"execute check HA is running failed with start HA. the exception is : ", (Throwable)e);
                }
                return false;
            }
        }
        return false;
    }

    public void stopHA() {
        block9: {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"execute stop HA service.");
            }
            this.getOperateLog().normal("lego.sys.ha.stop", "lego.sys.haServer.manager", HaUtil.getAticCommonUtilService().getServerIp(), false, "lego.sys.ha.stopSuccess", new String[0]);
            String stopHAResult = "";
            ManageService manageService = null;
            try {
                manageService = HaUtil.getHaService();
                if (manageService != null) {
                    stopHAResult = manageService.stopHa();
                    if (this.isStopHASuccess(stopHAResult, manageService)) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"execute stop HA success.");
                        }
                        this.responseResult("success");
                        return;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("execute stop HA failed. the resutl is : " + stopHAResult));
                    }
                }
            }
            catch (RemoteException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"execute stop HA failed. the exception is : ", (Throwable)e);
                }
            }
            catch (NotBoundException e) {
                if (!logger.isErrorEnabled()) break block9;
                logger.error((Object)"execute stop HA failed. the exception is : ", (Throwable)e);
            }
        }
        this.responseResult("error");
    }

    private boolean isStopHASuccess(String stopHAResult, ManageService manageService) {
        if (stopHAResult != null) {
            if ("remote HA is not primary!".equals(stopHAResult)) {
                return false;
            }
            if ("remote HA is stoped!".equals(stopHAResult)) {
                return true;
            }
            if ("remote HA stop success!".equals(stopHAResult)) {
                return true;
            }
            if ("remote HA stop error!".equals(stopHAResult)) {
                return false;
            }
            try {
                if (manageService != null) {
                    return !manageService.checkHaRunning();
                }
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"execute check HA is running failed with stop HA. the exception is : ", (Throwable)e);
                }
                return false;
            }
        }
        return false;
    }

    public void switchHA() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"execute switch HA.");
        }
        String switchHAResult = "";
        ManageService manageService = null;
        this.getOperateLog().normal("lego.sys.ha.switch", "lego.sys.haServer.manager", System.getProperty("nms.server.host"), false, "lego.sys.ha.switch.success", new String[0]);
        try {
            manageService = HaUtil.getHaService();
            if (manageService != null) {
                this.responseResult("success");
                switchHAResult = manageService.switchHa();
                if (!this.isSwitchHASuccess(switchHAResult)) {
                    logger.error((Object)("execute switch HA failed. the resutl is : " + switchHAResult));
                }
            }
        }
        catch (RemoteException e) {
            logger.error((Object)"execute switch HA failed. the exception is : ", (Throwable)e);
        }
        catch (NotBoundException e) {
            logger.error((Object)"execute switch HA failed. the exception is : ", (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)"execute switch HA failed. the exception is : ", (Throwable)e);
        }
        this.responseResult("error");
    }

    private boolean isSwitchHASuccess(String switchHAResult) {
        return switchHAResult != null && switchHAResult.indexOf("true") >= 0 && switchHAResult.indexOf("false") < 0;
    }

    public void synchronizationHA() {
        this.responseResult("success");
    }

    public Boolean getIsServiceNull() {
        return this.isServiceNull;
    }

    public void setIsServiceNull(Boolean isServiceNull) {
        this.isServiceNull = isServiceNull;
    }

    public Boolean getIsHARunning() {
        return this.isHARunning;
    }

    public void setIsHARunning(Boolean isHARunning) {
        this.isHARunning = isHARunning;
    }

    public Boolean getIsAbleToSwitch() {
        return this.isAbleToSwitch;
    }

    public void setIsAbleToSwitch(Boolean isAbleToSwitch) {
        this.isAbleToSwitch = isAbleToSwitch;
    }

    public List<MonitorInfo> getMonitorInfoList() {
        return this.monitorInfoList;
    }

    public void setMonitorInfoList(List<MonitorInfo> monitorInfoList) {
        this.monitorInfoList = monitorInfoList;
    }
}

