/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system.util;

import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.parents.servcice.ILogHoldTimeService;
import java.util.ArrayList;
import java.util.List;

public final class SystemUtil {
    private static final Long NUM_24 = 24L;
    private static final Long NUM_31 = 31L;
    private static final Long NUM_366 = 366L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);

    private SystemUtil() {
    }

    public static LogHoldTimeForm getLogHoldTime() {
        try {
            LogHoldTimeForm logHoldTime;
            ServiceContext sc = ServiceContext.getInstance();
            ILogHoldTimeService service = (ILogHoldTimeService)sc.getService("logHoldTimeService", ILogHoldTimeService.class);
            List list = new ArrayList();
            if (null != service) {
                list = service.findLogHoldTime();
            }
            if (null != list && !list.isEmpty()) {
                logHoldTime = (LogHoldTimeForm)list.get(0);
            } else {
                logHoldTime = new LogHoldTimeForm();
                logHoldTime.setHoldTime(1);
                logHoldTime.setTacticsLogTime(90);
                logHoldTime.setHoldOriginal(90);
                logHoldTime.setHoldHour(12);
                logHoldTime.setHoldDay(1);
                logHoldTime.setDayReportTime(60);
                logHoldTime.setWeekReportTime(6);
                logHoldTime.setMonthReportTime(1);
                logHoldTime.setYearReportTime(5);
                logHoldTime.setDivertDelayTime(300);
                logHoldTime.setDevSyslogTime(90);
                logHoldTime.setPageSizeNum(10);
            }
            return logHoldTime;
        }
        catch (Exception e) {
            logger.error((Object)"getLogHoldTime function error", (Throwable)e);
            return null;
        }
    }

    public static Long getDataKeepTime(int holdType, int holdTime) {
        long dataKeepTime = 0L;
        switch (holdType) {
            case 2: {
                dataKeepTime = NUM_31 * 24L * 60L * 60L * (long)holdTime;
                break;
            }
            case 3: {
                dataKeepTime = NUM_366 * 24L * 60L * 60L * (long)holdTime;
                break;
            }
            default: {
                dataKeepTime = NUM_24 * 60L * 60L * (long)holdTime;
            }
        }
        return dataKeepTime;
    }
}

