/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.common;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.hs.lego.core.system.sysmonitor.service.db.MonitorFactory;
import com.hs.lego.core.system.sysmonitor.service.dealwithevent.IDealWithAlarm;
import com.hs.lego.core.system.sysmonitor.service.hostserver.HostServerMonitorImpl;
import com.hs.lego.core.system.sysmonitor.service.hostserver.IhostServerMonitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class SysMonitorCache {
    private static final int KEEP_POINT = 180;
    private static final int DEFULT_COUNT = 120;
    private List<Map<Long, HostServerMonitorInfo>> hostInfoList = new CopyOnWriteArrayList<Map<Long, HostServerMonitorInfo>>();
    private List<Map<Long, List<DataBaseInfo>>> dataBaseList = new CopyOnWriteArrayList<Map<Long, List<DataBaseInfo>>>();
    private Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private MonitorFactory dbMonitor;
    private IhostServerMonitor hostServerMonitor = new HostServerMonitorImpl();
    private IDealWithAlarm dealWithAlarm;
    private final Object lock = new Object();

    public void run(int count, boolean firstStart) {
        if (null == this.hostInfoList || null == this.dataBaseList) {
            this.log.error((Object)"SysMonitorCache  hostInfoList is null");
            return;
        }
        long currentTime = System.currentTimeMillis();
        HostServerMonitorInfo hostInfo = null;
        List<DataBaseInfo> dataBaseInfo = null;
        HashMap<Long, HostServerMonitorInfo> hostMap = new HashMap<Long, HostServerMonitorInfo>();
        HashMap<Long, List<DataBaseInfo>> dataBaseMap = null;
        if (120 == count || firstStart) {
            hostInfo = this.hostServerMonitor.getHostServerInfo(count, firstStart);
            try {
                dataBaseInfo = this.dbMonitor.isLocale() ? this.dbMonitor.getMonitor().getDbInfo(hostInfo.getDiskInfo()) : this.dbMonitor.getMonitor().getDbInfo();
                if (null != dataBaseInfo && !dataBaseInfo.isEmpty()) {
                    dataBaseMap = new HashMap<Long, List<DataBaseInfo>>();
                    dataBaseMap.put(currentTime, dataBaseInfo);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        } else if (this.isListNotEmpty()) {
            Map<Long, HostServerMonitorInfo> lastHostInfo = this.hostInfoList.get(this.hostInfoList.size() - 1);
            Set<Map.Entry<Long, HostServerMonitorInfo>> enity = lastHostInfo.entrySet();
            for (Map.Entry<Long, HostServerMonitorInfo> temp : enity) {
                hostInfo = new HostServerMonitorInfo();
                hostInfo.setCpuInfo(temp.getValue().getCpuInfo());
                hostInfo.setMemoryInfo(temp.getValue().getMemoryInfo());
                hostInfo.setDiskInfo(temp.getValue().getDiskInfo());
            }
            HostServerMonitorInfo temp = this.hostServerMonitor.getHostServerInfo(count, firstStart);
            ResourceUse memoryInfo = temp.getMemoryInfo();
            ResourceUse cpuInfo = temp.getCpuInfo();
            if (null != hostInfo) {
                hostInfo.setCpuInfo(cpuInfo);
                hostInfo.setMemoryInfo(memoryInfo);
            }
        }
        hostMap.put(currentTime, hostInfo);
        this.freshMonitor(this.hostInfoList, hostMap);
        this.freshMonitor(this.dataBaseList, dataBaseMap);
        this.dealWithAlarm.generateEvent(dataBaseInfo, this.dbMonitor.isLocale());
        this.dealWithAlarm.generateEvent(hostInfo);
    }

    private boolean isListNotEmpty() {
        return null != this.hostInfoList && !this.hostInfoList.isEmpty();
    }

    private void freshMonitor(List list, Object obj) {
        if (null == obj) {
            return;
        }
        if (null != list && list.size() >= 180) {
            list.remove(0);
        }
        if (null != list) {
            list.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<Long, HostServerMonitorInfo>> getHostInfoList() {
        Object object = this.lock;
        synchronized (object) {
            return this.hostInfoList;
        }
    }

    public void setHostInfoList(List<Map<Long, HostServerMonitorInfo>> hostInfoList) {
        this.hostInfoList = hostInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<Long, List<DataBaseInfo>>> getDataBaseList() {
        Object object = this.lock;
        synchronized (object) {
            return this.dataBaseList;
        }
    }

    public void setDataBaseList(List<Map<Long, List<DataBaseInfo>>> dataBaseList) {
        this.dataBaseList = dataBaseList;
    }

    public void setDealWithAlarm(IDealWithAlarm dealWithAlarm) {
        this.dealWithAlarm = dealWithAlarm;
    }

    public void setDbMonitor(MonitorFactory dbMonitor) {
        this.dbMonitor = dbMonitor;
    }
}

