/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.db;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.sysmonitor.service.db.IMonitorDao;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class MonitorDao
extends HibernateDaoSupport
implements IMonitorDao {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getDBInfo() {
        Connection connection = null;
        try {
            DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)this.getSessionFactory());
            if (null == dataSource) {
                throw new LegoUncheckedException("dataSource is null");
            }
            connection = dataSource.getConnection();
            if (null == connection) {
                throw new LegoUncheckedException("connection is null");
            }
            String url = null;
            String dbType = connection.getMetaData().getDatabaseProductName();
            if ("MySQL".equals(dbType)) {
                url = connection.getMetaData().getURL();
                if (url.contains("//")) {
                    url = url.substring(url.indexOf("//") + 2);
                }
                url = url.contains(":") ? url.substring(0, url.indexOf(":")) : url.substring(0, url.indexOf("/"));
            } else if ("Microsoft SQL Server".equals(dbType)) {
                url = connection.getMetaData().getURL();
                if (url.contains("//")) {
                    url = url.substring(url.indexOf("//") + 2);
                }
                url = url.contains(":") ? url.substring(0, url.indexOf(":")) : url.substring(0, url.indexOf(";"));
            }
            String[] stringArray = new String[]{url, dbType};
            return stringArray;
        }
        catch (SQLException e) {
            LOGGER.error((Object)("session is error" + e));
            String[] stringArray = null;
            return stringArray;
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("session is error" + e));
            String[] stringArray = null;
            return stringArray;
        }
        catch (Exception e) {
            LOGGER.error((Object)("session is error" + e));
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (null != connection) {
                try {
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("connection is error" + e));
                        connection = null;
                    }
                }
                catch (Throwable throwable) {
                    connection = null;
                    throw throwable;
                }
            }
        }
    }
}

