/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.db.mysql;

import com.hs.lego.core.system.sysmonitor.service.db.mysql.IMysqlMonitorDao;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class MysqlMonitorDao
extends HibernateDaoSupport
implements IMysqlMonitorDao {
    private static final String DB_SIZE_SQL = "SELECT TABLE_SCHEMA, SUM(DATA_LENGTH) AS DATA_SIZE, SUM(INDEX_LENGTH) AS INDEX_SIZE, SUM(DATA_FREE) AS UNUSED_SIZE, SUM(MAX_DATA_LENGTH) AS MAX_DATA_SIZE FROM INFORMATION_SCHEMA.TABLES GROUP BY TABLE_SCHEMA";
    private static final String DB_FILE_SQL = "SELECT VARIABLE_VALUE FROM performance_schema.GLOBAL_VARIABLES WHERE VARIABLE_NAME = 'DATADIR'";
    private static final String DB_BASE_SQL = "SELECT VARIABLE_VALUE FROM performance_schema.GLOBAL_VARIABLES WHERE VARIABLE_NAME = 'BASEDIR'";
    private static final String DB_VERSION_SQL = "SELECT VERSION()";
    private static final String DBMS_INFORMATION_SCHEMA = "information_schema";
    private static final String DBMS_PERF_SCHEMA = "performance_schema";
    private static final String DBMS_MYSQL_SCHEMA = "mysql";

    @Override
    public List<Object[]> getDbSize() {
        ArrayList<Object[]> dbList = null;
        List<?> rs = this.findBySql(DB_SIZE_SQL);
        if (null == rs) {
            return dbList;
        }
        dbList = new ArrayList<Object[]>();
        for (Object obj : rs) {
            Object[] objs = (Object[])obj;
            String dbName = objs[0].toString();
            if (dbName.isEmpty() || DBMS_INFORMATION_SCHEMA.equals(dbName) || DBMS_MYSQL_SCHEMA.equals(dbName) || DBMS_PERF_SCHEMA.equals(dbName)) continue;
            dbList.add(objs);
        }
        return dbList;
    }

    @Override
    public String getDBVersion() {
        String dbVersion = null;
        List<?> rs = null;
        rs = this.findBySql(DB_VERSION_SQL);
        if (null != rs) {
            for (Object obj : rs) {
                dbVersion = obj.toString();
            }
        }
        return dbVersion;
    }

    @Override
    public String getDBFilePath() {
        String dbPath = null;
        List<?> rs = null;
        rs = this.findBySql(DB_FILE_SQL);
        if (null != rs) {
            for (Object obj : rs) {
                dbPath = obj.toString();
            }
        }
        if ((dbPath == null || "".equals(dbPath.trim())) && null != (rs = this.findBySql(DB_BASE_SQL))) {
            for (Object obj : rs) {
                dbPath = obj.toString();
            }
        }
        return dbPath;
    }

    private List<?> findBySql(String sql) {
        FindBySqlCallBack callback = new FindBySqlCallBack(sql);
        return (List)super.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    private static final class FindBySqlCallBack
    implements HibernateCallback {
        private String sql;

        public FindBySqlCallBack(String sql) {
            this.sql = sql;
        }

        public Object doInHibernate(Session session) {
            List list = session.createNativeQuery(this.sql).getResultList();
            return list;
        }
    }
}

