/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.dealwithevent;

import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultQueryCondition;
import com.hs.lego.cbb.fault.sdk.model.FaultVO;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.hs.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.hs.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.hs.lego.core.system.sysmonitor.service.dealwithevent.AlarmCount;
import com.hs.lego.core.system.sysmonitor.service.dealwithevent.IDealWithAlarm;
import com.hs.lego.core.system.sysmonitor.service.treshold.ISysmTresholdService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DealWithAlarm
implements IDealWithAlarm {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private static final int COUNT = 3;
    private static final int SLLEEP_TIME = 1000;
    private static final int LOOP_COUNT = 100;
    private FaultService faultService = null;
    private Map<String, AlarmCount> countMap = new HashMap<String, AlarmCount>();
    private Map<String, Boolean> firstStartFlag = new HashMap<String, Boolean>();
    private ISysmTresholdService sysTresholdService;

    @Override
    public void generateEvent(List<DataBaseInfo> currentDataBaseInfo, boolean locale) {
        if (null == currentDataBaseInfo) {
            return;
        }
        for (DataBaseInfo temp : currentDataBaseInfo) {
            if (!locale && temp.getAutoIncrease().booleanValue()) {
                LOGGER.info((Object)("Remote db server .Db auto increase and not upper Limit .so don't generate alarm .db name is " + temp.getDataBaseName()));
                continue;
            }
            this.generateEvent(temp.getDataBaseName(), temp.getPercent(), SysmTresholdType.db);
        }
    }

    @Override
    public void generateEvent(HostServerMonitorInfo serverMonitorInfo) {
        if (null == serverMonitorInfo) {
            return;
        }
        ResourceUse cpuUse = serverMonitorInfo.getCpuInfo();
        ResourceUse memUse = serverMonitorInfo.getMemoryInfo();
        this.generateEvent("CPU", cpuUse.getPercent(), SysmTresholdType.cpu);
        this.generateEvent("MEM", memUse.getPercent(), SysmTresholdType.mem);
        List<DiskResouceUse> diskList = serverMonitorInfo.getDiskInfo();
        this.generateDiskEvent(diskList);
    }

    private void generateDiskEvent(List<DiskResouceUse> diskList) {
        if (null == diskList) {
            return;
        }
        for (DiskResouceUse temp : diskList) {
            this.generateEvent(temp.getDiskName(), temp.getPercent(), SysmTresholdType.disk);
        }
    }

    private void generateEvent(String resName, String percent, SysmTresholdType type) {
        SysmTreshold treshold = null;
        float lpercent = -1.0f;
        if (null != this.sysTresholdService) {
            treshold = this.sysTresholdService.getSysmTreshold(type.getValue());
        }
        if (null == treshold) {
            return;
        }
        lpercent = this.getPercent(percent);
        if (lpercent < 0.0f) {
            return;
        }
        if (lpercent >= (float)treshold.getPercent()) {
            this.dealWithMoreTreshold(resName, treshold, lpercent);
        } else {
            this.dealWithLessTreshold(resName, treshold, lpercent);
        }
    }

    private void dealWithMoreTreshold(String resName, SysmTreshold treshold, float lpercent) {
        if (!this.countMap.containsKey(resName)) {
            AlarmCount alarmCount = new AlarmCount();
            alarmCount.setResName(resName);
            alarmCount.setCount(1);
            this.countMap.put(resName, alarmCount);
            if (!"CPU".equals(resName) && !"MEM".equals(resName)) {
                this.generateEvent(resName, true, treshold, lpercent);
            }
        } else {
            AlarmCount alarmCount = this.countMap.get(resName);
            int count = alarmCount.getCount();
            if ("CPU".equals(resName) || "MEM".equals(resName)) {
                if (++count == 3) {
                    alarmCount.setCount(4);
                    this.countMap.put(resName, alarmCount);
                    alarmCount.setGenerateAlarm(Boolean.TRUE);
                    this.generateEvent(resName, true, treshold, lpercent);
                } else {
                    Boolean judgeCleared = this.judgeFaultClear(resName);
                    if (judgeCleared.booleanValue() && count > 3) {
                        count = 1;
                    }
                    alarmCount.setCount(count);
                    this.countMap.put(resName, alarmCount);
                }
            }
        }
    }

    private Boolean judgeFaultClear(String resName) {
        String alarmId = null;
        if ("CPU".equals(resName)) {
            alarmId = "0x000803220001";
        } else if ("MEM".equals(resName)) {
            alarmId = "0x000803220002";
        } else {
            return false;
        }
        FaultQueryCondition faultQueryCondition = new FaultQueryCondition();
        faultQueryCondition.setClearStatus(Byte.valueOf((byte)1));
        List faults = this.faultService.listAllFault(faultQueryCondition);
        for (int i = 0; i < faults.size(); ++i) {
            Fault fault = (Fault)faults.get(i);
            if (!fault.getFaultDefineId().equals(alarmId)) continue;
            return fault.getClearStatus() == 1;
        }
        return false;
    }

    private void dealWithLessTreshold(String resName, SysmTreshold treshold, float lpercent) {
        if (this.countMap.containsKey(resName)) {
            AlarmCount alarmCount = this.countMap.get(resName);
            if ("CPU".equals(resName) || "MEM".equals(resName)) {
                if (alarmCount.isGenerateAlarm()) {
                    this.generateEvent(resName, false, treshold, lpercent);
                }
            } else {
                this.generateEvent(resName, false, treshold, lpercent);
            }
            this.countMap.remove(resName);
        } else if (this.firstStartFlag.isEmpty() || !this.firstStartFlag.containsKey(resName)) {
            this.generateEvent(resName, false, treshold, lpercent);
            this.firstStartFlag.put(resName, Boolean.TRUE);
        }
    }

    private void generateEvent(String resNme, boolean isAlarm, SysmTreshold treshold, float crrentPercent) {
        if (null == treshold) {
            return;
        }
        String[] alarmParam = null;
        String alarmId = "";
        if (treshold.getId().longValue() == SysmTresholdType.cpu.getValue()) {
            alarmParam = new String[]{String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220001";
        } else if (treshold.getId().longValue() == SysmTresholdType.db.getValue()) {
            alarmParam = new String[]{resNme, String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220003";
        } else if (treshold.getId().longValue() == SysmTresholdType.disk.getValue()) {
            alarmParam = new String[]{resNme, String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220004";
        } else if (treshold.getId().longValue() == SysmTresholdType.mem.getValue()) {
            alarmParam = new String[]{String.valueOf(treshold.getPercent()), String.valueOf(crrentPercent)};
            alarmId = "0x000803220002";
        }
        FaultVO fault = new FaultVO();
        fault.setFaultDefineId(alarmId);
        fault.setSeverity(FaultVO.FaultSeverity.MAJOR.getValue());
        fault.setSourceType(FaultVO.FaultSourceType.SYSTEM.getValue());
        fault.setSource("system");
        fault.setMoId(Long.valueOf(1L));
        fault.setParam(alarmParam);
        try {
            if (!isAlarm) {
                this.faultService.restoreFault(fault);
            } else {
                this.faultService.createFault(fault);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"alarmService    generate  LegoRestoreAlarm error", (Throwable)e);
        }
    }

    private float getPercent(String oldPercent) {
        float lPercent = -1.0f;
        String percent = oldPercent.replaceAll("%", "").trim();
        if (!"".equals(percent) && !"N/A".equals(percent)) {
            lPercent = Float.valueOf(percent).floatValue();
        }
        return lPercent;
    }

    public ISysmTresholdService getSysTresholdService() {
        return this.sysTresholdService;
    }

    public void setSysTresholdService(ISysmTresholdService sysTresholdService) {
        this.sysTresholdService = sysTresholdService;
    }

    public FaultService getFaultService() {
        return this.faultService;
    }

    public void setFaultService(FaultService faultService) {
        this.faultService = faultService;
    }
}

