/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.hostserver;

import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.hs.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import com.hs.lego.core.system.sysmonitor.service.hostserver.IhostServerMonitor;
import com.hs.lego.core.system.sysmonitor.service.hostserver.SystemToolFactory;
import com.hs.lego.core.system.sysmonitor.service.hostserver.WindowsSystemTool;
import java.util.List;

public class HostServerMonitorImpl
implements IhostServerMonitor {
    private static final int MB = 1024;
    private static final int HUNDRED = 100;
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int DEFULT_COUNT = 120;
    private ISystemTool systemTool;

    @Override
    public HostServerMonitorInfo getHostServerInfo(int count, boolean firstStart) {
        HostServerMonitorInfo hostServerMonitorInfo = new HostServerMonitorInfo();
        this.systemTool = SystemToolFactory.getSystemTool();
        if (120 == count || firstStart) {
            List<DiskResouceUse> diskInfo = this.systemTool.getDisk();
            hostServerMonitorInfo.setDiskInfo(diskInfo);
        }
        long totalMem = 0L;
        long availMem = 0L;
        double percent = 0.0;
        if (this.systemTool instanceof WindowsSystemTool) {
            String[] result = this.systemTool.getAllInfo("");
            if (null != result && result.length > 2) {
                percent = Double.parseDouble(result[0]);
                totalMem = Long.parseLong(result[1]);
                availMem = Long.parseLong(result[2]);
            }
        } else {
            totalMem = this.systemTool.getTotalMemInfo();
            availMem = this.systemTool.getAvailMemInfo();
            percent = this.systemTool.getCpuInfo();
        }
        ResourceUse memoryInfo = this.getMemoryInfo(totalMem, availMem);
        ResourceUse cpuInfo = this.getCpuInfo(percent);
        hostServerMonitorInfo.setCpuInfo(cpuInfo);
        hostServerMonitorInfo.setMemoryInfo(memoryInfo);
        return hostServerMonitorInfo;
    }

    @Override
    public ResourceUse getMemoryInfo() {
        this.systemTool = SystemToolFactory.getSystemTool();
        long totalMem = this.systemTool.getTotalMemInfo();
        long availMem = this.systemTool.getAvailMemInfo();
        ResourceUse memory = this.getMemoryInfo(totalMem, availMem);
        return memory;
    }

    private ResourceUse getMemoryInfo(long totalMem, long availMem) {
        ResourceUse memory = new ResourceUse();
        String totalMB = totalMem / 1024L + " MB";
        String usedMB = (totalMem - availMem) / 1024L + " MB";
        String remain = availMem / 1024L + " MB";
        memory.setTotal(totalMB);
        memory.setUsed(usedMB);
        memory.setRemain(remain);
        double percent = 0.0;
        long used = 0L;
        if (totalMem > 0L) {
            used = (totalMem - availMem) * 100L;
            percent = (double)used / (double)totalMem;
            percent = MathUtil.getDoubleValue((double)percent);
        }
        memory.setPercent(percent + "%");
        return memory;
    }

    @Override
    public ResourceUse getCpuInfo() {
        this.systemTool = SystemToolFactory.getSystemTool();
        double percent = this.systemTool.getCpuInfo();
        ResourceUse cpuInfo = null;
        cpuInfo = percent < 0.0 ? this.getCpuInfo(0.0) : this.getCpuInfo(percent);
        return cpuInfo;
    }

    private ResourceUse getCpuInfo(double percentParam) {
        double percent = percentParam;
        ResourceUse cpuInfo = new ResourceUse();
        if (percent < 0.0) {
            percent = 0.0;
        }
        cpuInfo.setPercent(percent + "%");
        return cpuInfo;
    }

    @Override
    public List<DiskResouceUse> getDiskInfo() {
        this.systemTool = SystemToolFactory.getSystemTool();
        List<DiskResouceUse> diskInfo = this.systemTool.getDisk();
        return diskInfo;
    }
}

