/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.hostserver;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class LinuxSystemTool
implements ISystemTool {
    private static final String MEM_INFO_PATH = "/proc/meminfo";
    private static final String CPU_INFO_PATH = "/proc/stat";
    private static final long MB2GB = 1000L;
    private static final int ONE_HUNDRED = 100;
    private static final int A_THOUSAND = 1000;
    private static final int LINE_KEY_NUM = 7;
    private static final int LINE_TYPE = 1;
    private static final int LINE_TOTAL = 2;
    private static final int LINE_USED = 3;
    private static final int LINE_AVLID = 4;
    private static final int LINE_PERCENT = 5;
    private static final int LINE_NAME = 6;
    private static final int TIME_OUT = 5000;
    private static final int SLEEP_TIME = 5000;
    private static final int MAX_STRING_SIZE = 10240;
    private static final String ISO = "iso9660";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinuxSystemTool() {
        LOGGER.info((Object)"~~begin to load oscommand.properties");
        Properties props = new Properties();
        InputStream instream = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            if (null != loader) {
                instream = loader.getResourceAsStream("oscommand.properties");
            }
            if (null != instream) {
                props.load(instream);
            }
            String linuxDiskCmd = props.getProperty("cmd.linux.disk", "df -hT");
            System.setProperty("cmd.linux.disk", linuxDiskCmd);
            LOGGER.info((Object)("cmd.linux.disk:" + linuxDiskCmd));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read oscommand.properties error.", (Throwable)e);
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close InputStream of oscommand.properties fail");
                }
            }
        }
    }

    @Override
    public long getPercentMemInfo() {
        int[] result = this.getMemInfo();
        long memUsedPercent = result[0] * 100 / (result[0] + result[1]);
        return memUsedPercent;
    }

    @Override
    public long getTotalMemInfo() {
        long total = -1L;
        int[] result = this.getMemInfo();
        if (result.length >= 2) {
            total = result[0] + result[1];
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int[] getMemInfo() {
        String[] strArray;
        int[] result;
        block11: {
            LOGGER.debug((Object)"start");
            result = new int[3];
            strArray = new String[4];
            Runtime rt = Runtime.getRuntime();
            BufferedReader errRead = null;
            BufferedReader bufRead = null;
            Process process = null;
            try {
                process = rt.exec("free");
                errRead = new BufferedReader(new InputStreamReader(process.getErrorStream(), "utf-8"));
                bufRead = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
                String str = null;
                while (null != (str = errRead.readLine())) {
                }
                while ((str = bufRead.readLine()) != null) {
                    if (!str.contains("-/+ buffers/cache:")) continue;
                    StringTokenizer token = new StringTokenizer(str);
                    for (int i = 0; token.hasMoreTokens() && i < 4; ++i) {
                        strArray[i] = token.nextToken();
                    }
                }
                this.destroy(errRead, bufRead, process);
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException error");
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception", (Throwable)e);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.destroy(errRead, bufRead, process);
            }
        }
        if (null != strArray[2] && null != strArray[3]) {
            result[0] = Integer.parseInt(strArray[2]);
            result[1] = Integer.parseInt(strArray[3]);
        }
        return result;
    }

    private void destroy(BufferedReader errRead, BufferedReader bufRead, Process process) {
        try {
            if (null != errRead) {
                errRead.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"buf close failure");
        }
        try {
            if (null != bufRead) {
                bufRead.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"buf close failure");
        }
        if (null != process) {
            try {
                process.destroy();
            }
            catch (Exception e2) {
                LOGGER.error((Object)"buf close failure:", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CpuInfo getSomeTimeCpuInfo() {
        CpuInfo cpuInfo = new CpuInfo();
        FileInputStream fileInput = null;
        InputStreamReader input = null;
        BufferedReader bufReader = null;
        try {
            StringTokenizer token;
            File file = new File(LinuxSystemTool.getCpuInfoPath());
            fileInput = new FileInputStream(file);
            input = new InputStreamReader((InputStream)fileInput, "utf-8");
            bufReader = new BufferedReader(input);
            String str = bufReader.readLine();
            if (str != null && (token = new StringTokenizer(str)).hasMoreTokens()) {
                token.nextToken();
                cpuInfo.user = Float.parseFloat(token.nextToken());
                cpuInfo.nice = Float.parseFloat(token.nextToken());
                cpuInfo.sys = Float.parseFloat(token.nextToken());
                cpuInfo.idle = Float.parseFloat(token.nextToken());
                cpuInfo.syswa = Float.parseFloat(token.nextToken());
                cpuInfo.syswi = Float.parseFloat(token.nextToken());
                cpuInfo.syssi = Float.parseFloat(token.nextToken());
                cpuInfo.sysst = Float.parseFloat(token.nextToken());
            }
        }
        catch (IOException e) {
            LOGGER.info((Object)"getCpuInfo() | IOException");
        }
        finally {
            try {
                if (null != bufReader) {
                    bufReader.close();
                }
                if (null != input) {
                    input.close();
                }
                if (null != fileInput) {
                    fileInput.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"fail to close buf IOException");
            }
        }
        return cpuInfo;
    }

    @Override
    public double getCpuInfo() {
        double cpuUsedPercent = 0.0;
        CpuInfo infoOne = this.getSomeTimeCpuInfo();
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.info((Object)("getCpuInfo() | sleep interrupted:" + e));
        }
        CpuInfo infoTwo = this.getSomeTimeCpuInfo();
        float total = infoTwo.user + infoTwo.sys + infoTwo.nice + infoTwo.idle + infoTwo.syswa + infoTwo.syswi + infoTwo.syssi + infoTwo.sysst - (infoOne.user + infoOne.sys + infoOne.nice + infoOne.idle + infoOne.syswa + infoOne.syswi + infoOne.syssi + infoOne.sysst);
        if (0.0f != total) {
            cpuUsedPercent = 1.0f - (infoTwo.idle - infoOne.idle) / total;
        }
        LOGGER.debug((Object)("getCpuInfo() | cpuUsedPercent is:{0} " + cpuUsedPercent));
        return 100.0 * cpuUsedPercent;
    }

    public static String getMemInfoPath() {
        return MEM_INFO_PATH;
    }

    public static String getCpuInfoPath() {
        return CPU_INFO_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiskResouceUse> getDisk() {
        LOGGER.info((Object)"getRootPartition() | start to get root partition");
        ArrayList<DiskResouceUse> diskList = new ArrayList<DiskResouceUse>();
        String o = System.getProperty("os.name");
        String os = null;
        if (null == o) {
            return diskList;
        }
        os = o.toLowerCase(Locale.US);
        if (!os.contains("linux")) {
            LOGGER.error((Object)("os name not clear: " + os));
            return diskList;
        }
        String cmd = "sudo df -hT";
        String cmdAdjust = System.getProperty("cmd.linux.disk");
        if (cmdAdjust != null && !cmdAdjust.isEmpty()) {
            if (Pattern.matches("[0-9A-Za-z./]+", cmdAdjust)) {
                cmd = cmdAdjust;
                LOGGER.info((Object)("use linux disk adjust command: " + cmdAdjust));
            }
        } else {
            LOGGER.info((Object)"use defualt linux disk adjust command: df -hT");
        }
        LOGGER.info((Object)("get disk info cmd is " + cmd));
        Process process = null;
        BufferedReader in = null;
        InputStreamReader ir = null;
        int exitVal = -1;
        try {
            process = Runtime.getRuntime().exec(cmd);
            this.sleep(5000);
            long startTime = System.currentTimeMillis();
            boolean processFinished = false;
            while (System.currentTimeMillis() - startTime < 5000L && !processFinished) {
                exitVal = process.exitValue();
                LOGGER.info((Object)("process.exitValue() = " + exitVal));
                if (0 == exitVal) {
                    processFinished = Boolean.TRUE;
                }
                this.sleep(5000);
            }
            if (0 == exitVal) {
                ir = new InputStreamReader(process.getInputStream(), "utf-8");
                in = new BufferedReader(ir);
                String str = "";
                ArrayList<String> regularOutput = new ArrayList<String>();
                String leftString = "";
                while ((str = in.readLine()) != null) {
                    List<String> result;
                    String temp = str.replaceAll("\\s", " ");
                    if (!leftString.isEmpty()) {
                        temp = leftString + " " + temp;
                    }
                    if ((result = this.getSplitDiskValues(temp)).size() >= 7) {
                        if (temp.length() > 10240 || regularOutput.size() > 10240) break;
                        regularOutput.add(temp);
                        leftString = "";
                        continue;
                    }
                    leftString = str;
                    LOGGER.info((Object)("less line retrived:" + leftString));
                }
                for (String line : regularOutput) {
                    DiskResouceUse resourceUse = this.getResouceUse(line);
                    if (null == resourceUse) continue;
                    diskList.add(resourceUse);
                }
            }
        }
        catch (IllegalThreadStateException e) {
            LOGGER.error((Object)"Fail to get root partition, IOException:", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Fail to get root partition, IOException");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Fail to get root partition, exception:", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Fail to get root partition, exception:", (Throwable)e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != ir) {
                    ir.close();
                }
            }
            catch (IOException ioex) {
                LOGGER.error((Object)"fail to close input");
            }
            catch (Exception ex) {
                LOGGER.error((Object)"fail to close input", (Throwable)ex);
            }
            if (null != process) {
                try {
                    process.destroy();
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"buf close failure:", (Throwable)ex);
                }
            }
        }
        return diskList;
    }

    private List<String> getSplitDiskValues(String str) {
        String temp = str.replaceAll("\\s", " ");
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(temp, " ");
        for (int i = 0; tokenizer.hasMoreTokens() && i < 7; ++i) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private DiskResouceUse getResouceUse(String str) {
        DiskResouceUse resourceUse = null;
        String keyword = "/dev/";
        String ukeyword = "udev";
        if (str.contains(keyword) && !str.contains(ukeyword)) {
            String keyword1 = "/";
            String keyword2 = "/opt";
            String keyword3 = "/opt/hwlog";
            String strTrim = str.trim();
            String[] wordList = (strTrim = strTrim.replaceAll("\\s", " ")).split(" ");
            String lastWord = wordList[wordList.length - 1];
            if (lastWord.equals(keyword1) || lastWord.equals(keyword2) || lastWord.equals(keyword3)) {
                LOGGER.info((Object)("getResouceUse: " + str));
                List<String> result = this.getSplitDiskValues(str);
                if (result.size() < 7) {
                    LOGGER.error((Object)("input string is no more than 7 : " + str));
                    return null;
                }
                if (ISO.equalsIgnoreCase(result.get(1))) {
                    LOGGER.error((Object)("ISO.equalsIgnoreCase: " + result.get(1)));
                    return null;
                }
                resourceUse = new DiskResouceUse();
                StringBuilder ssResult = new StringBuilder();
                ssResult.append("setDiskName: ");
                ssResult.append(result.get(6));
                ssResult.append(";setTotal: ");
                ssResult.append(result.get(2));
                ssResult.append(";setUsed: ");
                ssResult.append(result.get(3));
                ssResult.append(";setAvail: ");
                ssResult.append(result.get(4));
                ssResult.append(";setPercent: ");
                ssResult.append(result.get(5));
                LOGGER.info((Object)("disk item result: " + ssResult.toString()));
                for (String item : result) {
                    if (item != null) continue;
                    LOGGER.error((Object)"input string is encount null");
                    return null;
                }
                resourceUse.setDiskName(result.get(6));
                if (!result.get(0).contains(keyword) || result.get(0).contains(ukeyword)) {
                    LOGGER.error((Object)("disk name is invalid: " + result.get(0)));
                    return null;
                }
                resourceUse.setTotal(result.get(2));
                resourceUse.setUsed(result.get(3));
                resourceUse.setAvail(result.get(4));
                resourceUse.setPercent(result.get(5));
                resourceUse = this.unit(resourceUse);
                resourceUse.setUnit("GB");
            }
        }
        return resourceUse;
    }

    private DiskResouceUse unit(DiskResouceUse diskResouceUse) {
        String avail = diskResouceUse.getAvail();
        String used = diskResouceUse.getUsed();
        String total = diskResouceUse.getTotal();
        if (avail.contains("M") || avail.contains("K") || avail.contains("T")) {
            diskResouceUse.setAvail(this.getGb(avail));
        }
        if (used.contains("M") || used.contains("K") || used.contains("T")) {
            diskResouceUse.setUsed(this.getGb(used));
        }
        if (total.contains("M") || total.contains("K") || total.contains("T")) {
            diskResouceUse.setTotal(this.getGb(total));
        }
        return diskResouceUse;
    }

    private String getGb(String value) {
        Double gbValue;
        String gb = "";
        String gbUnit = "G";
        if (value.contains("M")) {
            gbValue = MathUtil.getDoubleValue((double)(Double.parseDouble(value.replaceAll("M", "")) / 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("K")) {
            gbValue = MathUtil.getDoubleValue((double)(Double.parseDouble(value.replaceAll("K", "")) / 1000000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("T")) {
            gbValue = MathUtil.getDoubleValue((double)(Double.parseDouble(value.replaceAll("T", "")) * 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        return gb;
    }

    private void sleep(int sleepTime) {
        try {
            TimeUnit.MILLISECONDS.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"System monitor thread interruptedException ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"System monitor thread Exception ", (Throwable)e);
        }
    }

    @Override
    public String[] getAllInfo(String para) {
        return new String[0];
    }

    @Override
    public long getAvailMemInfo() {
        int[] result = this.getMemInfo();
        return result[1];
    }

    private static class CpuInfo {
        private float user;
        private float nice;
        private float sys;
        private float idle;
        private float syswa;
        private float syswi;
        private float syssi;
        private float sysst;

        private CpuInfo() {
        }
    }
}

