/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.hostserver;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import com.hs.lego.core.system.sysmonitor.service.hostserver.LinuxSystemTool;
import com.hs.lego.core.system.sysmonitor.service.hostserver.WindowsSystemTool;
import java.util.Locale;

public final class SystemToolFactory {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private static final Object LOCK = new Object();
    private static ISystemTool systemTool = null;

    private SystemToolFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISystemTool getSystemTool() {
        Object object = LOCK;
        synchronized (object) {
            if (systemTool != null) {
                return systemTool;
            }
            String o = System.getProperty("os.name");
            if (null == o) {
                return null;
            }
            String os = o.toLowerCase(Locale.US);
            if (os.contains("win")) {
                try {
                    systemTool = new WindowsSystemTool();
                }
                catch (Exception e) {
                    LOGGER.info((Object)("init resource tool failed" + e));
                }
                LOGGER.info((Object)"use windows system tool");
            }
            if (os.contains("linux")) {
                systemTool = new LinuxSystemTool();
                LOGGER.info((Object)"use linux system tool");
            }
            return systemTool;
        }
    }
}

