/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.hostserver;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class WindowsSystemTool
implements ISystemTool {
    private static final String CPU_USE_PERCENT = "CPU";
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static final String MEM_AVAILMEM = "AVAILMEM";
    private static final long GB = 0x40000000L;
    private static final double DBHUNDRED = 100.0;
    private static final double LHUNDRED = 100.0;
    private static final int MAX_STRING_SIZE = 10240;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private final Object lock = new Object();
    private String cmd = "";

    public WindowsSystemTool() {
        String property = System.getProperty("user.dir");
        String currentPath = new File(property).getParentFile().getParent();
        this.cmd = currentPath + File.separator + "tools" + File.separator + "resource.exe ";
    }

    @Override
    public double getCpuInfo() {
        long percent = 0L;
        try {
            percent = this.getCPUAndMenInfo(CPU_USE_PERCENT);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return percent;
    }

    @Override
    public long getPercentMemInfo() {
        long total = this.getTotalMemInfo();
        long avail = this.getAvailMemInfo();
        long use = total - avail;
        double percent = (double)use * 100.0 / 100.0;
        return (long)percent;
    }

    @Override
    public long getAvailMemInfo() {
        return this.getCPUAndMenInfo(MEM_AVAILMEM);
    }

    @Override
    public long getTotalMemInfo() {
        return this.getCPUAndMenInfo(MEM_TOTALMEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCPUAndMenInfo(String paraParam) {
        StringBuffer sb = new StringBuffer();
        String[] para = (this.cmd + paraParam).split("\\s+");
        ProcessBuilder pb = new ProcessBuilder(para);
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e1) {
            LOGGER.error((Object)"getCPUAndMenInfo error");
        }
        InputStreamReader ir = null;
        LineNumberReader input = null;
        if (null == process) {
            LOGGER.error((Object)"getCPUAndMenInfo init process object occurs error, then process is null.");
            return 1L;
        }
        try {
            ir = new InputStreamReader(process.getInputStream(), "utf-8");
            input = new LineNumberReader(ir);
            String line = input.readLine();
            while (line != null) {
                LOGGER.info((Object)(line + "getCPUAndMenInfo"));
                sb.append(line);
                line = input.readLine();
                if (null == line || line.length() <= 0) continue;
                sb.append(System.getProperty("line.separator"));
            }
            if (sb.length() < 10240) {
                int beginindex = sb.lastIndexOf(System.getProperty("line.separator"));
                String value = null;
                value = -1 == beginindex ? sb.toString() : sb.substring(beginindex);
                long l = Long.parseLong(value);
                this.closestream(ir, input, process);
                return l;
            }
            this.closestream(ir, input, process);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"parse response getCPUAndMenInfo occurs error.");
        }
        finally {
            this.closestream(ir, input, process);
        }
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiskResouceUse> getDisk() {
        Object object = this.lock;
        synchronized (object) {
            File[] roots = File.listRoots();
            ArrayList<DiskResouceUse> list = new ArrayList<DiskResouceUse>();
            if (roots == null) {
                return list;
            }
            for (File file : roots) {
                DiskResouceUse disktemp = new DiskResouceUse();
                disktemp.setDiskName(file.getPath());
                double totalSpace = file.getTotalSpace();
                double usableSpace = file.getUsableSpace();
                if (!(totalSpace > 0.0) || !file.canWrite() || !(usableSpace > 0.0)) continue;
                double total = MathUtil.getDoubleValue((double)(totalSpace / 1.073741824E9));
                disktemp.setTotal(total + " G");
                double useableGB = MathUtil.getDoubleValue((double)(usableSpace / 1.073741824E9));
                double used = MathUtil.getDoubleValue((double)(total - useableGB));
                disktemp.setUsed(used + " G");
                disktemp.setUnit("GB");
                disktemp.setAvail(useableGB + " G");
                double percent = MathUtil.getDoubleValue((double)((totalSpace - usableSpace) / totalSpace)) * 100.0;
                disktemp.setPercent(percent + "%");
                list.add(disktemp);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllInfo(String paraParam) {
        StringBuffer sb = new StringBuffer();
        String[] para = (this.cmd + paraParam).split("\\s+");
        ProcessBuilder pb = new ProcessBuilder(para);
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e1) {
            LOGGER.error((Object)"getAllInfo error");
        }
        InputStreamReader ir = null;
        LineNumberReader input = null;
        if (null == process) {
            LOGGER.error((Object)"getAllInfo init process object occurs error, then process is null.");
            return new String[0];
        }
        try {
            ir = new InputStreamReader(process.getInputStream(), "utf-8");
            input = new LineNumberReader(ir);
            String line = input.readLine();
            while (line != null) {
                LOGGER.info((Object)(line + "getAllInfo"));
                sb.append(line);
                line = input.readLine();
                if (null == line || line.length() <= 0) continue;
                sb.append(System.getProperty("line.separator"));
            }
            if (sb.length() < 10240) {
                int beginindex = sb.lastIndexOf(System.getProperty("line.separator"));
                String value = null;
                value = -1 == beginindex ? sb.toString() : sb.substring(beginindex);
                String[] stringArray = value.split("-");
                this.closestream(ir, input, process);
                return stringArray;
            }
            this.closestream(ir, input, process);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"parse response getAllInfo occurs error.");
        }
        finally {
            this.closestream(ir, input, process);
        }
        return new String[0];
    }

    private void closestream(InputStreamReader ir, LineNumberReader input, Process process) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close io occurs error");
            }
        }
        if (null != ir) {
            try {
                ir.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close io occurs error");
            }
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"close io occurs error", (Throwable)e);
        }
    }
}

