/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.impl;

import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.hs.lego.core.system.sysmonitor.sdk.service.ISysMonitor;
import com.hs.lego.core.system.sysmonitor.service.common.MonitorCacheThread;
import com.hs.lego.core.system.sysmonitor.service.common.SysMonitorCache;
import com.hs.lego.core.system.sysmonitor.service.treshold.ISysmTresholdService;
import com.hs.lego.core.system.sysmonitor.service.treshold.SysmTresholdService;
import java.util.List;
import java.util.Map;

public class SysMonitorImpl
implements ISysMonitor {
    private static final long serialVersionUID = 1L;
    private SysMonitorCache sysMonitorCache;
    private MonitorCacheThread monitorCacheThread;
    private ISysmTresholdService sysTresholdService;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);

    @Override
    public Map<?, HostServerMonitorInfo> getCurrentHostServerInfo() {
        Map<Long, HostServerMonitorInfo> temp = null;
        List<Map<Long, HostServerMonitorInfo>> hostInfoList = this.sysMonitorCache.getHostInfoList();
        if (null == hostInfoList) {
            this.log.info((Object)"hostInfoList is null");
            return null;
        }
        if (!hostInfoList.isEmpty()) {
            temp = hostInfoList.get(hostInfoList.size() - 1);
        }
        return temp;
    }

    @Override
    public List<Map<Long, HostServerMonitorInfo>> getHistoryhostInfo() {
        return this.sysMonitorCache.getHostInfoList();
    }

    @Override
    public Map<?, List<DataBaseInfo>> getDataBaseInfo() {
        List<Map<Long, List<DataBaseInfo>>> list = this.sysMonitorCache.getDataBaseList();
        if (null == list) {
            this.log.info((Object)"DataBaseInfo is null");
            return null;
        }
        Map<Long, List<DataBaseInfo>> current = null;
        int listSize = list.size();
        if (listSize >= 1) {
            current = this.sysMonitorCache.getDataBaseList().get(listSize - 1);
        }
        return current;
    }

    @Override
    public List<Map<Long, List<DataBaseInfo>>> getHistoryDataBaseInfo() {
        List<Map<Long, List<DataBaseInfo>>> list = this.sysMonitorCache.getDataBaseList();
        return list;
    }

    @Override
    public List<SysmTreshold> getSysmTreshold() {
        return this.sysTresholdService.getSysmTreshold();
    }

    @Override
    public void updateSysmTreshold(List<SysmTreshold> list) {
        this.sysTresholdService.updateSysmTreshold(list);
    }

    public void setMonitorCacheThread(MonitorCacheThread monitorCacheThread) {
        this.monitorCacheThread = monitorCacheThread;
    }

    public void setSysTresholdService(SysmTresholdService sysTresholdService) {
        this.sysTresholdService = sysTresholdService;
    }

    public void setSysMonitorCache(SysMonitorCache sysMonitorCache) {
        this.sysMonitorCache = sysMonitorCache;
    }

    public ISysmTresholdService getSysTresholdService() {
        return this.sysTresholdService;
    }

    public void setSysTresholdService(ISysmTresholdService sysTresholdService) {
        this.sysTresholdService = sysTresholdService;
    }

    public SysMonitorCache getSysMonitorCache() {
        return this.sysMonitorCache;
    }

    public void initialize() {
        if (null != this.monitorCacheThread) {
            this.monitorCacheThread.setMonitorStart(true);
            this.monitorCacheThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            this.monitorCacheThread.start();
        }
        this.log.info((Object)"System bundle SysMonitor Modle start");
    }

    public void stop() {
        if (null != this.monitorCacheThread) {
            this.monitorCacheThread.setMonitorStart(false);
        }
        this.log.info((Object)"System bundle SysMonitor Modle stop");
    }
}

