/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.treshold;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.base.event.StatusChangedEvent;
import com.hs.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.hs.lego.core.sdk.base.model.Status;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.hs.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.hs.lego.core.system.sysmonitor.service.treshold.ISysmTresholdService;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SystemInitializeHold
implements SystemStatusChangedListener {
    private static final Properties PROPS = new Properties();
    private static final String DEFAULT_PROPERTIES = "sysmtreshold.properties";
    private static boolean propertyInit = false;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private ISysmTresholdService sysTresholdService;
    private ICommonDao dao;

    public void afterPropertiesSet() {
        this.initSysHold();
    }

    private void initSysHold() {
        List<SysmTreshold> list = this.sysTresholdService.getSysmTreshold();
        if (null == list || list.size() < 4) {
            this.initProperty();
            this.initFaultHold(list);
        }
    }

    private void initFaultHold(List<SysmTreshold> list) {
        SysmTreshold cpuTreshold = new SysmTreshold();
        cpuTreshold.setPercent(this.getInt("cpu"));
        long level = FaultEnum.AlarmSeverity.MAJOR.getValue();
        cpuTreshold.setAlarmLevel(level);
        cpuTreshold.setId(SysmTresholdType.cpu.getValue());
        SysmTreshold memTreshold = new SysmTreshold();
        memTreshold.setPercent(this.getInt("mem"));
        memTreshold.setAlarmLevel(level);
        memTreshold.setId(SysmTresholdType.mem.getValue());
        SysmTreshold diskTreshold = new SysmTreshold();
        diskTreshold.setPercent(this.getInt("disk"));
        diskTreshold.setAlarmLevel(level);
        diskTreshold.setId(SysmTresholdType.disk.getValue());
        SysmTreshold dbTreshold = new SysmTreshold();
        dbTreshold.setPercent(this.getInt("db"));
        dbTreshold.setAlarmLevel(level);
        dbTreshold.setId(SysmTresholdType.db.getValue());
        SysmTreshold installDiskTreshold = new SysmTreshold();
        installDiskTreshold.setPercent(this.getInt("installdisk"));
        installDiskTreshold.setAlarmLevel(level);
        installDiskTreshold.setId(SysmTresholdType.installdisk.getValue());
        if (list == null) {
            this.dao.save((Object)cpuTreshold);
            this.dao.save((Object)memTreshold);
            this.dao.save((Object)diskTreshold);
            this.dao.save((Object)dbTreshold);
            this.dao.save((Object)installDiskTreshold);
            return;
        }
        if (!list.contains(cpuTreshold)) {
            this.dao.save((Object)cpuTreshold);
        }
        if (!list.contains(memTreshold)) {
            this.dao.save((Object)memTreshold);
        }
        if (!list.contains(diskTreshold)) {
            this.dao.save((Object)diskTreshold);
        }
        if (!list.contains(dbTreshold)) {
            this.dao.save((Object)dbTreshold);
        }
        if (!list.contains(installDiskTreshold)) {
            this.dao.save((Object)installDiskTreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProperty() {
        if (propertyInit) {
            return;
        }
        InputStream stream = null;
        try {
            Enumeration<URL> enums = null;
            enums = this.getClass().getClassLoader().getResources(DEFAULT_PROPERTIES);
            while (enums.hasMoreElements()) {
                URL url = enums.nextElement();
                stream = url.openStream();
            }
            if (null != stream) {
                PROPS.load(stream);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"read default.properties fail.");
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        finally {
            try {
                if (null != stream) {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"IOException");
            }
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)PROPS);
        System.setProperties(sysProps);
        this.log.debug((Object)PROPS);
        propertyInit = true;
    }

    public String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public void setSysTresholdService(ISysmTresholdService sysTresholdService) {
        this.sysTresholdService = sysTresholdService;
    }

    public void setDao(ICommonDao dao) {
        this.dao = dao;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }
}

