/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.action;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollect;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollectDetail;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollectDetailInfo;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollectForm;
import com.hs.vsm.secservice.sdk.nfa.collect.service.IAticNfaCollectDetailService;
import com.hs.vsm.secservice.sdk.nfa.collect.service.IAticNfaCollectService;
import com.hs.vsm.secservice.sdk.nfa.collect.service.ICollectNFALogService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.common.SecNELogFactory;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import org.apache.struts2.ServletActionContext;

public class CollectNFALogAction
extends BaseAction {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private static final long serialVersionUID = -3680581018238391138L;
    private static boolean isStart = false;
    private static volatile boolean isCollecting = false;
    private Long pkid;
    private Date startTime;
    private Date endTime;
    private String fileName;
    private Integer status;
    private String details;
    private List<AticDevice> deviceList;
    private List<AticNfaCollect> nfaCollectList;
    private List<AticNfaCollectDetailInfo> detailList;
    private String[] ipList;
    private IAticNfaCollectService aticNfaCollectService;
    private ICollectNFALogService collectNFALogService;
    private IAticDeviceService aticDeviceService;
    private IAticNfaCollectDetailService aticNfaCollectDetailService;
    private ISysOptLog sysLogService;

    public String hasTaskWorking() {
        logger.info((Object)"into hasTaskWorking !");
        boolean flag = false;
        List<AticNfaCollect> collectTasks = null;
        collectTasks = this.aticNfaCollectService.getAllByStatus();
        if (collectTasks != null && collectTasks.size() > 0) {
            flag = true;
        }
        if (flag) {
            logger.info((Object)"others logCollectTask is working!");
            this.writeSysLog(this.getText("lego.sys.nfaCollect"), "lego.sys.nfaCollect.createTask", "lego.sys.nfaCollect.opt.failure", 0, null);
            this.responseResult("islocked");
        } else {
            CollectNFALogAction.setCollecting(true);
            CollectNFALogAction.setStart(false);
            logger.info((Object)"No logCollectTask execution!");
            this.writeSysLog(this.getText("lego.sys.nfaCollect"), "lego.sys.nfaCollect.createTask", "lego.sys.nfaCollect.opt.success", 1, null);
            this.responseResult("unlocked");
        }
        return "success";
    }

    public String collectByIp() {
        this.getResponse().setContentType("text/html;charset=UTF-8");
        if (!CollectNFALogAction.isCollecting()) {
            logger.info((Object)"logCollectTask not collecting");
            List<AticNfaCollect> collectTasks = null;
            collectTasks = this.aticNfaCollectService.getAllSortTime();
            JSONArray json = JSONArray.fromObject(collectTasks);
            this.responseResult(json.toString());
            return "success";
        }
        if (!CollectNFALogAction.isStart()) {
            CollectNFALogAction.setStart(true);
            this.collectByIp(this.ipList);
        }
        boolean flag = false;
        List<AticNfaCollect> collectTasks = null;
        collectTasks = this.aticNfaCollectService.getAllByStatus();
        if (collectTasks != null && collectTasks.size() > 0) {
            flag = true;
        }
        if (!flag) {
            CollectNFALogAction.setCollecting(false);
            CollectNFALogAction.setStart(false);
        }
        collectTasks = this.aticNfaCollectService.getAllSortTime();
        List<AticNfaCollectForm> taskForms = this.convert(collectTasks);
        JSONArray json = JSONArray.fromObject(taskForms);
        this.responseResult(json.toString());
        return "success";
    }

    public String reFreshCollectByIp() {
        this.getResponse().setContentType("text/html;charset=UTF-8");
        logger.info((Object)"into reFreshCollectByIp ...");
        boolean flag = false;
        List<AticNfaCollect> collectTasks = null;
        collectTasks = this.aticNfaCollectService.getAllByStatus();
        if (collectTasks != null && collectTasks.size() > 0) {
            flag = true;
        }
        if (!CollectNFALogAction.isCollecting() && !flag) {
            CollectNFALogAction.setCollecting(false);
            CollectNFALogAction.setStart(false);
        }
        collectTasks = this.aticNfaCollectService.getAllSortTime();
        List<AticNfaCollectForm> taskForms = this.convert(collectTasks);
        JSONArray json = JSONArray.fromObject(taskForms);
        this.responseResult(json.toString());
        return "success";
    }

    private List<AticNfaCollectForm> convert(List<AticNfaCollect> collectTasks) {
        ArrayList<AticNfaCollectForm> collectTaskForms = new ArrayList<AticNfaCollectForm>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (AticNfaCollect task : collectTasks) {
            Date endtime;
            AticNfaCollectForm taskForm = new AticNfaCollectForm();
            taskForm.setPkid(task.getPkid());
            taskForm.setStatus(task.getStatus());
            taskForm.setDetails(task.getDetails());
            taskForm.setFileName(task.getFileName());
            Date starttime = task.getStartTime();
            if (starttime != null) {
                taskForm.setStartTime(starttime);
                String time = format.format(starttime);
                taskForm.setStartTimeStr(time);
            }
            if ((endtime = task.getEndTime()) != null) {
                taskForm.setEndTime(endtime);
                String time = format.format(endtime);
                taskForm.setEndTimeStr(time);
            }
            collectTaskForms.add(taskForm);
        }
        return collectTaskForms;
    }

    private void collectByIp(String[] ips) {
        List<String> ipLists = Arrays.asList(ips);
        logger.info((Object)("ipLists: i = " + ipLists.toString()));
        this.collectNFALogService.download(ipLists);
        logger.info((Object)("ipLists: i = " + ipLists.toString()));
    }

    public String nfaCollect() {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        logger.info((Object)(currentUser + " get nfa log records."));
        this.nfaCollectList = this.aticNfaCollectService.getAllSortTime();
        return "success";
    }

    public String choseNfaDevice() {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        logger.info((Object)(currentUser.getUserName() + " get nfa device."));
        ArrayList onLineDevice = new ArrayList();
        ArrayList<AticDevice> pageOnLineDevice = new ArrayList<AticDevice>();
        try {
            int i;
            List allNFAdevices = this.aticDeviceService.getNFA2000VDevice();
            for (i = 0; i < allNFAdevices.size(); ++i) {
                if (0 != ((AticDevice)allNFAdevices.get(i)).getStatus()) continue;
                onLineDevice.add(allNFAdevices.get(i));
            }
            for (i = 0; i < onLineDevice.size(); ++i) {
                if (this.start > i || i >= this.pageSize * (this.start / this.pageSize + 1)) continue;
                pageOnLineDevice.add((AticDevice)onLineDevice.get(i));
            }
            Paging paging1 = new Paging();
            this.deviceList = pageOnLineDevice;
            this.total = onLineDevice.size();
            paging1.setData(this.deviceList);
            paging1.setCount(this.total);
        }
        catch (Exception e) {
            SecNELogFactory.getInstance().error((Object)"Exception happened when get the discovered devicelist", (Throwable)e);
            this.deviceList = new ArrayList<AticDevice>();
            this.total = 0;
        }
        return "success";
    }

    public String nfaCollectResult() {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        logger.info((Object)(currentUser.getUserName() + " get nfa collect detail."));
        Map<String, String> map = this.getConditions();
        if (null == this.pkid) {
            this.detailList = new ArrayList<AticNfaCollectDetailInfo>();
            this.total = 0;
            return "success";
        }
        map.put("pkid", this.pkid + "");
        Paging paging = this.aticNfaCollectDetailService.getDetailByPage(map, this.start, this.pageSize);
        List detailListTemp = paging.getData();
        ArrayList<AticNfaCollectDetailInfo> aticNfaCollectDetailInfos = new ArrayList<AticNfaCollectDetailInfo>();
        for (int i = 0; i < paging.getData().size(); ++i) {
            AticNfaCollectDetailInfo aticNfaCollectDetailInfo = new AticNfaCollectDetailInfo((AticNfaCollectDetail)detailListTemp.get(i));
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(((AticNfaCollectDetail)detailListTemp.get(i)).getMoId());
            aticNfaCollectDetailInfo.setName(aticDevice == null ? "" : aticDevice.getName());
            aticNfaCollectDetailInfos.add(aticNfaCollectDetailInfo);
        }
        this.detailList = aticNfaCollectDetailInfos;
        this.total = paging.getCount();
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadCollectFile() {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        logger.info((Object)(currentUser.getUserName() + " download collect record."));
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        if (null != this.pkid && AticUtil.isNull((String)this.pkid.toString())) {
            logger.error((Object)"pkid is null or isEmpty.");
            return;
        }
        try {
            String onlyFileName = "";
            AticNfaCollect aticNfaCollect = this.aticNfaCollectService.findById(this.pkid);
            String currentFileName = aticNfaCollect.getFileName();
            int index = currentFileName.lastIndexOf("\\");
            if (index > 0) {
                onlyFileName = currentFileName.substring(index + 1, currentFileName.length());
            } else {
                int indexLinux = currentFileName.lastIndexOf("/");
                onlyFileName = currentFileName.substring(indexLinux + 1, currentFileName.length());
            }
            HttpServletResponse response = this.getResponse();
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(onlyFileName.getBytes("gb2312"), "ISO-8859-1"));
            input = new BufferedInputStream(new FileInputStream(currentFileName));
            output = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] b = new byte[1024];
            int len = 0;
            while ((len = input.read(b)) != -1) {
                ((BufferedOutputStream)output).write(b, 0, len);
            }
            ((BufferedOutputStream)output).flush();
            return;
        }
        catch (IOException e) {
            logger.error((Object)"download report error", (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            logger.error((Object)"download report error", (Throwable)e);
            return;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> map = new HashMap<String, String>();
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        map.put("userId", String.valueOf(currentUser.getUserID()));
        map.put("isAdmin", currentUser.getIsAdmin());
        return map;
    }

    public boolean ipListFilter() {
        boolean flag = false;
        flag = this.checkIpList(this.ipList);
        logger.info((Object)("in ipListFilter, flag = " + flag));
        return flag;
    }

    private boolean checkIpList(String[] ips) {
        if (ips == null || ips.length == 0 || !ips[0].contains(".")) {
            logger.warn((Object)"in checkIpList, ips == null or ips.length == 0 or !ips[0].contains(\".\")");
            return true;
        }
        logger.info((Object)("in checkIpList, ipList.length = " + ips.length));
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        for (String ip : ips) {
            Matcher matcher = pattern.matcher(ip);
            if (matcher.matches()) continue;
            logger.error((Object)("in checkIpList, ip format error: " + ip));
            return false;
        }
        return true;
    }

    private void writeSysLog(String target, String operation, String detail, int flag, String[] detailPara) {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setDate(new Date());
        oOptLog.setTarget(target);
        oOptLog.setLevel(SysoplogLevel.normal.getValue());
        oOptLog.setModule("lego.dic.module.AticBis");
        oOptLog.setOperation(operation);
        oOptLog.setDetail(detail);
        oOptLog.setDetailPara(detailPara);
        oOptLog.setResult(flag);
        oOptLog.setOperator(currentUser.getUserName());
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        if (null != this.sysLogService) {
            this.sysLogService.writeOptLog(oOptLog);
        }
    }

    public Long getPkid() {
        return this.pkid;
    }

    public void setPkid(Long pkid) {
        this.pkid = pkid;
    }

    public Date getStartTime() {
        if (this.startTime != null) {
            return (Date)this.startTime.clone();
        }
        return null;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime != null ? (Date)startTime.clone() : null;
    }

    public Date getEndTime() {
        if (this.endTime != null) {
            return (Date)this.endTime.clone();
        }
        return null;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime != null ? (Date)endTime.clone() : null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public List<AticNfaCollect> getNfaCollectList() {
        return this.nfaCollectList;
    }

    public void setNfaCollectList(List<AticNfaCollect> nfaCollectList) {
        this.nfaCollectList = nfaCollectList;
    }

    public List<AticDevice> getDeviceList() {
        return this.deviceList;
    }

    public void setDeviceList(List<AticDevice> deviceList) {
        this.deviceList = deviceList;
    }

    public List<AticNfaCollectDetailInfo> getDetailList() {
        return this.detailList;
    }

    public void setDetailList(List<AticNfaCollectDetailInfo> detailList) {
        this.detailList = detailList;
    }

    public String[] getIpList() {
        if (this.ipList != null) {
            return (String[])this.ipList.clone();
        }
        return new String[0];
    }

    public void setIpList(String[] ipList) {
        this.ipList = ipList != null ? (String[])ipList.clone() : null;
    }

    public static boolean isStart() {
        return isStart;
    }

    public static void setStart(boolean isStartFlag) {
        isStart = isStartFlag;
    }

    public static boolean isCollecting() {
        return isCollecting;
    }

    public static void setCollecting(boolean isCollectingFlag) {
        isCollecting = isCollectingFlag;
    }

    public IAticNfaCollectService getAticNfaCollectService() {
        return this.aticNfaCollectService;
    }

    public void setAticNfaCollectService(IAticNfaCollectService aticNfaCollectService) {
        this.aticNfaCollectService = aticNfaCollectService;
    }

    public ICollectNFALogService getCollectNFALogService() {
        return this.collectNFALogService;
    }

    public void setCollectNFALogService(ICollectNFALogService collectNFALogService) {
        this.collectNFALogService = collectNFALogService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticNfaCollectDetailService getAticNfaCollectDetailService() {
        return this.aticNfaCollectDetailService;
    }

    public void setAticNfaCollectDetailService(IAticNfaCollectDetailService aticNfaCollectDetailService) {
        this.aticNfaCollectDetailService = aticNfaCollectDetailService;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }
}

