/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.service;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.nfa.collect.thread.AllLogRecorder;
import com.hs.vsm.secservice.nfa.collect.thread.CollectLogTask;
import com.hs.vsm.secservice.nfa.collect.thread.DownLoadLogTask;
import com.hs.vsm.secservice.nfa.collect.util.CommonCfg;
import com.hs.vsm.secservice.nfa.collect.util.FileEdits;
import com.hs.vsm.secservice.nfa.collect.util.TarUtilsImpl;
import com.hs.vsm.secservice.nfa.collect.util.XZouTarAndGz;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollect;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollectDetail;
import com.hs.vsm.secservice.sdk.nfa.collect.service.IAticNfaCollectDetailService;
import com.hs.vsm.secservice.sdk.nfa.collect.service.IAticNfaCollectService;
import com.hs.vsm.secservice.sdk.nfa.collect.service.ICollectNFALogService;
import com.huawei.atic.resource.sdk.service.IResourceService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class CollectNFALogServiceImpl
implements ICollectNFALogService {
    private static final String COLLECT_URL = CommonCfg.getCollectURL();
    private static final String DOWNLOAD_URL = CommonCfg.getDownLoadURL();
    private static final String TEMP_DIR = CommonCfg.getTempDir();
    private static final String DOWNLOAD_DIR = CommonCfg.getDownLoadDir();
    private static final String TEMP_FILE_SUFFIX = CommonCfg.getTempFileSuffix();
    private static final String FILE_SUFFIX = CommonCfg.getFileSuffix();
    private static boolean isdownload = false;
    private static final int STATUS_COLLECTING = 0;
    private static final int STATUS_FAILURE = 1;
    private static final int STATUS_DOWNLOADING = 2;
    private static final int STATUS_SUCCESS = 3;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private AllLogRecorder allLogRecorder = new AllLogRecorder();
    private String compressFileName = CommonCfg.getCompressFileName();
    private double maxFileSize = CommonCfg.getMaxFileSize();
    private Long taskId;
    private String zipFileName;
    private IAticNfaCollectService aticNfaCollectService;
    private IAticNfaCollectDetailService aticNfaCollectDetailService;

    @Override
    public void download(List<String> iPList) {
        this.logger.info((Object)"in download: begin creatThread-------");
        this.creatThread(iPList);
        this.logger.info((Object)"in download: end creatThread------");
    }

    private void creatThread(final List<String> ipList) {
        List<AticNfaCollect> collectTasks = this.aticNfaCollectService.getAllByStatus();
        if (collectTasks != null && collectTasks.size() > 0) {
            CollectNFALogServiceImpl.setIsdownload(true);
        } else {
            CollectNFALogServiceImpl.setIsdownload(false);
        }
        if (!CollectNFALogServiceImpl.isIsdownload()) {
            CollectNFALogServiceImpl.setIsdownload(true);
            this.allLogRecorder.reset();
            try {
                ExecutorService executor = Executors.newSingleThreadExecutor();
                FutureTask<String> future = new FutureTask<String>(new Callable<String>(){

                    @Override
                    public String call() {
                        CollectNFALogServiceImpl.this.sendCollectAndDownReq(ipList);
                        return null;
                    }
                });
                Future<?> f = executor.submit(future);
                this.logger.info((Object)("creatThread f : " + f));
            }
            catch (Exception e) {
                this.logger.error((Object)("happen error when creatThread ,exception : " + e));
            }
        }
    }

    private void sendCollectAndDownReq(List<String> ipList) {
        List<AticNfaCollect> collectTasks = null;
        collectTasks = this.aticNfaCollectService.getAllSortTime();
        if (collectTasks != null && collectTasks.size() > 2) {
            int size = collectTasks.size();
            for (int index = 2; index < size; ++index) {
                AticNfaCollect collectTask = collectTasks.get(index);
                this.aticNfaCollectService.deleteById(collectTask.getPkid());
                this.aticNfaCollectDetailService.deleteByPkid(collectTask.getPkid());
                String filePath = collectTask.getFileName();
                this.deleteOldZipLog(filePath);
            }
        }
        AticNfaCollect collectTask = new AticNfaCollect();
        collectTask.setStartTime(new Date(System.currentTimeMillis()));
        collectTask.setStatus(0);
        Long taskPkId = (Long)this.aticNfaCollectService.save(collectTask);
        if (taskPkId == null) {
            this.logger.error((Object)"collect task save failure!");
            CollectNFALogServiceImpl.setIsdownload(false);
            return;
        }
        this.setTaskId(taskPkId);
        this.collectLogs(ipList);
        List<String> doneIpList = this.allLogRecorder.getDoneIPList();
        if (null == doneIpList || doneIpList.size() == 0) {
            this.logger.error((Object)"all nfa devices collect logs failure!");
            collectTask = this.aticNfaCollectService.findById(taskPkId);
            collectTask.setEndTime(new Date(System.currentTimeMillis()));
            collectTask.setStatus(1);
            collectTask.setDetails("all nfa device collect log failure!");
            this.aticNfaCollectService.saveOrUpdate(collectTask);
            CollectNFALogServiceImpl.setIsdownload(false);
            return;
        }
        if (this.allLogRecorder.getAllFileSize() > this.maxFileSize) {
            collectTask = this.aticNfaCollectService.findById(taskPkId);
            collectTask.setEndTime(new Date(System.currentTimeMillis()));
            collectTask.setStatus(1);
            collectTask.setDetails("The collected files[" + this.allLogRecorder.getAllFileSize() + "(M)] are larger than the limit[" + this.maxFileSize + "(M)]!");
            this.aticNfaCollectService.saveOrUpdate(collectTask);
            CollectNFALogServiceImpl.setIsdownload(false);
            return;
        }
        this.downLoadLogs(doneIpList);
        this.tarFiles(ipList);
        this.checkIp(ipList);
        CollectNFALogServiceImpl.setIsdownload(false);
    }

    private void deleteOldZipLog(String fileName) {
        if (fileName != null && !"".equals(fileName)) {
            FileEdits fileUtils = FileEdits.geInstance();
            if (fileUtils.deleteFile(fileName)) {
                this.logger.info((Object)("delete  file : " + fileName + " success!"));
            } else {
                this.logger.error((Object)("delete  file : " + fileName + " failure!"));
            }
        }
    }

    private void deleteTempDir(String fileName) {
        File[] fileList = new File(fileName).listFiles();
        if (null != fileList) {
            for (File oneFile : fileList) {
                if (!oneFile.delete()) continue;
                this.logger.info((Object)("delete  dir : " + fileName + " success!"));
            }
        } else {
            this.logger.info((Object)"delete  dir is Empty!");
        }
    }

    private void collectLogs(List<String> ipList) {
        ExecutorService executor = Executors.newFixedThreadPool(ipList.size());
        this.logger.info((Object)"start to create CollectLogTask !");
        for (String ip : ipList) {
            this.logger.info((Object)("create CollectLogTask(ip : " + ip + ",taskId : " + this.taskId + ")."));
            CollectLogTask task = new CollectLogTask(ip, this.allLogRecorder, COLLECT_URL, this.taskId);
            Future<Object> future = executor.submit(task);
            this.logger.info((Object)("create CollectLogTask(ip : " + ip + ",taskId : " + this.taskId + ") ok ! ----future : " + future));
        }
        executor.shutdown();
        try {
            if (executor.awaitTermination(30L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"all CollectLogTask is work over.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"CollectLogTask thread execute timeout.", (Throwable)e1);
        }
    }

    private void downLoadLogs(List<String> ipList) {
        AticNfaCollect collectTask = this.aticNfaCollectService.findById(this.getTaskId());
        collectTask.setStatus(2);
        File tempDirF = new File(TEMP_DIR);
        File downLoadDirF = new File(DOWNLOAD_DIR);
        if (!tempDirF.exists()) {
            if (tempDirF.mkdirs()) {
                this.logger.info((Object)("create tempDir: " + TEMP_DIR + "success!"));
            } else {
                collectTask.setEndTime(new Date(System.currentTimeMillis()));
                collectTask.setStatus(1);
                collectTask.setDetails("create create tempDir: " + TEMP_DIR + "fail!");
                this.aticNfaCollectService.saveOrUpdate(collectTask);
                CollectNFALogServiceImpl.setIsdownload(false);
                this.logger.error((Object)("create tempDir: " + TEMP_DIR + "fail!"));
                return;
            }
        }
        if (!downLoadDirF.exists()) {
            if (downLoadDirF.mkdirs()) {
                this.logger.info((Object)("create downLoadDir: " + DOWNLOAD_DIR + "success!"));
            } else {
                collectTask.setEndTime(new Date(System.currentTimeMillis()));
                collectTask.setStatus(1);
                collectTask.setDetails("create downLoadDir: " + DOWNLOAD_DIR + "fail!");
                this.aticNfaCollectService.saveOrUpdate(collectTask);
                CollectNFALogServiceImpl.setIsdownload(false);
                this.logger.error((Object)("create downLoadDir: " + DOWNLOAD_DIR + "fail!"));
                return;
            }
        }
        this.aticNfaCollectService.saveOrUpdate(collectTask);
        ExecutorService executor = Executors.newFixedThreadPool(ipList.size());
        this.logger.info((Object)"start to create DownLoadLogTask !");
        for (String ip : ipList) {
            this.logger.info((Object)("create DownLoadLogTask(ip : " + ip + ",taskId : " + this.taskId + ")."));
            DownLoadLogTask task = new DownLoadLogTask(ip, TEMP_DIR, FILE_SUFFIX, DOWNLOAD_URL, this.taskId);
            Future<Object> future = executor.submit(task);
            this.logger.info((Object)("create DownLoadLogTask(ip : " + ip + ",taskId : " + this.taskId + ") ok !---- future :" + future));
        }
        executor.shutdown();
        try {
            if (executor.awaitTermination(30L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"all DownLoadLogTask is work over.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"DownLoadLogTask execute timeout.", (Throwable)e1);
        }
    }

    private void tarFiles(List<String> ipList) {
        AticNfaCollect collectTask = this.aticNfaCollectService.findById(this.getTaskId());
        collectTask.setStatus(3);
        File isFile = new File(TEMP_DIR);
        boolean isFileExist = false;
        boolean tmp = false;
        String[] lst = isFile.list();
        if (lst != null) {
            tmp = lst.length != 0;
        }
        boolean bl = isFileExist = isFile.exists() && isFile.isDirectory() && tmp;
        if (isFileExist) {
            File downloadPath;
            TarUtilsImpl tarutil = new TarUtilsImpl();
            ArrayList<String> dirPathList = new ArrayList<String>();
            dirPathList.add(TEMP_DIR);
            String now = this.getTime();
            String tarFileNow = DOWNLOAD_DIR + File.separator + this.compressFileName + now + TEMP_FILE_SUFFIX;
            String zipFilePath = DOWNLOAD_DIR + File.separator + this.compressFileName + now + FILE_SUFFIX;
            this.setZipFileName(zipFilePath);
            tarutil.execute(dirPathList, tarFileNow);
            XZouTarAndGz targzutil = new XZouTarAndGz();
            targzutil.execute(dirPathList, tarFileNow);
            File zipFile = new File(this.zipFileName);
            if (zipFile.exists()) {
                collectTask.setEndTime(new Date(System.currentTimeMillis()));
                collectTask.setFileName(this.zipFileName);
                this.aticNfaCollectService.saveOrUpdate(collectTask);
            }
            this.logger.info((Object)"package over");
            File taffile = new File(tarFileNow);
            if (taffile.exists()) {
                this.deleteOldZipLog(tarFileNow);
            }
            if ((downloadPath = new File(TEMP_DIR)).exists()) {
                this.deleteTempDir(TEMP_DIR);
            }
        } else {
            collectTask.setEndTime(new Date(System.currentTimeMillis()));
            collectTask.setStatus(1);
            collectTask.setDetails("downLoad logs is null!");
            this.aticNfaCollectService.saveOrUpdate(collectTask);
            this.logger.error((Object)"File not exits");
            return;
        }
    }

    private String getTime() {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = dateFormat.format(now);
        return date;
    }

    private void checkIp(List<String> ipList) {
        IResourceService resService = (IResourceService)ServiceContext.getInstance().getService("resourceService", IResourceService.class);
        List<String> ips = this.aticNfaCollectDetailService.findIPsByPkid(this.taskId);
        for (String ip : ipList) {
            if (ips.contains(ip)) continue;
            ManagedObject mo = resService.getMoByIp(ip);
            Long moId = mo.getMoId();
            this.insertCollectDetail(moId, ip, this.taskId);
        }
    }

    private void insertCollectDetail(Long moId, String ip, Long taskPkId) {
        AticNfaCollectDetail collectDetail = new AticNfaCollectDetail();
        collectDetail.setIpAddress(ip);
        collectDetail.setPkid(taskPkId);
        collectDetail.setMoId(moId);
        collectDetail.setStatus(1);
        collectDetail.setDetails("collect logs failure!");
        this.aticNfaCollectDetailService.saveOrUpdate(collectDetail);
    }

    public static boolean isIsdownload() {
        return isdownload;
    }

    public static void setIsdownload(boolean isdownload) {
        CollectNFALogServiceImpl.isdownload = isdownload;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    public void setZipFileName(String zipFileName) {
        this.zipFileName = zipFileName;
    }

    public IAticNfaCollectService getAticNfaCollectService() {
        return this.aticNfaCollectService;
    }

    public void setAticNfaCollectService(IAticNfaCollectService aticNfaCollectService) {
        this.aticNfaCollectService = aticNfaCollectService;
    }

    public IAticNfaCollectDetailService getAticNfaCollectDetailService() {
        return this.aticNfaCollectDetailService;
    }

    public void setAticNfaCollectDetailService(IAticNfaCollectDetailService aticNfaCollectDetailService) {
        this.aticNfaCollectDetailService = aticNfaCollectDetailService;
    }
}

