/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.thread;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.nfa.collect.thread.AllLogRecorder;
import com.hs.vsm.secservice.nfa.restful.sdk.service.IRestfulNFALogService;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollectDetail;
import com.hs.vsm.secservice.sdk.nfa.collect.model.RequestParams;
import com.hs.vsm.secservice.sdk.nfa.collect.service.IAticNfaCollectDetailService;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class CollectLogTask
implements Callable<Object> {
    private static final int STATUS_OK = 200;
    private static final int FAIL_CODE = 0;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private String host;
    private Long taskId;
    private AllLogRecorder allLogRecorder;
    private String collectURL;

    public CollectLogTask(String hostIp, AllLogRecorder logRecorder, String collectURL, Long taskId) {
        this.host = hostIp;
        this.allLogRecorder = logRecorder;
        this.collectURL = collectURL;
        this.taskId = taskId;
    }

    @Override
    public Object call() throws Exception {
        double fileSizeLong = 0.0;
        IAticNfaCollectDetailService aticNfaCollectDetailService = (IAticNfaCollectDetailService)ServiceContext.getInstance().getService("aticNfaCollectDetailService", IAticNfaCollectDetailService.class);
        IAticDeviceNfaService aticDeviceNfaService = (IAticDeviceNfaService)ServiceContext.getInstance().getService("aticDeviceNfaService", IAticDeviceNfaService.class);
        IResourceService resService = (IResourceService)ServiceContext.getInstance().getService("resourceService", IResourceService.class);
        ManagedObject mo = resService.getMoByIp(this.host);
        Long moId = mo.getMoId();
        AticDeviceNfa aticDeviceNFA = aticDeviceNfaService.findByMoid(moId);
        NfaInfoForm nfaInfoForm = new NfaInfoForm();
        nfaInfoForm.setApiKey(aticDeviceNFA.getApiKey());
        nfaInfoForm.setIpAdress(this.host);
        nfaInfoForm.setPort(aticDeviceNFA.getRestfulPort().intValue());
        nfaInfoForm.setUrlPost(this.collectURL);
        RequestParams params = new RequestParams();
        params.setRequestTimeOut(180000);
        params.setReceiveTimeOut(1800000);
        IRestfulNFALogService restfulNFALogService = (IRestfulNFALogService)ServiceContext.getInstance().getService("restfulNFALogService", IRestfulNFALogService.class);
        Result result = restfulNFALogService.collectLog(params, nfaInfoForm);
        if (200 != result.getStatusCode()) {
            AticNfaCollectDetail collectDetail = new AticNfaCollectDetail();
            collectDetail.setIpAddress(this.host);
            collectDetail.setPkid(this.taskId);
            collectDetail.setMoId(moId);
            collectDetail.setStatus(0);
            collectDetail.setDetails(result.getJson());
            aticNfaCollectDetailService.saveOrUpdate(collectDetail);
            this.logger.error((Object)(this.host + " [result]: Rest request fail. [status]: " + result.getStatusCode() + " [desc]: " + result.getJson()));
        } else {
            this.logger.info((Object)(this.host + " task succeed. [descrip]: " + result.getJson()));
            String reInfo = result.getJson();
            this.logger.info((Object)(this.host + " [Json return]: " + reInfo));
            List<String> reInfoList = Arrays.asList(reInfo.split(","));
            fileSizeLong = Double.valueOf(reInfoList.get(0));
            this.logger.info((Object)(this.host + ": ziplog size is " + fileSizeLong));
            this.allLogRecorder.addFileSize(fileSizeLong);
            this.allLogRecorder.addIp(this.host);
        }
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public AllLogRecorder getAllLogRecorder() {
        return this.allLogRecorder;
    }

    public void setAllLogRecorder(AllLogRecorder allLogRecorder) {
        this.allLogRecorder = allLogRecorder;
    }

    public String getCollectURL() {
        return this.collectURL;
    }

    public void setCollectURL(String collectURL) {
        this.collectURL = collectURL;
    }
}

