/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.thread;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.nfa.collect.thread.LogTransInfo;
import com.hs.vsm.secservice.nfa.restful.sdk.service.IRestfulNFALogService;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.sdk.nfa.collect.model.AticNfaCollectDetail;
import com.hs.vsm.secservice.sdk.nfa.collect.model.RequestParams;
import com.hs.vsm.secservice.sdk.nfa.collect.service.IAticNfaCollectDetailService;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;

public class DownLoadLogTask
implements Callable<Object> {
    private static final int STATUS_OK = 200;
    private static final int FAIL_CODE = 0;
    private static final int SUCCESS_CODE = 1;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private String host;
    private Long taskId;
    private String downLoadURL;
    private String downloadDir;
    private String fileSuffix;

    public DownLoadLogTask(String ip, String downloadDir, String fileSuffix, String downLoadURL, Long taskId) {
        this.host = ip;
        this.downloadDir = downloadDir;
        this.downLoadURL = downLoadURL;
        this.fileSuffix = fileSuffix;
        this.taskId = taskId;
    }

    @Override
    public Object call() throws Exception {
        AticNfaCollectDetail collectDetail;
        LogTransInfo info;
        IAticNfaCollectDetailService aticNfaCollectDetailService = (IAticNfaCollectDetailService)ServiceContext.getInstance().getService("aticNfaCollectDetailService", IAticNfaCollectDetailService.class);
        IAticDeviceNfaService aticDeviceNfaService = (IAticDeviceNfaService)ServiceContext.getInstance().getService("aticDeviceNfaService", IAticDeviceNfaService.class);
        IResourceService resService = (IResourceService)ServiceContext.getInstance().getService("resourceService", IResourceService.class);
        IRestfulNFALogService restfulNFALogService = (IRestfulNFALogService)ServiceContext.getInstance().getService("restfulNFALogService", IRestfulNFALogService.class);
        ManagedObject mo = resService.getMoByIp(this.host);
        Long moId = mo.getMoId();
        AticDeviceNfa aticDeviceNFA = aticDeviceNfaService.findByMoid(moId);
        NfaInfoForm nfaInfoForm = new NfaInfoForm();
        nfaInfoForm.setApiKey(aticDeviceNFA.getApiKey());
        nfaInfoForm.setIpAdress(this.host);
        nfaInfoForm.setPort(aticDeviceNFA.getRestfulPort().intValue());
        nfaInfoForm.setUrlGet(this.downLoadURL);
        RequestParams params = new RequestParams();
        params.setRequestTimeOut(300000);
        params.setReceiveTimeOut(300000);
        int times = 0;
        do {
            params.setTimes(times);
            Result result = restfulNFALogService.downLoadLog(params, nfaInfoForm);
            ++times;
            this.logger.info((Object)(this.host + " result statusCode: " + result.getStatusCode()));
            collectDetail = new AticNfaCollectDetail();
            collectDetail.setIpAddress(this.host);
            collectDetail.setPkid(this.taskId);
            collectDetail.setMoId(moId);
            collectDetail.setStatus(1);
            if (200 != result.getStatusCode()) {
                collectDetail.setStatus(0);
                collectDetail.setDetails(result.getJson());
                aticNfaCollectDetailService.saveOrUpdate(collectDetail);
                this.logger.info((Object)("Failed to downlod logs from " + this.host));
                return null;
            }
            info = this.readStreams(result);
            if (info == null) {
                collectDetail.setStatus(0);
                collectDetail.setDetails("Failed to downlod logs!");
                aticNfaCollectDetailService.saveOrUpdate(collectDetail);
                this.logger.info((Object)("Failed to downlod logs from " + this.host));
                return null;
            }
            this.logger.info((Object)("the end of the data: " + info.getResultDesc()));
        } while (!info.getResultDesc().equals("EOF"));
        aticNfaCollectDetailService.saveOrUpdate(collectDetail);
        this.logger.info((Object)("Successed in downloading file from the " + this.host));
        return times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogTransInfo readStreams(Result resp) {
        String fileName = "";
        File dir = new File(this.downloadDir);
        String json = resp.getJson();
        LogTransInfo result = null;
        if (!dir.exists()) {
            this.logger.info((Object)("local saving path (" + dir.getAbsolutePath() + ") doesn't exist."));
            return null;
        }
        fileName = fileName.concat(this.downloadDir).concat(File.separator).concat(this.host).concat(this.fileSuffix);
        this.logger.info((Object)("Saving file name: " + fileName));
        result = (LogTransInfo)JSONUtil.getInstance().fromJSON(json, LogTransInfo.class);
        if (result == null) {
            this.logger.info((Object)"result is null");
            return null;
        }
        OutputStream outStream = null;
        try {
            File f = new File(fileName);
            outStream = new FileOutputStream(f, true);
            this.logger.info((Object)("------ outStream write,   result.getLogfile().length = " + result.getLogfile().length));
            outStream.write(result.getLogfile(), 0, result.getLogfile().length);
            outStream.flush();
        }
        catch (FileNotFoundException e) {
            this.logger.info((Object)"OutputStream FileNotFoundException");
        }
        catch (IOException e) {
            this.logger.info((Object)"OutputStream IOException");
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                this.logger.info((Object)"OutputStream IOException when close stream");
            }
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getDownloadDir() {
        return this.downloadDir;
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public String getDownLoadURL() {
        return this.downLoadURL;
    }

    public void setDownLoadURL(String downLoadURL) {
        this.downLoadURL = downLoadURL;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }
}

