/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.util;

import com.hs.lego.core.sdk.exception.LegoCheckedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CommonCfg {
    private static final String COLLECTNFA_CFG = "/collectNFA.properties";
    private static final String COLLECT_URL = "collectURL";
    private static final String DOWNLOAD_URL = "downLoadURL";
    private static final String TEMP_DIR = "tempDir";
    private static final String DOWNLOAD_DIR = "downLoadDir";
    private static final String COMPRESS_FILE_NAME = "compressFileName";
    private static final String TEMP_FILE_SUFFIX = "tempFileSuffix";
    private static final String FILE_SUFFIX = "fileSuffix";
    private static final String MAX_FILE_SIZE = "maxFileSize";
    private static final Logger LOGGER = Logger.getLogger(CommonCfg.class);
    private static Properties props = new Properties();

    public static String getCollectURL() {
        return CommonCfg.getPropertyValue(COLLECT_URL);
    }

    public static String getDownLoadURL() {
        return CommonCfg.getPropertyValue(DOWNLOAD_URL);
    }

    public static String getTempDir() {
        return CommonCfg.getPropertyValue(TEMP_DIR);
    }

    public static String getDownLoadDir() {
        return CommonCfg.getPropertyValue(DOWNLOAD_DIR);
    }

    public static String getCompressFileName() {
        return CommonCfg.getPropertyValue(COMPRESS_FILE_NAME);
    }

    public static String getFileSuffix() {
        return CommonCfg.getPropertyValue(FILE_SUFFIX);
    }

    public static double getMaxFileSize() {
        double value = 0.0;
        String maxFileSize = CommonCfg.getPropertyValue(MAX_FILE_SIZE);
        if (null == maxFileSize || "".endsWith(maxFileSize.trim())) {
            return 0.0;
        }
        value = Double.parseDouble(maxFileSize);
        return value;
    }

    public static String getTempFileSuffix() {
        return CommonCfg.getPropertyValue(TEMP_FILE_SUFFIX);
    }

    private static String getPropertyValue(String key) {
        if (key == null || "".equals(key)) {
            throw new LegoCheckedException("cannot get value from key(" + key + ") in file:" + COLLECTNFA_CFG);
        }
        return props.getProperty(key);
    }

    static {
        InputStream is = null;
        try {
            is = CommonCfg.class.getResourceAsStream(COLLECTNFA_CFG);
            props.load(is);
        }
        catch (IOException e) {
            LOGGER.error((Object)"File open error");
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Stream close error");
                }
            }
        }
    }
}

