/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;

public final class FileEdits {
    private static FileEdits instance;
    private static ReentrantLock lock;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);

    private FileEdits() {
    }

    public static FileEdits geInstance() {
        lock.lock();
        try {
            FileEdits fileEdits = instance == null ? (FileEdits)FileEdits.class.newInstance() : instance;
            return fileEdits;
        }
        catch (InstantiationException e) {
            FileEdits fileEdits = null;
            return fileEdits;
        }
        catch (IllegalAccessException e) {
            FileEdits fileEdits = null;
            return fileEdits;
        }
        finally {
            lock.unlock();
        }
    }

    public double getSize(File file) {
        if (file.exists()) {
            if (!file.isFile()) {
                File[] fl = file.listFiles();
                if (null == fl) {
                    this.logger.info((Object)"listfiles is null");
                    return 0.0;
                }
                double ss = 0.0;
                for (File f : fl) {
                    ss += this.getSize(f);
                }
                return ss;
            }
            double ss = (double)file.length() / 1024.0 / 1024.0;
            this.logger.info((Object)(file.getName() + " : " + ss + "MB"));
            return ss;
        }
        this.logger.info((Object)"file is not exist");
        return 0.0;
    }

    public boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files == null) {
            this.logger.info((Object)("Has no file or dir in the " + dirFile.getAbsolutePath()));
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                this.logger.info((Object)("Delete file " + files[i].getAbsolutePath()));
                flag = this.deleteFile(files[i].getAbsolutePath());
                if (flag) continue;
                this.logger.warn((Object)("Failed to delete the file" + files[i].getAbsolutePath()));
                break;
            }
            this.logger.info((Object)("Delete dir " + files[i].getAbsolutePath()));
            flag = this.deleteDirectory(files[i].getAbsolutePath());
            if (flag) continue;
            this.logger.warn((Object)("Failed to delete the dir " + files[i].getAbsolutePath()));
            break;
        }
        if (!flag) {
            return false;
        }
        if (dirFile.delete()) {
            this.logger.warn((Object)("Failed to delete the dir " + dirFile.getAbsolutePath()));
            return true;
        }
        this.logger.info((Object)("Successed in deleting the current dir" + dirFile.getAbsolutePath()));
        return false;
    }

    public boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    static {
        lock = new ReentrantLock();
    }
}

