/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.sdk.nfa.collect.model.RequestParams;
import com.huawei.atic.secne.sdk.common.StringUtils;
import com.huawei.atic.secservice.nfa.restful.model.ApiKeyObject;
import com.huawei.atic.secservice.nfa.restful.model.BinLogObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.RequestObject;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.model.SnmpObject;
import com.huawei.atic.secservice.nfa.restful.util.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public final class LogHttpsClient {
    private static final LogHttpsClient INSTANCE = new LogHttpsClient();
    private static final int REQUEST_TIME_OUT = 5000;
    private static final int RECEIVE_TIME_OUT = 5000;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private SSLConnectionSocketFactory socketFactory;

    private LogHttpsClient() {
    }

    public static LogHttpsClient getInstance() {
        return INSTANCE;
    }

    private void enableSSL() {
        try {
            MyX509TrustManager tm = MyX509TrustManager.getInstance();
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{tm}, new SecureRandom());
            this.socketFactory = new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)("SSL is error," + e));
        }
        catch (KeyManagementException e) {
            this.logger.error((Object)("SSL is error," + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result doHttpsGet(RequestParams object, NfaInfoForm nfaInfoForm) throws IOException {
        int times = object.getTimes();
        int requestTimeOut = 5000;
        int receiveTimeOut = 5000;
        if (object.getRequestTimeOut() != 0) {
            requestTimeOut = object.getRequestTimeOut();
        }
        if (object.getReceiveTimeOut() != 0) {
            receiveTimeOut = object.getReceiveTimeOut();
        }
        this.enableSSL();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setConnectTimeout(requestTimeOut).setConnectionRequestTimeout(requestTimeOut).setSocketTimeout(receiveTimeOut).setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.socketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            Result result = new Result();
            if (null == nfaInfoForm) {
                result.setStatusCode(400);
                result.setJson(" NFa information is null");
                this.logger.error((Object)"doHttpsPost error,NFa information is null");
                Result result2 = result;
                return result2;
            }
            String api = nfaInfoForm.getApiKey();
            String host = nfaInfoForm.getIpAdress();
            int port = nfaInfoForm.getPort();
            StringBuffer urlBuffer = new StringBuffer();
            urlBuffer.append("https");
            urlBuffer.append(":");
            urlBuffer.append("//");
            urlBuffer.append(host);
            urlBuffer.append(":");
            urlBuffer.append(port);
            urlBuffer.append(nfaInfoForm.getUrlGet());
            urlBuffer.append("?times=" + times);
            String url = urlBuffer.toString();
            HttpGet get = new HttpGet(url);
            get.setHeader("X-api-key", DataProtectServiceConst.sdpDecryptLocalBuffer((String)api).toString());
            CloseableHttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)get);
            }
            catch (Exception e) {
                if (null != e.getMessage()) {
                    if (e.getMessage().contains("certificate is illegal")) {
                        result.setJson("certificate is illegal");
                    } else if (e.getMessage().contains("Connection timed out")) {
                        result.setJson("Connection timed out");
                    } else if (e.getMessage().contains("Read timed out")) {
                        result.setJson("Read timed out");
                    } else if (e.getMessage().contains("Connection refused: connect")) {
                        result.setJson("Connection refused: connect");
                    }
                }
                if (StringUtils.isEmpty((String)result.getJson())) {
                    result.setJson("certificate is error");
                }
                Result result3 = result;
                this.closeReader(reader);
                this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
                this.closeHttpClient(httpClient);
                return result3;
            }
            if (response != null) {
                int httpCode = response.getStatusLine().getStatusCode();
                result.setStatusCode(httpCode);
                if (httpCode == 200) {
                    HttpEntity entity2 = response.getEntity();
                    inputStream = entity2.getContent();
                    inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                    reader = new BufferedReader(inputStreamReader);
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cbuf = new char[2048];
                    int length = 0;
                    while ((length = reader.read(cbuf)) != -1) {
                        stringBuffer.append(String.valueOf(cbuf, 0, length));
                    }
                    result.setJson(stringBuffer.toString());
                }
                if (httpCode == 404) {
                    result.setJson("404 Not Found");
                }
            }
            Result result4 = result;
            return result4;
        }
        finally {
            this.closeReader(reader);
            this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
            this.closeHttpClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result doHttpsPost(RequestParams object, NfaInfoForm nfaInfoForm) throws IOException {
        this.logger.info((Object)("doHttpsPost is start, nfaInfoForm = " + nfaInfoForm));
        int requestTimeOut = 5000;
        int receiveTimeOut = 5000;
        if (object.getRequestTimeOut() != 0) {
            requestTimeOut = object.getRequestTimeOut();
        }
        if (object.getReceiveTimeOut() != 0) {
            receiveTimeOut = object.getReceiveTimeOut();
        }
        Result result = new Result();
        try {
            this.enableSSL();
        }
        catch (Exception e) {
            result.setJson("certificate is error");
            return result;
        }
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setConnectTimeout(requestTimeOut).setConnectionRequestTimeout(requestTimeOut).setSocketTimeout(receiveTimeOut).setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.socketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            if (null == nfaInfoForm) {
                result.setStatusCode(400);
                result.setJson(" NFa information is null");
                this.logger.error((Object)"doHttpsPost error,NFa information is null");
                Result result2 = result;
                return result2;
            }
            String api = nfaInfoForm.getApiKey();
            String host = nfaInfoForm.getIpAdress();
            int port = nfaInfoForm.getPort();
            StringBuffer urlBuffer = new StringBuffer();
            urlBuffer.append("https");
            urlBuffer.append(":");
            urlBuffer.append("//");
            urlBuffer.append(host);
            urlBuffer.append(":");
            urlBuffer.append(port);
            urlBuffer.append(nfaInfoForm.getUrlPost());
            String url = urlBuffer.toString();
            HttpPost post = new HttpPost(url);
            post.setHeader("X-api-key", DataProtectServiceConst.sdpDecryptLocalBuffer((String)api).toString());
            CloseableHttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)post);
            }
            catch (Exception e) {
                if (null != e.getMessage()) {
                    if (e.getMessage().contains("certificate is illegal")) {
                        result.setJson("certificate is illegal");
                    } else if (e.getMessage().contains("Connection timed out")) {
                        result.setJson("Connection timed out");
                    } else if (e.getMessage().contains("Read timed out")) {
                        result.setJson("Read timed out");
                    } else if (e.getMessage().contains("Connection refused: connect")) {
                        result.setJson("Connection refused: connect");
                    }
                }
                if (StringUtils.isEmpty((String)result.getJson())) {
                    result.setJson("certificate is error");
                }
                Result result3 = result;
                this.closeReader(reader);
                this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
                this.closeHttpClient(httpClient);
                return result3;
            }
            if (response != null) {
                int httpCode = response.getStatusLine().getStatusCode();
                result.setStatusCode(httpCode);
                if (httpCode == 200) {
                    HttpEntity entity2 = response.getEntity();
                    inputStream = entity2.getContent();
                    inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                    reader = new BufferedReader(inputStreamReader);
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cbuf = new char[2048];
                    while (reader.read(cbuf) > 0) {
                        stringBuffer.append(String.valueOf(cbuf));
                        if (stringBuffer.length() < 10000) continue;
                    }
                    if (stringBuffer.length() >= 10000) {
                        result.setJson("");
                    } else {
                        result.setJson(stringBuffer.toString().trim());
                    }
                }
                if (httpCode == 404) {
                    result.setJson("404 Not Found");
                }
                this.logger.info((Object)("doHttpsPost is over, result = " + result + ";json =" + this.getcleanedMessage(this.getSecureJson(object))));
            }
            Result result4 = result;
            return result4;
        }
        finally {
            this.closeReader(reader);
            this.closeInputStreamAndInputStreamReader(inputStream, inputStreamReader);
            this.closeHttpClient(httpClient);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String getSecureJson(Object object) {
        if (object instanceof RequestObject) {
            RequestObject requestObject = (RequestObject)object;
            if (requestObject.getData() instanceof BinLogObject) {
                BinLogObject binLogObject = (BinLogObject)requestObject.getData();
                binLogObject.setEncryKey("*******");
                return JSONUtil.getInstance().toJSONString((Object)binLogObject);
            }
            if (requestObject.getData() instanceof SnmpObject) {
                SnmpObject snmpObject = (SnmpObject)requestObject.getData();
                snmpObject.setReadCommunity("******");
                snmpObject.setV3AuthKey("******");
                snmpObject.setV3EncryKey("******");
                snmpObject.setWriteCommunity("******");
                return JSONUtil.getInstance().toJSONString((Object)snmpObject);
            }
        } else if (object instanceof ApiKeyObject) {
            ApiKeyObject apiKeyObject = (ApiKeyObject)object;
            apiKeyObject.setUpdateApiKey("*******");
            return JSONUtil.getInstance().toJSONString((Object)apiKeyObject);
        }
        return JSONUtil.getInstance().toJSONString(object);
    }

    private void closeHttpClient(CloseableHttpClient httpClient) {
        try {
            if (null != httpClient) {
                httpClient.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"closeHttpClient is failed, result = ", (Throwable)e);
        }
        finally {
            httpClient = null;
        }
    }

    private void closeReader(BufferedReader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"closeReader is failed, result = ", (Throwable)e);
        }
        finally {
            reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInputStreamAndInputStreamReader(InputStream inputStream, InputStreamReader inputStreamReader) {
        try {
            if (null != inputStreamReader) {
                inputStreamReader.close();
            }
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"close inputStreamReader or inputStream failed!");
        }
        finally {
            inputStreamReader = null;
            inputStream = null;
        }
    }
}

