/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.nfa.collect.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.nfa.collect.util.TarUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.activemq.console.command.store.tar.TarEntry;
import org.apache.activemq.console.command.store.tar.TarOutputStream;

public class TarUtilsImpl
implements TarUtils {
    private static final int BUFFER = 4096;
    private static final byte[] B_ARRAY = new byte[4096];
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);

    @Override
    public String getDirSeparator() {
        String separator = "";
        String osType = System.getProperty("os.name");
        if (osType == null) {
            this.logger.info((Object)"Get os name failed.");
            return separator;
        }
        if (osType.contains("Linux")) {
            separator = "/";
        } else if (osType.contains("Windows")) {
            separator = "\\";
        }
        return separator;
    }

    @Override
    public void execute(List<String> inputFileNameList, String targetFileName) {
        if (inputFileNameList.size() == 0) {
            this.logger.error((Object)"The tar src dir is null.");
        }
        targetFileName = targetFileName.endsWith(".tar") ? targetFileName : targetFileName + ".tar";
        FileOutputStream fileOutputStream = null;
        try {
            File f = new File(targetFileName);
            fileOutputStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"creat FileOutputStream failed: FileNotFoundException");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        TarOutputStream targetTarFile = new TarOutputStream((OutputStream)bufferedOutputStream);
        for (String inputFileName : inputFileNameList) {
            this.logger.info((Object)"Enter the loop.");
            File inputFile = new File(inputFileName);
            this.logger.info((Object)("TAR: the src dir (" + inputFileName + ")"));
            String base = inputFileName.substring(inputFileName.lastIndexOf(this.getDirSeparator()) + 1);
            this.logger.info((Object)("TAR: after sub,the src dir is (" + base + ")"));
            this.tarPack(targetTarFile, inputFile, base);
        }
        this.logger.info((Object)("The src first-tar: " + inputFileNameList.get(0)));
        for (int i = 0; i < inputFileNameList.size(); ++i) {
            this.logger.info((Object)("The src first-tar is not null, it's " + i + " file is " + inputFileNameList.get(i)));
        }
        try {
            targetTarFile.close();
            bufferedOutputStream.close();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"close out stream appear IOException");
        }
    }

    private void tarPack(TarOutputStream out, File inputFile, String base) {
        if (inputFile.isDirectory()) {
            this.logger.info((Object)(inputFile + " is a dir."));
            this.packFolder(out, inputFile, base);
        } else {
            this.logger.info((Object)(inputFile + " is a file."));
            this.packFile(out, inputFile, base);
        }
    }

    private void packFolder(TarOutputStream out, File inputFile, String base) {
        File[] fileList = inputFile.listFiles();
        try {
            out.putNextEntry(new TarEntry(base + this.getDirSeparator()));
        }
        catch (IOException e) {
            this.logger.error((Object)"pack Folder appear IOException");
        }
        if (fileList == null) {
            return;
        }
        base = base.length() == 0 ? "" : base + this.getDirSeparator();
        for (File file : fileList) {
            this.logger.info((Object)("Sart to tar " + base + file.getName()));
            this.tarPack(out, file, base + file.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packFile(TarOutputStream out, File inputFile, String base) {
        if (out == null) {
            this.logger.error((Object)"TarOutputStream is null");
            return;
        }
        TarEntry tarEntry = new TarEntry(base);
        tarEntry.setSize(inputFile.length());
        try {
            out.putNextEntry(tarEntry);
        }
        catch (IOException e) {
            this.logger.error((Object)"pack File appear IOException");
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFile);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"pack Folder appear FileNotFoundException");
            try {
                out.closeEntry();
            }
            catch (IOException e1) {
                this.logger.error((Object)"pack Folder appear IOException1");
                return;
            }
            return;
        }
        int b = 0;
        try {
            while ((b = in.read(B_ARRAY, 0, 4096)) != -1) {
                out.write(B_ARRAY, 0, b);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"pack Folder appear IOException when write stream.");
        }
        finally {
            try {
                in.close();
                out.closeEntry();
            }
            catch (IOException e) {
                this.logger.error((Object)"pack Folder appear IOException when close stream.");
            }
        }
    }
}

