/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.certjob;

import com.hs.atic.system.service.CertificateValidityImpl;
import com.hs.lego.cbb.task.certjob.CertificateValidator;
import com.hs.lego.cbb.task.certjob.KeyStoreCertificateValidator;
import com.hs.lego.cbb.task.sdk.job.StatefulJobBean;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.validity.CertificateValidity;
import com.hs.lego.cbb.validity.service.ICertificateProvider;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.List;

public class CertificateValidityJob
extends StatefulJobBean {
    protected Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);

    @Override
    public String executeJob(Task task) {
        this.checkValidity();
        return "success";
    }

    private void checkValidity() {
        ICertificateProvider certValidateService = (ICertificateProvider)ServiceContext.getInstance().getService("certificateValidityImpl", CertificateValidityImpl.class);
        if (null == certValidateService) {
            this.logger.error((Object)"Failed to bind any certificate provider from product.");
            return;
        }
        try {
            List<CertificateValidity> keyStores = certValidateService.getKeyStores();
            if (null != keyStores && !keyStores.isEmpty()) {
                KeyStoreCertificateValidator validator = new KeyStoreCertificateValidator();
                validator.validate(keyStores);
            }
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Error occured when validate jks certificate.");
        }
        try {
            List<CertificateValidity> singleCertificates = certValidateService.getCertificates();
            if (null != singleCertificates && !singleCertificates.isEmpty()) {
                CertificateValidator certificateValidator = new CertificateValidator();
                certificateValidator.validate(singleCertificates);
            }
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Error occured when validate certificate.");
        }
    }
}

