/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.certjob;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class TaskConfig {
    private static final Object LOCK = new Object();
    private static final String CERT_THRESHOLD = "certificate.fault.threshold";
    private static final String CERT_PERIOD = "certificate.fault.period";
    private static final String CERT_RUN_TIME = "certificate.fault.time";
    private static TaskConfig instance = new TaskConfig();
    protected Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private Properties prop = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskConfig() {
        FileInputStream in = null;
        String rootPath = System.getProperty("Atic.install.base");
        String path = null;
        if (null != rootPath && !rootPath.isEmpty()) {
            path = rootPath + "/Runtime/vsm_conf/CertValidity.properties";
        }
        try {
            if (path != null) {
                in = new FileInputStream(path);
                this.prop.load(in);
            } else {
                this.logger.error((Object)"Failed to get product certificates from CertValidity.properties");
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"file not found exception");
        }
        catch (IOException e) {
            this.logger.error((Object)"IOException error");
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"IOException error");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized TaskConfig getInstance() {
        Object object = LOCK;
        synchronized (object) {
            return instance;
        }
    }

    public Integer getThreshold() {
        if (this.prop.containsKey(CERT_THRESHOLD)) {
            return Integer.valueOf(this.prop.getProperty(CERT_THRESHOLD));
        }
        return 30;
    }

    public Integer getPeriod() {
        if (this.prop.containsKey(CERT_PERIOD)) {
            return Integer.valueOf(this.prop.getProperty(CERT_PERIOD));
        }
        return 1;
    }

    public String getRunTime() {
        if (this.prop.containsKey(CERT_RUN_TIME)) {
            return this.prop.getProperty(CERT_RUN_TIME).trim();
        }
        return "03:00";
    }
}

