/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.initlizer;

import com.hs.lego.cbb.task.certjob.TaskInitializer;
import com.hs.lego.cbb.task.dao.ITaskTypeDAO;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sysjob.InitDataStorageTask;
import com.huawei.atic.schedule.AticBackendThreadUtil;
import java.util.List;

public class InitTaskTypeThread {
    private TaskInitializer certTaskInitializer;
    private InitDataStorageTask initDataStorageTask;
    private ITaskTypeDAO taskTypeDao;
    private List<TaskType> types;

    private InitTaskTypeThread() {
    }

    public static InitTaskTypeThread getInstance() {
        return InitTaskTypeThreadHolder.instance;
    }

    public void init() {
        this.initTaskTypes();
        AticBackendThreadUtil aticBackendThreadUtil = AticBackendThreadUtil.getInstance();
        Thread dataStorageTask = new Thread((Runnable)this.initDataStorageTask, "initDataStorageTask");
        aticBackendThreadUtil.addAticBackendThread(dataStorageTask);
        Thread certTaskThread = new Thread((Runnable)this.certTaskInitializer, "certTaskInitializer");
        aticBackendThreadUtil.addAticBackendThread(certTaskThread);
    }

    private void initTaskTypes() {
        if (null == this.types || this.types.isEmpty()) {
            return;
        }
        for (TaskType type : this.types) {
            TaskType type1;
            type.setType(Integer.valueOf(1));
            if (null == this.taskTypeDao || null != (type1 = this.taskTypeDao.readTaskType(type.getTaskType()))) continue;
            this.taskTypeDao.addTaskType(type);
        }
    }

    public TaskInitializer getCertTaskInitializer() {
        return this.certTaskInitializer;
    }

    public void setCertTaskInitializer(TaskInitializer certTaskInitializer) {
        this.certTaskInitializer = certTaskInitializer;
    }

    public InitDataStorageTask getInitDataStorageTask() {
        return this.initDataStorageTask;
    }

    public void setInitDataStorageTask(InitDataStorageTask initDataStorageTask) {
        this.initDataStorageTask = initDataStorageTask;
    }

    public ITaskTypeDAO getTaskTypeDao() {
        return this.taskTypeDao;
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }

    public List<TaskType> getTypes() {
        return this.types;
    }

    public void setTypes(List<TaskType> types) {
        this.types = types;
    }

    private static class InitTaskTypeThreadHolder {
        private static InitTaskTypeThread instance = new InitTaskTypeThread();

        private InitTaskTypeThreadHolder() {
        }
    }
}

