/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.sysjob;

import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskParameter;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.nem.fault.sdk.service.IFaultBackupService;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StorageFactory {
    private static final int SLEEPCOUNT = 100;
    private static final long SLEEPTIME = 1000L;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private ISysOptLog sysLogService;
    private IFaultBackupService faultBackupService = null;
    private ITaskService taskService;
    private TaskParameter taskParameter = null;
    private String sysOptType = "log_bk";
    private String alarmType = "alarm_bk";
    private String fileStyle = "";
    private String lang = "";
    private String reserDate;
    private String filePath;
    private Map<String, Object> condition;

    public String dateStorage(String dateType) {
        String resultLink = "";
        Task task = null;
        this.log.info((Object)("System dateStorage begin dateType is " + dateType));
        for (int i = 0; null == this.taskService && i < 100; ++i) {
            this.taskService = (ITaskService)ServiceContext.getInstance().getService("taskService", ITaskService.class);
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)e);
            }
        }
        if (null != this.taskService) {
            this.log.info((Object)"taskService is  not null");
            this.condition = new HashMap<String, Object>();
            if (dateType.equals(this.sysOptType)) {
                this.filePath = "datastorage" + File.separator + "sysoptlog";
                this.condition.put("taskType", this.sysOptType);
                this.sysLogService = this.getISysOptLogService();
            } else if (dateType.equals(this.alarmType)) {
                this.condition.put("taskType", this.alarmType);
                this.faultBackupService = this.getFaultBackupService();
                this.filePath = "datastorage" + File.separator + "alarm";
            }
            this.log.info((Object)("filePath=" + this.filePath));
            List taskList = this.taskService.queryTasks(this.condition);
            if (null == taskList || taskList.isEmpty()) {
                return "";
            }
            task = (Task)taskList.get(0);
            this.taskParameter = task.getParameter();
            if (null != this.taskParameter) {
                this.fileStyle = this.taskParameter.getParameter1();
                this.reserDate = this.taskParameter.getParameter2();
                this.lang = this.taskParameter.getParameter3();
                resultLink = this.dateStorageByType(dateType);
            }
        } else {
            this.log.info((Object)"taskService is null");
        }
        return resultLink;
    }

    private IFaultBackupService getFaultBackupService() {
        for (int i = 0; null == this.faultBackupService && i < 100; ++i) {
            try {
                this.faultBackupService = (IFaultBackupService)ServiceContext.getInstance().getService("faultBackupService", IFaultBackupService.class);
                continue;
            }
            catch (RuntimeException e) {
                this.log.error((Object)("taskService is null" + e));
                continue;
            }
            finally {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.log.error((Object)("InterruptedException" + e));
                }
            }
        }
        return this.faultBackupService;
    }

    private ISysOptLog getISysOptLogService() {
        for (int i = 0; null == this.sysLogService && i < 100; ++i) {
            try {
                this.sysLogService = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
                continue;
            }
            catch (RuntimeException e) {
                this.log.error((Object)("taskService is null" + e));
                continue;
            }
            finally {
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.log.error((Object)("InterruptedException" + e));
                }
            }
        }
        return this.sysLogService;
    }

    private String dateStorageByType(String dateType) {
        String resultLink = "";
        String fileTypes = this.getFileType(this.fileStyle);
        this.log.info((Object)("fileTypes=" + fileTypes));
        if (dateType.equals(this.sysOptType)) {
            if (null != this.sysLogService) {
                resultLink = this.sysLogService.transferLog(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang), this.filePath);
            } else {
                this.log.info((Object)"System dateStorage ISysOptLog is null");
            }
        } else if (dateType.equals(this.alarmType)) {
            if (null != this.faultBackupService) {
                resultLink = this.faultBackupService.transferAlarm(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang), this.filePath);
            } else {
                this.log.info((Object)"System dateStorage IFaultBackupService is null");
            }
        }
        this.log.info((Object)("resultLink=" + resultLink));
        return resultLink;
    }

    private long getEndTime(String resDate) {
        long endTime = -1L;
        if (null != resDate && !resDate.equals("")) {
            int reserDate1 = Integer.parseInt(resDate);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -reserDate1);
            endTime = cal.getTime().getTime();
        }
        return endTime;
    }

    private String getFileType(String fileType) {
        String file = "";
        file = fileType.equals("1") ? "csv" : "excel";
        return file;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    private String getLang(String language) {
        String langUa = "";
        langUa = language.equals("1") ? "en" : "zh";
        return langUa;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    public TaskParameter getTaskParameter() {
        return this.taskParameter;
    }

    public void setTaskParameter(TaskParameter taskParameter) {
        this.taskParameter = taskParameter;
    }

    public void setFaultBackupService(IFaultBackupService faultBackupService) {
        this.faultBackupService = faultBackupService;
    }
}

