/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.storage.webapp.action;

import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskParameter;
import com.hs.lego.cbb.task.sdk.model.TaskResult;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.cbb.task.sdk.service.TaskCategory;
import com.hs.lego.cbb.task.sdk.service.TaskPeriodType;
import com.hs.lego.cbb.task.sdk.service.TaskStatus;
import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;

public class StorageAction
extends BaseAction {
    private static final long serialVersionUID = -5574565332623620816L;
    private static final int TWO = 2;
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private String cycleDate;
    private String defaultCycleDate = "30";
    private String reserDate;
    private String defaultReserDate = "90";
    private List<LangPair> listFilestyle;
    private String filestyleLab;
    private String filestyleValue;
    private String defaultFilestyle = "1";
    private int taskType = 1;
    private String sysOptType = "log_bk";
    private String eventType = "alarm_bk";
    private String filePath;
    private String lang;
    private String lastReserDate;
    private String time = "02:00:00";
    private String defaultTime = "02:00:00";
    private TaskResult taskResult;
    private List<LangPair> listLang;
    private String langLab;
    private String langValue;
    private List<TaskResult> taskRecordList;
    private Long[] box = new Long[0];
    private String[] boxNames = new String[0];
    private long taskId;
    private String fileName;
    private String title;
    private String downFileName;
    private ITaskService taskService;

    public String preSaveSysOptStorage() {
        this.taskType = 1;
        this.sysOptStorage();
        return "success";
    }

    public String preSaveEventOptStorage() {
        this.taskType = 2;
        this.sysOptStorage();
        return "success";
    }

    public String testActionOne() {
        this.taskType = 1;
        this.sysOptStorage();
        return "success";
    }

    public String testActionTwo() {
        this.taskType = 2;
        this.sysOptStorage();
        return "success";
    }

    public String sysOptStorage() {
        Date lastReDate = null;
        this.time = this.defaultTime;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> condition = new HashMap<String, String>();
        if (this.taskType == 1) {
            this.title = "lego.lab.storage.sysoptset";
            condition.put("taskType", this.sysOptType);
        } else if (this.taskType == 2) {
            this.title = "lego.lab.storage.eventset";
            condition.put("taskType", this.eventType);
        }
        List taskList = this.taskService.queryTasks(condition);
        this.langValue = "1";
        if (null == taskList || taskList.isEmpty()) {
            this.cycleDate = this.defaultCycleDate;
            this.reserDate = this.defaultReserDate;
            this.filestyleValue = this.defaultFilestyle;
            this.filestyleLab = this.getText("lego.lab.storage.filestyle." + this.defaultFilestyle);
            this.langLab = this.getText("lego.lab.com.lang.en");
            this.langValue = "1";
            lastReDate = this.getFirstStorageTime();
            if (null == lastReDate) {
                throw new LegoCheckedException(205L, new String[]{this.getText("lego.lab.storage.cycleDate")});
            }
            this.taskRecordList = new ArrayList<TaskResult>();
        } else {
            lastReDate = this.taskExtractHandler(this.taskService, taskList);
        }
        this.lastReserDate = dateFormat.format(lastReDate);
        this.listFilestyle = new ArrayList<LangPair>();
        LangPair len1 = new LangPair("1", this.getText("lego.lab.storage.filestyle.1"));
        LangPair len2 = new LangPair("2", this.getText("lego.lab.storage.filestyle.2"));
        this.listFilestyle.add(len1);
        this.listFilestyle.add(len2);
        this.listLang = new ArrayList<LangPair>();
        LangPair langEn = new LangPair("1", this.getText("lego.lab.com.lang.en"));
        LangPair langZh = new LangPair("2", this.getText("lego.lab.com.lang.zh"));
        this.listLang.add(langEn);
        this.listLang.add(langZh);
        return "success";
    }

    private Date taskExtractHandler(ITaskService tempTaskService, List<Task> taskList) {
        Task task = taskList.get(0);
        this.taskId = task.getTaskId();
        Paging paging = tempTaskService.queryTaskResultList(task.getTaskId(), this.start, this.pageSize);
        this.taskRecordList = paging.getData();
        this.total = paging.getCount();
        this.taskResult = tempTaskService.readTaskResult(task.getTaskId().longValue());
        String parameter1 = task.getParameter().getParameter1();
        this.filestyleValue = null;
        if (this.isParaEmpty(parameter1)) {
            this.filestyleValue = parameter1;
        }
        this.filestyleLab = this.getText("lego.lab.storage.filestyle." + this.filestyleValue);
        String parameter2 = task.getParameter().getParameter2();
        this.reserDate = this.isParaEmpty(parameter2) ? parameter2 : this.defaultReserDate;
        String parameter3 = task.getParameter().getParameter3();
        if (this.isParaEmpty(parameter3)) {
            this.langValue = parameter3;
        }
        this.langLab = this.langValue.equals("1") ? this.getText("lego.lab.com.lang.en") : this.getText("lego.lab.com.lang.zh");
        String parameter4 = task.getParameter().getParameter4();
        if (this.isParaEmpty(parameter4)) {
            this.time = parameter4;
        }
        Date lastReDate = null != task.getPreTime() ? task.getPreTime() : task.getBaseTime();
        this.filePath = task.getParameter().getParameter5();
        this.cycleDate = task.getPeriod() + "";
        return lastReDate;
    }

    public boolean validateCommon() {
        if (this.checkParamNull(this.cycleDate) || this.checkParamNull(this.reserDate) || this.checkParamNull(this.filestyleValue) || this.checkParamNull(this.langValue)) {
            return false;
        }
        return !this.checkParamErrorRange(Integer.parseInt(this.cycleDate), 1, 120) && !this.checkParamErrorRange(Integer.parseInt(this.reserDate), 1, 120) && !this.checkParamErrorRange(Integer.parseInt(this.filestyleValue), 1, 2) && !this.checkParamErrorRange(Integer.parseInt(this.langValue), 1, 2);
    }

    private boolean checkParamNull(String str) {
        return null == str || "".equals(str.trim()) || str.length() > 3;
    }

    private boolean checkParamErrorRange(int icheck, int min, int max) {
        return min > icheck || max < icheck;
    }

    private boolean isParaEmpty(String parameter1) {
        return null != parameter1 && !parameter1.equalsIgnoreCase("");
    }

    public String saveSysOptStorage() {
        this.taskType = 1;
        this.saveSysOptStorSet();
        return "success";
    }

    public String saveEventOptStorage() {
        this.taskType = 2;
        this.saveSysOptStorSet();
        return "success";
    }

    private void saveSysOptStorSet() {
        this.getOperateLog().normal("lego.lab.storage.parameters.edit", "lego.dic.module.system");
        String[] timeList = this.time.split(":");
        StringBuffer middleTime = new StringBuffer();
        for (int i = 0; i < timeList.length; ++i) {
            String setTime = timeList[i];
            if (setTime.length() < 2) {
                middleTime.append('0').append(setTime);
            } else {
                middleTime.append(setTime);
            }
            if (i == 2) continue;
            middleTime.append(':');
        }
        this.time = middleTime.toString();
        try {
            if (Integer.parseInt(this.cycleDate) < 1 || Integer.parseInt(this.cycleDate) > 120) {
                throw new LegoCheckedException(205L, new String[]{this.getText("lego.lab.storage.cycleDate")});
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"ERROR IN StorageAction saveSysOptStorSet", (Throwable)e);
        }
        try {
            if (Integer.parseInt(this.reserDate) < 1 || Integer.parseInt(this.reserDate) > 120) {
                throw new LegoCheckedException(205L, new String[]{this.getText("lego.lab.storage.reserDate")});
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"ERROR IN StorageAction saveSysOptStorSet", (Throwable)e);
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", "log_bk");
        String[] param = new String[]{this.time, " " + this.cycleDate, " " + this.reserDate, "lego.lab.storage.filestyle." + this.filestyleValue, this.langValue.equals("1") ? "lego.lab.com.lang.en" : "lego.lab.com.lang.zh"};
        if (this.taskType == 1) {
            condition.put("taskType", this.sysOptType);
            this.getOperateLog().normal("lego.lab.storage.parameters.edit", "lego.dic.module.system", "lego.lab.storage.sysOptLog", true, "lego.lab.storage.log.detail", param);
        } else if (this.taskType == 2) {
            condition.put("taskType", this.eventType);
            this.getOperateLog().normal("lego.lab.storage.parameters.edit", "lego.dic.module.system", "lego.lab.storage.event", true, "lego.lab.storage.log.detail", param);
        }
        List taskList = this.taskService.queryTasks(condition);
        Task task = null;
        if (null == taskList || taskList.isEmpty()) {
            task = new Task();
            TaskType taskTypeTemp = null;
            if (this.taskType == 1) {
                taskTypeTemp = this.taskService.readTaskType(this.sysOptType);
                task.setTaskName("SystemOptStorage");
            } else if (this.taskType == 2) {
                task.setTaskName("EventOptStorage");
                taskTypeTemp = this.taskService.readTaskType(this.eventType);
            }
            Date currentDate = new Date();
            Date date = this.getFirstStorageTime();
            if (null == date) {
                throw new LegoCheckedException(205L, new String[]{this.getText("lego.lab.storage.cycleDate")});
            }
            task.setBaseTime(date);
            task.setCreateTime(currentDate);
            task.setExecuteType(Integer.valueOf(2));
            task.setIsNotifyFail(Boolean.valueOf(false));
            task.setPeriod(Integer.valueOf(this.cycleDate));
            task.setPeriodtimes(Integer.valueOf(-1));
            task.setPeriodType(Integer.valueOf(TaskPeriodType.date.getValue()));
            task.setLastModifyTime(currentDate);
            task.setTaskType(taskTypeTemp);
            task.setCreateUser(Long.valueOf(1L));
            task.setTaskCategory(Integer.valueOf(TaskCategory.system.getValue()));
            task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
            TaskParameter taskParameter = new TaskParameter();
            taskParameter.setParameter1(this.filestyleValue);
            taskParameter.setParameter2(this.reserDate);
            taskParameter.setParameter3(this.langValue);
            taskParameter.setParameter4(this.time);
            task.setParameter(taskParameter);
            task.setIsNotifyFail(Boolean.valueOf(false));
            task.setIsNotifySuccess(Boolean.valueOf(false));
            task.setIsSendMail(Boolean.valueOf(false));
            task.setIsSendNote(Boolean.valueOf(false));
            taskParameter.setTask(task);
            this.taskId = this.taskService.addTask(task);
        } else {
            int newtaskPeriod;
            Date latelyTime = null;
            task = (Task)taskList.get(0);
            Date baseTime = task.getBaseTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
            int taskPeriod = task.getPeriod();
            if (taskPeriod != (newtaskPeriod = Integer.parseInt(this.cycleDate))) {
                task.setPeriod(Integer.valueOf(this.cycleDate));
                latelyTime = new Date();
                task.setBaseTime(this.getBaseTime(latelyTime, this.time, "0"));
                task.setNextTime(null);
            } else if (!this.time.equalsIgnoreCase(dateFormat.format(baseTime))) {
                latelyTime = null != task.getNextTime() ? task.getNextTime() : task.getBaseTime();
                Date nextDate = this.getBaseTime(latelyTime, this.time);
                if (null != task.getNextTime()) {
                    task.setNextTime(nextDate);
                }
                task.setBaseTime(nextDate);
            }
            TaskParameter taskParameter = task.getParameter();
            taskParameter.setParameter1(this.filestyleValue);
            taskParameter.setParameter4(this.time);
            taskParameter.setParameter2(this.reserDate);
            taskParameter.setParameter3(this.langValue);
            task.setParameter(taskParameter);
            task.setLastModifyTime(new Date());
            this.taskService.updateTask(task);
        }
    }

    public boolean validateBox() {
        int i;
        if (null != this.box && this.box.length > 0) {
            if (this.box.length > 100) {
                return false;
            }
            for (i = 0; i < this.box.length; ++i) {
                if (this.box[i] >= 0L) continue;
                return false;
            }
        }
        if (null != this.boxNames && this.boxNames.length > 0) {
            if (this.boxNames.length > 100) {
                return false;
            }
            for (i = 0; i < this.boxNames.length; ++i) {
                if (this.boxNames[i].matches("^([\\d-_]+.zip|lego.dic.warningaralm.noexist)$") && this.boxNames[i].length() <= 32) continue;
                return false;
            }
        }
        return true;
    }

    public void deleteTaskResult() {
        this.taskType = 1;
        this.deleteTaskResults();
    }

    public void deleteEventResult() {
        this.taskType = 2;
        this.deleteTaskResults();
    }

    private void deleteTaskResults() {
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.box.length; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(this.box[i].longValue());
            tempBatch.setTargetName(this.boxNames[i]);
            bathOprLst.add(tempBatch);
        }
        this.deleteTaskResultsFile(this.taskType);
        this.batchOperationResult = this.taskService.deleteTaskResultList(bathOprLst, this.taskType);
        if (this.batchOperationResult != null) {
            this.bathResult(this.batchOperationResult);
        }
    }

    public void deleteTaskResultsFile(int taskType1) {
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        if (this.taskType == 1) {
            this.getOperateLog().warning("lego.lab.storage.dellog", "lego.dic.module.system");
        } else {
            this.getOperateLog().warning("lego.lab.storage.delalarm", "lego.dic.module.system", "lego.dic.warningaralm.noexist", true, "", null);
        }
        for (int i = 0; i < this.boxNames.length; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetName(this.boxNames[i]);
            bathOprLst.add(tempBatch);
        }
        this.taskService.deleteFile(taskType1, bathOprLst);
    }

    public void isExitDownFile() {
        this.taskType = 1;
        this.isExitDwFile();
    }

    public void isExitEventDownFile() {
        this.taskType = 2;
        this.isExitDwFile();
    }

    private void isExitDwFile() {
        String dwFileName = "";
        if (this.getDownFileName() != null) {
            dwFileName = this.getDownFileName();
        }
        if ((dwFileName = Normalizer.normalize(dwFileName, Normalizer.Form.NFKC)).indexOf(".") != dwFileName.lastIndexOf(".") || dwFileName.contains("/") || dwFileName.contains("\\")) {
            throw new LegoCheckedException(1291L);
        }
        if (!this.taskService.checkFile(this.taskType, dwFileName).booleanValue()) {
            throw new LegoCheckedException(1291L);
        }
        if (!this.taskService.checkFileSize(this.taskType, dwFileName).booleanValue()) {
            throw new LegoCheckedException(1297L);
        }
    }

    public void downloadFile() {
        this.taskType = 1;
        this.downFile();
    }

    public void downloadEventFile() {
        this.taskType = 2;
        this.downFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downFile() {
        String tfileName = "";
        String dwFileName = "";
        if (this.getDownFileName() != null) {
            tfileName = dwFileName = this.getDownFileName();
        }
        if ((dwFileName = Normalizer.normalize(dwFileName, Normalizer.Form.NFKC)).indexOf(".") != dwFileName.lastIndexOf(".")) {
            throw new LegoCheckedException(1291L);
        }
        if (!this.taskService.checkFile(this.taskType, dwFileName).booleanValue()) {
            throw new LegoCheckedException(1291L);
        }
        if (this.taskType == 1) {
            this.getOperateLog().info("lego.lab.storage.downlog", "lego.dic.module.system", dwFileName);
        } else {
            this.getOperateLog().info("lego.lab.storage.downevent", "lego.dic.module.system", dwFileName);
        }
        HttpServletResponse response = this.getResponse();
        this.responseSet(tfileName, response);
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            List dataList = this.taskService.downLoadLarge(this.taskType, dwFileName);
            for (byte[] data : dataList) {
                bos.write(data);
            }
            bos.flush();
        }
        catch (LegoCheckedException le) {
            this.logger.error((Object)"ERROR IN StorageAction downFile", (Throwable)le);
        }
        catch (IOException e) {
            this.log.error((Object)"StorageAction downFile IOException error653110170615808");
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"StorageAction downFile IOException error653110170615808");
                }
                bos = null;
            }
        }
    }

    private void responseSet(String tfileName, HttpServletResponse response) {
        response.reset();
        if (!this.checkHeaderStr(tfileName)) {
            this.log.error((Object)"responseSet error,tfileName is inValid.653110170615808");
            return;
        }
        response.setContentType("application/x-download");
        response.addHeader("Content-Disposition", "attachment;filename=" + tfileName);
    }

    private boolean checkHeaderStr(String str) {
        char[] unsafeChar;
        for (char c : unsafeChar = new char[]{'\n', '\r', '=', ':'}) {
            if (str.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private Date getBaseTime(Date date, String time1, String cycle) {
        Calendar nextCal = Calendar.getInstance();
        nextCal.setTime(date);
        if (date.before(new Date())) {
            nextCal.add(5, Integer.parseInt(cycle));
        }
        Date baseTime = nextCal.getTime();
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            baseTime = dateFormat.parse(formatDay.format(baseTime) + " " + time1);
        }
        catch (ParseException e) {
            this.log.error((Object)("StorageAction getBaseTime:" + e.getMessage() + 653110170615808L));
        }
        if (baseTime.before(new Date())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseTime);
            cal.add(5, 1);
            baseTime = cal.getTime();
        }
        return baseTime;
    }

    private Date getBaseTime(Date date, String time1) {
        Calendar nextCal = Calendar.getInstance();
        nextCal.setTime(date);
        Date baseTime = nextCal.getTime();
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            baseTime = dateFormat.parse(formatDay.format(baseTime) + " " + time1);
        }
        catch (ParseException e) {
            this.log.error((Object)("StorageAction getBaseTime:" + e.getMessage() + 653110170615808L));
        }
        if (baseTime.before(new Date())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseTime);
            cal.add(5, 1);
            baseTime = cal.getTime();
        }
        return baseTime;
    }

    public String queryTaskResult() {
        Paging paging = this.taskService.queryTaskResultList(Long.valueOf(this.taskId), this.start, this.pageSize);
        this.taskRecordList = paging.getData();
        this.total = paging.getCount();
        return "success";
    }

    private Date getFirstStorageTime() {
        Date fristRunTime = null;
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        Date nextDay = cal.getTime();
        try {
            fristRunTime = dateFormat.parse(formatDay.format(nextDay) + " " + this.time);
        }
        catch (ParseException e) {
            this.log.error((Object)("StorageAction getFirstStorageTime:" + e.getMessage() + 653110170615808L));
        }
        return fristRunTime;
    }

    public String getCycleDate() {
        return this.cycleDate;
    }

    public void setCycleDate(String cycleDate) {
        this.cycleDate = cycleDate;
    }

    public String getReserDate() {
        return this.reserDate;
    }

    public void setReserDate(String reserDate) {
        this.reserDate = reserDate;
    }

    public List<LangPair> getListFilestyle() {
        return this.listFilestyle;
    }

    public void setListFilestyle(List<LangPair> listFilestyle) {
        this.listFilestyle = listFilestyle;
    }

    public String getFilestyleLab() {
        return this.filestyleLab;
    }

    public void setFilestyleLab(String filestyleLab) {
        this.filestyleLab = filestyleLab;
    }

    public String getFilestyleValue() {
        return this.filestyleValue;
    }

    public void setFilestyleValue(String filestyleValue) {
        this.filestyleValue = filestyleValue;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public void setTaskType(int taskType) {
        this.taskType = taskType;
    }

    public String getSysOptType() {
        return this.sysOptType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLastReserDate() {
        return this.lastReserDate;
    }

    public void setLastReserDate(String lastReserDate) {
        this.lastReserDate = lastReserDate;
    }

    public TaskResult getTaskResult() {
        return this.taskResult;
    }

    public void setTaskResult(TaskResult taskResult) {
        this.taskResult = taskResult;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public List<LangPair> getListLang() {
        return this.listLang;
    }

    public void setListLang(List<LangPair> listLang) {
        this.listLang = listLang;
    }

    public String getLangLab() {
        return this.langLab;
    }

    public void setLangLab(String langLab) {
        this.langLab = langLab;
    }

    public String getLangValue() {
        return this.langValue;
    }

    public void setLangValue(String langValue) {
        this.langValue = langValue;
    }

    public List<TaskResult> getTaskRecordList() {
        return this.taskRecordList;
    }

    public void setTaskRecordList(List<TaskResult> taskRecordList) {
        this.taskRecordList = taskRecordList;
    }

    public Long[] getBox() {
        return (Long[])ArrayDeepClone.deepClone((Object)this.box);
    }

    public void setBox(Long[] box) {
        this.box = (Long[])ArrayDeepClone.deepClone((Object)box);
    }

    public String[] getBoxNames() {
        return (String[])ArrayDeepClone.deepClone((Object)this.boxNames);
    }

    public void setBoxNames(String[] boxNames) {
        this.boxNames = (String[])ArrayDeepClone.deepClone((Object)boxNames);
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getDstChangeHour() {
        Calendar pre = Calendar.getInstance();
        TimeZone timeZone = TimeZone.getDefault();
        if (timeZone.useDaylightTime()) {
            pre.setTime(new Date());
            pre.set(11, 0);
            for (int i = 0; i < 364; ++i) {
                if (!timeZone.inDaylightTime(pre.getTime())) {
                    Calendar after = Calendar.getInstance();
                    after.setTime(pre.getTime());
                    after.add(6, 1);
                    if (timeZone.inDaylightTime(after.getTime())) {
                        after.setTime(pre.getTime());
                        for (int j = 0; j < 23; ++j) {
                            after.add(11, 1);
                            if (!timeZone.inDaylightTime(pre.getTime()) && timeZone.inDaylightTime(after.getTime())) {
                                return pre.get(11) + 1;
                            }
                            pre.add(11, 1);
                        }
                        break;
                    }
                }
                pre.add(6, 1);
            }
        }
        return -1;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }
}

