/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.lus.SecDownLoadUtil;
import com.hs.atic.bis.lus.model.UpdateModel;
import com.hs.atic.bis.lus.util.SHA256Digester;
import com.hs.atic.bis.model.LibFileSync;
import com.hs.atic.bis.util.DeployLibFileThread;
import com.hs.atic.bis.util.UnDeployLocCusThread;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.GlobeDeployStatusForm;
import com.hs.atic.sdk.bis.form.LibraryFileForm;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.service.IGlobeDeployStatusService;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.atic.util.LibFilePathUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class LibraryFileAction
extends BaseAction {
    private static Map<String, String> deployOrUndeploy = new HashMap<String, String>();
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final long serialVersionUID = 1L;
    private static List<LibFileSync> syncLibFileListStatic = new ArrayList<LibFileSync>();
    private transient ILibraryFileService libraryFileService;
    private transient ILocationCustomService locationCustomService;
    private transient IGlobeDeployStatusService globeDeployStatusService;
    private transient IAticDeviceService aticDeviceService;
    private int allLibFileNum = 40;
    private int libFileSize = 20;
    private int libFileSizeUnit = 1024;
    private List<LibraryFileForm> libFileList = new ArrayList<LibraryFileForm>();
    private String sortType = "DESC";
    private String sortField = "pkId";
    private Long[] libIdList;
    private String[] libNameList;
    private File libFile;
    private String libName;
    private Long libId;
    private String libType;
    private String hashCode;
    private Long[] ipPkids;
    private List<GlobeDeployStatusForm> objDeployList = new ArrayList<GlobeDeployStatusForm>();
    private boolean needClearInterval = false;
    private List<LibFileSync> syncLibFileList = new ArrayList<LibFileSync>();
    private SecDownLoadUtil secDownLoadUtil = new SecDownLoadUtil();
    private String helpLanguage = "";

    public Long[] getIpPkids() {
        if (null != this.ipPkids) {
            return (Long[])this.ipPkids.clone();
        }
        return new Long[0];
    }

    public void setIpPkids(Long[] ipPkids) {
        this.ipPkids = null != ipPkids ? (Long[])ipPkids.clone() : null;
    }

    public boolean validateIpPkids() {
        if (null == this.ipPkids || this.ipPkids.length == 0) {
            return false;
        }
        for (Long ipPkid : this.ipPkids) {
            if (ipPkid >= 0L) continue;
            return false;
        }
        return true;
    }

    public ILocationCustomService getLocationCustomService() {
        return this.locationCustomService;
    }

    public void setLocationCustomService(ILocationCustomService locationCustomService) {
        this.locationCustomService = locationCustomService;
    }

    public String getHelpLanguage() {
        return this.helpLanguage;
    }

    public void setHelpLanguage(String helpLanguage) {
        this.helpLanguage = helpLanguage;
    }

    public String listLibraryFile() throws UnsupportedEncodingException {
        Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
        if ("zh".equalsIgnoreCase(locale.getLanguage())) {
            this.setHelpLanguage("zh_cn");
        } else {
            this.setHelpLanguage("en");
        }
        this.firstInstallLoadLibFileToDB();
        Paging page = this.libraryFileService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.libFileList = page.getData();
        this.processData4Jsp(this.libFileList);
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        LOG.info((Object)("query library file list, size = " + this.libFileList.size()));
        this.getSession().getAttribute("esn");
        return "list";
    }

    private void firstInstallLoadLibFileToDB() throws UnsupportedEncodingException {
        String[] fileList;
        String libFilePath;
        File file;
        int libFileCount = this.libraryFileService.getLibFileCount();
        if (0 == libFileCount && (file = new File(libFilePath = LibFilePathUtil.getLibFilePath())).exists() && null != (fileList = file.list()) && fileList.length > 0) {
            String[] stringArray = fileList;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String fileName;
                this.libName = fileName = stringArray[i];
                if (!this.processParaBeforeSaveToDb()) continue;
                this.libFile = new File(libFilePath + this.libName);
                this.saveLibFile4DBAndFirstInstall(true, false);
            }
        }
    }

    private Map<String, String> createQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("sortName", this.sortField);
        queryMap.put("sortType", this.sortType);
        return queryMap;
    }

    private void processData4Jsp(List<LibraryFileForm> libFileLists) {
        for (LibraryFileForm libraryFileForm : libFileLists) {
            this.setLibFileType(libraryFileForm);
            this.setLibFileImportTimeAndType(libraryFileForm);
            this.setLibFileDeployTime(libraryFileForm);
            this.setLibFileDeployStatus(libraryFileForm);
            this.setLibFileHashCode(libraryFileForm);
        }
    }

    private void setLibFileHashCode(LibraryFileForm libraryFileForm) {
        if (null != libraryFileForm.getHashCode() && libraryFileForm.getHashCode().length() == 64) {
            libraryFileForm.setHashCode4Jsp("SHA-256:" + libraryFileForm.getHashCode());
        } else if (null != libraryFileForm.getHashCode() && libraryFileForm.getHashCode().length() == 32) {
            libraryFileForm.setHashCode4Jsp("MD5:" + libraryFileForm.getHashCode());
        }
    }

    private void setLibFileDeployStatus(LibraryFileForm libraryFileForm) {
        String deployStatusJsp = ZoneBisUtil.getDeployStatus4Jsp(libraryFileForm.getDeployStatus(), false);
        libraryFileForm.setDeployStatus4Jsp(deployStatusJsp);
    }

    private void setLibFileDeployTime(LibraryFileForm libraryFileForm) {
        if (null == libraryFileForm.getDeployTime() || libraryFileForm.getDeployTime() <= 0L) {
            libraryFileForm.setDeployTime4Jsp("");
        } else {
            libraryFileForm.setDeployTime4Jsp(AticUtil.convertTimeLong((Long)libraryFileForm.getDeployTime()));
        }
    }

    private void setLibFileImportTimeAndType(LibraryFileForm libraryFileForm) {
        if (null == libraryFileForm.getImportTime() || libraryFileForm.getImportTime() <= 0L) {
            libraryFileForm.setImportTime4Jsp("");
        } else {
            libraryFileForm.setImportTime4Jsp(AticUtil.convertTimeLong((Long)libraryFileForm.getImportTime()));
        }
        if (libraryFileForm.getImportType().equals("Upload")) {
            libraryFileForm.setImportType4Jsp(this.getText("atic.bis.libraryFile.importType.upload"));
        } else {
            libraryFileForm.setImportType4Jsp(this.getText("atic.bis.libraryFile.importType.update"));
        }
    }

    private void setLibFileType(LibraryFileForm libraryFileForm) {
        String libType4Jsp = this.getLibFileType4Jsp(libraryFileForm.getLibType());
        libraryFileForm.setLibType4Jsp(libType4Jsp);
    }

    private String getLibFileType4Jsp(String libTypeStr) {
        String libType4Jsp = "";
        libType4Jsp = libTypeStr.equals("Lib_Location") ? this.getText("atic.bis.libraryFile.libType.location") : (libTypeStr.equals("Lib_BOT") ? this.getText("atic.bis.libraryFile.libType.bot") : (libTypeStr.equals("Lib_IpReputation") ? this.getText("atic.bis.libraryFile.libType.ipReputation") : (libTypeStr.equals("Lib_IPS") ? this.getText("atic.bis.libraryFile.libType.ips") : (libTypeStr.equals("Lib_CNC") ? this.getText("atic.bis.libraryFile.libType.cnc") : (libTypeStr.equals("Lib_SSLDetec") ? this.getText("atic.bis.libraryFile.libType.ssl") : this.getText("atic.bis.libraryFile.libType.location"))))));
        return libType4Jsp;
    }

    public boolean checkLibType() {
        if ("Lib_Location".equals(this.libType)) {
            return true;
        }
        if ("Lib_BOT".equals(this.libType)) {
            return true;
        }
        if ("Lib_IpReputation".equals(this.libType)) {
            return true;
        }
        if ("Lib_IPS".equals(this.libType)) {
            return true;
        }
        if ("Lib_SSLDetec".equals(this.libType)) {
            return true;
        }
        return StringUtils.equals((CharSequence)"Location_Custom", (CharSequence)this.libType);
    }

    public boolean checkLibId() {
        if (null != this.libId) {
            try {
                return this.libId >= 1L;
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return false;
    }

    public void delLibraryFile() {
        this.getOperateLog().warning("atic.bis.libraryFile.delete.libraryFile", "lego.dic.module.AticBis");
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (null != this.libIdList) {
            for (int i = 0; i < this.libIdList.length; ++i) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(this.libIdList[i].longValue());
                bo.setTargetName(this.libNameList[i]);
                batchOpList.add(bo);
            }
            this.batchOperationResult = this.libraryFileService.batchDelLibraryFile(batchOpList);
        }
        List result = this.batchOperationResult.getResult();
        for (BatchOperation each : result) {
            if (each.getErrorCode() != 0L) continue;
            String libNameStr = each.getTargetName();
            String libFileAllPath = LibFilePathUtil.getLibFilePath() + libNameStr;
            File file = new File(libFileAllPath);
            if (!file.exists() || !file.isFile()) continue;
            boolean delResult = file.delete();
            LOG.info((Object)("delResult from discard, delResult: " + delResult + ",libName: " + this.getcleanedMessage(libNameStr)));
        }
        LOG.info((Object)("delete delLibraryFile : " + this.getcleanedMessage(AticUtil.appendOperNameFromBatchOper((BatchOperationResult)this.batchOperationResult))));
        this.bathResult(this.batchOperationResult);
    }

    public boolean validateLibIdList() {
        if (null == this.libIdList || this.libIdList.length == 0) {
            return false;
        }
        for (Long checkId : this.libIdList) {
            if (checkId >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateLibNameList() {
        if (null == this.libNameList || this.libNameList.length == 0) {
            return false;
        }
        for (String tempLibName : this.libNameList) {
            if (AticUtil.validateSpecialStr((String)tempLibName) && (tempLibName.endsWith(".zip") || tempLibName.endsWith(".mod"))) continue;
            LOG.error((Object)("libName validate is error! libName=" + this.getcleanedMessage(tempLibName)));
            return false;
        }
        return true;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public String importLibFile() {
        LOG.info((Object)"prepare to importLibFile");
        return "success";
    }

    public String listLibDeployResult() {
        LOG.info((Object)"listLibDeployResult");
        boolean setDeployingStatus = true;
        setDeployingStatus = this.libraryFileService.setLibFileToDepolying(null, this.libId, this.libType);
        if (setDeployingStatus) {
            this.getLibFileDeployStatus();
            DeployLibFileThread deployLibFileThread = new DeployLibFileThread(this.createConditionMap(), this.aticDeviceService.getAntiDDoSDevice());
            deployLibFileThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            deployLibFileThread.start();
        } else {
            LOG.error((Object)"setOtherLibFileToUndeploy error");
        }
        return "success";
    }

    public void checkIsZoneOccupy() {
        List<LocationCustomForm> locCus = this.locationCustomService.getListByPkIds(this.ipPkids);
        if (null == locCus || locCus.isEmpty()) {
            this.responseResult("notexist");
            LOG.error((Object)"checkIsZoneOccupy :   not exist.");
            return;
        }
        ArrayList<String> locationIds = new ArrayList<String>();
        for (LocationCustomForm loca : locCus) {
            locationIds.add(loca.getPkId().toString());
        }
        List<String> zoneNames = this.locationCustomService.checkIsZoneOccupy(locationIds);
        if (null == zoneNames || zoneNames.isEmpty()) {
            this.responseResult("notexist");
            LOG.info((Object)"checkIsZoneOccupy :zoneNames is Empty!");
            return;
        }
        this.responseResult(zoneNames.toString());
    }

    public String listLocCusUnDeployResult() {
        LOG.info((Object)"listLocCusUnDeployResult");
        this.getLibFileDeployStatus();
        List allDdosFirewall = this.aticDeviceService.getAntiDDoSDevice();
        UnDeployLocCusThread unDeployLocCusThread = new UnDeployLocCusThread(this.createConditionMap(), allDdosFirewall);
        unDeployLocCusThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
        unDeployLocCusThread.start();
        return "success";
    }

    private Map<String, String> createConditionMap() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        String operator = currentUser.getUserName();
        String terminalIp = this.fetchRequest().getRemoteAddr();
        LibraryFileForm form = this.libraryFileService.findById(this.libId);
        String libFileName = "";
        if (null != form) {
            libFileName = form.getLibName();
        }
        HashMap<String, String> condtionMap = new HashMap<String, String>();
        condtionMap.put("objectId", String.valueOf(this.libId));
        condtionMap.put("objectType", String.valueOf(this.libType));
        condtionMap.put("libFilePath", LibFilePathUtil.getLibFilePath() + libFileName);
        condtionMap.put("operator", String.valueOf(operator));
        condtionMap.put("terminalIp", String.valueOf(terminalIp));
        condtionMap.put("httpSessionId", this.getSession().getId() + "_" + this.libId);
        return condtionMap;
    }

    public String refreshDeployStatus() {
        String result = deployOrUndeploy.get(this.getSession().getId() + "_" + this.libId);
        if (!AticUtil.isNull((String)result)) {
            deployOrUndeploy.remove(this.getSession().getId() + "_" + this.libId);
            this.needClearInterval = true;
        }
        this.getLibFileDeployStatus();
        return "success";
    }

    public String listSyncLibFile() throws UnsupportedEncodingException {
        List<UpdateModel> updateInfoList = this.secDownLoadUtil.syncloadLibFile();
        List<UpdateModel> umList = this.secDownLoadUtil.getLibraryFileUpdateModelInfo();
        for (UpdateModel um : umList) {
            LibraryFileForm libFileForm = this.libraryFileService.getMaxVerLibFile(um.getLibFileType());
            this.addLibFileToSyncList(libFileForm, updateInfoList, um);
        }
        this.responseResult("success");
        return "success";
    }

    public String showListSyncLibFile() {
        this.syncLibFileList = LibraryFileAction.getSyncLibFileListStatic();
        return "success";
    }

    private void addLibFileToSyncList(LibraryFileForm botLibFileForm, List<UpdateModel> updateInfoList, UpdateModel um) throws UnsupportedEncodingException {
        LibFileSync botSync = new LibFileSync();
        Long libFielId = 0L;
        String currentLibFileName = "";
        if (null != botLibFileForm) {
            libFielId = botLibFileForm.getPkId();
            currentLibFileName = botLibFileForm.getLibName();
        }
        botSync.setLibFileId(libFielId);
        botSync.setCurrentLibFileName(currentLibFileName);
        botSync.setLibFileType(um.getLibFileType());
        botSync.setLibFileType4Jsp(this.getLibFileType4Jsp(um.getLibFileType()));
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation("atic.bis.libraryFile.secdownload");
        syncSysLog.setModule("lego.dic.module.AticBis");
        syncSysLog.setLevel(SysoplogLevel.normal.getValue());
        syncSysLog.setOperator(currentUser.getUserName().trim());
        syncSysLog.setTerminalIp(currentUser.getIpAdr());
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        String modeName = um.getModeName().trim();
        if (null != updateInfoList) {
            for (UpdateModel updateModel : updateInfoList) {
                if (!updateModel.getModeName().trim().equals(modeName)) continue;
                if (updateModel.getMessageCode().equals(String.valueOf(0))) {
                    boolean isSave = false;
                    String libFilePath = LibFilePathUtil.getLibFilePath();
                    String libFileName = "";
                    libFileName = updateModel.getModeName().startsWith("IPS") ? this.secDownLoadUtil.getIpsOfflineFileName() : this.secDownLoadUtil.getLibFileNameFromUpdateInfo(updateModel);
                    this.hashCode = this.secDownLoadUtil.getLibFileSHA256FromUpdateInfo(updateModel);
                    if (updateModel.isDownLoad()) {
                        botSync.setRemoteLibFileStatus4Jsp(this.getText("atic.bis.libraryFile.sync.success"));
                        botSync.setRemoteLibFileStatus("success");
                    } else {
                        botSync.setRemoteLibFileStatus4Jsp(this.getText("atic.bis.libraryFile.sync.error.unkonw"));
                    }
                    this.libName = libFileName;
                    this.libFile = new File(libFilePath + libFileName);
                    if (!AticUtil.isNull((String)libFileName)) {
                        botSync.setRemoteLibFileName(libFileName);
                        if (this.libFile.exists()) {
                            isSave = this.saveLibFile4DBAndFirstInstall(false, true);
                        }
                    }
                    if (isSave) {
                        syncSysLog.setResult(1);
                        syncSysLog.setTarget(libFileName);
                        syncSysLog.setDetail("atic.bis.libraryFile.secdownload.success");
                        sysOptLog.writeOptLog(syncSysLog);
                        continue;
                    }
                    syncSysLog.setResult(0);
                    syncSysLog.setTarget(libFileName);
                    syncSysLog.setDetail("atic.bis.libraryFile.secdownload.fail");
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                String messageCode = "atic.bis.libraryFile.sync.error." + updateModel.getMessageCode();
                String message = this.getText(messageCode);
                if ("420".equals(updateModel.getMessageCode())) {
                    String remotelibFileName = this.secDownLoadUtil.getLibFileNameFromUpdateInfo(updateModel);
                    botSync.setRemoteLibFileName(remotelibFileName);
                    botSync.setRemoteLibFileStatus4Jsp(message);
                    syncSysLog.setResult(1);
                    syncSysLog.setTarget(remotelibFileName);
                    syncSysLog.setDetail(messageCode);
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                if (message.equals(messageCode)) {
                    botSync.setRemoteLibFileStatus4Jsp(this.getText("atic.bis.libraryFile.sync.error.unkonw"));
                    syncSysLog.setResult(0);
                    syncSysLog.setTarget(modeName);
                    syncSysLog.setDetail("atic.bis.libraryFile.sync.error.unkonw");
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                botSync.setRemoteLibFileStatus4Jsp(message);
                syncSysLog.setResult(0);
                syncSysLog.setTarget(modeName);
                syncSysLog.setDetail(messageCode);
                sysOptLog.writeOptLog(syncSysLog);
            }
            this.syncLibFileList.add(botSync);
        } else {
            botSync.setRemoteLibFileStatus4Jsp(this.getText("lego.err.571917"));
            this.syncLibFileList.add(botSync);
            LOG.warn((Object)"Synchronize Library File. updateInfoList is null");
            syncSysLog.setResult(0);
            syncSysLog.setTarget(modeName);
            syncSysLog.setDetail("lego.err.571917");
            sysOptLog.writeOptLog(syncSysLog);
        }
        LibraryFileAction.setSyncLibFileListStatic(this.syncLibFileList);
    }

    private void getLibFileDeployStatus() {
        Paging page = this.globeDeployStatusService.queryByPage(this.createQueryMap4GlobeDeploy(), 0, Integer.MAX_VALUE);
        List allDeployStatus = page.getData();
        List allDdosFirewall = this.aticDeviceService.getAntiDDoSDevice();
        for (AticDevice firewall : allDdosFirewall) {
            boolean containInDeploy = false;
            for (GlobeDeployStatusForm globeDeployStatusForm : allDeployStatus) {
                if (!globeDeployStatusForm.getTargetId().equals(firewall.getMoId())) continue;
                globeDeployStatusForm.setDeployStatus4Jsp(ZoneBisUtil.getDeployStatus4Jsp(globeDeployStatusForm.getDeployStatus(), false));
                this.objDeployList.add(globeDeployStatusForm);
                containInDeploy = true;
                break;
            }
            if (containInDeploy) continue;
            GlobeDeployStatusForm temp = new GlobeDeployStatusForm();
            temp.setTargetId(firewall.getMoId());
            temp.setTargetName(firewall.getName());
            temp.setTargetType(firewall.getDeviceModel());
            temp.setTargetIp(firewall.getIpAddress());
            temp.setDeployStatus("undeployed");
            temp.setDeployStatus4Jsp(this.getText("atic.bis.libraryFile.deployStatus.undeployed"));
            this.objDeployList.add(temp);
        }
    }

    private Map<String, String> createQueryMap4GlobeDeploy() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("libId", String.valueOf(this.libId));
        queryMap.put("libType", this.libType);
        return queryMap;
    }

    public void uploadLibFile() {
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        HttpServletRequest request = this.fetchRequest();
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        SysOptLog sysLog = new SysOptLog();
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        sysLog.setOperation("atic.bis.libraryFile.import");
        sysLog.setModule("lego.dic.module.AticBis");
        sysLog.setDate(new Date());
        sysLog.setTerminalIp(currentUser.getIpAdr());
        sysLog.setOperator(currentUser.getUserName());
        sysLog.setResult(0);
        try {
            if (this.saveLibFileToDb().booleanValue()) {
                if (!this.saveFileToDisk(this.libFile)) {
                    sysLog.setDetail("com.hs.vsm.import.result.failed1");
                    sysOptLog.writeOptLog(sysLog);
                    throw new LegoCheckedException(570507L);
                }
            } else {
                sysLog.setDetail("com.hs.vsm.import.result.failed1");
                sysOptLog.writeOptLog(sysLog);
                throw new LegoCheckedException(570507L);
            }
            this.responseResult("success");
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            sysLog.setDetail("lego.err." + errorCode);
            sysOptLog.writeOptLog(sysLog);
            LOG.error((Object)("uploadLibFile:" + e.getErrorCode()));
            this.responseResult("lego.err." + e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            sysLog.setDetail("com.hs.vsm.import.result.failed1");
            sysOptLog.writeOptLog(sysLog);
            LOG.error((Object)"uploadLibFile unkonw error", (Throwable)e);
            this.responseResult("lego.err.570507");
        }
    }

    public boolean processParaBeforeSaveToDb() {
        boolean paraIsRight = false;
        int iLast = this.libName.lastIndexOf(".");
        String onlyFileName = this.libName.substring(0, iLast);
        if (!onlyFileName.matches("^[a-zA-Z]{1}\\w*$")) {
            return false;
        }
        if (this.libName.startsWith("AM_H") && this.libName.endsWith(".sdb")) {
            paraIsRight = true;
        } else if (this.libName.startsWith("location_sdb") && this.libName.endsWith(".zip")) {
            paraIsRight = true;
        } else if (this.libName.startsWith("REGION_H") && this.libName.endsWith(".zip")) {
            paraIsRight = true;
        } else if (this.libName.startsWith("IPS_H") && this.libName.endsWith(".zip")) {
            paraIsRight = true;
        } else if (this.libName.startsWith("IPRPU_H") && this.libName.endsWith(".zip")) {
            paraIsRight = true;
        } else if (this.libName.startsWith("CSG_H") && this.libName.endsWith(".mod")) {
            paraIsRight = true;
        }
        return paraIsRight;
    }

    private String getLibType(String libNameStr) {
        String libTypeStr = this.secDownLoadUtil.getLibType(libNameStr);
        if (AticUtil.isNull((String)libTypeStr)) {
            this.responseResult(this.getText("atic.bis.libraryFile.fileType.tip"));
        }
        return libTypeStr;
    }

    private Boolean saveLibFileToDb() throws UnsupportedEncodingException {
        return this.saveLibFile4DBAndFirstInstall(false, false);
    }

    private boolean saveLibFile4DBAndFirstInstall(boolean isFirstInstall, boolean isSync) throws UnsupportedEncodingException {
        try {
            String libTypeStr = this.getLibType(this.libName);
            String libNameStr = this.libName;
            int libSize = (int)(this.libFile.length() / (long)this.libFileSizeUnit + 1L);
            long importTime = System.currentTimeMillis() / 1000L;
            String importType = "Upload";
            if (isSync) {
                importType = "Update";
            } else {
                this.hashCode = SHA256Digester.getInstance().digest(libNameStr);
            }
            String deployStatus = "undeployed";
            if (!isFirstInstall) {
                String[] detailPara = new String[]{libNameStr, this.getLibFileType4Jsp(libTypeStr), libSize + "KB"};
                this.getOperateLog().normal("atic.bis.libraryFile.import", "lego.dic.module.AticBis", libNameStr, false, "atic.bis.libraryFile.import.importSummary", detailPara);
            }
            if (libSize > this.libFileSize * this.libFileSizeUnit) {
                throw new LegoCheckedException(571912L);
            }
            if (!AticUtil.checkFileType((File)this.libFile, (String)"504B0304") && !AticUtil.checkFileType((File)this.libFile, (String)"56353030")) {
                this.responseResult("atic.bis.libraryFile.fileType.tip");
                return false;
            }
            if (this.libraryFileService.isExists(libNameStr)) {
                throw new LegoCheckedException(571901L);
            }
            if (this.libraryFileService.getLibFileCount() >= this.allLibFileNum) {
                throw new LegoCheckedException(571903L);
            }
            LibraryFileForm libraryFileForm = new LibraryFileForm();
            libraryFileForm.setLibType(libTypeStr);
            libraryFileForm.setLibName(libNameStr);
            libraryFileForm.setLibSize(libSize);
            libraryFileForm.setImportTime(importTime);
            libraryFileForm.setImportType(importType);
            libraryFileForm.setDeployStatus(deployStatus);
            libraryFileForm.setDeployTime(0L);
            if (null == this.hashCode || "".equals(this.hashCode)) {
                this.hashCode = SHA256Digester.getInstance().digest(libNameStr);
            }
            libraryFileForm.setHashCode(this.hashCode);
            Long pkid = this.libraryFileService.saveLibraryFile(libraryFileForm);
            if (pkid > 0L) {
                return true;
            }
        }
        catch (LegoCheckedException e) {
            if (isFirstInstall) {
                LOG.error((Object)("saveLibFile4DBAndFirstInstall LegoCheckedException" + e.getErrorCode()));
            }
            throw e;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFileToDisk(File fileName) {
        this.getResponse().setContentType("text/html");
        String importPath = LibFilePathUtil.getLibFilePath();
        if (!ZoneBisUtil.createFile(importPath)) {
            throw new LegoCheckedException(570507L);
        }
        importPath = importPath + File.separator + this.libName;
        boolean saveFileSucess = false;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(fileName);
            fileOutput = new FileOutputStream(importPath);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream(fileOutput);
            byte[] buff = new byte[this.libFileSizeUnit * this.libFileSizeUnit];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
            saveFileSucess = true;
        }
        catch (IOException e) {
            LOG.error((Object)"saveFile error: ", (Throwable)e);
            saveFileSucess = false;
        }
        finally {
            if (null != fileInput) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"downloadFile", (Throwable)e);
                }
                fileInput = null;
            }
            if (null != fileOutput) {
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"downloadFile", (Throwable)e);
                }
                fileOutput = null;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"downloadFile", (Throwable)e);
                }
                bis = null;
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"downloadFile", (Throwable)e);
                }
                bos = null;
            }
        }
        return saveFileSucess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadLibFile() {
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        String fileName = "";
        String[] detailPara = new String[]{this.libName};
        if (null != this.libId && AticUtil.isNull((String)this.libId.toString())) {
            LOG.error((Object)"libId is null or isEmpty.");
            this.getOperateLog().normal("atic.bis.libraryFile.downLoad", "lego.dic.module.AticBis", this.libName, false, "atic.bis.libraryFile.downLoad.Summary.failed", detailPara);
            return;
        }
        try {
            this.getOperateLog().normal("atic.bis.libraryFile.downLoad", "lego.dic.module.AticBis", this.libName, false, "atic.bis.libraryFile.downLoad.Summary", detailPara);
            if (null == this.libId) {
                this.getOperateLog().normal("atic.bis.libraryFile.downLoad", "lego.dic.module.AticBis", this.libName, false, "atic.bis.libraryFile.downLoad.Summary.failed", detailPara);
                LOG.error((Object)("libId=" + this.libId + " is not exist."));
                throw new LegoCheckedException(571900L);
            }
            LibraryFileForm libFileForm = this.libraryFileService.findById(this.libId);
            if (null == libFileForm) {
                this.getOperateLog().normal("atic.bis.libraryFile.downLoad", "lego.dic.module.AticBis", this.libName, false, "atic.bis.libraryFile.downLoad.Summary.failed", detailPara);
                LOG.error((Object)("libId=" + this.libId + " is not exist."));
                AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
            } else {
                fileName = this.libName;
                if (!AticUtil.checkFileName((String)fileName, (String)"zip") && !AticUtil.checkFileName((String)fileName, (String)"mod")) {
                    this.fetchRequest().getSession().invalidate();
                    this.getOperateLog().normal("atic.bis.libraryFile.downLoad", "lego.dic.module.AticBis", this.libName, false, "atic.bis.libraryFile.downLoad.Summary.failed", detailPara);
                    return;
                }
                HttpServletResponse response = this.getResponse();
                response.setContentType("application/x-download");
                response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gb2312"), "ISO-8859-1"));
                input = new BufferedInputStream(new FileInputStream(LibFilePathUtil.getLibFilePath() + fileName));
                output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = input.read(b)) != -1) {
                    ((BufferedOutputStream)output).write(b, 0, len);
                }
                ((BufferedOutputStream)output).flush();
            }
        }
        catch (IOException e) {
            this.getOperateLog().normal("atic.bis.libraryFile.downLoad", "lego.dic.module.AticBis", this.libName, false, "atic.bis.libraryFile.downLoad.Summary.failed", detailPara);
            LOG.error((Object)"download report error", (Throwable)e);
            AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
        }
        catch (RuntimeException e) {
            this.getOperateLog().normal("atic.bis.libraryFile.downLoad", "lego.dic.module.AticBis", this.libName, false, "atic.bis.libraryFile.downLoad.Summary.failed", detailPara);
            LOG.error((Object)"download report error", (Throwable)e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    public boolean validateLibName() {
        return AticUtil.checkFileName((String)this.libName, (String)"zip") || AticUtil.checkFileName((String)this.libName, (String)"mod");
    }

    public List<LibraryFileForm> getLibFileList() {
        return this.libFileList;
    }

    public void setLibFileList(List<LibraryFileForm> libFileList) {
        this.libFileList = libFileList;
    }

    public Long[] getLibIdList() {
        if (null != this.libIdList) {
            return (Long[])this.libIdList.clone();
        }
        return new Long[0];
    }

    public void setLibIdList(Long[] libIdList) {
        this.libIdList = null != libIdList ? (Long[])libIdList.clone() : null;
    }

    public String[] getLibNameList() {
        if (null != this.libNameList) {
            return (String[])this.libNameList.clone();
        }
        return new String[0];
    }

    public void setLibNameList(String[] libNameList) {
        this.libNameList = null != libNameList ? (String[])libNameList.clone() : null;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public File getLibFile() {
        return this.libFile;
    }

    public void setLibFile(File libFile) {
        this.libFile = libFile;
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public Long getLibId() {
        return this.libId;
    }

    public void setLibId(Long libId) {
        this.libId = libId;
    }

    public String getLibType() {
        return this.libType;
    }

    public void setLibType(String libType) {
        this.libType = libType;
    }

    public List<GlobeDeployStatusForm> getObjDeployList() {
        return this.objDeployList;
    }

    public void setObjDeployList(List<GlobeDeployStatusForm> objDeployList) {
        this.objDeployList = objDeployList;
    }

    public boolean isNeedClearInterval() {
        return this.needClearInterval;
    }

    public void setNeedClearInterval(boolean needClearInterval) {
        this.needClearInterval = needClearInterval;
    }

    public List<LibFileSync> getSyncLibFileList() {
        return this.syncLibFileList;
    }

    public void setSyncLibFileList(List<LibFileSync> syncLibFileList) {
        this.syncLibFileList = syncLibFileList;
    }

    public String getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    public static Map<String, String> getDeployOrUndeploy() {
        return deployOrUndeploy;
    }

    public static void setDeployOrUndeploy(Map<String, String> deployOrUndeploy) {
        LibraryFileAction.deployOrUndeploy = deployOrUndeploy;
    }

    public static List<LibFileSync> getSyncLibFileListStatic() {
        return syncLibFileListStatic;
    }

    public static void setSyncLibFileListStatic(List<LibFileSync> syncLibFileListStatic) {
        LibraryFileAction.syncLibFileListStatic = syncLibFileListStatic;
    }

    public ILibraryFileService getLibraryFileService() {
        return this.libraryFileService;
    }

    public void setLibraryFileService(ILibraryFileService libraryFileService) {
        this.libraryFileService = libraryFileService;
    }

    public IGlobeDeployStatusService getGlobeDeployStatusService() {
        return this.globeDeployStatusService;
    }

    public void setGlobeDeployStatusService(IGlobeDeployStatusService globeDeployStatusService) {
        this.globeDeployStatusService = globeDeployStatusService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

