/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.model.GlobeDeployStatus;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.form.LocationIpForm;
import com.hs.atic.sdk.bis.service.IGlobeDeployStatusService;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.sdk.bis.service.ILocationIpService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class LocationCustomAction
extends BaseAction {
    private static Boolean isBatchdeployorundeploy = false;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final long serialVersionUID = 1L;
    private int allLocCusNum = 64;
    private String ipSplitRange = "-";
    private String ipSplitMask = "/";
    private String nextLine = "\n";
    private int allIpNumFiveHundred = 500;
    private int oneLocIpNum = 50;
    private int maskLess = 1;
    private int maskMore = 32;
    private String sortType = "DESC";
    private String sortField = "pkId";
    private Long[] locIdList;
    private String[] locNameList;
    private String locationName;
    private String description;
    private String ipString;
    private long locationId;
    private transient ILocationCustomService locationCustomService;
    private transient ILocationIpService locationIpService;
    private transient ILibraryFileService libraryFileService;
    private transient IGlobeDeployStatusService globeDeployStatusService;
    private transient IAticDeviceService aticDeviceService;
    private List<LocationCustomForm> locCustomList = new ArrayList<LocationCustomForm>();
    private String helpLanguage = "";

    public String getHelpLanguage() {
        return this.helpLanguage;
    }

    public void setHelpLanguage(String helpLanguage) {
        this.helpLanguage = helpLanguage;
    }

    public String listLocationCustom() {
        Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
        if ("zh".equalsIgnoreCase(locale.getLanguage())) {
            this.setHelpLanguage("zh_cn");
        } else {
            this.setHelpLanguage("en");
        }
        List allDdosFirewall = this.aticDeviceService.getAntiDDoSDevice();
        Paging page = this.locationCustomService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.locCustomList = page.getData();
        for (LocationCustomForm locationCustomForm : this.locCustomList) {
            String update;
            Long pkId = locationCustomForm.getPkId();
            List<GlobeDeployStatus> deployStatusList = this.globeDeployStatusService.findById(pkId);
            if (deployStatusList.isEmpty()) {
                Long pkID = locationCustomForm.getPkId();
                String update2 = "undeployed";
                this.libraryFileService.setLibFileToDepolying(update2, pkID, "");
                continue;
            }
            int numb = 0;
            for (GlobeDeployStatus globeDeployStatus : deployStatusList) {
                if (!globeDeployStatus.getDeployStatus().equalsIgnoreCase("success")) continue;
                ++numb;
            }
            Long libId = pkId;
            String libType = locationCustomForm.getLocationType();
            if (numb > 0 && numb == allDdosFirewall.size()) {
                update = "success";
                this.libraryFileService.setLibFileToDepolying(update, libId, libType);
                continue;
            }
            if (numb > 0 && numb < allDdosFirewall.size()) {
                update = "part_suc";
                this.libraryFileService.setLibFileToDepolying(update, libId, libType);
                continue;
            }
            if (numb != 0) continue;
            update = "failure";
            this.libraryFileService.setLibFileToDepolying(update, libId, libType);
        }
        this.processData4Jsp();
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        LOG.info((Object)("query location Custom list, size = " + this.locCustomList.size()));
        return "list";
    }

    public void delLocationCustom() {
        this.getOperateLog().warning("atic.bis.locationCustom.delete.locationCustom", "lego.dic.module.AticBis");
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.locIdList.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.locIdList[i].longValue());
            bo.setTargetName(this.locNameList[i]);
            batchOpList.add(bo);
        }
        this.batchOperationResult = this.locationCustomService.batchDelLocationCustom(batchOpList);
        LOG.info((Object)("delete delLocationCustom : " + AticUtil.appendOperNameFromBatchOper((BatchOperationResult)this.batchOperationResult)));
        this.bathResult(this.batchOperationResult);
    }

    public boolean processBeforeDel() {
        if (null == this.locIdList || null == this.locNameList) {
            LOG.error((Object)"locIdList or locNameList is null");
            return false;
        }
        try {
            Object[] objectArray = this.locIdList;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                long id = objectArray[i];
                if (id >= 0L) continue;
                return false;
            }
            for (String name : this.locNameList) {
                if (AticUtil.validateSpecialStr((String)name) && name.length() <= 63 && name.length() != 0) continue;
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean checkLocId() {
        try {
            Long[] longArray = this.locIdList;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                if (id >= 0L) continue;
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public String showAddLocationCustom() {
        LOG.info((Object)"prepare to showAddLocationCustom");
        this.checkLocCusNum();
        return "add";
    }

    public void addLocationCustom() {
        String[] detailPara;
        this.processBeforeAdd();
        this.checkLocNameExist();
        String[] ipList = this.checkIpNumMore50();
        this.checkAllIpNumMore500(ipList.length);
        if (this.locationId > 0L) {
            detailPara = new String[]{this.locationName, this.ipString.replaceAll(this.nextLine, ";")};
            this.getOperateLog().normal("atic.bis.locationCustom.eidtLocCus", "lego.dic.module.AticBis", this.locationName, false, "atic.bis.locationCustom.editLocCus.summary", detailPara);
        } else {
            detailPara = new String[]{this.locationName, this.ipString.replaceAll(this.nextLine, ";")};
            this.getOperateLog().normal("atic.bis.locationCustom.addLocCus", "lego.dic.module.AticBis", this.locationName, false, "atic.bis.locationCustom.addLocCus.summary", detailPara);
        }
        try {
            this.saveLocationCustomToDB(ipList);
            this.responseResult("success");
        }
        catch (LegoCheckedException e) {
            String errorInfo = this.getText("lego.err." + e.getErrorCode());
            Object[] para = e.getParameters();
            if (null != para && para.length > 0) {
                errorInfo = MessageFormat.format(errorInfo, para);
            }
            this.responseResult(errorInfo);
            throw e;
        }
        catch (Exception e) {
            this.responseResult(this.getText("lego.err.570507"));
        }
    }

    private void checkLocCusNum() {
        int locCusNum = this.locationCustomService.getLocCustomCount();
        if (locCusNum >= this.allLocCusNum) {
            LOG.error((Object)("ALL_LOC_CUS\uff3fNUM: " + locCusNum + "  more than " + this.allLocCusNum));
            throw new LegoCheckedException(571911L);
        }
    }

    private void checkLocNameExist() {
        boolean isExist = this.locationCustomService.isExists(this.locationName);
        if (isExist) {
            if (this.locationId > 0L) {
                LocationCustomForm form = this.locationCustomService.findById(this.locationId);
                if (null == form) {
                    this.getOperateLog().normal("atic.bis.locationCustom.addLocCus", "lego.dic.module.AticBis", this.locationName, false, "lego.err.571905", null);
                    throw new LegoCheckedException(571905L);
                }
                if (!form.getLocationName().equals(this.locationName)) {
                    LOG.error((Object)"locationName exist.");
                    this.getOperateLog().normal("atic.bis.locationCustom.addLocCus", "lego.dic.module.AticBis", this.locationName, false, "lego.err.571905", null);
                    throw new LegoCheckedException(571908L);
                }
            } else {
                LOG.error((Object)"locationName exist.");
                this.getOperateLog().normal("atic.bis.locationCustom.addLocCus", "lego.dic.module.AticBis", this.locationName, false, "lego.err.571905", null);
                throw new LegoCheckedException(571908L);
            }
        }
    }

    private void checkAllIpNumMore500(int length) {
        List<LocationIpForm> ipList;
        int allIpNum = this.locationIpService.getAllLocationIp().size();
        if (this.locationId > 0L && null != (ipList = this.locationIpService.getLocationIpByLocId(this.locationId))) {
            allIpNum -= ipList.size();
        }
        if (allIpNum >= this.allIpNumFiveHundred) {
            LOG.error((Object)"checkAllIpNumMore500 more 500.");
            String[] params = new String[]{"0"};
            throw new LegoCheckedException(571910L, params);
        }
        if (allIpNum + length > this.allIpNumFiveHundred) {
            LOG.error((Object)"checkAllIpNumMore500 more 500.");
            int canInputNum = this.allIpNumFiveHundred - allIpNum;
            String[] params = new String[]{String.valueOf(canInputNum)};
            throw new LegoCheckedException(571910L, params);
        }
        LOG.info((Object)"checkAllIpNumMore500 less 500.");
    }

    private Map<String, String> createConditionMap() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        String operator = currentUser.getUserName();
        String terminalIp = this.fetchRequest().getRemoteAddr();
        HashMap<String, String> condtionMap = new HashMap<String, String>();
        condtionMap.put("objectId", String.valueOf(this.locationId));
        condtionMap.put("objectType", "Location_Custom");
        condtionMap.put("operator", String.valueOf(operator));
        condtionMap.put("terminalIp", String.valueOf(terminalIp));
        return condtionMap;
    }

    private void saveLocationCustomToDB(String[] ipList) {
        LocationCustomForm locationCustomForm = new LocationCustomForm();
        List<LocationIpForm> locationIpFormList = this.getLocationIpList(ipList);
        if (this.locationId > 0L) {
            locationCustomForm.setPkId(this.locationId);
            this.unDeployLocation();
        }
        locationCustomForm.setLocationName(this.locationName);
        locationCustomForm.setDescription(this.description);
        locationCustomForm.setLocationIpList(locationIpFormList);
        locationCustomForm.setDeployStatus("undeployed");
        long pkId = this.locationCustomService.saveLocationCustom(locationCustomForm);
        if (pkId <= 0L) {
            LOG.error((Object)"saveLocationCustom failure.");
            throw new LegoCheckedException(570507L);
        }
        LOG.info((Object)"saveLocationCustom success.");
    }

    private void unDeployLocation() {
        ArrayList<Long> firewallIds;
        LocationCustomForm locCus = this.locationCustomService.findById(this.locationId);
        if (null != locCus) {
            firewallIds = new ArrayList<Long>();
            for (AticDevice firewall : this.aticDeviceService.getAntiDDoSDevice()) {
                firewallIds.add(firewall.getMoId());
            }
        } else {
            LOG.error((Object)("locationCustomId=" + this.locationId + ",name = " + this.getcleanedMessage(this.locationName) + " is not exist."));
            throw new LegoCheckedException(571905L);
        }
        this.libraryFileService.unDeployLibFileOnDevice(this.createConditionMap(), firewallIds);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<LocationIpForm> getLocationIpList(String[] ipList) {
        ArrayList<LocationIpForm> locationIpFormList = new ArrayList<LocationIpForm>();
        for (int i = ipList.length - 1; i >= 0; --i) {
            String ipStr = ipList[i].trim();
            if ("".equals(ipStr)) continue;
            boolean ipFormatIsRight = true;
            LocationIpForm locationIpForm = new LocationIpForm();
            if (ipStr.contains(this.ipSplitRange)) {
                locationIpForm.setIpString(ipStr);
                String startIp = IPUtil4Atic.convert2CompleteIp((String)ipStr.split(this.ipSplitRange)[0]);
                String endIp = IPUtil4Atic.convert2CompleteIp((String)ipStr.split(this.ipSplitRange)[1]);
                String[] startAndEnd = new String[]{startIp, endIp};
                if (AticUtil.isNull((String)startIp) || AticUtil.isNull((String)endIp) || !IPUtil4Atic.checkStartEndIpArray((String[])startAndEnd)) {
                    ipFormatIsRight = false;
                }
                locationIpForm.setStartIp(startIp);
                locationIpForm.setEndIp(endIp);
                locationIpFormList.add(locationIpForm);
            } else if (ipStr.contains(this.ipSplitMask)) {
                locationIpForm.setIpString(ipStr);
                String ipAddress = ipStr.split(this.ipSplitMask)[0];
                String maskInput = ipStr.split(this.ipSplitMask)[1];
                int maskInteger = 0;
                if (AticUtil.isNum((String)maskInput).booleanValue()) {
                    maskInteger = Integer.parseInt(maskInput);
                }
                if (IPUtil.isIpv4((String)ipAddress) && (maskInteger > this.maskMore || maskInteger < this.maskLess)) {
                    LOG.error((Object)("ip format wrong, srcIpStr: " + ipStr));
                    String[] params = new String[]{ipStr};
                    throw new LegoCheckedException(571914L, params);
                }
                String maskStr = AticUtil.getMask((Integer)maskInteger);
                String startIp = IPUtil4Atic.convert2CompleteIp((String)AticUtil.getMaskStartIp((String)ipAddress, (String)maskStr));
                String endIp = IPUtil4Atic.convert2CompleteIp((String)AticUtil.getMaskEndIp((String)ipAddress, (String)maskStr));
                if (AticUtil.isNull((String)startIp) || AticUtil.isNull((String)endIp)) {
                    ipFormatIsRight = false;
                }
                locationIpForm.setStartIp(startIp);
                locationIpForm.setEndIp(endIp);
                locationIpFormList.add(locationIpForm);
            } else {
                ipFormatIsRight = false;
            }
            if (ipFormatIsRight) continue;
            LOG.error((Object)("ip format wrong, srcIpStr: " + ipStr));
            String[] params = new String[]{ipStr};
            throw new LegoCheckedException(571913L, params);
        }
        for (LocationIpForm form : locationIpFormList) {
            int index = locationIpFormList.indexOf(form);
            String[] srcIpRange = new String[]{form.getStartIp(), form.getEndIp()};
            for (int j = index + 1; j < locationIpFormList.size(); ++j) {
                String endIp;
                String startIp = ((LocationIpForm)locationIpFormList.get(j)).getStartIp();
                String[] ipRange = new String[]{startIp, endIp = ((LocationIpForm)locationIpFormList.get(j)).getEndIp()};
                boolean isCross = IPUtil4Atic.isCrossIpRange((String[])ipRange, (String[])srcIpRange);
                if (!isCross) continue;
                LOG.error((Object)("ipRange conflict,srcIpStr: " + form.getIpString() + ", srcIpRange:" + form.getIpString() + "," + startIp + "---" + endIp));
                String[] params = new String[]{form.getIpString()};
                throw new LegoCheckedException(571909L, params);
            }
            List<LocationIpForm> formList = this.locationIpService.getAllLocationIp();
            if (this.locationId > 0L) {
                List<LocationIpForm> thisLocIpList = this.locationIpService.getLocationIpByLocId(this.locationId);
                formList.removeAll(thisLocIpList);
            }
            for (LocationIpForm locationIpForm : formList) {
                String endIp;
                String startIp = locationIpForm.getStartIp();
                String[] ipRange = new String[]{startIp, endIp = locationIpForm.getEndIp()};
                boolean isCross = IPUtil4Atic.isCrossIpRange((String[])ipRange, (String[])srcIpRange);
                if (!isCross) continue;
                LOG.error((Object)("ipRange conflict,srcIpStr: " + form.getIpString() + ", srcIpRange:" + form.getIpString() + "," + startIp + "---" + endIp));
                String[] params = new String[]{form.getIpString()};
                throw new LegoCheckedException(571909L, params);
            }
        }
        return locationIpFormList;
    }

    public String viewLocationCustom() {
        LocationCustomForm locationCustomForm = this.locationCustomService.findById(this.locationId);
        if (null == locationCustomForm) {
            throw new LegoCheckedException(571905L);
        }
        this.locationName = locationCustomForm.getLocationName();
        this.description = locationCustomForm.getDescription();
        List<LocationIpForm> ipList = this.locationIpService.getLocationIpByLocId(this.locationId);
        this.ipString = "";
        for (LocationIpForm form : ipList) {
            this.ipString = this.ipString + form.getIpString() + this.nextLine;
        }
        return "list";
    }

    public String showEditLocationCustom() {
        this.viewLocationCustom();
        return "list";
    }

    private String[] checkIpNumMore50() {
        String[] ipList = this.ipString.split(this.nextLine);
        if (ipList.length > this.oneLocIpNum) {
            LOG.error((Object)"locationCustom num more than 50.");
            throw new LegoCheckedException(571907L);
        }
        return ipList;
    }

    public boolean validateLocationName() {
        if (AticUtil.isNull((String)this.locationName)) {
            return false;
        }
        String locationNameTemp = this.locationName.trim();
        if ("otherlocation".equalsIgnoreCase(locationNameTemp) || "other".equalsIgnoreCase(locationNameTemp)) {
            return false;
        }
        if (locationNameTemp.length() > 63) {
            return false;
        }
        if (locationNameTemp.equalsIgnoreCase("null")) {
            return false;
        }
        String locationNameRegex = "^(?!null$)[a-zA-Z]{1}\\w*$";
        return locationNameTemp.matches(locationNameRegex);
    }

    private void processBeforeAdd() {
        String[] ipList = this.ipString.trim().split(this.nextLine);
        for (int i = 0; i < ipList.length; ++i) {
            String[] ipAddress = null;
            String ip = ipList[i].trim();
            if (ip.contains(this.ipSplitRange)) {
                ipAddress = ip.split(this.ipSplitRange);
                if (IPUtil.isIpv4((String)ipAddress[0]) && !IPUtil.isIpv4((String)ipAddress[1])) {
                    LOG.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if ("0.0.0.0".equals(ipAddress[0]) && "0.0.0.0".equals(ipAddress[1])) {
                    LOG.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if (IPUtil.isIpv4((String)ipAddress[0])) continue;
                LOG.error((Object)("ip format wrong, srcIpStr: " + ip));
                String[] params = new String[]{ip};
                throw new LegoCheckedException(571913L, params);
            }
            if (ip.contains(this.ipSplitMask)) {
                ipAddress = ip.split(this.ipSplitMask);
                if (IPUtil.isIpv4((String)ipAddress[0]) && !LocationCustomAction.isIpv4Mask(ipAddress[1])) {
                    LOG.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if ("0.0.0.0".equals(ipAddress[0])) {
                    LOG.error((Object)("ip format wrong, srcIpStr: " + ip));
                    String[] params = new String[]{ip};
                    throw new LegoCheckedException(571913L, params);
                }
                if (IPUtil.isIpv4((String)ipAddress[0])) continue;
                LOG.error((Object)("ip format wrong, srcIpStr: " + ip));
                String[] params = new String[]{ip};
                throw new LegoCheckedException(571913L, params);
            }
            LOG.error((Object)("ip format wrong, srcIpStr: " + ip));
            String[] params = new String[]{ip};
            throw new LegoCheckedException(571913L, params);
        }
    }

    public static boolean isIpv4Mask(String maskIpv4) {
        String regex = "^1[0-9]|2[0-9]|3[0-2]|[8-9]$";
        return !LocationCustomAction.isNull(maskIpv4) && maskIpv4.matches(regex);
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    private void processData4Jsp() {
        Paging page = this.locationCustomService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.locCustomList = page.getData();
        for (LocationCustomForm locationCustomForm : this.locCustomList) {
            this.setLocCustomDeployTime(locationCustomForm);
            this.setLocCustomDeployStatus(locationCustomForm);
        }
    }

    private void setLocCustomDeployStatus(LocationCustomForm locationCustomForm) {
        String deployStatusJsp = ZoneBisUtil.getDeployStatus4Jsp(locationCustomForm.getDeployStatus(), false);
        locationCustomForm.setDeployStatus4Jsp(deployStatusJsp);
    }

    private void setLocCustomDeployTime(LocationCustomForm locationCustomForm) {
        if (null == locationCustomForm.getDeployTime() || locationCustomForm.getDeployTime() <= 0L) {
            locationCustomForm.setDeployTime4Jsp("");
        } else {
            locationCustomForm.setDeployTime4Jsp(AticUtil.convertTimeLong((Long)locationCustomForm.getDeployTime()));
        }
    }

    private Map<String, String> createQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("sortName", this.sortField);
        queryMap.put("sortType", this.sortType);
        return queryMap;
    }

    public void batchDoDeploy() {
        LOG.info((Object)"start batchDoDeploy");
        HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("application/xml;charset=UTF-8");
        if (isBatchdeployorundeploy.booleanValue()) {
            LOG.info((Object)"isBatchDeployOrUnDeploy is true: batchDoDeploy");
            try {
                response.getWriter().write("isBatchDeployOrUnDeploy");
            }
            catch (Exception e) {
                LOG.error((Object)"batchDoDeploy  response.getWriter().write error", (Throwable)e);
            }
            return;
        }
        LocationCustomAction.setIsBatchdeployorundeploy(true);
        ArrayList<Long> firewallIds = new ArrayList<Long>();
        for (AticDevice firewall : this.aticDeviceService.getAntiDDoSDevice()) {
            firewallIds.add(firewall.getMoId());
        }
        for (int i = 0; i < this.locIdList.length; ++i) {
            long locId = 0L;
            boolean setDeployingStatus = true;
            try {
                locId = this.locIdList[i];
                setDeployingStatus = this.libraryFileService.setLibFileToDepolying(null, locId, "Location_Custom");
                if (setDeployingStatus) {
                    LocationCustomForm locCus = this.locationCustomService.findById(locId);
                    if (null == locCus) continue;
                    this.libraryFileService.deployLibFileOnDevice(this.createLocConditionMap(locId), firewallIds);
                    continue;
                }
                LOG.error((Object)"setLibFileToDepolying error");
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("unkown error,locId =" + locId + e));
            }
        }
        LocationCustomAction.setIsBatchdeployorundeploy(false);
        LOG.info((Object)"end batchDoDeploy");
    }

    private Map<String, String> createLocConditionMap(long locId) {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        String operator = currentUser.getUserName();
        String terminalIp = this.fetchRequest().getRemoteAddr();
        HashMap<String, String> condtionMap = new HashMap<String, String>();
        condtionMap.put("objectId", String.valueOf(locId));
        condtionMap.put("objectType", String.valueOf("Location_Custom"));
        condtionMap.put("operator", String.valueOf(operator));
        condtionMap.put("terminalIp", String.valueOf(terminalIp));
        condtionMap.put("httpSessionId", this.getSession().getId() + "_" + locId);
        return condtionMap;
    }

    public void batchDoUnDeploy() {
        LOG.info((Object)"start batchDoUnDeploy");
        HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("application/xml;charset=UTF-8");
        if (isBatchdeployorundeploy.booleanValue()) {
            LOG.info((Object)"isBatchDeployOrUnDeploy is true: batchDoUnDeploy");
            try {
                response.getWriter().write("isBatchDeployOrUnDeploy");
            }
            catch (IOException e) {
                LOG.error((Object)"batchDoUnDeploy  response.getWriter().write error", (Throwable)e);
            }
            return;
        }
        LocationCustomAction.setIsBatchdeployorundeploy(true);
        ArrayList<Long> firewallIds = new ArrayList<Long>();
        for (AticDevice firewall : this.aticDeviceService.getAntiDDoSDevice()) {
            firewallIds.add(firewall.getMoId());
        }
        for (int i = 0; i < this.locIdList.length; ++i) {
            long locId = 0L;
            try {
                locId = this.locIdList[i];
                LocationCustomForm locCus = this.locationCustomService.findById(locId);
                if (null == locCus) continue;
                this.libraryFileService.unDeployLibFileOnDevice(this.createLocConditionMap(locId), firewallIds);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("unkown error,locId =" + locId + e));
            }
        }
        LocationCustomAction.setIsBatchdeployorundeploy(false);
        LOG.info((Object)"end batchDoUnDeploy");
    }

    public static Boolean getIsBatchdeployorundeploy() {
        return isBatchdeployorundeploy;
    }

    public static void setIsBatchdeployorundeploy(Boolean isBatchdeployorundeploy) {
        LocationCustomAction.isBatchdeployorundeploy = isBatchdeployorundeploy;
    }

    public boolean checkParams() {
        if (this.locationId < 0L) {
            return false;
        }
        if (null == this.ipString || this.ipString.trim().length() == 0) {
            return false;
        }
        String ipStringRegex = "^[0-9|\\-|\\/|\\.|\\n|\\r]*$";
        return this.ipString.trim().length() <= 5000 && this.ipString.matches(ipStringRegex);
    }

    public List<LocationCustomForm> getLocCustomList() {
        return this.locCustomList;
    }

    public void setLocCustomList(List<LocationCustomForm> locCustomList) {
        this.locCustomList = locCustomList;
    }

    public Long[] getLocIdList() {
        if (null != this.locIdList) {
            return (Long[])this.locIdList.clone();
        }
        return new Long[0];
    }

    public void setLocIdList(Long[] locIdList) {
        this.locIdList = null != locIdList ? (Long[])locIdList.clone() : null;
    }

    public String[] getLocNameList() {
        if (null != this.locNameList) {
            return (String[])this.locNameList.clone();
        }
        return new String[0];
    }

    public void setLocNameList(String[] locNameList) {
        this.locNameList = null != locNameList ? (String[])locNameList.clone() : null;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIpString() {
        return this.ipString;
    }

    public void setIpString(String ipString) {
        this.ipString = ipString;
    }

    public long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(long locationId) {
        this.locationId = locationId;
    }

    public boolean validateBatchLocNameList() {
        if (null == this.locNameList) {
            return false;
        }
        try {
            String locationNameRegex = "^(?!(?i)null$)[a-zA-Z]{1}\\w*$";
            for (String locName : this.locNameList) {
                if (locName.matches(locationNameRegex)) continue;
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateBatchLocIdList() {
        if (null == this.locIdList) {
            return false;
        }
        try {
            Long[] longArray = this.locIdList;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                if (id >= 0L) continue;
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public ILocationCustomService getLocationCustomService() {
        return this.locationCustomService;
    }

    public void setLocationCustomService(ILocationCustomService locationCustomService) {
        this.locationCustomService = locationCustomService;
    }

    public ILocationIpService getLocationIpService() {
        return this.locationIpService;
    }

    public void setLocationIpService(ILocationIpService locationIpService) {
        this.locationIpService = locationIpService;
    }

    public ILibraryFileService getLibraryFileService() {
        return this.libraryFileService;
    }

    public void setLibraryFileService(ILibraryFileService libraryFileService) {
        this.libraryFileService = libraryFileService;
    }

    public IGlobeDeployStatusService getGlobeDeployStatusService() {
        return this.globeDeployStatusService;
    }

    public void setGlobeDeployStatusService(IGlobeDeployStatusService globeDeployStatusService) {
        this.globeDeployStatusService = globeDeployStatusService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

