/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.bis.model.LibraryFile;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class LibraryFileDao
extends CommonDaoImpl {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from LibraryFile where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String libName = conditionMap.get("libName");
        String libType = conditionMap.get("libType");
        String importType = conditionMap.get("importType");
        if (!AticUtil.isNull((String)libName)) {
            hql = hql + " and libName = ? ";
            queryMap.put(index++, libName.trim());
        }
        if (!AticUtil.isNull((String)libType)) {
            hql = hql + " and libType = ? ";
            queryMap.put(index++, libType);
        }
        if (!AticUtil.isNull((String)importType)) {
            hql = hql + " and importType = ? ";
            queryMap.put(index++, importType);
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public boolean isExists(String libName) {
        String hql = "from LibraryFile where lower(libName) = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, libName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public LibraryFile get(String libType) {
        String hql = "from LibraryFile where libType = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, libType);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (LibraryFile)result.get(0);
    }

    public void setOtherLibFileToUndeploy(Long libId, String libType) {
        String updateDeployStatusHQL = "UPDATE LibraryFile SET deployStatus= ? , deployTime = 0 WHERE pkId <> ? AND libType = ? ";
        Object[] paramObj = new Object[]{"undeployed", libId, libType};
        this.getHibernateTemplate().bulkUpdate(updateDeployStatusHQL, paramObj);
        this.logger.info((Object)("setOtherLibFileToUndeploy: " + updateDeployStatusHQL));
    }

    public void setLibFileToDepolying(Long libId) {
        String updateDeployStatusHQL = "UPDATE LibraryFile SET deployStatus= ? WHERE pkId= ? ";
        Object[] paramObj = new Object[]{"deploying", libId};
        this.getHibernateTemplate().bulkUpdate(updateDeployStatusHQL, paramObj);
        this.logger.info((Object)("setLibFileToDepolying: " + updateDeployStatusHQL));
    }

    public LibraryFile getDeployedIpLocationFile() {
        String hql = "from LibraryFile where libType = ? and (deployStatus = ? or deployStatus = ? )";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, "Lib_Location");
        param.put(1, "success");
        param.put(2, "part_suc");
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (LibraryFile)result.get(0);
    }

    public LibraryFile getMaxVerLibFile(String libFileType) {
        String hql = "from LibraryFile where libType = ? and importType = ? order by importTime DESC";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, libFileType);
        param.put(1, "Update");
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (LibraryFile)result.get(0);
    }

    public List<LibraryFile> getAll() {
        List<LibraryFile> libFileList = new ArrayList<LibraryFile>();
        String selectLocCusDeployStatusHQL = "from LibraryFile";
        List result = this.findByHql(selectLocCusDeployStatusHQL);
        if (result != null) {
            libFileList = result;
        }
        return libFileList;
    }

    public LibraryFile get(Long objectId) {
        String hql = "from LibraryFile where pkId = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, objectId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (LibraryFile)result.get(0);
    }

    public void remove(Long id) {
        String hql = "delete from LibraryFile where pkId = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }
}

