/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.query.NativeQuery;

public class LocationCustomDao
extends CommonDaoImpl {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public List<LocationCustom> queryByDeployStatus(String deployStatus) {
        String selectDeployStatusHQL = "from LocationCustom where deployStatus='undeployed'";
        List result = this.findByHql(selectDeployStatusHQL);
        return result;
    }

    public void setLocCustomToDepolying(Long libId) {
        String updateDeployStatusHQL = "UPDATE LocationCustom SET deployStatus = ? WHERE pkId = ? ";
        Object[] paramObj = new Object[]{"deploying", libId};
        this.getHibernateTemplate().bulkUpdate(updateDeployStatusHQL, paramObj);
        this.logger.info((Object)("setLocationCustomToDepolying: " + updateDeployStatusHQL));
    }

    public void updateLocationCustom(LocationCustom locationCustom) {
        super.getHibernateTemplate().saveOrUpdate((Object)locationCustom);
    }

    public void updateLocCustomToDepolying(String status, Long libId) {
        String updateDeployStatusHQL = "UPDATE LocationCustom SET deployStatus = ? WHERE pkId = ? ";
        Object[] paramObj = new Object[]{status, libId};
        this.getHibernateTemplate().bulkUpdate(updateDeployStatusHQL, paramObj);
        this.logger.info((Object)("updateLocationCustomStatus: " + updateDeployStatusHQL));
    }

    public boolean isExists(String locationName) {
        String hql = "from LocationCustom where lower(locationName) = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, locationName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public LocationCustom findByName(String locationName) {
        Iterator iterator;
        String hql = "from LocationCustom where lower(locationName) = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, locationName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        if (null != result && !result.isEmpty() && (iterator = result.iterator()).hasNext()) {
            LocationCustom cus = (LocationCustom)iterator.next();
            return cus;
        }
        return null;
    }

    public List<LocationCustom> findAll() {
        String hql = "from LocationCustom where 1=1 ";
        List result = this.findByHql(hql);
        if (null != result && !result.isEmpty()) {
            return result;
        }
        return null;
    }

    public List<LocationCustom> getDeployedIpLocationCustom() {
        List<LocationCustom> locCusList = new ArrayList<LocationCustom>();
        String selectLocCusDeployStatusHQL = "from LocationCustom WHERE deployStatus = ? OR deployStatus = ? ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, "success");
        queryMap.put(1, "part_suc");
        List result = this.findByHql(selectLocCusDeployStatusHQL, queryMap);
        if (result != null) {
            locCusList = result;
        }
        return locCusList;
    }

    public void remove(Long id) {
        String hql = "delete from LocationCustom where pkId = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public List<LocationCustom> getAll() {
        List<LocationCustom> locCusList = new ArrayList<LocationCustom>();
        String selectLocCusDeployStatusHQL = "from LocationCustom";
        List result = this.findByHql(selectLocCusDeployStatusHQL);
        if (result != null) {
            locCusList = result;
        }
        return locCusList;
    }

    public LocationCustom get(Long objectId) {
        String hql = "from LocationCustom where pkId = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, objectId.toString());
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (LocationCustom)result.get(0);
    }

    public List<LocationCustom> getListByPkIds(Long[] objectIds) {
        StringBuffer sql = new StringBuffer("from LocationCustom where pkId in ( ");
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        int num = objectIds.length;
        for (int i = 0; i < num; ++i) {
            param.put(i, objectIds[i].toString());
            sql.append("?");
            if (i < 0 || i >= num - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        List result = this.findByHql(sql.toString(), param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<String> checkIsZoneOccupy(List<String> locationIds) {
        StringBuffer sql = new StringBuffer("select o.zone_name from t_atic_zone_info o where o.zone_id in (select z.zone_id from t_vsm_zone_iplocation z where z.location_id in (");
        int num = locationIds.size();
        for (int i = 0; i < num; ++i) {
            sql.append("?");
            if (i < 0 || i >= num - 1) continue;
            sql.append(",");
        }
        sql.append("))");
        try {
            NativeQuery query = this.currentSession().createNativeQuery(sql.toString());
            for (int i = 0; i < num; ++i) {
                query.setParameter(i + 1, (Object)locationIds.get(i));
            }
            return query.getResultList();
        }
        catch (Exception e) {
            this.logger.error((Object)"checkIsZoneOccupy failed", (Throwable)e);
            return null;
        }
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        Paging page = new Paging();
        HashMap queryMap = new HashMap();
        String hql = "from LocationCustom where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }
}

