/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.sdk.bis.model.ZoneBaseLineStudyInfo;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ZoneBaseLineStudyDao
extends BaseDao<ZoneBaseLineStudyInfo, Long> {
    public ZoneBaseLineStudyDao() {
        super(ZoneBaseLineStudyInfo.class);
    }

    public ZoneBaseLineStudyDao(Class<ZoneBaseLineStudyInfo> persistentClass) {
        super(persistentClass);
    }

    public void update(ZoneBaseLineStudyInfo object) {
        this.getHibernateTemplate().clear();
        this.getHibernateTemplate().update((Object)object);
    }

    public Serializable create(ZoneBaseLineStudyInfo object) {
        return this.getHibernateTemplate().save((Object)object);
    }

    public List<ZoneBaseLineStudyInfo> queryByHql(String hql) {
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    public List<ZoneBaseLineStudyInfo> queryByHqlAndParam(String hql, Object object) {
        return super.getHibernateTemplate().find(hql, new Object[]{object});
    }

    public List<ZoneBaseLineStudyInfo> queryPageByHql(String hql, int start, int pageSize) {
        return (List)new HibernateTemplate(this.getSessionFactory()).execute((HibernateCallback)new InnerClassQuery(hql, start, pageSize));
    }

    protected List<Object> conditionHql(Map<String, String> queryMap, StringBuffer hql) {
        ArrayList<Object> param = new ArrayList<Object>();
        String zoneId = queryMap.get("zoneId");
        if (null != zoneId && !"".equals(zoneId)) {
            hql.append(" where zoneId = ? ");
            param.add(Long.valueOf(zoneId));
        }
        return param;
    }

    public void deleteByZoneId(long zoneId) {
        new HibernateTemplate(this.getSessionFactory()).execute((HibernateCallback)new InnerClassDelete(zoneId));
    }

    public List<ZoneBaseLineStudyInfo> getBaseLineTaskByDevId(long devId) {
        String hql = "SELECT baseline FROM ZoneDeviceInfo info,ZoneBaseLineStudyInfo baseline where info.zoneId =baseline.zoneId and baseline.status = '1' and info.deviceId = ? ";
        return this.getHibernateTemplate().find(hql, new Object[]{devId});
    }

    public List<String> getCollectorIpByZoneId(long zoneId, long deviceId) {
        String hql = "SELECT c.ipAddress FROM ZoneDeviceInfo dev ,CollectorDevice cdev,Collector c where dev.deviceId = cdev.deviceId and cdev.collectorId = c.moId and dev.zoneId = ?  and dev.deviceId <> ? ";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId, deviceId});
    }

    public List<String> getCollectorIpNoSigByZoneId(long zoneId, long deviceId) {
        String hql = "SELECT c.ipAddress FROM ZoneDeviceInfo dev ,CollectorDevice cdev,Collector c where dev.deviceId = cdev.deviceId and EXISTS (SELECT moId FROM Firewall WHERE moId = dev.deviceId)  and cdev.collectorId = c.moId and dev.zoneId = ?  and dev.deviceId <> ? ";
        return this.getHibernateTemplate().find(hql, new Object[]{zoneId, deviceId});
    }

    public int getStartedBaselineZoneNum(String zoneIds) {
        String[] zoneIdList = zoneIds.split(",");
        ArrayList<Long> zoneIdArrayList = new ArrayList<Long>();
        StringBuffer hql = new StringBuffer();
        hql.append("select count(*) From ZoneBaseLineStudyInfo baseline where baseline.status='1' and baseline.zoneId in ( ");
        for (int i = 0; i < zoneIdList.length; ++i) {
            zoneIdArrayList.add(Long.valueOf(zoneIdList[i]));
            if (0 == i) {
                hql.append('?');
                continue;
            }
            hql.append(",? ");
        }
        hql.append(')');
        return this.getRowCountByHsql(hql.toString(), zoneIdArrayList.toArray());
    }

    public ZoneBaseLineStudyInfo querySingleTask(long studyId, long zoneId) {
        String hql = "from ZoneBaseLineStudyInfo where studyId = ? and zoneId = ? ";
        List list = this.getHibernateTemplate().find(hql, new Object[]{studyId, zoneId});
        if (null != list && !list.isEmpty()) {
            return (ZoneBaseLineStudyInfo)list.get(0);
        }
        return null;
    }

    public void deleteSingleTask(long studyId, long zoneId) {
        String hql = "delete from ZoneBaseLineStudyInfo where studyId = ? and zoneId = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{studyId, zoneId});
    }

    private static class InnerClassDelete
    implements HibernateCallback {
        private long zoneId;

        public InnerClassDelete(long zoneId) {
            this.zoneId = zoneId;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery("delete from ZoneBaseLineStudyInfo zblsi where zblsi.zoneId = :zoneId");
            q.setLong("zoneId", this.zoneId);
            return q.executeUpdate();
        }
    }

    private static class InnerClassQuery
    implements HibernateCallback {
        private String hql;
        private int start;
        private int pageSize;

        public InnerClassQuery(String hql, int start, int pageSize) {
            this.hql = hql;
            this.start = start;
            this.pageSize = pageSize;
        }

        public Object doInHibernate(Session session) {
            Query query = session.createQuery(this.hql);
            query.setFirstResult(this.start);
            if (this.pageSize != 0) {
                query.setMaxResults(this.pageSize);
            }
            return query.list();
        }
    }
}

