/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus;

import com.hs.atic.bis.lus.SecDownLoadUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Properties;

public class AutoSecDownloadThread
extends Thread {
    private static final int SLEEP_FOR_A_WHILE = 10;
    private final Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private String filePath = "autoSecDownload.conf";
    private int autoTime = 4;
    private boolean isAlive = true;
    private SecDownLoadUtil secDownLoadUtil;

    public AutoSecDownloadThread() {
        this.initConf();
    }

    @Override
    public void run() {
        this.log.info((Object)"Download secLibFile is running.");
        while (this.isAlive) {
            if (this.isTimeRun().booleanValue()) {
                try {
                    if (null == this.secDownLoadUtil) {
                        this.secDownLoadUtil = new SecDownLoadUtil();
                    }
                    this.log.info((Object)"download file start!");
                    this.secDownLoadUtil.downloadSecLibFile();
                    this.log.info((Object)"download file end!");
                }
                catch (Exception e) {
                    this.log.error((Object)"download file some errors happend", (Throwable)e);
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)("download file InterruptedException error: " + e));
            }
        }
        this.log.info((Object)"Download secLibFile stop!");
    }

    private Boolean isTimeRun() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int minute = cal.get(12);
        int scond = cal.get(13);
        if (hour == this.autoTime && 0 == minute && 10 > scond) {
            return true;
        }
        return false;
    }

    private void initConf() {
        Properties conf = this.openPropertyFile();
        this.autoTime = Integer.parseInt(conf.getProperty("downLoadTime"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties openPropertyFile() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.filePath);
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"autoSecDownload.conf FileNotFoundException.");
        }
        catch (IOException e) {
            this.log.error((Object)"execute AutoSecDownloadThread.openPropertyFile() failed, IOException");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"execute AutoSecDownloadThread.openPropertyFile() failed! ", (Throwable)e);
                }
            }
        }
        return properties;
    }

    public void setAlive(boolean isAliveBool) {
        this.log.info((Object)("AutoSecDownloadThread isAlive: " + isAliveBool));
        this.isAlive = isAliveBool;
    }
}

