/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus;

import com.hs.atic.bis.lus.ServerEsnBuilder;
import com.hs.atic.bis.lus.model.FeatureModel;
import com.hs.atic.bis.lus.model.FsmProductParam;
import com.hs.atic.bis.lus.model.FsmProxyParam;
import com.hs.atic.bis.lus.model.FsmServerParam;
import com.hs.atic.bis.lus.model.FsmUpdateParam;
import com.hs.atic.bis.lus.model.LatestVersionTag;
import com.hs.atic.bis.lus.model.UpdateModel;
import com.hs.atic.bis.lus.util.AppSumCbbLibrary;
import com.hs.atic.bis.lus.util.DownloadSignature;
import com.hs.atic.bis.lus.util.SHA256Digester;
import com.hs.atic.sdk.bis.form.LibraryFileForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LibFilePathUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.fds.util.PackUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class SecDownLoadUtil {
    private static final String ANTI_DDOS = "AntiDDoS";
    private static final String OFFLINE = "offline";
    private static String regist = "";
    private final Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private transient ILibraryFileService libraryFileService;
    private int allLibFileNum = 40;
    private int libFileSizeUnit = 1024;
    private int libFileSize = 50;
    private String libFilePath;
    private String ipsEngFileName;
    private String ipsLibFileName;
    private String ipsOfflineIniFileName;
    private String ipsOfflineFileName;

    public String getIpsOfflineFileName() {
        return this.ipsOfflineFileName;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getRegist() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        String esn = this.getEsn4LibFileUpdate();
        regist = AticUtil.isNull((String)esn) ? UUID.randomUUID().toString().replaceAll("-", "") : esn;
    }

    private String getEsn4LibFileUpdate() {
        StringBuffer esn = new StringBuffer();
        List<String> esnList = ServerEsnBuilder.getInstance().getServerEsns();
        if (null != esnList && !esnList.isEmpty()) {
            for (String tempEsn : esnList) {
                esn.append(tempEsn);
            }
        }
        return esn.toString();
    }

    public void downloadSecLibFile() {
        List<UpdateModel> updateInfoList = this.syncloadLibFile();
        List<UpdateModel> umList = this.getLibraryFileUpdateModelInfo();
        for (UpdateModel um : umList) {
            this.addLibFileToSyncList(updateInfoList, um);
        }
    }

    public List<UpdateModel> syncloadLibFile() {
        Map<String, List<UpdateModel>> updateInfoMap = this.getUpdateInfo();
        if (updateInfoMap.isEmpty()) {
            this.log.info((Object)"updateInfoMap is null or Empty");
            return null;
        }
        Set<Map.Entry<String, List<UpdateModel>>> restAuthSet = updateInfoMap.entrySet();
        ArrayList<UpdateModel> updateInfoList = new ArrayList<UpdateModel>();
        this.setLibraryFileService((ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class));
        int countLibraryFile = this.libraryFileService.getLibFileCount();
        block0: for (Map.Entry<String, List<UpdateModel>> updateListEntry : restAuthSet) {
            boolean isIps = updateListEntry.getKey().startsWith("IPS");
            List<UpdateModel> updateList = updateListEntry.getValue();
            if (null == updateList) {
                this.log.info((Object)("updateInfoList is null. updateListEntry.getKey() is :" + SecDownLoadUtil.getcleanedMessage(updateListEntry.getKey())));
            }
            Map<UpdateModel, Boolean> checkResult = this.checkDownload(updateList);
            for (Map.Entry<UpdateModel, Boolean> entry : checkResult.entrySet()) {
                String libFileName = "";
                if (null != entry.getKey()) {
                    libFileName = isIps ? this.ipsOfflineFileName : this.getLibFileNameFromUpdateInfo(entry.getKey());
                }
                if (this.libraryFileService.isExists(libFileName) || !entry.getValue().booleanValue()) {
                    entry.getKey().setMessageCode("420");
                    updateInfoList.add(entry.getKey());
                    continue;
                }
                if (++countLibraryFile > this.allLibFileNum) {
                    entry.getKey().setMessageCode("571903");
                    updateInfoList.add(entry.getKey());
                    continue;
                }
                if (entry.getValue().booleanValue()) {
                    boolean isDownload = false;
                    if (isIps) {
                        UpdateModel updateModel;
                        if (null == updateList) {
                            this.log.info((Object)"updateList is null.");
                            continue block0;
                        }
                        Iterator<UpdateModel> iterator = updateList.iterator();
                        while (iterator.hasNext() && (isDownload = this.download(updateModel = iterator.next()))) {
                        }
                        if (isDownload && (isDownload = this.creatOfflineIniFile(entry.getKey()))) {
                            isDownload = this.packSecIpsLib();
                        }
                        if (!isDownload) {
                            entry.getKey().setMessageCode("421");
                        }
                        this.deleteIpsFile();
                    } else {
                        isDownload = this.download(entry.getKey());
                    }
                    if (isDownload) {
                        entry.getKey().setDownLoad(true);
                    } else {
                        --countLibraryFile;
                    }
                }
                updateInfoList.add(entry.getKey());
            }
        }
        return updateInfoList;
    }

    public Map<String, List<UpdateModel>> getUpdateInfo() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        FsmServerParam.ByReference fsmServerParam = new FsmServerParam.ByReference();
        try {
            fsmServerParam.setSzRemoteAddr(this.libraryFileService.getSecDownHttpUrl());
        }
        catch (UnsupportedEncodingException e1) {
            this.log.error((Object)"RemoteAddr i18n is error", (Throwable)e1);
        }
        fsmServerParam.setUsRemotePort(Short.parseShort(this.libraryFileService.getSecDownHttpPort()));
        FsmProxyParam.ByReference fsmProxyParam = new FsmProxyParam.ByReference();
        FsmProductParam.ByReference fsmProductParam = new FsmProductParam.ByReference();
        HashMap<String, List<UpdateModel>> updateMap = new HashMap<String, List<UpdateModel>>();
        if (AticUtil.isNull((String)this.libFilePath)) {
            this.libFilePath = LibFilePathUtil.getLibFilePath();
        }
        List<UpdateModel> needUpdata = this.getLibraryFileUpdateModelInfo();
        for (UpdateModel updateModel : needUpdata) {
            ArrayList<UpdateModel> updateList = new ArrayList<UpdateModel>();
            String modeName = updateModel.getModeName();
            FsmUpdateParam.ByReference fsmUpdateParam = new FsmUpdateParam.ByReference();
            LatestVersionTag.ByReference latestVersionTag = new LatestVersionTag.ByReference();
            try {
                fsmUpdateParam.setSzLocalPath(this.libFilePath);
                fsmProductParam.setSzPrdName(updateModel.getProductName());
                fsmProductParam.setSzPrdVer(updateModel.getProductVersion());
                fsmProductParam.setSzDevEsn(updateModel.getEsn());
                fsmUpdateParam.setSzSdbCtrlItem(updateModel.getModeName());
            }
            catch (UnsupportedEncodingException e1) {
                this.log.error((Object)"SzLocalPath or SzPrdName or SzPrdVer or SzDevEsn SzSdbCtrlItem i18n error", (Throwable)e1);
            }
            AppSumCbbLibrary library = AppSumCbbLibrary.SYNC_INSTANCE;
            int result = library.libGetVersion(fsmServerParam, fsmProxyParam, fsmProductParam, fsmUpdateParam, latestVersionTag);
            String szLatestVer = "";
            String szIpsEngineVer = "";
            try {
                szLatestVer = new String(latestVersionTag.getSzLatestVer(), "utf-8").trim();
                szIpsEngineVer = new String(latestVersionTag.getSzIpsEngineVer(), "utf-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)"connectServerfailed!", (Throwable)e);
            }
            if (0 != result || szLatestVer.isEmpty()) {
                this.log.info((Object)("no version exist or query result failed. result=" + result));
                continue;
            }
            HashMap<String, FeatureModel> featureMap = new HashMap<String, FeatureModel>();
            FeatureModel versionFeatureModel = new FeatureModel();
            versionFeatureModel.setFeatureVersion(szLatestVer);
            versionFeatureModel.setFeatureType("LIBRARY");
            featureMap.put(szLatestVer, versionFeatureModel);
            if (updateModel.getModeName().startsWith("IPS")) {
                this.ipsLibFileName = this.getFileNameByFeatureModel(updateModel, versionFeatureModel);
                this.log.info((Object)("ipsLibFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsLibFileName)));
            }
            String ipsEngineVersion = szIpsEngineVer.trim();
            versionFeatureModel.setEngineVersion(ipsEngineVersion);
            if (!ipsEngineVersion.isEmpty()) {
                FeatureModel ipsEngineFeatureModel = new FeatureModel();
                ipsEngineFeatureModel.setFeatureVersion(szIpsEngineVer);
                ipsEngineFeatureModel.setFeatureType("ENGINE");
                ipsEngineFeatureModel.setEngineVersion(ipsEngineVersion);
                featureMap.put(szIpsEngineVer, ipsEngineFeatureModel);
                this.ipsEngFileName = this.getFileNameByFeatureModel(updateModel, ipsEngineFeatureModel);
                this.log.info((Object)("ipsEngFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsEngFileName)));
                Integer dotLastIndex = this.ipsLibFileName.lastIndexOf(46);
                this.ipsOfflineFileName = dotLastIndex != -1 ? this.ipsLibFileName.substring(0, dotLastIndex) + "_" + OFFLINE + ".zip" : "";
                this.log.info((Object)("ipsOfflineFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsOfflineFileName)));
            }
            updateModel.setFeatureMap(featureMap);
            updateModel.setMessageCode(String.valueOf(0));
            updateList.add(updateModel);
            updateMap.put(modeName, updateList);
        }
        return updateMap;
    }

    private void deleteIpsFile() {
        if (AticUtil.isNull((String)this.libFilePath)) {
            this.libFilePath = LibFilePathUtil.getLibFilePath();
        }
        if (null != this.ipsEngFileName) {
            this.deleteFile(this.libFilePath + this.ipsEngFileName);
        }
        if (null != this.ipsLibFileName) {
            this.deleteFile(this.libFilePath + this.ipsLibFileName);
        }
        if (null != this.ipsOfflineIniFileName) {
            this.deleteFile(this.libFilePath + this.ipsOfflineIniFileName);
        }
    }

    private void deleteFile(String fileAllpath) {
        File file = new File(fileAllpath);
        if (file.exists() && !file.delete()) {
            this.log.error((Object)"file.delete() failed");
        }
    }

    private void addLibFileToSyncList(List<UpdateModel> updateInfoList, UpdateModel um) {
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation("atic.bis.libraryFile.autosecdownload");
        syncSysLog.setModule("lego.dic.module.AticBis");
        syncSysLog.setLevel(SysoplogLevel.normal.getValue());
        syncSysLog.setOperator("system");
        syncSysLog.setTerminalIp("127.0.0.1");
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        String modeName = um.getModeName().trim();
        if (null != updateInfoList) {
            for (UpdateModel updateModel : updateInfoList) {
                if (!updateModel.getModeName().trim().equals(modeName)) continue;
                if (updateModel.getMessageCode().equals(String.valueOf(0))) {
                    boolean isSave = false;
                    String libFilePathStr = LibFilePathUtil.getLibFilePath();
                    String libFileName = "";
                    libFileName = updateModel.getModeName().startsWith("IPS") ? this.getIpsOfflineFileName() : this.getLibFileNameFromUpdateInfo(updateModel);
                    String sha256 = this.getLibFileSHA256FromUpdateInfo(updateModel);
                    File libFile = new File(libFilePathStr + libFileName);
                    if (!AticUtil.isNull((String)libFileName) && libFile.exists()) {
                        isSave = this.saveLibFile(libFileName, libFile, sha256);
                    }
                    if (isSave) {
                        syncSysLog.setResult(1);
                        syncSysLog.setTarget(libFileName);
                        syncSysLog.setDetail("atic.bis.libraryFile.autosecdownload.success");
                        sysOptLog.writeOptLog(syncSysLog);
                        continue;
                    }
                    syncSysLog.setResult(0);
                    syncSysLog.setTarget(libFileName);
                    syncSysLog.setDetail("atic.bis.libraryFile.autosecdownload.fail");
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                String messageCode = "atic.bis.libraryFile.sync.error." + updateModel.getMessageCode();
                if ("420".equals(updateModel.getMessageCode())) {
                    String remotelibFileName = this.getLibFileNameFromUpdateInfo(updateModel);
                    syncSysLog.setResult(1);
                    syncSysLog.setTarget(remotelibFileName);
                    syncSysLog.setDetail(messageCode);
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                String message = AticUtil.getText((String)messageCode);
                if (message.equals(messageCode)) {
                    syncSysLog.setResult(0);
                    syncSysLog.setTarget(modeName);
                    syncSysLog.setDetail("atic.bis.libraryFile.sync.error.unkonw");
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                syncSysLog.setResult(0);
                syncSysLog.setTarget(modeName);
                syncSysLog.setDetail(messageCode);
                sysOptLog.writeOptLog(syncSysLog);
            }
        } else {
            this.log.warn((Object)"updateInfoList is null");
            syncSysLog.setResult(0);
            syncSysLog.setTarget(modeName);
            syncSysLog.setDetail("lego.err.571917");
            sysOptLog.writeOptLog(syncSysLog);
        }
    }

    private boolean saveLibFile(String libFileName, File libFile, String sha256) {
        try {
            String libType = this.getLibType(libFileName);
            int libSize = (int)(libFile.length() / (long)this.libFileSizeUnit + 1L);
            long importTime = System.currentTimeMillis() / 1000L;
            String importType = "Update";
            String deployStatus = "undeployed";
            if (libSize > this.libFileSize * this.libFileSizeUnit) {
                throw new LegoCheckedException(571912L);
            }
            this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
            if (this.libraryFileService.isExists(libFileName)) {
                throw new LegoCheckedException(571901L);
            }
            if (this.libraryFileService.getLibFileCount() >= this.allLibFileNum) {
                throw new LegoCheckedException(571903L);
            }
            LibraryFileForm libraryFileForm = new LibraryFileForm();
            libraryFileForm.setLibType(libType);
            libraryFileForm.setLibName(libFileName);
            libraryFileForm.setLibSize(libSize);
            libraryFileForm.setImportTime(importTime);
            libraryFileForm.setImportType(importType);
            libraryFileForm.setDeployStatus(deployStatus);
            libraryFileForm.setDeployTime(0L);
            if (null == sha256 || "".equals(sha256)) {
                libraryFileForm.setHashCode(SHA256Digester.getInstance().digest(libFileName));
            } else {
                libraryFileForm.setHashCode(sha256);
            }
            Long pkid = this.libraryFileService.saveLibraryFile(libraryFileForm);
            if (pkid > 0L) {
                return true;
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)("autoSecDownload.saveLibFile4DBAndFirstInstall LegoCheckedException" + e.getErrorCode()));
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)("autoSecDownload.saveLibFile4DBAndFirstInstall Exception" + e));
            return false;
        }
        return false;
    }

    public String getLibType(String libName) {
        String libType = "";
        if (libName.startsWith("location_sdb") && libName.endsWith(".zip")) {
            libType = "Lib_Location";
        } else if (libName.startsWith("REGION_H") && libName.endsWith(".zip")) {
            libType = "Lib_Location";
        } else if (libName.startsWith("IPS_H") && libName.endsWith(".zip")) {
            libType = "Lib_IPS";
        } else if (libName.startsWith("CNC_H") && libName.endsWith(".zip")) {
            libType = "Lib_CNC";
        } else if (libName.startsWith("IPRPU_H") && libName.endsWith(".zip")) {
            libType = "Lib_IpReputation";
        } else if (libName.startsWith("CSG_H") && libName.endsWith(".mod")) {
            libType = "Lib_SSLDetec";
        }
        return libType;
    }

    public String getLibFileNameFromUpdateInfo(UpdateModel updateModel) {
        ArrayList<String> libFileNameList = new ArrayList<String>();
        if (null != updateModel && null != updateModel.getFeatureMap()) {
            for (FeatureModel featureModel : updateModel.getFeatureMap().values()) {
                String libFileTemp = this.getFileNameByFeatureModel(updateModel, featureModel);
                libFileNameList.add(libFileTemp);
            }
            if (!libFileNameList.isEmpty()) {
                return (String)libFileNameList.get(0);
            }
        }
        return "";
    }

    public String getLibFileSHA256FromUpdateInfo(UpdateModel updateModel) {
        ArrayList<String> sha256List = new ArrayList<String>();
        if (null != updateModel) {
            for (FeatureModel featureModel : updateModel.getFeatureMap().values()) {
                String sha256 = featureModel.getFeatureSHA256();
                sha256List.add(sha256);
            }
            if (!sha256List.isEmpty()) {
                return (String)sha256List.get(0);
            }
        }
        return "";
    }

    public boolean download(UpdateModel updateModel) {
        boolean downLoadResult;
        block13: {
            UpdateModel um;
            FsmProductParam.ByReference fsmProductParam;
            FsmProxyParam.ByReference fsmProxyParam;
            FsmServerParam.ByReference fsmServerParam;
            AppSumCbbLibrary library;
            block12: {
                this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
                library = AppSumCbbLibrary.SYNC_INSTANCE;
                fsmServerParam = new FsmServerParam.ByReference();
                fsmServerParam.setUsRemotePort(Short.parseShort(this.libraryFileService.getSecDownHttpPort()));
                fsmProxyParam = new FsmProxyParam.ByReference();
                fsmProductParam = new FsmProductParam.ByReference();
                FsmUpdateParam.ByReference fsmUpdateParam = new FsmUpdateParam.ByReference();
                try {
                    fsmServerParam.setSzRemoteAddr(this.libraryFileService.getSecDownHttpUrl());
                    fsmProductParam.setSzPrdName(updateModel.getProductName());
                    fsmProductParam.setSzPrdVer(updateModel.getProductVersion());
                    fsmProductParam.setSzDevEsn(updateModel.getEsn());
                    fsmUpdateParam.setSzLocalPath(LibFilePathUtil.getLibFilePath());
                    fsmUpdateParam.setSzSdbCtrlItem(updateModel.getModeName());
                }
                catch (UnsupportedEncodingException e1) {
                    this.log.error((Object)"SzRemoteAddr or SzPrdName or SzPrdVer or SzDevEsn or SzLocalPath or SzSdbCtrlItem i18n error", (Throwable)e1);
                }
                um = updateModel;
                downLoadResult = true;
                if (updateModel.getModeName().startsWith("IPS")) break block12;
                int downloadStatus = 0;
                try {
                    downloadStatus = library.libUpdate(fsmServerParam, fsmProxyParam, fsmProductParam, fsmUpdateParam);
                }
                catch (Exception e) {
                    this.log.error((Object)"download error:", (Throwable)e);
                    downLoadResult = false;
                }
                if (downloadStatus == 0) break block13;
                this.log.error((Object)"download fail");
                downLoadResult = false;
                break block13;
            }
            for (FeatureModel featureModel : um.getFeatureMap().values()) {
                int downloadStatus = 0;
                FsmUpdateParam.ByReference fsmParam = new FsmUpdateParam.ByReference();
                try {
                    fsmParam.setSzLocalPath(LibFilePathUtil.getLibFilePath());
                    fsmParam.setSzSdbCtrlItem(updateModel.getModeName());
                }
                catch (UnsupportedEncodingException e1) {
                    this.log.error((Object)"SzRemoteAddr or SzPrdName or SzPrdVer or SzDevEsn or SzLocalPath or SzSdbCtrlItem i18n error", (Throwable)e1);
                }
                if ("LIBRARY".equalsIgnoreCase(featureModel.getFeatureType())) {
                    try {
                        fsmParam.setSzEngName("IPS");
                        fsmParam.setUlP2sType(1);
                        fsmParam.setSzEngVer(featureModel.getEngineVersion());
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.error((Object)"SzEngName or SzEngVer i18n error", (Throwable)e);
                    }
                }
                try {
                    downloadStatus = library.libUpdate(fsmServerParam, fsmProxyParam, fsmProductParam, fsmParam);
                }
                catch (Exception e) {
                    this.log.error((Object)"download error:", (Throwable)e);
                    downLoadResult = false;
                    break;
                }
                if (downloadStatus == 0) continue;
                this.log.error((Object)("download fail,downloadStatus:" + downloadStatus));
                downLoadResult = false;
                break;
            }
        }
        return downLoadResult;
    }

    private boolean creatOfflineIniFile(UpdateModel updateModel) {
        this.ipsOfflineIniFileName = this.ipsLibFileName.substring(0, this.ipsLibFileName.lastIndexOf(46)) + "_" + OFFLINE + ".ini";
        this.log.info((Object)("ipsOfflineIniFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsOfflineIniFileName)));
        DownloadSignature downloadSignature = new DownloadSignature();
        return downloadSignature.writeNewIniFile(updateModel, this.libFilePath, this.ipsOfflineIniFileName);
    }

    private boolean packSecIpsLib() {
        boolean isSuccess = false;
        File sdbFile = new File(this.libFilePath + this.ipsLibFileName);
        File engineFile = new File(this.libFilePath + this.ipsEngFileName);
        File newIniFile = new File(this.libFilePath + this.ipsOfflineIniFileName);
        String zipFilePath = this.libFilePath + this.ipsOfflineFileName;
        File zipFile = new File(zipFilePath);
        ArrayList<File> resFileList = new ArrayList<File>();
        resFileList.add(sdbFile);
        resFileList.add(engineFile);
        resFileList.add(newIniFile);
        try {
            PackUtil.zipFiles(resFileList, zipFile);
            isSuccess = true;
        }
        catch (Exception e) {
            this.log.error((Object)"packSecIpsLib filed", (Throwable)e);
        }
        return isSuccess;
    }

    public Map<UpdateModel, Boolean> checkDownload(List<UpdateModel> updateList) {
        HashMap<UpdateModel, Boolean> checkResult = new HashMap<UpdateModel, Boolean>();
        if (null == updateList || updateList.isEmpty()) {
            return checkResult;
        }
        ILibraryFileService libraryFileServices = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        boolean isActive = false;
        for (UpdateModel um : updateList) {
            if (um.getMessageCode().equals(String.valueOf(0))) {
                Iterator<Map.Entry<String, FeatureModel>> it = um.getFeatureMap().entrySet().iterator();
                while (it.hasNext()) {
                    int libraryFileCount = libraryFileServices.queryByPage(this.createCondition(um, it.next()), 0, 0).getCount();
                    if (libraryFileCount <= 0) continue;
                    this.log.info((Object)"atic has the last lib file.");
                }
                if (um.getFeatureMap().isEmpty()) {
                    this.log.info((Object)"no lib file to down.");
                } else {
                    this.log.info((Object)("has lib file to down, productName : " + SecDownLoadUtil.getcleanedMessage(um.getProductName())));
                    isActive = true;
                }
            }
            checkResult.put(um, isActive);
        }
        return checkResult;
    }

    private Map<String, String> createCondition(UpdateModel um, Map.Entry<String, FeatureModel> entry) {
        String libName = this.getFileNameByFeatureModel(um, entry.getValue());
        String libType = "";
        libType = ANTI_DDOS.equals(um.getProductName()) ? "Lib_BOT" : "Lib_Location";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("libName", libName);
        queryMap.put("libType", libType);
        queryMap.put("importType", "Update");
        return queryMap;
    }

    private String getFileNameByFeatureModel(UpdateModel um, FeatureModel featureModel) {
        if ("ENGINE".equalsIgnoreCase(featureModel.getFeatureType())) {
            return um.getModeName() + "_" + featureModel.getFeatureVersion() + ".zip";
        }
        if (um.getLibFileType().contains("SSLDetec")) {
            return featureModel.getFeatureVersion() + ".mod";
        }
        return um.getModeName().replaceAll("_E", "_H") + "_" + featureModel.getFeatureVersion() + ".zip";
    }

    public List<UpdateModel> getLibraryFileUpdateModelInfo() {
        Document document = this.openXML("/libraryFile.xml");
        ArrayList<UpdateModel> umList = new ArrayList<UpdateModel>();
        if (null == document) {
            this.log.info((Object)"document is null.");
            return umList;
        }
        List list = document.selectNodes("//libraryFiles/libraryFile");
        for (Node node : list) {
            String type = node.selectSingleNode("@type").getText();
            String productName = node.selectSingleNode("@productName").getText();
            String productVersion = node.selectSingleNode("@productVersion").getText();
            String modeName = node.selectSingleNode("@modeName").getText();
            UpdateModel um = new UpdateModel();
            um.setLibFileType(type);
            um.setModeName(modeName);
            um.setCurVer(this.findLibFileMaxVer(type));
            if (AticUtil.isNull((String)regist)) {
                this.getRegist();
            }
            um.setEsn(regist);
            um.setLac(regist + "_" + type);
            um.setProductName(productName);
            um.setProductVersion(productVersion);
            umList.add(um);
        }
        return umList;
    }

    private String findLibFileMaxVer(String libFileType) {
        String libFileMaxVer = "";
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        LibraryFileForm libFileForm = this.libraryFileService.getMaxVerLibFile(libFileType);
        if (null != libFileForm && libFileType.equalsIgnoreCase("Lib_BOT")) {
            String maxVer = libFileForm.getLibName().split("_")[2];
            libFileMaxVer = maxVer.substring(0, maxVer.length() - 4);
        }
        return libFileMaxVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document openXML(String path) {
        Document document = null;
        InputStream inputStream = null;
        try {
            inputStream = SecDownLoadUtil.class.getResourceAsStream(path);
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            document = reader.read(inputStream);
        }
        catch (SAXException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (Exception e) {
            this.log.error((Object)"openXML() Exception:", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"openXML() inputStream.close() Exception:", (Throwable)e);
                }
            }
        }
        return document;
    }

    public ILibraryFileService getLibraryFileService() {
        return this.libraryFileService;
    }

    public void setLibraryFileService(ILibraryFileService libraryFileService) {
        this.libraryFileService = libraryFileService;
    }
}

