/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus.util;

import com.hs.atic.bis.lus.model.FeatureModel;
import com.hs.atic.bis.lus.model.UpdateModel;
import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.util.BackupCheckKit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.fds.util.FileToolsFactory;
import com.huawei.fds.util.FileUtil;
import com.huawei.fds.util.LineFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServlet;
import sun.security.action.GetPropertyAction;

public class DownloadSignature
extends HttpServlet {
    public static final String REG_TWO_SIGN_VER = "^(?i)[\\w]{1,64}?$";
    public static final String REG_SIGNATUR_NEW_FILENAME = "^(?i)[a-z0-9-]{1,16}_[a-z][\\d]{6}[a-f\\d]{2}_[\\d]{8}[a-f\\d]{2}(_[\\d]{8}[a-f\\d]{2})?(T|t)?(\\.[a-z0-9]{1,16})?$";
    private static final long serialVersionUID = 7659210987938232743L;
    private static final String PRODUCT_ENABLE = "product_enable";
    private static final String APPLY = "apply";
    private static final String APPMATCH = "APPMatch";
    private static final String APPNAME = "AppName";
    private static final String PACKAGE = "package";
    private static final String ENGINE_FILE = "engineFile";
    private static final String SDB_FILE = "sdbFile";
    private static final String SIGN = "sign";
    private static final String ENGINE_FILE_SH = "engineFileSha256";
    private static final String SDB_FILE_SH = "sdbFileSha256";
    private static final String SIGN_KEY = "engine";
    private final Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeNewIniFile(UpdateModel updateModel, String libFilePath, String ipsOfflineIniFileName) {
        boolean isSuccess = false;
        String appMatch = "ENABLE";
        String appNamePostfix = "";
        String appNamePrefix = "IPS ";
        String appName = appNamePrefix + this.getEngineVersion(updateModel) + appNamePostfix;
        ArrayList<String> productEnables = new ArrayList<String>();
        productEnables.add("AntiDDoS8030 " + updateModel.getProductVersion().trim());
        productEnables.add("AntiDDoS8080 " + updateModel.getProductVersion().trim());
        productEnables.add("AntiDDoS8160 " + updateModel.getProductVersion().trim());
        String engineDetail = this.getFileDetailInfo(updateModel, libFilePath, true);
        String sdbDetail = this.getFileDetailInfo(updateModel, libFilePath, false);
        String engineDetailMD = this.getFileDetailInfoMD(updateModel, libFilePath, true);
        String sdbDetailMD = this.getFileDetailInfoMD(updateModel, libFilePath, false);
        LineFileWriter writer = FileToolsFactory.getFileWriter(libFilePath + ipsOfflineIniFileName);
        StringBuffer newIniContent = new StringBuffer();
        try {
            String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            writer.init();
            writer.writeLine("[apply]");
            newIniContent.append("[apply]" + lineSeparator);
            writer.writeLine("APPMatch=" + appMatch);
            newIniContent.append("APPMatch=" + appMatch + lineSeparator);
            writer.writeLine("AppName=" + appName);
            newIniContent.append("AppName=" + appName + lineSeparator);
            writer.writeLine("[product_enable]");
            newIniContent.append("[product_enable]" + lineSeparator);
            for (String str : productEnables) {
                writer.writeLine(str);
                newIniContent.append(str + lineSeparator);
            }
            writer.writeLine("[package]");
            newIniContent.append("[package]" + lineSeparator);
            writer.writeLine("engineFile=" + engineDetailMD);
            newIniContent.append("engineFile=" + engineDetailMD + lineSeparator);
            writer.writeLine("sdbFile=" + sdbDetailMD);
            newIniContent.append("sdbFile=" + sdbDetailMD + lineSeparator);
            newIniContent.append(SIGN_KEY);
            String iniHashCode = FileUtil.hashCodeMD(newIniContent.toString().getBytes("UTF-8"));
            writer.writeLine("sign=" + iniHashCode);
            writer.writeLine("engineFileSha256=" + engineDetail);
            writer.writeLine("sdbFileSha256=" + sdbDetail);
            isSuccess = true;
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"write unsupportedEncoding error", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"write newIni file error", (Throwable)e);
        }
        finally {
            writer.dispose();
        }
        return isSuccess;
    }

    private String getEngineVersion(UpdateModel updateModel) {
        Iterator<FeatureModel> iterator = updateModel.getFeatureMap().values().iterator();
        if (iterator.hasNext()) {
            FeatureModel featureModel = iterator.next();
            return featureModel.getEngineVersion();
        }
        return "";
    }

    private String getLibraryVersion(UpdateModel updateModel) {
        for (FeatureModel featureModel : updateModel.getFeatureMap().values()) {
            if (!"LIBRARY".equalsIgnoreCase(featureModel.getFeatureType())) continue;
            return featureModel.getFeatureVersion();
        }
        return "";
    }

    private String getEngineFileName(UpdateModel updateModel) {
        return updateModel.getModeName().trim() + "_" + this.getEngineVersion(updateModel) + ".zip";
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String getLibraryFileName(UpdateModel updateModel) {
        return updateModel.getModeName().trim().replace('E', 'H') + "_" + this.getLibraryVersion(updateModel) + ".zip";
    }

    public String getFileDetailInfo(UpdateModel updateModel, String libFilePath, boolean isEngine) {
        String fileName = "";
        fileName = isEngine ? this.getEngineFileName(updateModel) : this.getLibraryFileName(updateModel);
        String hashCode = "";
        File file = new File(libFilePath + fileName);
        if (file.exists()) {
            try {
                hashCode = BackupCheckKit.getFileHash(file);
                int hashCodeLen = hashCode.length();
                for (int i = 0; i < 64 - hashCodeLen; ++i) {
                    hashCode = "0" + hashCode;
                }
            }
            catch (ConfigBackupException e) {
                this.log.error((Object)("get hashCode failed. file:" + DownloadSignature.getcleanedMessage(file.toString()) + ", Exception:" + e));
            }
        }
        return hashCode;
    }

    public String getFileDetailInfoMD(UpdateModel updateModel, String libFilePath, boolean isEngine) {
        String fileName = "";
        fileName = isEngine ? this.getEngineFileName(updateModel) : this.getLibraryFileName(updateModel);
        String hashCode = "";
        File file = new File(libFilePath + fileName);
        if (file.exists()) {
            try {
                hashCode = BackupCheckKit.getFileHashMD(file);
                int hashCodeLen = hashCode.length();
                for (int i = 0; i < 32 - hashCodeLen; ++i) {
                    hashCode = "0" + hashCode;
                }
            }
            catch (ConfigBackupException e) {
                this.log.error((Object)("get hashCode failed. file:" + DownloadSignature.getcleanedMessage(file.toString()) + ", Exception:" + e));
            }
        }
        return fileName + "," + hashCode;
    }
}

