/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.service.IAticCommonUtilService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AticCommonUtilServiceImpl
implements IAticCommonUtilService {
    private static final String CONFIG_FILE = "/datetable.properties";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IAticDeviceService aticDeviceService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private int dayInterval = 7;
    private int hourInterval = 1;
    private long refreshTime = 0L;
    private long lastTime = 0L;
    private ZoneCollectorRMIProxy collectorRMIProxy;

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    @Override
    public boolean checkCollectorStatus(String deviceIp) {
        if (null == deviceIp) {
            return false;
        }
        if (deviceIp.contains(",")) {
            String[] ips = deviceIp.split(",");
            for (int i = 0; i < ips.length; ++i) {
                AticDevice device = this.aticDeviceService.getDeviceByIp(ips[i]);
                if (null == device) {
                    return false;
                }
                Long deviceId = device.getMoId();
                Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(deviceId);
                if (collectorId != null) {
                    CollectorInfo info = this.collectorService.getCollectorInfo(collectorId.longValue());
                    if (info == null) {
                        return false;
                    }
                    SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(info.getIpAddress());
                    if (sysManagerService != null) continue;
                    return false;
                }
                return false;
            }
        } else {
            AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
            if (null == device) {
                return false;
            }
            Long deviceId = device.getMoId();
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(deviceId);
            if (collectorId != null) {
                CollectorInfo info = this.collectorService.getCollectorInfo(collectorId.longValue());
                if (info == null) {
                    return false;
                }
                SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(info.getIpAddress());
                return sysManagerService != null;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkCollectorStatusByCollectorId(Long collecorId) {
        if (collecorId != null) {
            CollectorInfo info = this.collectorService.getCollectorInfo(collecorId.longValue());
            if (info == null) {
                return false;
            }
            SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(info.getIpAddress());
            return sysManagerService != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConfFromFile() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = AticUtil.class.getResourceAsStream(CONFIG_FILE);
            properties.load(inputStream);
            this.dayInterval = Integer.parseInt(properties.getProperty("DayTableInterval"));
            this.hourInterval = Integer.parseInt(properties.getProperty("HourTableInterval"));
            this.refreshTime = Long.parseLong(properties.getProperty("RefreshTime"));
            this.lastTime = System.currentTimeMillis();
            this.logger.info((Object)("read table conf ----------> dayInterval:" + this.dayInterval + ";hourInterval:" + this.hourInterval + ";refreshTime:" + this.refreshTime + ";lastTime:" + this.lastTime));
        }
        catch (IOException e) {
            this.logger.error((Object)"read day table file error!!");
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"read day table file error!!");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"close file error!!");
                }
            }
        }
    }

    @Override
    public int getDayTableInterval() {
        if (System.currentTimeMillis() - this.lastTime > this.refreshTime) {
            this.getConfFromFile();
        }
        return this.dayInterval;
    }

    @Override
    public int getHourTableInterval() {
        if (System.currentTimeMillis() - this.lastTime > this.refreshTime) {
            this.getConfFromFile();
        }
        return this.hourInterval;
    }

    @Override
    public String getServerIp() {
        return System.getProperty("nms.server.host");
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

