/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.ZoneBaseLineStudyDao;
import com.hs.atic.bis.service.BaselineThread;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.ZoneBaseLineStudyForm;
import com.hs.atic.sdk.bis.model.ZoneBaseLineStudyInfo;
import com.hs.atic.sdk.bis.service.IBaseLineService;
import com.hs.atic.sdk.bis.service.IBaselineDataService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.service.ICollectorService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BaseLineServiceImpl
implements IBaseLineService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IBaselineDataService baselineDataRealService;
    private ICollectorService collectorService;
    private BaselineThread baselineThread;
    private ZoneBaseLineStudyDao zoneBaseLineStudyDao;

    @Override
    public void createOrUpdate(ZoneBaseLineStudyForm form) {
        ZoneBaseLineStudyForm studyForm = null;
        if (null != form.getStudyId()) {
            studyForm = this.querySingleBaselineTask(form.getStudyId(), form.getZoneId());
        }
        if (studyForm != null) {
            this.zoneBaseLineStudyDao.update(this.converToInfo(form));
            return;
        }
        Long pkid = (Long)this.zoneBaseLineStudyDao.create(this.converToInfo(form));
        form.setStudyId(pkid);
    }

    @Override
    public ZoneBaseLineStudyForm queryByZoneId(long zoneId) {
        List<ZoneBaseLineStudyInfo> list = this.zoneBaseLineStudyDao.queryByHqlAndParam("from ZoneBaseLineStudyInfo as z where z.zoneId = ? ", zoneId);
        if (!list.isEmpty()) {
            return this.converToForm(list.get(0));
        }
        return null;
    }

    private ZoneBaseLineStudyInfo converToInfo(ZoneBaseLineStudyForm form) {
        if (form == null) {
            return null;
        }
        ZoneBaseLineStudyInfo info = new ZoneBaseLineStudyInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        return info;
    }

    private ZoneBaseLineStudyForm converToForm(ZoneBaseLineStudyInfo info) {
        if (info == null) {
            return null;
        }
        ZoneBaseLineStudyForm form = new ZoneBaseLineStudyForm();
        AticUtil.copyProperties((Object)info, (Object)form);
        return form;
    }

    @Override
    public Long startBaselineTask(ZoneBaseLineStudyForm form) {
        this.createOrUpdate(form);
        this.startTask(form);
        return form.getStudyId();
    }

    private void removeTask(ZoneBaseLineStudyForm form) {
        ZoneBaseLineStudyInfo info = new ZoneBaseLineStudyInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.baselineThread.removeTask(info);
    }

    private void startTask(ZoneBaseLineStudyForm form) {
        ZoneBaseLineStudyInfo info = new ZoneBaseLineStudyInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.baselineThread.addTask(info);
    }

    @Override
    public ZoneBaseLineStudyForm stopBaselineTask(ZoneBaseLineStudyForm baseLineStudyForm) {
        this.baselineDataRealService.modifyBaseLineTask(baseLineStudyForm.getZoneId(), false, baseLineStudyForm.getStartTime(), baseLineStudyForm.getCyc(), baseLineStudyForm.getStudyId());
        this.createOrUpdate(baseLineStudyForm);
        this.removeTask(baseLineStudyForm);
        return baseLineStudyForm;
    }

    @Override
    public void deleteBaseLineTask(Long zoneId) {
        List<ZoneBaseLineStudyForm> zoneBaseLineStudyForms = this.queryBaselineTaskByZoneId(zoneId);
        if (!zoneBaseLineStudyForms.isEmpty()) {
            try {
                for (ZoneBaseLineStudyForm baseLineStudyForm : zoneBaseLineStudyForms) {
                    this.logger.info((Object)("ZoneId = " + baseLineStudyForm.getZoneId() + "  StartTime = " + baseLineStudyForm.getStartTime() + "  Cyc = " + baseLineStudyForm.getCyc() + "  StudyId = " + baseLineStudyForm.getStudyId()));
                    if (this.baselineDataRealService.modifyBaseLineTask(baseLineStudyForm.getZoneId(), false, baseLineStudyForm.getStartTime(), baseLineStudyForm.getCyc(), baseLineStudyForm.getStudyId())) {
                        this.zoneBaseLineStudyDao.remove(baseLineStudyForm.getStudyId());
                    }
                    this.logger.info((Object)("delete baseline task success when delete zone [zoneid:" + zoneId + "] "));
                    try {
                        this.removeTask(baseLineStudyForm);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"remove  baseline task from memory failure when delete zone !!!");
                    }
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"delete baseline task failure when delete zone !!!", (Throwable)e);
            }
        }
    }

    @Override
    public void stopBaseLineTaskByZoneId(Long zoneId) {
        List<ZoneBaseLineStudyForm> zoneBaseLineStudyForms = this.queryBaselineTaskByZoneId(zoneId);
        if (!zoneBaseLineStudyForms.isEmpty()) {
            for (ZoneBaseLineStudyForm baseLineStudyForm : zoneBaseLineStudyForms) {
                try {
                    if (baseLineStudyForm.getStatus() != 1) continue;
                    SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    baseLineStudyForm.setStopTime(formate.format(System.currentTimeMillis()));
                    baseLineStudyForm.setNewEndTime(baseLineStudyForm.getStopTime());
                    baseLineStudyForm.setStatus(0);
                    if (this.baselineDataRealService.modifyBaseLineTask(baseLineStudyForm.getZoneId(), false, baseLineStudyForm.getStartTime(), baseLineStudyForm.getCyc(), baseLineStudyForm.getStudyId())) {
                        this.createOrUpdate(baseLineStudyForm);
                    }
                    this.logger.info((Object)("delete baseline task success when deploy zone !!![zoneid:" + zoneId + "]" + "studyId: " + baseLineStudyForm.getStudyId()));
                    try {
                        this.removeTask(baseLineStudyForm);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"remove  baseline task from memory failure when delete zone !!!");
                    }
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)"delete baseline task failure when deploy zone !!!");
                }
            }
        }
    }

    @Override
    public int getStartedBaseline(String zoneIds) {
        int startedBaselineZoneNum = this.zoneBaseLineStudyDao.getStartedBaselineZoneNum(zoneIds);
        if (startedBaselineZoneNum != 0) {
            return startedBaselineZoneNum;
        }
        return 0;
    }

    @Override
    public List<ZoneBaseLineStudyForm> queryBaselineTaskByZoneId(long zoneId) {
        List<ZoneBaseLineStudyInfo> list = this.zoneBaseLineStudyDao.queryByHqlAndParam("from ZoneBaseLineStudyInfo as z where z.zoneId = ? ", zoneId);
        ArrayList<ZoneBaseLineStudyForm> lisForms = new ArrayList<ZoneBaseLineStudyForm>();
        if (null != list && !list.isEmpty()) {
            for (ZoneBaseLineStudyInfo zoneStudyInfo : list) {
                ZoneBaseLineStudyForm zoneStudyForm = this.converToForm(zoneStudyInfo);
                lisForms.add(zoneStudyForm);
            }
            return lisForms;
        }
        return lisForms;
    }

    @Override
    public ZoneBaseLineStudyForm querySingleBaselineTask(long studyId, long zoneId) {
        ZoneBaseLineStudyInfo zoneStudyInfo = this.zoneBaseLineStudyDao.querySingleTask(studyId, zoneId);
        return this.converToForm(zoneStudyInfo);
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.zoneBaseLineStudyDao.queryByPage(queryMap, start, pageSize);
        List list = page.getData();
        ArrayList<ZoneBaseLineStudyForm> formList = new ArrayList<ZoneBaseLineStudyForm>();
        for (ZoneBaseLineStudyInfo zoneStudyInfo : list) {
            ZoneBaseLineStudyForm form = new ZoneBaseLineStudyForm();
            ZoneUtil.copyProperties(zoneStudyInfo, form);
            formList.add(form);
        }
        page.setData(formList);
        return page;
    }

    @Override
    public void deleteSingeBaselineTask(long studyId, long zoneId) {
        ZoneBaseLineStudyForm baseLineStudyForm = this.querySingleBaselineTask(studyId, zoneId);
        if (baseLineStudyForm != null) {
            try {
                if (this.baselineDataRealService.modifyBaseLineTask(baseLineStudyForm.getZoneId(), false, baseLineStudyForm.getStartTime(), baseLineStudyForm.getCyc(), baseLineStudyForm.getStudyId())) {
                    this.zoneBaseLineStudyDao.deleteSingleTask(studyId, zoneId);
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"delete baseline task failure when delete zone !!!");
            }
            try {
                this.removeTask(baseLineStudyForm);
            }
            catch (Exception e) {
                this.logger.error((Object)"remove  baseline task from memory failure when delete zone !!!");
            }
        }
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IBaselineDataService getBaselineDataRealService() {
        return this.baselineDataRealService;
    }

    public void setBaselineDataRealService(IBaselineDataService baselineDataRealService) {
        this.baselineDataRealService = baselineDataRealService;
    }

    public ZoneBaseLineStudyDao getZoneBaseLineStudyDao() {
        return this.zoneBaseLineStudyDao;
    }

    public void setZoneBaseLineStudyDao(ZoneBaseLineStudyDao zoneBaseLineStudyDao) {
        this.zoneBaseLineStudyDao = zoneBaseLineStudyDao;
    }

    public BaselineThread getBaliBaselineThread() {
        return this.baselineThread;
    }

    public BaselineThread getBaselineThread() {
        return this.baselineThread;
    }

    public void setBaselineThread(BaselineThread baselineThread) {
        this.baselineThread = baselineThread;
    }

    public void setBaliBaselineThread(BaselineThread baliBaselineThread) {
        this.baselineThread = baliBaselineThread;
    }
}

