/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.service.BaselineTolerance;
import com.hs.atic.collector.entity.baseline.BaseLineQueryBean;
import com.hs.atic.collector.entity.baseline.BaseLineTask;
import com.hs.atic.collector.entity.baseline.BaselineDetailQueryBean;
import com.hs.atic.collector.entity.baseline.BaselineMetaData;
import com.hs.atic.rmi.BaseLineDataRmiService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.BaselineMetaDataForm;
import com.hs.atic.sdk.bis.service.IBaselineDataService;
import com.hs.atic.sdk.util.BaseLineGetSuggestionValueQueryBean;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.NfaBaselineObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class BaselineDataRealServiceImpl
implements IBaselineDataService {
    public static final int DEVICE_SERVICE_TYPE_CLEAN_ADD_DETECT = 2;
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IAticDeviceService aticDeviceService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IDefendGroupService defendGroupService;
    private IZoneDeviceService zoneDeviceService;
    private IZoneServiceService zoneServiceService;
    private BaselineTolerance baselineTolerance;
    private IClusterService clusterService;
    private IRestfulNfaService restfulNfaService;
    private IAticDeviceNfaService aticDeviceNfaService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    protected int getDeviceTypeByDevIp(String deviceIp) {
        AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
        return device.getDdosType();
    }

    protected List<ZoneDeviceForm> getOtherDeviceInTheSameDefendGroup(long zoneId, String deviceIp) {
        ArrayList<ZoneDeviceForm> result = new ArrayList<ZoneDeviceForm>();
        AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (null == device) {
            return result;
        }
        List groups = this.defendGroupService.getDefendGroupFormListByDevId(device.getMoId());
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (DefendGroupForm group : groups) {
            groupIds.add(group.getId());
        }
        List zoneDevices = this.zoneDeviceService.getByZoneId(Long.valueOf(zoneId));
        for (ZoneDeviceForm form : zoneDevices) {
            long deviceId = form.getDeviceId();
            device = this.aticDeviceService.getDeviceByMoid(deviceId);
            if (device.getDdosType() == 0) continue;
            groups = this.defendGroupService.getDefendGroupFormListByDevId(deviceId);
            if (groupIds.isEmpty() && groups.isEmpty()) {
                result.add(form);
            }
            for (DefendGroupForm group : groups) {
                if (!groupIds.contains(group.getId())) continue;
                result.add(form);
            }
        }
        return result;
    }

    @Override
    public Map<Long, Long> getBaselineMetaData(Map<String, String> queryMap) {
        Map<Long, Long> result = new HashMap<Long, Long>();
        String deviceIp = queryMap.get("deviceIp");
        if (null == deviceIp) {
            return result;
        }
        try {
            BaselineDetailQueryBean queryBean = new BaselineDetailQueryBean();
            String serviceType = queryMap.get("serviceType");
            AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
            if (AticUtil.isNull((String)serviceType)) {
                queryBean.setDestinationZone(true);
                queryBean.setVersion(Integer.parseInt(queryMap.get("version")));
            } else {
                queryBean.setServiceType(serviceType);
                queryBean.setVersion(StringUtils.equals((CharSequence)queryMap.get("version"), (CharSequence)"") ? 0 : Integer.parseInt(queryMap.get("version")));
            }
            queryBean.setBiz(Long.parseLong(queryMap.get("realBizId")));
            queryBean.setDeviceIp(queryMap.get("realdevIp"));
            queryBean.setEndTime(queryMap.get("endTime"));
            queryBean.setFieldName(queryMap.get("fieldName"));
            queryBean.setStartTime(queryMap.get("startTime"));
            queryBean.setTableSuffix(queryMap.get("tableSuffix"));
            queryBean.setZoneId(Long.parseLong(queryMap.get("realZoneId")));
            queryBean.setDevType(Integer.parseInt(queryMap.get("realDevType")));
            queryBean.setStudyId(Long.parseLong(queryMap.get("studyId")));
            queryBean.setDirection(Integer.parseInt(queryMap.get("direction")));
            String collectorIp = this.getCollectorIp(queryBean.getDeviceIp());
            BaseLineDataRmiService service = this.collectorRMIProxy.getBaselineDataService(collectorIp);
            if (service != null) {
                this.logger.info((Object)("queryBaselineDetail queryBean is " + AticUtil.getcleanedMessage((String)queryBean.toString())));
                result = service.getBaselieDetail(queryBean);
            }
            String devVersion = device.getVersion();
            Integer cleanCpuNumber = device.getCleanCpuNumber();
            Integer detectCpuNumber = device.getDetectCpuNumber();
            ArrayList errorList = new ArrayList();
            for (Map.Entry entry : result.entrySet()) {
                Long value = (Long)entry.getValue();
                if (null != devVersion && (devVersion.contains("V100R001") || devVersion.contains("V500R001C00"))) {
                    if (0 == queryBean.getDevType() && null != cleanCpuNumber && !cleanCpuNumber.equals(0)) {
                        value = value * (long)cleanCpuNumber.intValue();
                    }
                    if (1 == queryBean.getDevType() && null != detectCpuNumber && !detectCpuNumber.equals(0)) {
                        value = value * (long)detectCpuNumber.intValue();
                    }
                } else {
                    this.logger.error((Object)("device version is null, device ip=" + this.getcleanedMessage(device.getIpAddress())));
                }
                if (value >= 0L && value < Integer.MAX_VALUE) {
                    entry.setValue(value);
                    continue;
                }
                errorList.add(entry.getKey());
            }
            if (!errorList.isEmpty()) {
                this.logger.error((Object)AticUtil.getcleanedMessage((String)("getBaselineMetaData has value<0 to be remove, queryMap=" + queryMap.toString() + ". And all result=" + result.toString())));
                for (Long l : errorList) {
                    result.remove(l);
                }
            }
        }
        catch (RemoteException e) {
            this.logger.error((Object)"getBaselieDetail error ");
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"getBaselieDetail error ");
        }
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    private String getCollectorIp(String deviceIp) {
        CollectorInfo info;
        Long deviceId = this.aticDeviceService.getMoidByIP(deviceIp);
        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(deviceId);
        if (collectorId != null && (info = this.collectorService.getCollectorInfo(collectorId.longValue())) != null && info.getStatus() == 1) {
            return info.getIpAddress();
        }
        return null;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    protected List<ZoneServiceForm> queryZoneService(long zoneId, long devId, String serviceType, int direction, String serviceName) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", zoneId + "");
        queryMap.put("deviceId", devId + "");
        queryMap.put("protocol", serviceType);
        queryMap.put("direction", direction + "");
        if (null != serviceName && !"".equals(serviceName)) {
            queryMap.put("serviceName", serviceName);
        }
        List zoneServiceForms = this.zoneServiceService.queryByPage(queryMap, 0, Integer.MAX_VALUE).getData();
        return zoneServiceForms;
    }

    protected List<BaseLineQueryBean> getCleanBeans(Map<String, String> queryMap, List<ZoneServiceForm> queryZoneService) {
        List<BaseLineQueryBean> queryBeans = null;
        String devIp = queryMap.get("deviceIp");
        String servceName = queryMap.get("serviceName");
        String serviceType = queryMap.get("serviceType");
        int version = Integer.parseInt(queryMap.get("version"));
        long zoneId = Long.parseLong(queryMap.get("zoneId"));
        long studyId = this.getStudyId(queryMap);
        int direction = Integer.parseInt(queryMap.get("direction"));
        List<ZoneDeviceForm> otherDevice = this.getOtherDeviceInTheSameDefendGroup(zoneId, devIp);
        ArrayList<ZoneServiceForm> otherZoneService = new ArrayList<ZoneServiceForm>();
        for (ZoneDeviceForm zoneDeviceForm : otherDevice) {
            otherZoneService.addAll(this.queryZoneService(zoneId, zoneDeviceForm.getDeviceId(), serviceType, direction, ""));
        }
        queryBeans = this.compareZoneService2GetQueryBean(queryZoneService, otherZoneService, devIp);
        for (BaseLineQueryBean bean : queryBeans) {
            bean.setDeviceIp(devIp);
            bean.setServiceName(servceName);
            bean.setServiceType(serviceType);
            bean.setVersion(version);
            bean.setStudyId(studyId);
        }
        return queryBeans;
    }

    protected List<BaseLineQueryBean> compareZoneService2GetQueryBean(List<ZoneServiceForm> queryZoneService, List<ZoneServiceForm> otherZoneService, String devIp) {
        ArrayList<BaseLineQueryBean> baseLineQueryBeans = new ArrayList<BaseLineQueryBean>();
        for (ZoneServiceForm zoneServiceForm : queryZoneService) {
            for (ZoneServiceForm otherServiceForm : otherZoneService) {
                AticDevice device;
                if (!this.compareZoneServie(zoneServiceForm, otherServiceForm) || null == (device = this.aticDeviceService.getDeviceByMoid(otherServiceForm.getDeviceId().longValue())) || !device.getIpAddress().equals(devIp)) continue;
                BaseLineQueryBean bean = new BaseLineQueryBean();
                bean.setBiz(zoneServiceForm.getPkid());
                bean.setZoneId(zoneServiceForm.getZoneId());
                bean.setRealBiz(otherServiceForm.getPkid());
                bean.setRealDevIp(device.getIpAddress());
                bean.setRealDevType(1);
                bean.setRealZoneId(otherServiceForm.getZoneId());
                bean.setDirection(zoneServiceForm.getDirection());
                baseLineQueryBeans.add(bean);
                break;
            }
            BaseLineQueryBean bean = new BaseLineQueryBean();
            bean.setBiz(zoneServiceForm.getPkid());
            bean.setZoneId(zoneServiceForm.getZoneId());
            bean.setRealBiz(zoneServiceForm.getPkid());
            bean.setRealDevIp(devIp);
            bean.setRealDevType(0);
            bean.setRealZoneId(zoneServiceForm.getZoneId());
            bean.setDirection(zoneServiceForm.getDirection());
            baseLineQueryBeans.add(bean);
        }
        return baseLineQueryBeans;
    }

    protected boolean compareZoneServie(ZoneServiceForm src, ZoneServiceForm dst) {
        if (!src.getZoneId().equals(dst.getZoneId())) {
            return false;
        }
        if (!src.getProtocol().equals(dst.getProtocol())) {
            return false;
        }
        if (src.getDirection() != null && dst.getDirection() != null && src.getDirection().intValue() != dst.getDirection().intValue()) {
            return false;
        }
        if (src.getProtocolNum() != null && dst.getProtocolNum() != null && src.getProtocolNum().intValue() != dst.getProtocolNum().intValue()) {
            return false;
        }
        return this.compareStrAay(src.getIpList(), dst.getIpList()) && this.compareStrAay(src.getPortList(), dst.getPortList());
    }

    private boolean compareStrAay(String first, String next) {
        if (first != null && next != null) {
            Object[] s = first.split(";");
            Object[] d = next.split(";");
            Arrays.sort(s);
            Arrays.sort(d);
            return Arrays.equals(s, d);
        }
        return first == null && next == null;
    }

    protected List<BaseLineQueryBean> getDetectQueryBeans(Map<String, String> queryMap, List<ZoneServiceForm> queryZoneService, int type) {
        ArrayList<BaseLineQueryBean> queryBeans = new ArrayList<BaseLineQueryBean>();
        String devIp = queryMap.get("deviceIp");
        String servceName = queryMap.get("serviceName");
        String serviceType = queryMap.get("serviceType");
        int version = StringUtils.equals((CharSequence)queryMap.get("version"), (CharSequence)"") ? 0 : Integer.parseInt(queryMap.get("version"));
        long zoneId = Long.parseLong(queryMap.get("zoneId"));
        long studyId = this.getStudyId(queryMap);
        for (ZoneServiceForm forms : queryZoneService) {
            BaseLineQueryBean bean = new BaseLineQueryBean();
            bean.setBiz(forms.getPkid());
            bean.setDeviceIp(devIp);
            bean.setServiceName(servceName);
            bean.setServiceType(serviceType);
            bean.setVersion(version);
            bean.setZoneId(zoneId);
            bean.setStudyId(studyId);
            bean.setDirection(forms.getDirection());
            bean.setRealBiz(forms.getPkid());
            bean.setRealDevIp(devIp);
            bean.setRealDevType(1);
            bean.setRealZoneId(zoneId);
            queryBeans.add(bean);
            if (2 != type) continue;
            bean = new BaseLineQueryBean();
            bean.setBiz(forms.getPkid());
            bean.setDeviceIp(devIp);
            bean.setServiceName(servceName);
            bean.setServiceType(serviceType);
            bean.setVersion(version);
            bean.setZoneId(zoneId);
            bean.setStudyId(studyId);
            bean.setDirection(forms.getDirection());
            bean.setRealBiz(forms.getPkid());
            bean.setRealDevIp(devIp);
            bean.setRealDevType(0);
            bean.setRealZoneId(zoneId);
            queryBeans.add(bean);
        }
        return queryBeans;
    }

    protected List<BaseLineQueryBean> getQueryBeans(Map<String, String> queryMap) {
        this.logger.info((Object)("The queryMap=" + AticUtil.getcleanedMessage((String)queryMap.toString())));
        String devIp = queryMap.get("deviceIp");
        String zoneId = queryMap.get("zoneId");
        String serviceType = queryMap.get("serviceType");
        String studyId = queryMap.get("studyId");
        String direction = queryMap.get("direction");
        if (AticUtil.isNull((String)devIp) || AticUtil.isNull((String)zoneId) || AticUtil.isNull((String)studyId) || AticUtil.isNull((String)direction)) {
            return new ArrayList<BaseLineQueryBean>();
        }
        AticDevice device = this.aticDeviceService.getDeviceByIp(devIp);
        int type = device.getDdosType();
        int deviceType = device.getDeviceType();
        queryMap.put("deviceType", String.valueOf(deviceType));
        ArrayList<BaseLineQueryBean> queryBeans = new ArrayList<BaseLineQueryBean>();
        List<ZoneServiceForm> queryZoneService = this.queryZoneService(Long.parseLong(zoneId), device.getMoId(), serviceType, Integer.parseInt(direction), queryMap.get("serviceName"));
        if (0 != type) {
            queryBeans.addAll(this.getDetectQueryBeans(queryMap, queryZoneService, type));
        }
        if (0 == type) {
            queryBeans.addAll(this.getCleanBeans(queryMap, queryZoneService));
        }
        return queryBeans;
    }

    private long getStudyId(Map<String, String> queryMap) {
        String studyIdStr = queryMap.get("studyId");
        long studyId = 0L;
        if (studyIdStr != null && !studyIdStr.isEmpty()) {
            studyId = Long.parseLong(studyIdStr);
        }
        return studyId;
    }

    protected List<BaseLineQueryBean> getCleanBeans4DestinationZone(Map<String, String> queryMap) {
        ArrayList<BaseLineQueryBean> queryBeans = new ArrayList<BaseLineQueryBean>();
        String devIp = queryMap.get("deviceIp");
        String servceName = queryMap.get("serviceName");
        String serviceType = queryMap.get("serviceType");
        long zoneId = Long.parseLong(queryMap.get("zoneId"));
        long studyId = this.getStudyId(queryMap);
        List<ZoneDeviceForm> otherDevice = this.getOtherDeviceInTheSameDefendGroup(zoneId, devIp);
        for (ZoneDeviceForm deviceForm : otherDevice) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
            if (device == null) continue;
            BaseLineQueryBean bean = new BaseLineQueryBean();
            bean.setBiz(0L);
            bean.setDeviceIp(devIp);
            bean.setServiceName(servceName);
            bean.setServiceType(serviceType);
            bean.setZoneId(zoneId);
            bean.setStudyId(studyId);
            bean.setIsDestinationZone(true);
            bean.setRealBiz(0L);
            bean.setRealDevIp(device.getIpAddress());
            bean.setRealDevType(1);
            bean.setRealZoneId(zoneId);
            queryBeans.add(bean);
        }
        if (queryBeans.isEmpty()) {
            BaseLineQueryBean bean = new BaseLineQueryBean();
            bean.setBiz(0L);
            bean.setDeviceIp(devIp);
            bean.setServiceName(servceName);
            bean.setServiceType(serviceType);
            bean.setZoneId(zoneId);
            bean.setIsDestinationZone(true);
            bean.setRealBiz(0L);
            bean.setRealDevIp(devIp);
            bean.setRealDevType(0);
            bean.setRealZoneId(zoneId);
            queryBeans.add(bean);
        }
        return queryBeans;
    }

    protected List<BaseLineQueryBean> getDetectQueryBeans4DestinationZone(Map<String, String> queryMap, int type) {
        ArrayList<BaseLineQueryBean> queryBeans = new ArrayList<BaseLineQueryBean>();
        String devIp = queryMap.get("deviceIp");
        String servceName = queryMap.get("serviceName");
        String serviceType = queryMap.get("serviceType");
        long zoneId = Long.parseLong(queryMap.get("zoneId"));
        long studyId = this.getStudyId(queryMap);
        BaseLineQueryBean beanOne = new BaseLineQueryBean();
        beanOne.setBiz(0L);
        beanOne.setDeviceIp(devIp);
        beanOne.setServiceName(servceName);
        beanOne.setServiceType(serviceType);
        beanOne.setZoneId(zoneId);
        beanOne.setStudyId(studyId);
        beanOne.setIsDestinationZone(true);
        beanOne.setRealBiz(0L);
        beanOne.setRealDevIp(devIp);
        beanOne.setRealDevType(1);
        beanOne.setRealZoneId(zoneId);
        queryBeans.add(beanOne);
        if (2 == type) {
            BaseLineQueryBean beanTwo = new BaseLineQueryBean();
            beanTwo.setBiz(0L);
            beanTwo.setDeviceIp(devIp);
            beanTwo.setServiceName(servceName);
            beanTwo.setServiceType(serviceType);
            beanTwo.setZoneId(zoneId);
            beanTwo.setIsDestinationZone(true);
            beanTwo.setRealBiz(0L);
            beanTwo.setRealDevIp(devIp);
            beanTwo.setRealDevType(0);
            beanTwo.setRealZoneId(zoneId);
            queryBeans.add(beanTwo);
        }
        return queryBeans;
    }

    protected List<BaselineMetaData> sumBaselineMetaData(List<BaselineMetaData> list) {
        ArrayList<BaselineMetaData> result = new ArrayList<BaselineMetaData>();
        if (list.isEmpty()) {
            return result;
        }
        for (BaselineMetaData data : list) {
            if (result.contains(data)) {
                ((BaselineMetaData)result.get(result.indexOf(data))).dataCopy(data);
                continue;
            }
            result.add(data);
        }
        return result;
    }

    @Override
    public List<BaselineMetaDataForm> queryByPage(Map<String, String> queryMap) {
        List<BaseLineQueryBean> queryBeans = this.getQueryBeans(queryMap);
        ArrayList<BaselineMetaDataForm> forms = new ArrayList<BaselineMetaDataForm>();
        if (queryBeans.isEmpty()) {
            return forms;
        }
        AticDevice device = this.aticDeviceService.getDeviceByIp(queryMap.get("deviceIp"));
        ArrayList<BaselineMetaData> allResults = new ArrayList<BaselineMetaData>();
        for (BaseLineQueryBean bean : queryBeans) {
            try {
                String collectorIp = this.getCollectorIp(bean.getRealDevIp());
                BaseLineDataRmiService baselineService = this.collectorRMIProxy.getBaselineDataService(collectorIp);
                if (baselineService == null) continue;
                this.logger.info((Object)("query collector data,params is " + bean.toString()));
                allResults.addAll(baselineService.getBaselieMataData(bean));
            }
            catch (Exception e) {
                this.logger.error((Object)"getBaselineMetaData error", (Throwable)e);
            }
        }
        List<BaselineMetaData> sumResults = this.sumBaselineMetaData(allResults);
        String devVersion = device.getVersion();
        Integer cleanCpuNumber = device.getCleanCpuNumber();
        Integer detectCpuNumber = device.getDetectCpuNumber();
        for (BaselineMetaData each : sumResults) {
            BaselineMetaDataForm form = new BaselineMetaDataForm();
            AticUtil.copyProperties((Object)each, (Object)form);
            long newValue = form.getValue();
            if (null != devVersion && (devVersion.contains("V100R001") || devVersion.contains("V500R001C00"))) {
                if (0 == each.getRealDevType() && null != cleanCpuNumber && cleanCpuNumber != 0) {
                    newValue *= (long)cleanCpuNumber.intValue();
                }
                if (1 == each.getRealDevType() && null != detectCpuNumber && detectCpuNumber != 0) {
                    newValue *= (long)detectCpuNumber.intValue();
                }
            } else {
                this.logger.info((Object)("device version is null, device ip=" + this.getcleanedMessage(device.getIpAddress()) + "deviceType is " + device.getDdosType()));
            }
            if (newValue > 0L && newValue < Integer.MAX_VALUE) {
                form.setValue(newValue);
                forms.add(form);
                continue;
            }
            this.logger.error((Object)("the BaselineMetaData value < 0 or newValue < Integer.MAX_VALUE,devIP:" + form.getDeviceIp() + ",zoneId:" + form.getZoneId() + ",direction:" + form.getDirection()));
        }
        return forms;
    }

    @Override
    public boolean modifyBaseLineTask(Long zoneId, boolean isStart, String startTime, Integer cyc, Long strudyId) {
        boolean result = false;
        if (!isStart) {
            result = true;
        }
        ZonePolicyApplyForm zonePolicyApplyForm = this.zonePolicyApplyService.queryByZoneId(zoneId);
        List<ZoneDeviceForm> deviceIdList = null;
        if (zonePolicyApplyForm != null) {
            deviceIdList = zonePolicyApplyForm.getZoneDeviceForms();
        }
        if (null != deviceIdList) {
            for (ZoneDeviceForm device : deviceIdList) {
                BaseLineDataRmiService baselineService;
                Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(device.getDeviceId());
                if (collectorId == null) continue;
                String collectorIp = null;
                CollectorInfo info = this.collectorService.getCollectorInfo(collectorId.longValue());
                if (info != null && info.getStatus() == 1) {
                    collectorIp = info.getIpAddress();
                }
                if (null == collectorIp || null == (baselineService = this.collectorRMIProxy.getBaselineDataService(collectorIp))) continue;
                try {
                    BaseLineTask baseLineTask = new BaseLineTask();
                    baseLineTask.setZoneId(zoneId);
                    baseLineTask.setStartup(isStart);
                    baseLineTask.setStart(startTime);
                    baseLineTask.setCyc(cyc.intValue());
                    baseLineTask.setPkid(strudyId);
                    result = baselineService.modifyBaseLineTask(baseLineTask);
                    this.logger.info((Object)("Atic Management Center call collector baseline_task result :" + result));
                    if (result) continue;
                    this.logger.error((Object)("modifyBaseLineTask to collecotor error, zoneId=" + zoneId + ", device=" + device.getDeviceIp() + ", collectorIp=" + collectorIp));
                    return false;
                }
                catch (Exception e) {
                    this.logger.error((Object)("modifyBaseLineTask to collecotor error, zoneId=" + zoneId + ", device=" + device.getDeviceIp() + ", collectorIp=" + collectorIp), (Throwable)e);
                    return false;
                }
            }
        }
        return result;
    }

    @Override
    public long getReadjustBaseLine(String policyItem, long baseline) {
        return this.baselineTolerance.calculateBaseLine(policyItem, baseline);
    }

    @Override
    public long getSuggestionValue(BaseLineGetSuggestionValueQueryBean baseLineGetSuggestionValueQueryBean) {
        long baselineValue = baseLineGetSuggestionValueQueryBean.getBaselineValue();
        int currentValue = baseLineGetSuggestionValueQueryBean.getCurrentValue();
        int currentValueWeight = baseLineGetSuggestionValueQueryBean.getCurrentValueWeight();
        String policyItem = baseLineGetSuggestionValueQueryBean.getPolicyItem();
        AticDevice device = baseLineGetSuggestionValueQueryBean.getDevice();
        String serviceType = baseLineGetSuggestionValueQueryBean.getServiceType();
        String keyItem = Constant.getPolicyItemMap().get(policyItem);
        if (null != keyItem) {
            policyItem = keyItem;
        }
        baselineValue = this.getReadjustBaseLine(policyItem, baselineValue);
        long suggestionValue = 0L;
        if (currentValue > 0) {
            Double weightPercent = Double.valueOf(currentValueWeight) / 100.0;
            long value1 = (long)((double)currentValue * weightPercent);
            long value2 = (long)((double)baselineValue * (1.0 - weightPercent));
            suggestionValue = value1 + value2;
        } else {
            suggestionValue = baselineValue;
        }
        suggestionValue = this.compareSuggestValueThreshold(policyItem, suggestionValue, device, serviceType);
        return suggestionValue;
    }

    @Override
    public long compareSuggestValueThreshold(String policyItem, long suggestionValue, AticDevice aticDevice, String serviceType) {
        return this.baselineTolerance.compareSuggestValueThreshold(policyItem, suggestionValue, aticDevice, serviceType);
    }

    public boolean deployNfaBaslineTask(List<ZoneDeviceForm> aticDeviceList, Long zoneId, boolean isStart) {
        if (aticDeviceList.isEmpty()) {
            return true;
        }
        ArrayList<Result> errResultList = new ArrayList<Result>();
        ArrayList<Result> successResultList = new ArrayList<Result>();
        Result result = null;
        NfaBaselineObject baselineObject = new NfaBaselineObject();
        baselineObject.setZoneId(zoneId.longValue());
        int enable = isStart ? 1 : 0;
        baselineObject.setEnable(enable);
        for (ZoneDeviceForm zoneForm : aticDeviceList) {
            Long deviceId = zoneForm.getDeviceId();
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
            if (aticDevice.getDeviceType() == 7) {
                List devList = this.clusterService.getDeviceListByVirtualId(deviceId);
                if (null == devList || devList.isEmpty()) continue;
                for (AticDevice device : devList) {
                    result = this.deployNfaBaselineByOnce(baselineObject, device);
                    if (!this.checkJson(result)) {
                        errResultList.add(result);
                        continue;
                    }
                    successResultList.add(result);
                }
                continue;
            }
            if (aticDevice.getDeviceType() != 5) continue;
            result = this.deployNfaBaselineByOnce(baselineObject, aticDevice);
            if (!this.checkJson(result)) {
                errResultList.add(result);
                continue;
            }
            successResultList.add(result);
        }
        for (Result rst : errResultList) {
            this.logger.error((Object)("Deploy baseline to nfa error:" + rst.toString()));
        }
        for (Result rst : successResultList) {
            this.logger.info((Object)("Deploy baseline to nfa success:" + rst.toString()));
        }
        return errResultList.isEmpty();
    }

    private boolean checkJson(Result result) {
        JSONObject json;
        int statusCode = result.getStatusCode();
        return 200 == statusCode && "ok".equalsIgnoreCase((String)(json = JSONObject.fromObject((Object)result.getJson())).get("errDesc"));
    }

    private Result deployNfaBaselineByOnce(NfaBaselineObject baselineObject, AticDevice aticDevice) {
        AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByMoid(Long.valueOf(aticDevice.getMoId()));
        NfaInfoForm nfaInfoForm = new NfaInfoForm();
        nfaInfoForm.setDeviceId(Long.valueOf(aticDevice.getMoId()));
        nfaInfoForm.setIpAdress(aticDevice.getIpAddress());
        nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
        nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort().intValue());
        return this.restfulNfaService.restNfaModifyBaseline(baselineObject, nfaInfoForm);
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public IDefendGroupService getDefendGroupService() {
        return this.defendGroupService;
    }

    public void setDefendGroupService(IDefendGroupService defendGroupService) {
        this.defendGroupService = defendGroupService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    public BaselineTolerance getBaselineTolerance() {
        return this.baselineTolerance;
    }

    public void setBaselineTolerance(BaselineTolerance baselineTolerance) {
        this.baselineTolerance = baselineTolerance;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public IRestfulNfaService getRestfulNfaService() {
        return this.restfulNfaService;
    }

    public void setRestfulNfaService(IRestfulNfaService restfulNfaService) {
        this.restfulNfaService = restfulNfaService;
    }

    public IAticDeviceNfaService getAticDeviceNfaService() {
        return this.aticDeviceNfaService;
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }
}

