/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.ZoneBaseLineStudyDao;
import com.hs.atic.sdk.bis.form.BaselineMetaDataForm;
import com.hs.atic.sdk.bis.model.ZoneBaseLineStudyInfo;
import com.hs.atic.sdk.bis.service.IBaselineDataService;
import com.hs.atic.sdk.util.BaseLineGetSuggestionValueQueryBean;
import com.hs.atic.sdk.util.TimeTransferUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.NfaPolicyEditForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.INfaPolicyEditService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyMgrService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class BaselineThread
extends Thread {
    private Map<Long, ZoneBaseLineStudyInfo> tasks = new ConcurrentHashMap<Long, ZoneBaseLineStudyInfo>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IBaselineDataService baselineDataService;
    private IAticDeviceService aticDeviceService;
    private IZoneDeviceService zoneDeviceService;
    private IZoneServiceService iZoneServiceService = null;
    private IZoneService iZoneService;
    private ZoneBaseLineStudyInfo info;
    private IZonePolicyMgrService zonePolicyMgrService;
    private ZoneBaseLineStudyDao zoneBaseLineStudyDao;
    private ICommonUtilService commonUtilService;
    private ISysOptLog sysOptLog;
    private INfaPolicyEditService nfaPolicyEditService;

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)"BaselineThread InterruptedException ", (Throwable)e);
                    }
                    this.excuteBaseLine();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"BaselineThread error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void excuteBaseLine() {
        for (Map.Entry<Long, ZoneBaseLineStudyInfo> entry : this.tasks.entrySet()) {
            boolean flag;
            long endTimeMillis;
            ZoneBaseLineStudyInfo infos = this.tasks.get(entry.getKey());
            if (null == infos) {
                this.logger.error((Object)"excuteBaseLine() is error, infos is null.");
                continue;
            }
            long curTimeMillis = System.currentTimeMillis();
            if (1 == infos.getStatus() && curTimeMillis / 1000L >= (endTimeMillis = TimeTransferUtil.convertString2Long(infos.getNewEndTime())) && endTimeMillis != 0L) {
                this.logger.info((Object)("baseline end start" + AticUtil.getcleanedMessage((String)infos.toString())));
                infos.setStatus(0);
                infos.setStopTime(TimeTransferUtil.transferlong2String(curTimeMillis));
                if (!this.baselineDataService.modifyBaseLineTask(infos.getZoneId(), false, TimeTransferUtil.transferlong2String(System.currentTimeMillis()), infos.getCyc(), infos.getStudyId())) {
                    throw new LegoCheckedException(630132L);
                }
                this.baselineDataService.modifyBaseLineTask(infos.getZoneId(), false, infos.getStartTime(), infos.getCyc(), infos.getStudyId());
                this.zoneBaseLineStudyDao.update(infos);
                this.logger.info((Object)"baseline end");
            }
            if (flag = this.isTimeToSet(infos)) {
                this.logger.info((Object)("baseline cycle start" + AticUtil.getcleanedMessage((String)infos.toString())));
                if (infos.getAutoInure() != null && infos.getAutoInure().booleanValue()) {
                    this.logger.info((Object)"Automatic baseline learning results");
                    this.updateBaseline(infos);
                    this.depolyZoneService(infos);
                    this.removeTask(infos);
                }
                if (infos.getStatus() == 1) {
                    infos.setStartTime(TimeTransferUtil.transferlong2String(infos.getEndTime(infos.getStartTime()) * 1000L));
                    this.zoneBaseLineStudyDao.update(infos);
                    this.baselineDataService.modifyBaseLineTask(infos.getZoneId(), true, infos.getStartTime(), infos.getCyc(), infos.getStudyId());
                    this.addTask(infos);
                }
                this.logger.info((Object)"baseline cycle end");
            }
            if (!StringUtils.equals((CharSequence)"", (CharSequence)infos.getStopTime()) || 0 != infos.getStatus()) continue;
            this.logger.info((Object)"update baseline status start");
            int openBaselineNum = this.zoneBaseLineStudyDao.getStartedBaselineZoneNum(String.valueOf(infos.getZoneId()));
            if (openBaselineNum >= 1) continue;
            if (curTimeMillis / 1000L >= TimeTransferUtil.convertString2Long(infos.getNewStartTime())) {
                infos.setStatus(1);
                this.baselineDataService.modifyBaseLineTask(infos.getZoneId(), true, infos.getStartTime(), infos.getCyc(), infos.getStudyId());
                this.zoneBaseLineStudyDao.update(infos);
            }
            this.logger.info((Object)"update baseline status end");
        }
    }

    public void addTask(ZoneBaseLineStudyInfo infos) {
        this.tasks.put(infos.getStudyId(), infos);
        this.logger.info((Object)("BaselineThread addTask is [zoneId:" + infos.getZoneId() + "studyId:" + infos.getStudyId()));
    }

    public void removeTask(ZoneBaseLineStudyInfo infos) {
        this.tasks.remove(infos.getStudyId());
        this.logger.info((Object)("remove  baseline task from memory  [zoneId:" + infos.getZoneId() + "studyId:" + infos.getStudyId() + "] "));
    }

    public void initBaseLineTask() {
        String hql = "from ZoneBaseLineStudyInfo";
        List<ZoneBaseLineStudyInfo> zoneBaseLineStudyInfos = this.zoneBaseLineStudyDao.queryByHql(hql);
        if (zoneBaseLineStudyInfos != null && !zoneBaseLineStudyInfos.isEmpty()) {
            for (ZoneBaseLineStudyInfo zoneBaseLineStudyInfo : zoneBaseLineStudyInfos) {
                long curTimeMillis;
                if (zoneBaseLineStudyInfo.getStatus() == 1) {
                    this.addTask(zoneBaseLineStudyInfo);
                }
                if ((curTimeMillis = System.currentTimeMillis()) / 1000L < TimeTransferUtil.convertString2Long(zoneBaseLineStudyInfo.getNewStartTime()) || curTimeMillis / 1000L > TimeTransferUtil.convertString2Long(zoneBaseLineStudyInfo.getNewEndTime())) continue;
                this.addTask(zoneBaseLineStudyInfo);
            }
        }
    }

    private List<BaselineMetaDataForm> getR2BaseLineData(Set<String> serviceTypes, Map<String, String> map) {
        ArrayList<BaselineMetaDataForm> totoalResult = new ArrayList<BaselineMetaDataForm>();
        for (String serviceType : serviceTypes) {
            map.put("serviceType", serviceType);
            List<BaselineMetaDataForm> result = this.baselineDataService.queryByPage(map);
            totoalResult.addAll(result);
        }
        return totoalResult;
    }

    protected List<ZoneServiceForm> queryZoneService(long zoneId, long devId) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", zoneId + "");
        queryMap.put("deviceId", devId + "");
        List zoneServiceForms = this.iZoneServiceService.queryByPage(queryMap, 0, Integer.MAX_VALUE).getData();
        return zoneServiceForms;
    }

    protected List<BaselineMetaDataForm> sumBaselineMetaData(List<BaselineMetaDataForm> list) {
        ArrayList<BaselineMetaDataForm> result = new ArrayList<BaselineMetaDataForm>();
        if (list.isEmpty()) {
            return result;
        }
        for (BaselineMetaDataForm data : list) {
            if (result.contains(data)) {
                ((BaselineMetaDataForm)result.get(result.indexOf(data))).dataCopy(data);
                continue;
            }
            result.add(data);
        }
        return result;
    }

    private void updateServiceBaselineDataByDev(ZoneBaseLineStudyInfo infos, AticDevice device, String zoneName) {
        List<ZoneServiceForm> zoneServiceForms = this.queryZoneService(infos.getZoneId(), device.getMoId());
        HashSet<String> serviceTypes = new HashSet<String>();
        HashMap<Long, Object> serviceForms = new HashMap<Long, Object>();
        for (ZoneServiceForm zoneService : zoneServiceForms) {
            serviceTypes.add(zoneService.getProtocol());
            serviceForms.put(zoneService.getPkid(), this.iZoneServiceService.query(zoneService.getPkid()));
            NfaPolicyEditForm nfaPolicyEditForm = this.nfaPolicyEditService.queryByServiceId(zoneService.getPkid());
            zoneService.setNfaPolicyEditForm(nfaPolicyEditForm);
        }
        String deviceIp = device.getIpAddress();
        String ddosVersion = this.commonUtilService.getDDoSVersion(deviceIp);
        List<Object> totoalResult = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", ddosVersion);
        map.put("zoneId", infos.getZoneId().toString());
        map.put("deviceIp", deviceIp);
        map.put("studyId", infos.getStudyId().toString());
        map.put("direction", String.valueOf(3));
        if (ddosVersion.equalsIgnoreCase("4")) {
            totoalResult = this.getR2BaseLineData(serviceTypes, map);
        } else if ((ddosVersion.equalsIgnoreCase("1") || ddosVersion.equalsIgnoreCase("2") || ddosVersion.equalsIgnoreCase("5") || ddosVersion.equalsIgnoreCase("7")) && serviceTypes.contains("DEFAULT")) {
            map.put("serviceType", "DEFAULT");
            List<BaselineMetaDataForm> defaultResult = this.baselineDataService.queryByPage(map);
            this.logger.info((Object)("defaultResult size is " + defaultResult.size() + "defaultResult object is " + AticUtil.getcleanedMessage((String)defaultResult.toString())));
            totoalResult.addAll(defaultResult);
        }
        HashSet<Long> modifyBiz = new HashSet<Long>();
        for (BaselineMetaDataForm baselineMetaDataForm : totoalResult) {
            long serviceId = baselineMetaDataForm.getServiceId();
            if (!serviceForms.containsKey(serviceId) || !this.updateZoneService(baselineMetaDataForm, infos, device, zoneName, (ZoneServiceForm)serviceForms.get(baselineMetaDataForm.getServiceId()))) continue;
            modifyBiz.add(serviceId);
        }
        Iterator it = modifyBiz.iterator();
        while (it.hasNext()) {
            long l = (Long)it.next();
            this.iZoneServiceService.create(serviceForms.get(l));
            this.logger.info((Object)("updateServiceBaselineDataByDev serviceId is " + l));
        }
    }

    private boolean isTimeToSet(ZoneBaseLineStudyInfo infos) {
        long endTime;
        long now = System.currentTimeMillis() / 1000L;
        return now >= (endTime = infos.getEndTime(infos.getStartTime()));
    }

    private void depolyZoneService(ZoneBaseLineStudyInfo zoneInfo) {
        try {
            long zoneId = zoneInfo.getZoneId();
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            zoneIds.add(zoneId);
            this.zonePolicyMgrService.deploy(zoneIds, System.currentTimeMillis() / 1000L);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"depolyZoneService failure");
        }
        catch (Exception e) {
            this.logger.error((Object)"depolyZoneService failure");
        }
    }

    private void updateBaseline(ZoneBaseLineStudyInfo infos) {
        try {
            ZoneInfoForm zoneInfoForm;
            Long zoneId = infos.getZoneId();
            List zoneDeviceForms = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
            String zoneName = "";
            if (null != zoneId && null != (zoneInfoForm = this.iZoneService.getZoneNOIpById(zoneId))) {
                zoneName = zoneInfoForm.getZoneDesc();
            }
            for (ZoneDeviceForm zoneDevice : zoneDeviceForms) {
                AticDevice device = this.aticDeviceService.getDeviceByMoid(zoneDevice.getDeviceId().longValue());
                if (null == device) continue;
                this.updateServiceBaselineDataByDev(infos, device, zoneName);
            }
            this.logger.info((Object)" update baseline over");
        }
        catch (Exception e) {
            this.logger.error((Object)"update baseline failure", (Throwable)e);
        }
    }

    private Map<String, String> getOpeMap() {
        HashMap<String, String> opeMap = new HashMap<String, String>();
        opeMap.put("alertSpeed", "udpFloodAlertSpeed");
        opeMap.put("fragAlertSpeed", "udpFragAlertSpeed");
        opeMap.put("alertRate", "dnsRequsetAlertRate");
        opeMap.put("replyFloodAlertRate", "dnsReplyFloodAlertRate");
        opeMap.put("fingerAlert", "otherFingerAlert");
        return opeMap;
    }

    private void setOptLog(String zoneName, String key, Integer value, Boolean sucess) {
        try {
            SysOptLog sysOptLogLego = new SysOptLog();
            sysOptLogLego.setDate(new Date());
            sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
            sysOptLogLego.setModule("lego.dic.module.ddosApp");
            sysOptLogLego.setOperation("com.hs.vsm.secservice.ddos.policy.operation.name.auto.confirmBaselineTask");
            sysOptLogLego.setOperator("system");
            sysOptLogLego.setTarget(zoneName);
            if (sucess.booleanValue()) {
                sysOptLogLego.setResult(1);
                sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.confirmBaselineTask");
            } else {
                sysOptLogLego.setResult(0);
                sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.detail.confirmBaselineTask.failure");
            }
            Map<String, String> opeMap = this.getOpeMap();
            String opeString = opeMap.get(key);
            if (!AticUtil.isNull((String)opeString)) {
                key = opeString;
            }
            String[] para = new String[]{key, String.valueOf(value)};
            sysOptLogLego.setDetailPara(para);
            sysOptLogLego.setTerminalIp("127.0.0.1");
            this.sysOptLog.writeOptLog(sysOptLogLego);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"generate opt log error!!!");
        }
    }

    private boolean updateZoneService(BaselineMetaDataForm data, ZoneBaseLineStudyInfo infos, AticDevice device, String zoneName, ZoneServiceForm zoneForm) {
        StringBuffer sb = new StringBuffer(zoneName).append("(").append(zoneForm.getServiceName()).append(")");
        boolean isModify = false;
        Integer confValue = 0;
        try {
            String policyItem = Constant.getPolicyItemMap().get(data.getKey());
            if ("httpDestQpsAlertRate".equals(data.getKey()) || "httpQpsAlertRate".equals(data.getKey())) {
                policyItem = "httpDestQpsAlertRate";
            } else if (null == policyItem) {
                policyItem = data.getKey();
            }
            Integer currentValue = zoneForm.getCurrentValue(policyItem);
            BaseLineGetSuggestionValueQueryBean baseLineGetSuggestionValueQueryBean = new BaseLineGetSuggestionValueQueryBean();
            baseLineGetSuggestionValueQueryBean.setBaselineValue(data.getValue());
            baseLineGetSuggestionValueQueryBean.setCurrentValue(currentValue);
            baseLineGetSuggestionValueQueryBean.setCurrentValueWeight(infos.getHistoryHeft());
            baseLineGetSuggestionValueQueryBean.setPolicyItem(data.getKey());
            baseLineGetSuggestionValueQueryBean.setDevice(device);
            baseLineGetSuggestionValueQueryBean.setServiceType(data.getServiceType());
            confValue = (int)this.baselineDataService.getSuggestionValue(baseLineGetSuggestionValueQueryBean);
            if (infos.getEffectMode() == 1 && currentValue >= confValue) {
                return isModify;
            }
            zoneForm.setCurrentValue(policyItem, confValue);
            isModify = true;
            this.setOptLog(sb.toString(), data.getKey(), confValue, true);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"updateZoneService error.");
            this.setOptLog(sb.toString(), data.getKey(), confValue, false);
            return isModify;
        }
        catch (Exception e) {
            this.logger.error((Object)"updateZoneService error.");
            this.setOptLog(sb.toString(), data.getKey(), confValue, false);
            return isModify;
        }
        return isModify;
    }

    public void setBaselineDataService(IBaselineDataService baselineDataService) {
        this.baselineDataService = baselineDataService;
    }

    public void setInfo(ZoneBaseLineStudyInfo info) {
        this.info = info;
    }

    public void setiZoneServiceService(IZoneServiceService iZoneServiceServices) {
        this.iZoneServiceService = iZoneServiceServices;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public void setZonePolicyMgrService(IZonePolicyMgrService zonePolicyMgrService) {
        this.zonePolicyMgrService = zonePolicyMgrService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public INfaPolicyEditService getNfaPolicyEditService() {
        return this.nfaPolicyEditService;
    }

    public void setNfaPolicyEditService(INfaPolicyEditService nfaPolicyEditService) {
        this.nfaPolicyEditService = nfaPolicyEditService;
    }

    public ISysOptLog getSysOptLog() {
        return this.sysOptLog;
    }

    public void setSysOptLog(ISysOptLog sysOptLog) {
        this.sysOptLog = sysOptLog;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public ZoneBaseLineStudyDao getZoneBaseLineStudyDao() {
        return this.zoneBaseLineStudyDao;
    }

    public void setZoneBaseLineStudyDao(ZoneBaseLineStudyDao zoneBaseLineStudyDao) {
        this.zoneBaseLineStudyDao = zoneBaseLineStudyDao;
    }

    public IZoneService getiZoneService() {
        return this.iZoneService;
    }

    public void setiZoneService(IZoneService iZoneServices) {
        this.iZoneService = iZoneServices;
    }

    public IBaselineDataService getBaselineDataService() {
        return this.baselineDataService;
    }

    public ZoneBaseLineStudyInfo getInfo() {
        return this.info;
    }

    public IZoneServiceService getiZoneServiceService() {
        return this.iZoneServiceService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public IZonePolicyMgrService getZonePolicyMgrService() {
        return this.zonePolicyMgrService;
    }
}

