/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.collector.entity.BlackListData;
import com.hs.atic.rmi.BlackListRmiService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.BlackListForm;
import com.hs.atic.sdk.bis.service.IBlackListService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BlackListServiceImpl
implements IBlackListService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IAticDeviceService aticDeviceService;
    private ICollectorService collectorService;
    private ICollectorDeviceService collectorDeviceService;

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    @Override
    public Paging getBlackListData(Map<String, String> queryMap) {
        this.logger.info((Object)("query getBlackListData queryMap" + queryMap.toString()));
        Paging page = new Paging();
        try {
            BlackListRmiService service;
            String deviceIp = queryMap.get("deviceIp");
            List<Object> data = new ArrayList();
            Integer totalSize = 0;
            if (deviceIp.contains(",")) {
                String[] ips = deviceIp.split(",");
                service = null;
                for (int i = 0; i < ips.length; ++i) {
                    String collectorIP = this.getCollectorIp(ips[i]);
                    service = this.collectorRMIProxy.getBlackListService(collectorIP);
                    queryMap.remove("deviceIp");
                    queryMap.put("deviceIp", ips[i]);
                    data.addAll(service.getBlackListData(queryMap));
                    totalSize = totalSize + service.getQueryAllCount(queryMap);
                }
            } else {
                String collectorIP = this.getCollectorIp(deviceIp);
                service = this.collectorRMIProxy.getBlackListService(collectorIP);
                data = service.getBlackListData(queryMap);
                totalSize = service.getQueryAllCount(queryMap);
            }
            ArrayList<BlackListForm> forms = new ArrayList<BlackListForm>();
            BlackListForm form = null;
            int start = Integer.parseInt(queryMap.get("start"));
            int pageSize = Integer.parseInt(queryMap.get("pageSize"));
            for (int i = start; i < (start + pageSize < data.size() ? start + pageSize : data.size()); ++i) {
                BlackListData each = (BlackListData)data.get(i);
                form = new BlackListForm();
                AticUtil.copyProperties((Object)each, (Object)form);
                if (null != form.getStartTime()) {
                    form.setStartTimeStr(AticUtil.formateTime((long)form.getStartTime()));
                }
                forms.add(form);
            }
            page.setData(forms);
            page.setCount(totalSize.intValue());
        }
        catch (RemoteException e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
        return page;
    }

    private String getCollectorIp(String deviceIp) {
        try {
            this.logger.info((Object)("query getBlackListData deviceIp" + deviceIp));
            Long collectorId = null;
            Long deviceId = this.aticDeviceService.getMoidByIP(deviceIp);
            if (null != deviceId) {
                collectorId = this.collectorDeviceService.getCollectorIdByDevId(deviceId);
            }
            CollectorInfo info = null;
            if (null != collectorId) {
                info = this.collectorService.getCollectorInfo(collectorId.longValue());
            }
            if (null != info) {
                return info.getIpAddress();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"getCollectorIp error ", (Throwable)e);
        }
        return "";
    }

    @Override
    public void stopService(List<BlackListForm> inputStr, String deviceIp) {
        this.logger.info((Object)("query getBlackListData input str is" + inputStr + " deviceIp is" + deviceIp));
        String collectorIP = this.getCollectorIp(deviceIp);
        BlackListRmiService service = this.collectorRMIProxy.getBlackListService(collectorIP);
        ArrayList<BlackListData> datas = new ArrayList<BlackListData>();
        for (BlackListForm blackListForm : inputStr) {
            BlackListData blackListData = new BlackListData();
            AticUtil.copyProperties((Object)blackListForm, (Object)blackListData);
            datas.add(blackListData);
        }
        try {
            service.stopService(datas);
        }
        catch (RemoteException e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void startupService(String inputStr, String deviceIp) {
        this.logger.info((Object)("query getBlackListData input str is" + BlackListServiceImpl.getcleanedMessage(inputStr) + " deviceIp is" + deviceIp));
        String collectorIP = this.getCollectorIp(deviceIp);
        BlackListRmiService service = this.collectorRMIProxy.getBlackListService(collectorIP);
        try {
            service.startupService(inputStr);
        }
        catch (RemoteException e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<BlackListForm> getAllBlackList(Map<String, String> queryMap) {
        this.logger.info((Object)AticUtil.getcleanedMessage((String)queryMap.toString()));
        ArrayList<BlackListForm> forms = new ArrayList<BlackListForm>();
        try {
            BlackListRmiService service;
            String deviceIp = queryMap.get("deviceIp");
            List<Object> data = new ArrayList();
            if (deviceIp.contains(",")) {
                void var7_9;
                String[] ips = deviceIp.split(",");
                service = null;
                boolean bl = false;
                while (var7_9 < ips.length) {
                    String collectorIP = this.getCollectorIp(ips[var7_9]);
                    service = this.collectorRMIProxy.getBlackListService(collectorIP);
                    queryMap.remove("deviceIp");
                    queryMap.put("deviceIp", ips[var7_9]);
                    data.addAll(service.getBlackListData(queryMap));
                    ++var7_9;
                }
            } else {
                String collectorIP = this.getCollectorIp(deviceIp);
                service = this.collectorRMIProxy.getBlackListService(collectorIP);
                data = service.getBlackListData(queryMap);
            }
            BlackListForm form = null;
            for (BlackListData blackListData : data) {
                form = new BlackListForm();
                AticUtil.copyProperties((Object)blackListData, (Object)form);
                if (null != form.getStartTime()) {
                    form.setStartTimeStr(AticUtil.formateTime((long)form.getStartTime()));
                }
                forms.add(form);
            }
        }
        catch (RemoteException e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
        return forms;
    }

    @Override
    public Map<String, Exception> stopAllService(String zoneId, String deviceIps) {
        this.logger.info((Object)(" zoneId is : " + BlackListServiceImpl.getcleanedMessage(zoneId)));
        this.logger.info((Object)(" deviceIPs is : " + deviceIps));
        String[] ips = deviceIps.split(",");
        HashMap<String, Exception> errMap = new HashMap<String, Exception>();
        HashSet<String> collectorsIp = new HashSet<String>();
        for (String deviceIp : ips) {
            String collectorIP = this.getCollectorIp(deviceIp);
            if (collectorsIp.contains(collectorIP)) continue;
            collectorsIp.add(collectorIP);
            BlackListRmiService service = this.collectorRMIProxy.getBlackListService(collectorIP);
            try {
                service.stopAllService(zoneId);
            }
            catch (RemoteException e) {
                this.logger.error((Object)("colletcor connect error . collector ip : " + collectorIP), (Throwable)e);
                errMap.put(collectorIP, e);
            }
        }
        return errMap;
    }
}

