/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.sdk.bis.service.IDateTableFileService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DateTableFileServiceImpl
implements IDateTableFileService {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private boolean isOpenKIOSwitch = false;
    private int divertIpMask;
    private int divertIpv6Mask;
    private int linkageDivertIpMask;
    private boolean cancelDivertByDetect;
    private boolean isOpenLoopBack300Switch = false;
    private int loopBack300DelayTime = 0;
    private boolean isLinkageWhenCloudCleanSwitch = false;
    private int retryDivertSleepTime = 5;

    public DateTableFileServiceImpl() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = AticUtil.class.getResourceAsStream("/datetable.properties");
            properties.load(inputStream);
            this.divertIpMask = Integer.parseInt(properties.getProperty("DivertIPMask"));
            this.divertIpv6Mask = Integer.parseInt(properties.getProperty("DivertIPV6Mask"));
            this.linkageDivertIpMask = Integer.parseInt(properties.getProperty("LinkageDivertIPMask"));
            int value = Integer.parseInt(properties.getProperty("CancelDivertByDetect"));
            this.cancelDivertByDetect = value != 0;
            this.isOpenKIOSwitch = Boolean.parseBoolean(properties.getProperty("isOpenKIO"));
            this.isOpenLoopBack300Switch = Boolean.parseBoolean(properties.getProperty("IsOpenLoopBack300"));
            this.loopBack300DelayTime = Integer.parseInt(properties.getProperty("LoopBack300DelayTime"));
            this.isLinkageWhenCloudCleanSwitch = Boolean.parseBoolean(properties.getProperty("IsLinkageWhenCloudClean"));
            this.retryDivertSleepTime = Integer.parseInt(properties.getProperty("RetryDivertSleepTime"));
            if (this.loopBack300DelayTime > 900) {
                this.loopBack300DelayTime = 900;
            }
            this.logger.info((Object)("load KIO infomation: isOpenKIO is " + this.isOpenKIOSwitch + ", LoopBack300DelayTime is " + this.loopBack300DelayTime + ", DivertIPMask is " + this.divertIpMask + ", DivertIPV6Mask is " + this.divertIpv6Mask + ", LinkageDivertIPMask is " + this.linkageDivertIpMask + ", CancelDivertByDetect is " + this.cancelDivertByDetect + ", IsOpenLoopBack300 is " + this.isOpenLoopBack300Switch + ", IsLinkageWhenCloudClean is " + this.isLinkageWhenCloudCleanSwitch + ", RetryDivertSleepTime is " + this.retryDivertSleepTime));
        }
        catch (IOException e) {
            this.logger.error((Object)("load property error, " + e));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("load property error, " + e));
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)("static mode is error " + e));
                }
            }
        }
    }

    @Override
    public boolean isOpenKIO() {
        return this.isOpenKIOSwitch;
    }

    @Override
    public int getLoopBack300DelayTime() {
        return this.loopBack300DelayTime;
    }

    @Override
    public int getDivertIpMask() {
        return this.divertIpMask;
    }

    @Override
    public int getDivertIpv6Mask() {
        return this.divertIpv6Mask;
    }

    @Override
    public int getLinkageDivertIpMask() {
        return this.linkageDivertIpMask;
    }

    @Override
    public boolean isCancelDivertByDetect() {
        return this.cancelDivertByDetect;
    }

    @Override
    public boolean isOpenLoopBack300() {
        return this.isOpenLoopBack300Switch;
    }

    @Override
    public boolean isLinkageWhenCloudClean() {
        return this.isLinkageWhenCloudCleanSwitch;
    }

    @Override
    public int getRetryDivertSleepTime() {
        return this.retryDivertSleepTime;
    }
}

