/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.collector.entity.BizInfoEntity;
import com.hs.atic.collector.entity.DefaultBizMappingEntity;
import com.hs.atic.common.service.impl.FoundDefaultIdCommonServiceImpl;
import com.hs.atic.rmi.FoundDefaultIdRmiService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.service.IFoundDefaultIdService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FoundDefaultIdServiceImpl
implements IFoundDefaultIdService {
    private IZoneServiceService zoneServiceService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IAticDeviceService aticDeviceService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private FoundDefaultIdCommonServiceImpl foundDefaultIdCommonServiceImpl;

    public FoundDefaultIdCommonServiceImpl getFoundDefaultIdCommonServiceImpl() {
        return this.foundDefaultIdCommonServiceImpl;
    }

    public void setFoundDefaultIdCommonServiceImpl(FoundDefaultIdCommonServiceImpl foundDefaultIdCommonServiceImpl) {
        this.foundDefaultIdCommonServiceImpl = foundDefaultIdCommonServiceImpl;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    @Override
    public void refeshDefaultZoneData() {
        Map<Object, Object> allDefZoneIds = new HashMap();
        try {
            allDefZoneIds = this.foundDefaultIdCommonServiceImpl.getAllDefaultZoneId();
        }
        catch (RemoteException e1) {
            this.logger.error((Object)"foundDefaultIdCommonServiceImpl getAllDefaultZoneId error", (Throwable)e1);
        }
        if (!allDefZoneIds.isEmpty()) {
            for (Map.Entry<Object, Object> entry : allDefZoneIds.entrySet()) {
                CollectorInfo collectorTemp;
                String devIp = (String)entry.getKey();
                AticDevice device = this.aticDeviceService.getDeviceByIp(devIp);
                Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
                if (null == collectorId || null == (collectorTemp = this.collectorService.getCollectorInfo(collectorId.longValue())) || null == collectorTemp.getIpAddress()) continue;
                try {
                    FoundDefaultIdRmiService service = this.collectorRMIProxy.getFoundDefaultIdRelationService(collectorTemp.getIpAddress());
                    if (null == service) continue;
                    service.refeshDefaultZoneData(allDefZoneIds);
                }
                catch (Exception e) {
                    this.logger.error((Object)("FoundDefaultIdServiceImpl refeshDefaultZoneData() error,collectorIp: " + this.getcleanedMessage(collectorTemp.getIpAddress())), (Throwable)e);
                }
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<String> getCollectorIps(List<String> deviceIps) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The getCollectorIps() used times is " + startTime + "ms"));
        ArrayList<String> collectorIps = new ArrayList<String>();
        if (null == deviceIps || deviceIps.isEmpty()) {
            return collectorIps;
        }
        for (String deviceIp : deviceIps) {
            CollectorInfo collectorTemp;
            AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
            if (null == collectorId || null == (collectorTemp = this.collectorService.getCollectorInfo(collectorId.longValue())) || null == collectorTemp.getIpAddress() || collectorIps.contains(collectorTemp.getIpAddress())) continue;
            collectorIps.add(collectorTemp.getIpAddress());
        }
        this.logger.info((Object)("The getCollectorIps() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
        return collectorIps;
    }

    @Override
    public void refeshDefaultBizData() {
        Map<Object, Object> allDefBizIds = new HashMap();
        try {
            allDefBizIds = this.foundDefaultIdCommonServiceImpl.getAllDefaultBizId();
        }
        catch (RemoteException e1) {
            this.logger.error((Object)"foundDefaultIdCommonServiceImpl getAllDefaultBizId error", (Throwable)e1);
        }
        if (!allDefBizIds.isEmpty()) {
            ArrayList<String> deviceIps = new ArrayList<String>();
            List<String> collectorIps = null;
            for (Map.Entry<Object, Object> entry : allDefBizIds.entrySet()) {
                if (deviceIps.contains(((DefaultBizMappingEntity)entry.getKey()).getDeviceIp())) continue;
                deviceIps.add(((DefaultBizMappingEntity)entry.getKey()).getDeviceIp());
            }
            collectorIps = this.getCollectorIps(deviceIps);
            if (collectorIps.isEmpty()) {
                return;
            }
            for (String collectorIp : collectorIps) {
                try {
                    FoundDefaultIdRmiService service = this.collectorRMIProxy.getFoundDefaultIdRelationService(collectorIp);
                    if (null == service) continue;
                    service.refeshDefaultBizData(allDefBizIds);
                }
                catch (Exception e) {
                    this.logger.error((Object)("FoundDefaultIdServiceImpl refeshDefaultZoneData() error ,collectorIp: " + collectorIp), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void refreshUserDefBizData() {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The refreshUserDefBizData() start time is " + startTime));
        Map<Object, Object> bizList = new HashMap();
        try {
            bizList = this.foundDefaultIdCommonServiceImpl.getAllBizInfo();
            this.logger.info((Object)("The getAllBizInfo() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
        }
        catch (RemoteException e1) {
            this.logger.error((Object)"foundDefaultIdCommonServiceImpl getAllBizInfo error", (Throwable)e1);
        }
        if (!bizList.isEmpty()) {
            ArrayList<String> deviceIps = new ArrayList<String>();
            List<String> collectorIps = null;
            for (Map.Entry<Object, Object> entry : bizList.entrySet()) {
                if (deviceIps.contains(((BizInfoEntity)entry.getKey()).getDeviceIp())) continue;
                deviceIps.add(((BizInfoEntity)entry.getKey()).getDeviceIp());
            }
            collectorIps = this.getCollectorIps(deviceIps);
            if (collectorIps.isEmpty()) {
                return;
            }
            for (String collectorIp : collectorIps) {
                try {
                    FoundDefaultIdRmiService service = this.collectorRMIProxy.getFoundDefaultIdRelationService(collectorIp);
                    if (null == service) continue;
                    service.refreshUserDefBizData(bizList);
                }
                catch (Exception e) {
                    this.logger.error((Object)("FoundDefaultIdServiceImpl refeshDefaultZoneData() error,collectorIp: " + collectorIp), (Throwable)e);
                }
            }
        }
        this.logger.info((Object)("The refreshUserDefBizData() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

