/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.GlobeDeployStatusDao;
import com.hs.atic.bis.dao.LocationCustomDao;
import com.hs.atic.bis.dao.LocationDevEntityDao;
import com.hs.atic.bis.dao.LocationIpDao;
import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.bis.model.LocationDevEntity;
import com.hs.atic.bis.model.LocationIp;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.form.LocationIpForm;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.IpLocationUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocationCustomServiceImpl
implements ILocationCustomService {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LocationCustomDao locationCustomDao;
    private LocationIpDao locationIpDao;
    private GlobeDeployStatusDao globeDeployStatusDao;
    private IAticDeviceService aticDeviceService;
    private LocationDevEntityDao locationDevEntityDao;

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.locationCustomDao.queryByPage(queryMap, start, pageSize);
        List locationCustoms = page.getData();
        ArrayList<LocationCustomForm> locCustomForms = new ArrayList<LocationCustomForm>();
        for (LocationCustom locCustom : locationCustoms) {
            LocationCustomForm locCustomForm = new LocationCustomForm();
            AticUtil.copyProperties((Object)locCustom, (Object)locCustomForm);
            locCustomForms.add(locCustomForm);
        }
        page.setData(locCustomForms);
        this.logger.info((Object)("locCustomForms size: " + locCustomForms.size()));
        return page;
    }

    @Override
    public List<LocationCustom> queryByDeployStatus(String deployStatus) {
        List<LocationCustom> list = this.locationCustomDao.queryByDeployStatus(deployStatus);
        return list;
    }

    @Override
    public Long saveLocationCustom(LocationCustomForm locationCustomForm) {
        LocationCustom locationCustom;
        long locationId = 0L;
        if (null != locationCustomForm.getPkId() && locationCustomForm.getPkId() > 0L) {
            locationId = locationCustomForm.getPkId();
            LocationCustom temp = this.locationCustomDao.get(locationId);
            if (null == temp) {
                throw new LegoCheckedException(571905L);
            }
            locationCustom = (LocationCustom)AticUtil.copyProperties((Object)locationCustomForm, (Object)temp);
            this.locationCustomDao.updateLocationCustom(locationCustom);
            this.locationIpDao.deleteLocationIpByLocId(locationCustom.getPkId());
            this.globeDeployStatusDao.deleteLibFileByType(locationId, "Location_Custom");
        } else {
            locationCustom = new LocationCustom();
            locationCustom = (LocationCustom)AticUtil.copyProperties((Object)locationCustomForm, (Object)locationCustom);
            this.locationCustomDao.saveOrUpdate(locationCustom);
            locationId = locationCustom.getPkId();
        }
        this.logger.info((Object)("saveLocationCustom, name is : " + locationCustomForm.getLocationName()));
        List<LocationIpForm> ipList = locationCustomForm.getLocationIpList();
        boolean checkSaveIpSucess = true;
        if (null != ipList && !ipList.isEmpty()) {
            for (LocationIpForm locationIpItem : ipList) {
                locationIpItem.setLocationId(locationId);
                LocationIp locationIp = (LocationIp)AticUtil.copyProperties((Object)locationIpItem, (Object)new LocationIp());
                this.locationIpDao.saveOrUpdate(locationIp);
                Long locationIpId = locationIp.getPkId();
                if (locationIpId >= 0L) continue;
                checkSaveIpSucess = false;
                break;
            }
        }
        if (!checkSaveIpSucess) {
            this.delById(locationId);
            this.locationIpDao.deleteLocationIpByLocId(locationId);
            locationId = -1L;
        }
        return locationId;
    }

    @Override
    public boolean isExists(String locationName) {
        return this.locationCustomDao.isExists(locationName);
    }

    @Override
    public int getLocCustomCount() {
        int all = this.locationCustomDao.getAll().size();
        this.logger.info((Object)("getLocCustomCount all counts : " + all));
        return all;
    }

    @Override
    public BatchOperationResult batchDelLocationCustom(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList) {
            return result;
        }
        if (!boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                try {
                    LocationCustomForm ipLoc = this.findById(bo.getTargetId());
                    if (null == ipLoc) {
                        this.logger.error((Object)("delete locationCustom : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(571905L);
                        continue;
                    }
                    if (ipLoc.getDeployStatus().equals("success") || ipLoc.getDeployStatus().equals("part_suc") || ipLoc.getDeployStatus().equals("deploying")) {
                        this.logger.error((Object)("delete locationCustom : " + this.getcleanedMessage(bo.getTargetName()) + " failed, deployStatus is success"));
                        ++fail;
                        bo.setErrorCode(571906L);
                        continue;
                    }
                    if (null != ipLoc.getPkId() && (long)AticConstants.ATIC_SELF_DEFINED_LOCATION_STRAT_ID.intValue() <= ipLoc.getPkId()) {
                        IpLocationUtil.getIpLocationMap().remove(ipLoc.getPkId());
                    }
                    if (!ipLoc.getDeployStatus().equals("undeployed")) {
                        this.doExecUnDeployLocCusCmd(bo.getTargetId());
                    }
                    this.delById(bo.getTargetId());
                    this.locationIpDao.deleteLocationIpByLocId(bo.getTargetId());
                    this.globeDeployStatusDao.deleteLibFileByType(bo.getTargetId(), "Location_Custom");
                    bo.setOptDetail("atic.bis.locationCustom.delete.sucessSumary");
                    bo.setDetailParam(new String[]{bo.getTargetName()});
                    this.logger.info((Object)("delete locationCustom : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570507L);
                    this.logger.error((Object)("delete locationCustom : " + this.getcleanedMessage(bo.getTargetName()) + " failed"), (Throwable)e);
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("batch delete libFile result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void doExecUnDeployLocCusCmd(Long locCustomId) {
        String locCusName = "";
        StringBuffer buf = new StringBuffer();
        LocationCustom locationCustom = this.locationCustomDao.get(locCustomId);
        if (null != locationCustom) {
            locCusName = locationCustom.getLocationName();
        }
        if (AticUtil.isNull((String)locCusName)) {
            this.logger.error((Object)("locCusName is null: " + this.getcleanedMessage(locCusName)));
            return;
        }
        List allDdosFirewall = this.aticDeviceService.getAntiDDoSDevice();
        if (null == allDdosFirewall) {
            return;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system-view");
        cmds.add("location");
        String locationName = "geo-location user-defined " + locCusName;
        cmds.add("undo " + locationName);
        this.logger.warn((Object)("cmds:" + cmds));
        for (AticDevice firewall : allDdosFirewall) {
            try {
                List results = null;
                results = this.aticDeviceService.execCmd(cmds, firewall.getMoId());
                if (AticUtil.isCmdSucess((List)results)) continue;
                if (results.isEmpty()) {
                    return;
                }
                String cmdReusultStr = "";
                for (String result : results) {
                    buf.append(result + ";");
                }
                cmdReusultStr = buf.toString();
                this.logger.error((Object)("doExecUnDeployLocCusCmd failure: " + this.getcleanedMessage(cmdReusultStr)));
            }
            catch (Exception e) {
                this.logger.error((Object)("doExecUnDeployLocCusCmd unkonw error:" + e));
            }
        }
    }

    @Override
    public List<LocationCustomForm> findByDeviceIp(String deviceIp) {
        List<Long> locationCustomIds = this.locationDevEntityDao.getLocationDevEntityBydevIp(deviceIp);
        ArrayList<LocationCustomForm> list = new ArrayList<LocationCustomForm>();
        if (!locationCustomIds.isEmpty()) {
            for (Long id : locationCustomIds) {
                list.add(this.findById(id));
            }
        }
        return list;
    }

    @Override
    public LocationCustomForm findByIdFromDev(Long id) {
        Long locationCustomId = this.locationDevEntityDao.getLocationDevEntityByIdFormDev(id);
        if (null != locationCustomId) {
            return this.findById(locationCustomId);
        }
        return null;
    }

    @Override
    public Long findIdByIdFromDev(Long id, String deviceIp) {
        LocationDevEntity entity = this.locationDevEntityDao.getLocationDevEntityByDeviceIpAndId(id, deviceIp);
        if (null != entity) {
            Long locationCustomId = entity.getLocationId();
            return locationCustomId;
        }
        return null;
    }

    @Override
    public LocationCustomForm findById(Long locationCustomId) {
        LocationCustom locationCustom = this.locationCustomDao.get(locationCustomId);
        this.logger.info((Object)("find LocationCustom by id : " + locationCustomId));
        return (LocationCustomForm)AticUtil.copyProperties((Object)locationCustom, (Object)new LocationCustomForm());
    }

    @Override
    public List<LocationCustomForm> findAll() {
        List<LocationCustom> cusList = this.locationCustomDao.findAll();
        ArrayList<LocationCustomForm> cusformList = new ArrayList<LocationCustomForm>();
        if (null != cusList && !cusList.isEmpty()) {
            for (LocationCustom cus : cusList) {
                LocationCustomForm cusForm = new LocationCustomForm();
                AticUtil.copyProperties((Object)cus, (Object)cusForm);
                cusformList.add(cusForm);
            }
        }
        return cusformList;
    }

    @Override
    public LocationCustomForm findByName(String locationName) {
        LocationCustom cus = this.locationCustomDao.findByName(locationName);
        LocationCustomForm cusForm = new LocationCustomForm();
        if (null != cus) {
            AticUtil.copyProperties((Object)cus, (Object)cusForm);
        }
        return cusForm;
    }

    @Override
    public List<LocationCustomForm> getListByPkIds(Long[] objectIds) {
        if (null == objectIds || objectIds.length == 0) {
            return null;
        }
        List<LocationCustom> locationCustoms = this.locationCustomDao.getListByPkIds(objectIds);
        ArrayList<LocationCustomForm> locationCustomForms = new ArrayList<LocationCustomForm>();
        for (LocationCustom loc : locationCustoms) {
            locationCustomForms.add((LocationCustomForm)AticUtil.copyProperties((Object)loc, (Object)new LocationCustomForm()));
        }
        this.logger.info((Object)("getListByPkIds  : " + locationCustoms.size()));
        return locationCustomForms;
    }

    @Override
    public List<String> checkIsZoneOccupy(List<String> locationIds) {
        if (null == locationIds || locationIds.size() == 0) {
            return null;
        }
        return this.locationCustomDao.checkIsZoneOccupy(locationIds);
    }

    @Override
    public void delById(Long id) {
        this.locationCustomDao.remove(id);
    }

    public LocationCustomDao getLocationCustomDao() {
        return this.locationCustomDao;
    }

    public void setLocationCustomDao(LocationCustomDao locationCustomDao) {
        this.locationCustomDao = locationCustomDao;
    }

    public LocationIpDao getLocationIpDao() {
        return this.locationIpDao;
    }

    public void setLocationIpDao(LocationIpDao locationIpDao) {
        this.locationIpDao = locationIpDao;
    }

    public GlobeDeployStatusDao getGlobeDeployStatusDao() {
        return this.globeDeployStatusDao;
    }

    public void setGlobeDeployStatusDao(GlobeDeployStatusDao globeDeployStatusDao) {
        this.globeDeployStatusDao = globeDeployStatusDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public LocationDevEntityDao getLocationDevEntityDao() {
        return this.locationDevEntityDao;
    }

    public void setLocationDevEntityDao(LocationDevEntityDao locationDevEntityDao) {
        this.locationDevEntityDao = locationDevEntityDao;
    }

    public String findNameById(String libId) {
        String ipLocationName = null;
        LocationCustomForm findById = this.findById(Long.valueOf(libId));
        if (null != findById) {
            ipLocationName = findById.getLocationName();
        }
        return ipLocationName;
    }
}

