/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.collector.entity.protal.ProtalServiceConfInfo;
import com.hs.atic.rmi.MssConfService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.service.IMssMgr;
import com.hs.atic.system.SysConfigManager;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.service.dao.CollectorDao;
import java.rmi.RemoteException;

public class MssMgrImpl
implements IMssMgr {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private SysConfigManager sysConfigManager;
    private CollectorDao collectorDao;
    private ZoneCollectorRMIProxy collectorRMIProxy;

    public void setSysConfigManager(SysConfigManager sysConfigManager) {
        this.sysConfigManager = sysConfigManager;
    }

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public SysConfigManager getSysConfigManager() {
        return this.sysConfigManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateMssSftpConf(String[] mssSftpConf) throws RemoteException {
        String result = "";
        boolean aticSucceed = this.sysConfigManager.updateMssSftpConf(mssSftpConf);
        boolean allCollectorSucceed = false;
        try {
            if (aticSucceed) {
                ProtalServiceConfInfo conf = new ProtalServiceConfInfo();
                conf.setSftpServerIp(mssSftpConf[0].split(",")[1]);
                conf.setSftpPort(Integer.parseInt(mssSftpConf[1].split(",")[1]));
                conf.setSftpUser(mssSftpConf[2].split(",")[1]);
                conf.setSftpPwd(mssSftpConf[3].split(",")[1]);
                String[] arrIps = this.collectorDao.getAllCollectorIP();
                if (arrIps.length > 0) {
                    int succeedResult = 0;
                    for (int i = 0; i < arrIps.length; ++i) {
                        MssConfService client = this.collectorRMIProxy.getMssConfService(arrIps[i]);
                        if (client != null) {
                            boolean collectorUpdateSucceed = client.updateSftpConf(conf);
                            if (collectorUpdateSucceed) {
                                ++succeedResult;
                                continue;
                            }
                            this.logger.error((Object)("collector updateSftpConf failed. collectorIp:" + arrIps[i]));
                            continue;
                        }
                        this.logger.error((Object)("collector updateSftpConf failed. MssConfService is null. collectorIp:" + arrIps[i]));
                    }
                    if (succeedResult == arrIps.length) {
                        allCollectorSucceed = true;
                    }
                }
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"collector updateMssSftpConf failed!");
        }
        catch (RemoteException e) {
            this.logger.error((Object)"collector updateMssSftpConf failed!", (Throwable)e);
        }
        finally {
            result = allCollectorSucceed ? "succeed" : "collectorfailed";
        }
        return result;
    }
}

