/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.collector.entity.ServiceLearningTask;
import com.hs.atic.rmi.ServiceLearningData;
import com.hs.atic.rmi.ServiceLearningRmiService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.ServiceLearningForm;
import com.hs.atic.sdk.bis.service.IServiceLearningService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ServiceLearningServiceImpl
implements IServiceLearningService {
    private static final String SERVICE_LEARNNING_NOCONFIRMED = "0";
    private static final String SERVICE_LEARNNING_CONFIRMED = "1";
    private static final int GGP = 3;
    private static final int IPINIP = 4;
    private static final int GRE = 47;
    private static final int ESP = 50;
    private static final int AH = 51;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IAticDeviceService aticDeviceService;
    private IZoneServiceService zoneServiceService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    private String getCollectorIp(String deviceIp) {
        AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (null == device) {
            throw new LegoCheckedException(570504L);
        }
        Long deviceId = device.getMoId();
        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(deviceId);
        if (collectorId != null) {
            CollectorInfo info = this.collectorService.getCollectorInfo(collectorId.longValue());
            return info.getIpAddress();
        }
        throw new LegoCheckedException(570504L);
    }

    @Override
    public void addServiceLearningTask(String zoneId, String deviceIp, String startTime, String stopTime) {
        ServiceLearningRmiService service = this.getCollectorService(deviceIp);
        if (null == service) {
            throw new LegoCheckedException(570504L);
        }
        try {
            ServiceLearningTask task = new ServiceLearningTask();
            task.setDeviceIp(deviceIp);
            task.setZoneId(zoneId == null ? 0L : Long.parseLong(zoneId));
            task.setStartTime(startTime);
            task.setStopTime(stopTime);
            service.addServiceLearningTask(task);
        }
        catch (Exception e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
    }

    @Override
    public void removeServiceLearningTask(String zoneId, String deviceIp) {
        ServiceLearningRmiService service = this.getCollectorService(deviceIp);
        if (null == service) {
            return;
        }
        try {
            ServiceLearningTask task = new ServiceLearningTask();
            task.setDeviceIp(deviceIp);
            task.setZoneId(zoneId == null ? 0L : Long.parseLong(zoneId));
            service.removeServiceLearningTask(task);
        }
        catch (Exception e) {
            this.logger.error((Object)"removeServiceLearningTask error", (Throwable)e);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private ServiceLearningRmiService getCollectorService(String deviceIp) {
        ServiceLearningRmiService service;
        this.logger.info((Object)("deviceIp:" + this.getcleanedMessage(deviceIp)));
        try {
            service = this.collectorRMIProxy.getServiceLearningRmiService(this.getCollectorIp(deviceIp));
        }
        catch (Exception e) {
            service = null;
        }
        return service;
    }

    private List<ZoneServiceForm> getZoneServiceForms(String zoneId, String devId) {
        return this.zoneServiceService.queryAllZoneService(zoneId, devId);
    }

    @Override
    public Paging getServiceLearningData(Map<String, Object> queryMap) {
        List<ServiceLearningData> serviceLearningDatas;
        String deviceIp = (String)queryMap.get("deviceIP");
        String deviceId = (String)queryMap.get("deviceId");
        String zoneId = (String)queryMap.get("zoneId");
        if (AticUtil.isNull((String)deviceIp) || "".equals(deviceIp)) {
            return null;
        }
        ServiceLearningRmiService service = this.getCollectorService(deviceIp);
        if (service == null) {
            throw new LegoCheckedException(570504L);
        }
        try {
            serviceLearningDatas = service.getServiceLearingData(queryMap);
        }
        catch (Exception e1) {
            throw new LegoCheckedException(570504L, (Throwable)e1);
        }
        if (null == serviceLearningDatas || serviceLearningDatas.isEmpty()) {
            Paging page = new Paging();
            page.setData(new ArrayList());
            page.setCount(0);
            return page;
        }
        List<ZoneServiceForm> zoneServiceForms = this.getZoneServiceForms(zoneId, deviceId);
        Paging page = this.transformData2Form(serviceLearningDatas, zoneServiceForms, queryMap);
        return page;
    }

    private List<ServiceLearningData> transformZoneSrv2LearningData(List<ZoneServiceForm> zoneServiceForms) {
        ArrayList<ServiceLearningData> result = new ArrayList<ServiceLearningData>();
        if (null != zoneServiceForms && !zoneServiceForms.isEmpty()) {
            for (ZoneServiceForm form : zoneServiceForms) {
                if ("DEFAULT".equals(form.getProtocol())) continue;
                result.addAll(this.transformSingeZoneServices2Data(form));
            }
        }
        return result;
    }

    private List<ServiceLearningData> transformSingeZoneServices2Data(ZoneServiceForm form) {
        ArrayList<ServiceLearningData> list = new ArrayList<ServiceLearningData>();
        String protocol = form.getProtocol();
        String portList = form.getPortList();
        String ipList = form.getIpList();
        String[] ipArray = ipList.split(";");
        String[] portArray = "Other".equals(protocol) ? new String[]{SERVICE_LEARNNING_NOCONFIRMED} : portList.split(";");
        for (String port : portArray) {
            for (String ip : ipArray) {
                ServiceLearningData data = new ServiceLearningData();
                data.setServiceType(form.getProtocol());
                data.setPort(Long.parseLong(port));
                data.setServiceName(form.getServiceName());
                data.setZoneIp(ip);
                if ("Other".equals(protocol)) {
                    data.setProtocolNum(form.getProtocolNum());
                } else {
                    data.setProtocolNum(0);
                }
                list.add(data);
            }
        }
        return list;
    }

    private boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    private Paging transformData2Form(List<ServiceLearningData> datas, List<ZoneServiceForm> zoneServiceForms, Map<String, Object> queryMap) {
        List<ServiceLearningData> subServiceLearningDatas;
        Paging page = new Paging();
        ArrayList<ServiceLearningForm> forms = new ArrayList<ServiceLearningForm>();
        ArrayList<ServiceLearningData> result = new ArrayList<ServiceLearningData>();
        String deviceId = (String)queryMap.get("deviceId");
        String state = (String)queryMap.get("state");
        String queryName = (String)queryMap.get("serviceName");
        List<ServiceLearningData> transformDatas = this.transformZoneSrv2LearningData(zoneServiceForms);
        for (ServiceLearningData data : datas) {
            if (SERVICE_LEARNNING_NOCONFIRMED.equals(state) && transformDatas.contains(data) || SERVICE_LEARNNING_CONFIRMED.equals(state) && !transformDatas.contains(data)) continue;
            if (transformDatas.contains(data)) {
                data.setState(SERVICE_LEARNNING_CONFIRMED);
                data.setServiceName(transformDatas.get(transformDatas.indexOf(data)).getServiceName());
            } else {
                data.setState(SERVICE_LEARNNING_NOCONFIRMED);
            }
            if (!this.isNull(queryName) && !data.getServiceName().toLowerCase(Locale.getDefault()).contains(queryName.toLowerCase(Locale.getDefault()))) continue;
            result.add(data);
        }
        if (result.isEmpty()) {
            page.setData(forms);
            page.setCount(0);
            return page;
        }
        if (null == queryMap.get("autoEffect") || !((Boolean)queryMap.get("autoEffect")).booleanValue()) {
            int start = this.getPageStart(queryMap);
            int pageSize = this.getPageSize(queryMap);
            int resultSize = result.size();
            int end = start + pageSize;
            if (start >= resultSize) {
                start = resultSize - (resultSize % pageSize == 0 ? pageSize : resultSize % pageSize);
                start = start > 0 ? start : 0;
                end = resultSize;
            } else if (end > resultSize) {
                end = resultSize;
            }
            subServiceLearningDatas = result.subList(start, end);
        } else {
            subServiceLearningDatas = result;
        }
        for (ServiceLearningData each : subServiceLearningDatas) {
            ServiceLearningForm serviceLearningForm = new ServiceLearningForm();
            AticUtil.copyProperties((Object)each, (Object)serviceLearningForm);
            serviceLearningForm.setDeviceId(deviceId);
            if ("Other".equals(serviceLearningForm.getServiceType())) {
                serviceLearningForm.setServiceType(String.valueOf(each.getProtocolNum()));
                serviceLearningForm.setServiceTypeDisplay(this.getOtherDisplay(each.getProtocolNum()));
            } else {
                serviceLearningForm.setServiceTypeDisplay(serviceLearningForm.getServiceType());
            }
            forms.add(serviceLearningForm);
        }
        page.setData(forms);
        page.setCount(result.size());
        return page;
    }

    private String getOtherDisplay(Integer protocol) {
        switch (protocol) {
            case 3: {
                return "GGP";
            }
            case 4: {
                return "IP-in-IP";
            }
            case 47: {
                return "GRE";
            }
            case 50: {
                return "ESP";
            }
            case 51: {
                return "AH";
            }
        }
        return protocol + "";
    }

    private int getPageStart(Map<String, Object> queryMap) {
        int start = queryMap.get("start") == null ? 0 : Integer.parseInt((String)queryMap.get("start"));
        return start;
    }

    private int getPageSize(Map<String, Object> queryMap) {
        int pageSize = queryMap.get("pageSize") == null ? 10 : Integer.parseInt((String)queryMap.get("pageSize"));
        return pageSize;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

