/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.alarm.entity.AlarmDevInfo;
import com.hs.atic.alarm.entity.AlarmZoneInfo;
import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.collector.entity.alarm.DnsDefendAlarmEntity;
import com.hs.atic.collector.entity.alarm.DynBlistAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.atic.rmi.IpStateData;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.syslog.entity.NfaAnomalyEntity;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IVpnDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.IDelBlackholeScheduler;
import com.huawei.atic.policy.third.service.IDelDivertScheduler;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ZoneAlarmHandler {
    public static final int BLACK_LIST_ATTACKTYPE_OF_HTTP_FLOOD = 3;
    public static final int BLACK_LIST_ATTACKTYPE_OF_URL_MONITOR = 4;
    public static final int BLACK_LIST_ATTACKTYPE_OF_TCP_CONNECTION_FLOOD = 5;
    public static final int BLACK_LIST_ATTACKTYPE_OF_SLOW_ATTACK = 6;
    public static final int BLACK_LIST_ATTACKTYPE_OF_HTTPS_FLOOD = 7;
    public static final int BLACK_LIST_ATTACKTYPE_OF_HOST_FILTER = 12;
    public static final int BLACK_LIST_ATTACKTYPE_OF_FINGER_SHOOT = 14;
    public static final int DDOS_BLACKLIST_SLOW_HTTP = 15;
    public static final int DDOS_BLACKLIST_MALWARE = 16;
    public static final int DDOS_BLACKLIST_HTTP_FILTER_AUTOADD = 17;
    public static final int BLACK_LIST_ATTACKTYPE_HTTPS_ERROR_CODE_CHECK = 21;
    public static final int BLACK_LIST_ATTACKTYPE_HTTPS_FINGERPRINT = 22;
    public static final int DEFEND_SCPOE_1 = 1;
    public static final int DEFEND_SCPOE_2 = 2;
    public static final int DEFEND_SCPOE_3 = 3;
    public static final int DEFEND_SCPOE_4 = 4;
    public static final int HTTP_FLOOD = 27;
    private static final int CLEARCACHEINTERVAL = 30000;
    private static Map<Long, AlarmZoneInfo> zoneCache = new HashMap<Long, AlarmZoneInfo>();
    private static Map<String, AlarmDevInfo> deviceCache = new HashMap<String, AlarmDevInfo>();
    private static Map<Long, String> blackListRecords = new HashMap<Long, String>();
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private long clearcachetime = System.currentTimeMillis();
    private ICommonUtilService commonUtilService;
    private IAlarmService alarmService;
    private IAticDeviceService aticDeviceService;
    private IFilterService filterService;
    private IZoneService zoneService;
    private IZoneDeviceService zoneDeviceService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private CollectorDao collectorDao;
    private IDelDivertScheduler delDivertScheduler;
    private IDelBlackholeScheduler delBlackholeScheduler;
    private PageSizeConfigService pageSizeConfigService;
    private INpFilterService npFilterService;
    private int defaultUnBolockTime = 0;

    public void clearCache() {
        if (System.currentTimeMillis() - this.clearcachetime > 30000L) {
            zoneCache.clear();
            deviceCache.clear();
            this.clearcachetime = System.currentTimeMillis();
        }
    }

    public void dnsDefendAlarm(List<DnsDefendAlarmEntity> dnsDefendAlarmList) {
        if (!dnsDefendAlarmList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (DnsDefendAlarmEntity entity : dnsDefendAlarmList) {
                AticAlarmObject obj = this.generateDnsDefendAlarm(entity);
                alarmObjectList.add(obj);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
    }

    private AticAlarmObject generateDnsDefendAlarm(DnsDefendAlarmEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        String[] param = new String[4];
        String deviceName = "";
        long deviceMoId = 0L;
        AlarmDevInfo device = this.getDeviceFromCache(entity.getDeviceIp());
        if (null != device) {
            deviceName = device.getDevName();
            deviceMoId = device.getMoId();
        }
        int deviceType = entity.getDeviceType();
        String deviceTypeResoure = Constant.DEVICE_SERVICE_TYPE_CLEAN == deviceType ? "com.hs.atic.alart.divert.type.clean" : "com.hs.atic.alart.device.type.detect";
        param[0] = deviceName;
        param[1] = entity.getDeviceIp();
        param[2] = deviceTypeResoure;
        param[3] = entity.getDomainName();
        alarmObject.setAlarmId("0x0000000803240813");
        alarmObject.setAlarmParam(param);
        alarmObject.setIsAlarm(entity.getIsAlarm());
        alarmObject.setMoId(Long.valueOf(deviceMoId));
        alarmObject.setExtendMoId(Long.valueOf(0L));
        alarmObject.setMoName(deviceName);
        alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.MINOR);
        alarmObject.setMoIp(entity.getDeviceIp());
        alarmObject.setAlertTime(entity.getAlermTime());
        return alarmObject;
    }

    private AlarmDevInfo getDeviceFromCache(String deviceIp) {
        if (deviceCache.containsKey(deviceIp)) {
            return deviceCache.get(deviceIp);
        }
        AticDevice device = null;
        if (null != this.aticDeviceService) {
            device = this.aticDeviceService.getDeviceByIp(deviceIp);
        }
        if (null != device) {
            AlarmDevInfo info = new AlarmDevInfo();
            info.setDevName(device.getName());
            info.setMoId(device.getMoId());
            deviceCache.put(deviceIp, info);
            return info;
        }
        return null;
    }

    private AlarmZoneInfo getZoneFromCache(long zoneId) {
        if (zoneCache.containsKey(zoneId)) {
            return zoneCache.get(zoneId);
        }
        ZoneInfoForm form = this.zoneService.getZoneNOIpById(zoneId);
        if (null != form) {
            AlarmZoneInfo info = new AlarmZoneInfo();
            info.setMoId(form.getMoId());
            info.setZoneType(form.getZoneType());
            info.setZoneName(form.getZoneDesc());
            ZonePolicyApplyForm applyForm = this.zonePolicyApplyService.queryByZoneId(zoneId);
            if (null == applyForm) {
                info.setDefendMode(0);
            } else {
                info.setDefendMode(applyForm.getDefendMode());
            }
            zoneCache.put(zoneId, info);
            return info;
        }
        return null;
    }

    public void abnormalAlarm(List<IpAlarmEntity> alertList) {
        if (!alertList.isEmpty()) {
            ArrayList<IpStateData> ipStateDataList = new ArrayList<IpStateData>();
            IpStateData ipStateData = null;
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (IpAlarmEntity alarmEntity : alertList) {
                if (alarmEntity.isIsAlarm()) {
                    List<AbnormalAlarmEntity> abnolmalList = alarmEntity.getAbnolmalList();
                    for (int i = abnolmalList.size() - 1; i >= 0; --i) {
                        AbnormalAlarmEntity abnormalEntity = abnolmalList.get(i);
                        if (abnormalEntity.isAlarm()) continue;
                        abnolmalList.remove(i);
                    }
                } else {
                    ipStateData = this.generateIpStateData(alarmEntity);
                    ipStateDataList.add(ipStateData);
                    logger.info((Object)("divert ipStateData :" + ipStateData.toString()));
                }
                AticAlarmObject alarmObject = this.generateAbnormalAlarm(alarmEntity);
                alarmObjectList.add(alarmObject);
            }
            if (!ipStateDataList.isEmpty()) {
                this.delDivertScheduler = this.getDelDivertScheduler();
                this.delDivertScheduler.addIpStateData(ipStateDataList);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
    }

    public void zoneDivertAlarm(List<IpAlarmEntity> alertList) {
        if (!alertList.isEmpty()) {
            ArrayList<IpStateData> ipStateDataList = new ArrayList<IpStateData>();
            IpStateData ipStateData = null;
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (IpAlarmEntity alarmEntity : alertList) {
                if (alarmEntity.isIsAlarm()) {
                    List<AbnormalAlarmEntity> abnolmalList = alarmEntity.getAbnolmalList();
                    for (int i = abnolmalList.size() - 1; i >= 0; --i) {
                        AbnormalAlarmEntity abnormalEntity = abnolmalList.get(i);
                        if (abnormalEntity.isAlarm()) continue;
                        abnolmalList.remove(i);
                    }
                }
                ipStateData = this.generateIpStateData(alarmEntity);
                logger.info((Object)("divert ipStateData :" + ipStateData.toString()));
                if (ipStateData.getPolicy() != 0) {
                    ipStateDataList.add(ipStateData);
                }
                AticAlarmObject alarmObject = this.generateAbnormalAlarm(alarmEntity);
                alarmObjectList.add(alarmObject);
            }
            if (!ipStateDataList.isEmpty()) {
                this.delDivertScheduler = this.getDelDivertScheduler();
                this.delDivertScheduler.addIpStateData(ipStateDataList);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
    }

    public void zoneBlackholeAlarm(List<IpAlarmEntity> alertList) {
        if (!alertList.isEmpty()) {
            ArrayList<IpStateData> blackholeDataList = new ArrayList<IpStateData>();
            IpStateData ipStateData = null;
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (IpAlarmEntity alarmEntity : alertList) {
                if (alarmEntity.isIsAlarm()) {
                    List<AbnormalAlarmEntity> abnolmalList = alarmEntity.getAbnolmalList();
                    for (int i = abnolmalList.size() - 1; i >= 0; --i) {
                        AbnormalAlarmEntity abnormalEntity = abnolmalList.get(i);
                        if (abnormalEntity.isAlarm()) continue;
                        abnolmalList.remove(i);
                    }
                }
                ipStateData = this.generateIpStateData(alarmEntity);
                logger.info((Object)("blackhole ipStateData :" + ipStateData.toString()));
                if (ipStateData.getPolicy() != 0) {
                    blackholeDataList.add(ipStateData);
                }
                AticAlarmObject alarmObject = this.generateAbnormalAlarm(alarmEntity);
                alarmObjectList.add(alarmObject);
            }
            if (!blackholeDataList.isEmpty()) {
                this.delBlackholeScheduler = this.getDelBlackholeScheduler();
                this.delBlackholeScheduler.addIpStateData(blackholeDataList);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
    }

    private IpStateData generateIpStateData(IpAlarmEntity alarmEntity) {
        logger.info((Object)("outbound IpAlarmEntity:" + alarmEntity.toString()));
        IpStateData ipStateData = new IpStateData(alarmEntity.getZoneIp(), alarmEntity.getZoneId(), alarmEntity.getDeviceIp());
        ipStateData.setFromCleanDevice(alarmEntity.getDeviceType() == 0);
        ipStateData.setAlarm(alarmEntity.isIsAlarm());
        ipStateData.setDirection(alarmEntity.getDirection());
        if (!alarmEntity.isIsAlarm() && 1 == alarmEntity.getDirection()) {
            ipStateData.setPolicy(9);
        } else if (!alarmEntity.isIsAlarm() && 2 == alarmEntity.getDirection()) {
            ipStateData.setPolicy(98);
        } else if (99 == alarmEntity.getDiversionAction()) {
            ZonePolicyApplyForm applyForm = this.zonePolicyApplyService.queryByZoneId(alarmEntity.getZoneId());
            if (ZoneConstants.BLACKHOLE_TYPE_INTERFACEBOARD.equals(applyForm.getBlackholeType())) {
                ipStateData.setPolicy(6);
            } else if (ZoneConstants.BLACKHOLE_TYPE_ROUTE.equals(applyForm.getBlackholeType())) {
                ipStateData.setPolicy(3);
            } else {
                ipStateData.setPolicy(4);
            }
        } else {
            ipStateData.setPolicy(alarmEntity.getDiversionAction());
        }
        return ipStateData;
    }

    private AticAlarmObject generateAbnormalAlarm(IpAlarmEntity entity) {
        Long deviceId = 0L;
        AlarmDevInfo device = this.getDeviceFromCache(entity.getDeviceIp());
        if (null != device) {
            deviceId = device.getMoId();
        }
        String zoneName = "";
        long zoneMoId = 0L;
        AlarmZoneInfo zoneInfo = this.getZoneFromCache(entity.getZoneId());
        if (null != zoneInfo) {
            zoneName = zoneInfo.getZoneName();
            zoneMoId = zoneInfo.getMoId();
        }
        AticAlarmObject alarmObject = new AticAlarmObject();
        String[] alarm = this.assembleAbnormalAlarmInfo(entity);
        alarmObject.setAlarmId("0x0000000803240801");
        alarmObject.setAlarmParam(alarm);
        alarmObject.setIsAlarm(Boolean.valueOf(entity.isIsAlarm()));
        alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.getSeverity((int)entity.getSeverity()));
        alarmObject.setMoId(Long.valueOf(zoneMoId));
        alarmObject.setMoName(zoneName);
        alarmObject.setMoIp(entity.getZoneIp());
        alarmObject.setExtendMoId(deviceId);
        alarmObject.setAlertTime(entity.getBeginTime());
        return alarmObject;
    }

    private String[] assembleSyslogAbnormalInfo(NfaAnomalyEntity entity) {
        String[] paramTemp = new String[8];
        String deviceIp = entity.getDevIp();
        String zoneName = "--";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("currentUserId", "1");
        queryMap.put("currentUserIsAdmin", "true");
        queryMap.put("queryIpAddress", entity.getDstIp1());
        Paging result = this.zoneService.queryByPage(queryMap, 0, 10);
        List zoneInfos = result.getData();
        Long zoneMoId = 0L;
        if (!zoneInfos.isEmpty()) {
            ZoneInfoForm zoneInfo = (ZoneInfoForm)zoneInfos.get(0);
            zoneName = zoneInfo.getZoneDesc();
            zoneMoId = zoneInfo.getMoId();
        } else {
            Long defaultZoneId = this.zoneDeviceService.getDefaultZoneIdByDevId(Long.valueOf(entity.getDeviceId()));
            if (null != defaultZoneId) {
                AlarmZoneInfo zoneInfo = this.getZoneFromCache(defaultZoneId);
                if (null != zoneInfo) {
                    zoneName = zoneInfo.getZoneName();
                    zoneMoId = zoneInfo.getMoId();
                } else {
                    logger.error((Object)"zoneInfo is null");
                    return paramTemp;
                }
            }
        }
        String dstIp = entity.getDstIp1();
        String attackType = entity.getSubType();
        String threshold = entity.getThreshold() + entity.getUnit();
        String current = entity.getCurrent() + entity.getUnit();
        paramTemp[0] = deviceIp;
        paramTemp[1] = zoneName;
        paramTemp[2] = dstIp;
        paramTemp[3] = attackType;
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("1", "SYN Flood");
        typeMap.put("2", "SYN-ACK Flood");
        typeMap.put("3", "FIN/RST Flood");
        typeMap.put("4", "HTTP Flood");
        typeMap.put("5", "New Connections Flood");
        typeMap.put("6", "UDP Bandwidth Overflow");
        typeMap.put("7", "UDP Flood");
        typeMap.put("8", "TCP Flood");
        typeMap.put("9", "ICMP Abnormal");
        typeMap.put("10", "Fragment Flood");
        typeMap.put("11", "DNS Flood");
        typeMap.put("12", "SIP Flood");
        for (Map.Entry key : typeMap.entrySet()) {
            if (!StringUtils.equals((CharSequence)((CharSequence)key.getKey()), (CharSequence)attackType)) continue;
            paramTemp[3] = (String)typeMap.get(key.getKey());
            break;
        }
        paramTemp[4] = threshold;
        paramTemp[5] = current;
        paramTemp[6] = zoneMoId.toString();
        paramTemp[7] = null == entity.getSeverity() || "".equals(entity.getSeverity()) ? "--" : entity.getSeverity();
        return paramTemp;
    }

    private AticAlarmObject generateSyslogAbnormalAlarm(NfaAnomalyEntity entity) {
        AticAlarmObject alarmObject = new AticAlarmObject();
        String[] param = this.assembleSyslogAbnormalInfo(entity);
        alarmObject.setAlarmId("0x0000000803240816");
        alarmObject.setAlarmParam(param);
        if (entity.getStatus().trim().equalsIgnoreCase("Ongoing")) {
            alarmObject.setIsAlarm(Boolean.valueOf(true));
        } else {
            alarmObject.setIsAlarm(Boolean.valueOf(false));
        }
        alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.getSeverity((int)3));
        if ("0".equals(param[6])) {
            String deviceName = "";
            String devIp = entity.getDevIp();
            AlarmDevInfo device = this.getDeviceFromCache(devIp);
            if (null != device) {
                deviceName = device.getDevName();
            }
            alarmObject.setMoId(Long.valueOf(entity.getDeviceId()));
            alarmObject.setExtendMoId(Long.valueOf(param[6]));
            alarmObject.setMoName(deviceName);
            alarmObject.setMoIp(devIp);
        } else {
            alarmObject.setMoId(Long.valueOf(param[6]));
            alarmObject.setExtendMoId(Long.valueOf(entity.getDeviceId()));
            alarmObject.setMoName(param[1]);
            alarmObject.setMoIp(entity.getDstIp1());
        }
        alarmObject.setAlertTime(entity.getAticTime() * 1000L);
        return alarmObject;
    }

    public void syslogAbnormalAlarm(List<NfaAnomalyEntity> nfaList) {
        if (!nfaList.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (NfaAnomalyEntity entity : nfaList) {
                AticAlarmObject obj = this.generateSyslogAbnormalAlarm(entity);
                alarmObjectList.add(obj);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
    }

    private String getDefendModeResource(int defendMode) {
        switch (defendMode) {
            case 0: {
                return "com.hs.atic.alart.defendMode.auto";
            }
            case 1: {
                return "com.hs.atic.alart.defendMode.manual";
            }
        }
        return "com.hs.atic.alart.defendMode.no.defend";
    }

    private String[] assembleAbnormalAlarmInfo(IpAlarmEntity entity) {
        String[] param = new String[8 + 5 * entity.getAbnolmalList().size()];
        int i = 0;
        for (AbnormalAlarmEntity alarmEntity : entity.getAbnolmalList()) {
            NPFilterForm npfilterTemp;
            FilterForm filterTemp;
            int attackTypeValue = alarmEntity.getAlertTypeValue();
            String attackType = "";
            long filterId = 0L;
            if (2000 == attackTypeValue) {
                attackType = "atic.attack.type.62";
            }
            attackType = attackTypeValue > 2000 && attackTypeValue < 80000 ? (null != (filterTemp = this.filterService.queryFilterName(filterId = (long)(attackTypeValue - 2000))) && !AticUtil.isNull((String)filterTemp.getFilterName()) ? filterTemp.getFilterName() : "Unknown Filter " + filterId) : (attackTypeValue >= 80000 ? (attackTypeValue == 80000 ? "com.hs.atic.alart.attack.attackType.80000" : (null != (npfilterTemp = this.npFilterService.queryNPFilterFormByfilterId(filterId = (long)(attackTypeValue - 80000))) && !AticUtil.isNull((String)npfilterTemp.getFilterName()) ? npfilterTemp.getFilterName() : "com.hs.atic.alart.attack.attackType.80000")) : "com.hs.atic.alart.attack.attackType." + attackTypeValue);
            String unit = AticConstants.attackLogThresholdTrans((int)alarmEntity.getPpsOrKbps());
            String unit1 = AticConstants.attackLogThresholdTrans((int)alarmEntity.getPpsOrKbps1());
            String limitValue = "-";
            if (alarmEntity.getLimitValue() > 0L || alarmEntity.getLimitValue1() > 0L) {
                limitValue = (alarmEntity.getLimitValue() > 0L ? alarmEntity.getLimitValue() + unit : "-") + "/" + (alarmEntity.getLimitValue1() > 0L ? alarmEntity.getLimitValue1() + unit1 : "-");
            }
            String currentValue = "-";
            if (alarmEntity.getCurrentValue() > 0L || alarmEntity.getCurrentValue1() > 0L) {
                currentValue = (alarmEntity.getCurrentValue() > 0L ? alarmEntity.getCurrentValue() + unit : "-") + "/" + (alarmEntity.getCurrentValue1() > 0L ? alarmEntity.getCurrentValue1() + unit1 : "-");
            }
            String attacker = "-";
            if (null != alarmEntity.getAttacker() && !"".equals(alarmEntity.getAttacker())) {
                attacker = alarmEntity.getAttacker();
            }
            param[8 + i * 5] = attackType;
            param[9 + i * 5] = limitValue;
            param[10 + i * 5] = currentValue;
            param[11 + i * 5] = this.queryDestinationPort(alarmEntity.getPorts());
            param[12 + i * 5] = attacker;
            ++i;
        }
        try {
            ZoneDeviceForm zoneDeviceForm;
            int deviceType;
            String deviceIp = entity.getDeviceIp();
            long zoneId = entity.getZoneId();
            String zoneIp = entity.getZoneIp();
            String deviceName = "";
            Long deviceId = 0L;
            AlarmDevInfo device = this.getDeviceFromCache(deviceIp);
            if (null != device) {
                deviceName = device.getDevName();
                deviceId = device.getMoId();
            }
            String zoneName = "";
            int zoneDefendMode = 0;
            int zoneType = 0;
            AlarmZoneInfo zoneInfo = this.getZoneFromCache(zoneId);
            if (null != zoneInfo) {
                zoneName = zoneInfo.getZoneName();
                zoneDefendMode = zoneInfo.getDefendMode();
                zoneType = zoneInfo.getZoneType();
            }
            String deviceTypeResoure = (deviceType = entity.getDeviceType()) == 0 ? "com.hs.atic.alart.divert.type.clean" : "com.hs.atic.alart.device.type.detect";
            String realMode = this.getDefendModeResource(zoneDefendMode);
            String attackDirection = "inbound";
            if (entity.getDirection() != 1) {
                attackDirection = "outbound";
            }
            param[0] = deviceName;
            param[1] = deviceIp;
            param[2] = deviceTypeResoure;
            param[3] = zoneName;
            param[4] = zoneIp;
            param[5] = realMode;
            param[6] = "--";
            param[7] = attackDirection;
            String vpnName = null;
            int ipv4Mask = 32;
            int ipv6Mask = 128;
            if (1 == zoneType) {
                IVpnDeviceService vpnDeviceService = ZoneReferUtil.getVpnDeviceService();
                if (vpnDeviceService.isVpnExcluded(deviceId, zoneId, zoneIp, IPUtil.isIpv4((String)zoneIp) ? ipv4Mask : ipv6Mask)) {
                    return param;
                }
                if (!vpnDeviceService.isVpnIncluded(deviceId, zoneId)) {
                    logger.info((Object)"vpnDeviceService.isVpnIncluded() is false");
                } else {
                    vpnName = vpnDeviceService.getIncludedVpn(deviceId, zoneId, zoneIp, IPUtil.isIpv4((String)zoneIp) ? ipv4Mask : ipv6Mask);
                }
            }
            if ((null == vpnName || "".equals(vpnName)) && null != (zoneDeviceForm = this.zoneDeviceService.getByZoneIdAndDeviceid(Long.valueOf(zoneId), deviceId))) {
                vpnName = zoneDeviceForm.getVpnName();
            }
            if (null != vpnName && !"".equals(vpnName)) {
                param[6] = vpnName;
            }
        }
        catch (Exception e) {
            logger.error((Object)"assemble alarm info error", (Throwable)e);
        }
        return param;
    }

    private String queryDestinationPort(String destinationPort) {
        String[] array;
        if (destinationPort.isEmpty() || "0".equals(destinationPort)) {
            return "-";
        }
        HashSet<String> portSet = new HashSet<String>();
        for (String s : array = destinationPort.split(",")) {
            if ("0".equals(s)) continue;
            portSet.add(s);
        }
        String[] ports = new String[portSet.size()];
        portSet.toArray(ports);
        int len = ports.length >= 5 ? 5 : ports.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(ports[i]).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String getProtocolString(String protocol) {
        if ("6".equals(protocol)) {
            return "TCP";
        }
        if ("17".equals(protocol)) {
            return "UDP";
        }
        if ("1".equals(protocol)) {
            return "ICMP";
        }
        return "OTHER";
    }

    private String[] assembleBlistAlarmInfo(DynBlistAlarmEntity each) {
        String[] param = new String[9];
        try {
            boolean isAuto;
            String deviceIp = each.getDeviceIp();
            long zoneId = each.getZoneId();
            int black = each.getBlackListType();
            String blackType = this.getBlackType(black);
            String blackIp = each.getBlackIp();
            String deviceName = "";
            AlarmDevInfo device = this.getDeviceFromCache(deviceIp);
            if (null != device) {
                deviceName = device.getDevName();
            }
            String zoneName = "";
            AlarmZoneInfo zoneInfo = this.getZoneFromCache(zoneId);
            if (null != zoneInfo) {
                zoneName = zoneInfo.getZoneName();
            }
            String mode = "";
            mode = null != each.getIsAuto() ? ((isAuto = each.getIsAuto().booleanValue()) ? "com.hs.atic.alart.blacklist.confirm.auto" : "com.hs.atic.alart.blacklist.confirm.manual") : "com.hs.atic.alart.blacklist.confirm.auto";
            String protocol = this.getProtocolString(String.valueOf(each.getProtocol()));
            param[0] = deviceName;
            param[1] = deviceIp;
            param[2] = zoneName;
            param[3] = each.getZoneIp();
            param[4] = blackType;
            param[5] = blackIp;
            param[6] = protocol;
            param[7] = String.valueOf(each.getPort());
            param[8] = mode;
        }
        catch (Exception e) {
            logger.error((Object)"assemble alarm info error", (Throwable)e);
        }
        return param;
    }

    private String getBlackType(int blackType) {
        switch (blackType) {
            case 3: {
                return "HTTP Flood";
            }
            case 4: {
                return "URI Monitor";
            }
            case 5: {
                return "TCP Connection Flood";
            }
            case 6: {
                return "Slow Attack";
            }
            case 7: {
                return "HTTPS Flood";
            }
            case 12: {
                return "Host Filter";
            }
            case 14: {
                return "Fingerprint Matching";
            }
            case 15: {
                return "Slow Http Attack";
            }
            case 16: {
                return "Malware Attack";
            }
            case 17: {
                return "Filter Drop";
            }
            case 21: {
                return "Https Error-Code Check";
            }
            case 22: {
                return "Https Fingerprint";
            }
        }
        return "";
    }

    public void blackListAlarm(List<DynBlistAlarmEntity> dynAlarm) {
        if (!dynAlarm.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (DynBlistAlarmEntity entity : dynAlarm) {
                AticAlarmObject alarmObject = new AticAlarmObject();
                String[] alarm = this.assembleBlistAlarmInfo(entity);
                long zoneMoId = 0L;
                String zoneName = "";
                AlarmZoneInfo zoneInfo = this.getZoneFromCache(entity.getZoneId());
                if (null != zoneInfo) {
                    zoneMoId = zoneInfo.getMoId();
                    zoneName = zoneInfo.getZoneName();
                }
                long deviceMoId = 0L;
                AlarmDevInfo device = this.getDeviceFromCache(entity.getDeviceIp());
                if (null != device) {
                    deviceMoId = device.getMoId();
                }
                FaultEnum.AlarmSeverity alarmSeverity = null;
                Boolean isAuto = entity.getIsAuto();
                alarmSeverity = null != isAuto && isAuto != false ? FaultEnum.AlarmSeverity.MINOR : FaultEnum.AlarmSeverity.CRITICAL;
                alarmObject.setAlarmId("0x0000000803240804");
                alarmObject.setAlarmParam(alarm);
                alarmObject.setIsAlarm(entity.getIsAlarm());
                alarmObject.setAlertTime(entity.getAlertTime());
                alarmObject.setAlertLevel(alarmSeverity);
                alarmObject.setExtendMoId(Long.valueOf(deviceMoId));
                alarmObject.setMoId(Long.valueOf(zoneMoId));
                alarmObject.setMoName(zoneName);
                alarmObject.setMoIp(entity.getZoneIp());
                alarmObjectList.add(alarmObject);
            }
            if (!alarmObjectList.isEmpty()) {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
        }
        blackListRecords.clear();
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IDelDivertScheduler getDelDivertScheduler() {
        if (null == this.delDivertScheduler) {
            this.delDivertScheduler = ZoneReferUtil.getDelDivertScheduler();
        }
        return this.delDivertScheduler;
    }

    public IDelBlackholeScheduler getDelBlackholeScheduler() {
        if (null == this.delBlackholeScheduler) {
            this.delBlackholeScheduler = ZoneReferUtil.getDelBlackholeScheduler();
        }
        return this.delBlackholeScheduler;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public PageSizeConfigService getPageSizeConfigService() {
        return this.pageSizeConfigService;
    }

    public void setPageSizeConfigService(PageSizeConfigService pageSizeConfigService) {
        this.pageSizeConfigService = pageSizeConfigService;
    }

    public int getDefaultUnBolockTime() {
        return this.defaultUnBolockTime;
    }

    public void setDefaultUnBolockTime(int defaultUnBolockTime) {
        this.defaultUnBolockTime = defaultUnBolockTime;
    }

    public INpFilterService getNpFilterService() {
        return this.npFilterService;
    }

    public void setNpFilterService(INpFilterService npFilterService) {
        this.npFilterService = npFilterService;
    }
}

