/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.service.ZoneStateBuffer;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.rmi.ZoneState;
import com.hs.atic.rmi.ZoneStateService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyCustomService;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.Collector;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class ZoneStateHandler {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private CollectorDao collectorDao;
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IZonePolicyCustomService zonePolicyCustomService;

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public IZonePolicyCustomService getZonePolicyCustomService() {
        return this.zonePolicyCustomService;
    }

    public void setZonePolicyCustomService(IZonePolicyCustomService zonePolicyCustomService) {
        this.zonePolicyCustomService = zonePolicyCustomService;
    }

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public void initZoneState() {
        try {
            this.initZoneStates4Col();
        }
        catch (Exception e) {
            this.logger.error((Object)"initZoneStates4Col error!!!", (Throwable)e);
        }
        if (null == this.zonePolicyCustomService) {
            this.logger.info((Object)"first update zonestate,get zonePolicyCustomService error!!!");
            return;
        }
        try {
            Map<Long, Integer> result = ZoneStateBuffer.getInstance().getAllZoneState();
            this.zonePolicyCustomService.resetAllZoneState();
            this.persistentZoneState(result);
        }
        catch (Exception e) {
            this.logger.error((Object)"resetAllZoneState error!!!", (Throwable)e);
        }
    }

    private void persistentZoneState(Map<Long, Integer> map) {
        for (Map.Entry<Long, Integer> entry : map.entrySet()) {
            this.zonePolicyCustomService.updateZonePolicyApplyOfAbnormalState(entry.getKey(), entry.getValue());
            this.logger.info((Object)("update zone state :zone id =" + entry.getKey() + " abnormal state =" + entry.getValue()));
        }
    }

    private void initZoneStates4Col() {
        List collectorList = this.collectorDao.getAll();
        for (Collector co : collectorList) {
            this.initCollectorZoneState(co);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void initCollectorZoneState(Collector co) {
        try {
            ZoneStateService zoneStateService = this.collectorRMIProxy.getZoneStateService(co.getIpAddress());
            if (zoneStateService != null) {
                List<ZoneState> states = zoneStateService.getAllZoneState();
                for (ZoneState state : states) {
                    ZoneStateBuffer.getInstance().getZoneState(state, co.getIpAddress());
                }
            }
        }
        catch (RemoteException e) {
            this.logger.error((Object)("getCollectorZoneState error!!! " + this.getcleanedMessage(co.getIpAddress())));
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("getCollectorZoneState error!!! " + this.getcleanedMessage(co.getIpAddress())));
        }
    }
}

