/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.VtyConfigService;
import java.io.File;

public final class ZoneBisUtil {
    private ZoneBisUtil() {
    }

    public static IAticDeviceService getIFirewallService() {
        IAticDeviceService firewallService = (IAticDeviceService)AticUtil.getServiceContext().getService("aticDeviceService", IAticDeviceService.class);
        if (firewallService == null) {
            throw new LegoCheckedException(570506L);
        }
        return firewallService;
    }

    public static IZoneDeviceService getIZoneDeviceService() {
        IZoneDeviceService zoneDeviceService = (IZoneDeviceService)AticUtil.getServiceContext().getService("zoneDeviceService", IZoneDeviceService.class);
        if (zoneDeviceService == null) {
            throw new LegoCheckedException(570506L);
        }
        return zoneDeviceService;
    }

    public static IZoneServiceService getIZoneServiceService() {
        IZoneServiceService zoneServiceService = (IZoneServiceService)AticUtil.getServiceContext().getService("zoneServiceService", IZoneServiceService.class);
        if (zoneServiceService == null) {
            throw new LegoCheckedException(570506L);
        }
        return zoneServiceService;
    }

    public static boolean createFile(String importPath) {
        File file = new File(importPath);
        if (!file.exists()) {
            boolean ret = file.mkdir();
            return ret;
        }
        return true;
    }

    public static boolean checkIsErrorCode(String deployStatus) {
        String resource;
        String deployErrorCode = deployStatus;
        if (deployStatus.contains(",")) {
            deployErrorCode = deployErrorCode.split(",")[0];
        }
        return AticUtil.isNum((String)deployErrorCode) != false && !(resource = ZoneBisUtil.getText("lego.err." + deployErrorCode)).equals("lego.err." + deployErrorCode);
    }

    public static String getDeployStatus4Jsp(String deployStatus, boolean unDeploy) {
        String deployStatusJsp = "";
        if (deployStatus.equals("undeployed")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.undeployed");
        } else if (deployStatus.equals("failure")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.failure");
        } else if (deployStatus.equals("success")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.success");
        } else if (deployStatus.equals("deploying")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.deploying");
        } else if (deployStatus.equals("part_suc")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.partSuccess");
        } else if (ZoneBisUtil.checkIsErrorCode(deployStatus)) {
            if (deployStatus.contains(",")) {
                String deployErrorCode = deployStatus.split(",")[0];
                String errorInfo = deployStatus.substring(deployStatus.indexOf(",") + 1);
                deployStatusJsp = ZoneBisUtil.getText("lego.err." + deployErrorCode) + "(" + errorInfo + ")";
            } else {
                deployStatusJsp = ZoneBisUtil.getText("lego.err." + deployStatus);
            }
        } else {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.undeployed");
        }
        return deployStatusJsp;
    }

    public static Long getMoidByZoneid(Long zoneId) {
        Long moid = 0L;
        ServiceContext serviceContext = ServiceContext.getInstance();
        IZoneService zoneService = (IZoneService)serviceContext.getService("zoneService", IZoneService.class);
        ZoneInfoForm zoneInfoForm = zoneService.getById(zoneId);
        if (null != zoneInfoForm) {
            moid = zoneInfoForm.getMoId();
        }
        return moid;
    }

    public static ILicenseOutboundService getLicenseOutboundService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (ILicenseOutboundService)serviceContext.getService("licenseOutboundService", ILicenseOutboundService.class);
    }

    public static VtyConfigService getVtyConfigService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (VtyConfigService)serviceContext.getService("vtyConfigService", VtyConfigService.class);
    }

    public static String getText(String i18n) {
        return LocaleUtil.INSTANCE.getText(i18n);
    }
}

